/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.itemlistmanager;

import com.sas.models.itemlistmanager.ILMTreeToTableModelAdapter;
import com.sas.models.itemlistmanager.ItemListManagerViewerInterface;
import com.sas.models.itemlistmanager.tree.ILMTreeInterface;
import com.sas.models.itemlistmanager.tree.ILMTreeNode;
import com.sas.models.itemlistmanager.tree.TreeUtil;
import com.sas.swing.events.TextSelectionEvent;
import com.sas.swing.events.TextSelectionListener;
import com.sas.swing.visuals.itemlistmanager.AbstractItemListManagerPanel;
import com.sas.swing.visuals.itemlistmanager.LeftGroupRenderer;
import com.sas.swing.visuals.itemlistmanager.RB;
import com.sas.swing.visuals.itemlistmanager.RightGroupRenderer;
import com.sas.swing.visuals.tableview.editors.ComboBoxEditor;
import com.sas.swing.visuals.tableview.editors.TextSelectionEditor;
import com.sas.swing.visuals.tableview.renderers.StringRenderer;
import com.sas.visuals.Resources;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeNode;

public class TreeItemListManagerPanel
extends AbstractItemListManagerPanel
implements TextSelectionListener {
    public static final String RB_KEY = "TreeItemListManagerPanel.";
    protected ILMTreeInterface treeModel;
    protected ILMTreeToTableModelAdapter tableModelAdapter;
    protected JButton groupButton;
    protected JButton ungroupButton;
    protected JButton ungroupAllButton;
    protected boolean groupColumnSelectionEnabled;

    public TreeItemListManagerPanel() {
        this((ILMTreeInterface)null);
    }

    public TreeItemListManagerPanel(ILMTreeInterface model) {
        try {
            this.setModel(model);
            this.addButtons();
            this.setGroupColumnSelectionEnabled(false);
            this.setSensitivities();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setModel(ILMTreeInterface model) {
        this.treeModel = model;
        this.model = this.tableModelAdapter;
        if (model != null) {
            this.tableModelAdapter.setModel(this.treeModel);
            this.tableView.setModel(this.tableModelAdapter);
            this.setupRenderersAndEditors();
        }
    }

    public ILMTreeInterface getModel() {
        return this.treeModel;
    }

    @Override
    protected void init() {
        super.init();
        this.tableModelAdapter = new ILMTreeToTableModelAdapter();
    }

    protected void setupRenderersAndEditors() {
        JComboBox booleanComboBox = new JComboBox();
        List logicalConditions = this.treeModel.getLogicalConditionList();
        Iterator i = logicalConditions.iterator();
        while (i.hasNext()) {
            booleanComboBox.addItem(i.next());
        }
        this.setCellEditor("Condition", new ComboBoxEditor(booleanComboBox));
        this.setNonEditableCellEditor("FirstCondition");
        this.setCellRenderer("FirstCondition", new StringRenderer(""));
        this.setCellRenderer("LeftGroup", new LeftGroupRenderer(0));
        this.setCellRenderer("RightGroup", new RightGroupRenderer(0));
    }

    protected void selectRowsFromSelectedParen(int selectedParen, boolean startSelection) {
        int editingRow = this.tableView.getEditingRow();
        ILMTreeNode currentRowNode = this.tableModelAdapter.getTreeNodeFromRowIndex(editingRow);
        TreeNode[] groups = startSelection ? TreeUtil.getGroupsStartingWith(currentRowNode) : TreeUtil.getGroupsEndingWith(currentRowNode);
        TreeNode selectedGroup = groups[selectedParen];
        ILMTreeNode startNode = (ILMTreeNode)TreeUtil.getLeftMostChild(selectedGroup);
        ILMTreeNode endNode = (ILMTreeNode)TreeUtil.getRightMostChild(selectedGroup);
        int startRow = this.tableModelAdapter.getRowIndexFromTreeNode(startNode);
        int endRow = this.tableModelAdapter.getRowIndexFromTreeNode(endNode);
        if (startRow != -1 && endRow != -1) {
            this.tableView.addRowSelectionInterval(startRow, endRow);
        }
    }

    protected void addButtons() {
        this.groupButton = new JButton();
        this.groupButton.setAction(new GroupAction());
        this.groupButton.setName("Group");
        this.addButton(this.groupButton, 1, 0);
        this.ungroupButton = new JButton();
        this.ungroupButton.setAction(new UngroupAction());
        this.ungroupButton.setName("Ungroup");
        this.addButton(this.ungroupButton, 1, 1);
        this.ungroupAllButton = new JButton();
        this.ungroupAllButton.setAction(new UngroupAllAction());
        this.ungroupAllButton.setName("UngroupAll");
        this.addButton(this.ungroupAllButton, 1, 2);
        this.addButton(ItemListManagerViewerInterface.BUTTON_DIVIDER, 1, 3);
    }

    public Action getGroupAction() {
        return this.groupButton.getAction();
    }

    public Action getUngroupAction() {
        return this.ungroupButton.getAction();
    }

    public Action getUngroupAllAction() {
        return this.ungroupAllButton.getAction();
    }

    public ILMTreeNode getSelectedRow() {
        int row = this.tableView.getSelectedRow();
        return this.tableModelAdapter.getTreeNodeFromRowIndex(row);
    }

    public List getSelectedRows() {
        int[] rows = this.tableView.getSelectedRows();
        ArrayList<ILMTreeNode> list = new ArrayList<ILMTreeNode>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            ILMTreeNode node = this.tableModelAdapter.getTreeNodeFromRowIndex(rows[i]);
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    public void setSelectedRow(ILMTreeNode rowNode) {
        int row = this.tableModelAdapter.getRowIndexFromTreeNode(rowNode);
        if (row == -1) {
            return;
        }
        this.tableView.setRowSelectionInterval(row, row);
        this.setSensitivities();
    }

    public void setSelectedRows(List selectedRows) {
        this.tableView.clearSelection();
        if (selectedRows != null) {
            for (int i = 0; i < selectedRows.size(); ++i) {
                ILMTreeNode node = (ILMTreeNode)selectedRows.get(i);
                int row = this.tableModelAdapter.getRowIndexFromTreeNode(node);
                if (row == -1) continue;
                this.tableView.addRowSelectionInterval(row, row);
            }
        }
        this.setSensitivities();
    }

    public void clearSelectedRows() {
        this.tableView.clearSelection();
        this.setSensitivities();
    }

    public int getConditionColumnIndex() {
        return this.tableModelAdapter.getPredefinedColumnIndex(ILMTreeToTableModelAdapter.PREDEFINED_COLUMN_CONDITION);
    }

    public int getLeftGroupColumnIndex() {
        return this.tableModelAdapter.getPredefinedColumnIndex(ILMTreeToTableModelAdapter.PREDEFINED_COLUMN_LEFT_GROUP);
    }

    public int getRightGroupColumnIndex() {
        return this.tableModelAdapter.getPredefinedColumnIndex(ILMTreeToTableModelAdapter.PREDEFINED_COLUMN_RIGHT_GROUP);
    }

    public void setGroupColumnSelectionEnabled(boolean enabled) {
        this.groupColumnSelectionEnabled = enabled;
        if (enabled) {
            TextSelectionEditor groupEditor = new TextSelectionEditor(0);
            groupEditor.addTextSelectionListener(this);
            groupEditor.setFireSelectionChangedOnAllDrags(true);
            this.setCellEditor("LeftGroup", groupEditor);
            this.setCellEditor("RightGroup", groupEditor);
        } else {
            TableCellEditor editor = this.getCellEditor("LeftGroup");
            if (editor instanceof TextSelectionEditor) {
                ((TextSelectionEditor)editor).removeTextSelectionListener(this);
            }
            this.setNonEditableCellEditor("LeftGroup");
            editor = this.getCellEditor("RightGroup");
            if (editor instanceof TextSelectionEditor) {
                ((TextSelectionEditor)editor).removeTextSelectionListener(this);
            }
            this.setNonEditableCellEditor("RightGroup");
        }
    }

    @Override
    public void textSelectionChanged(TextSelectionEvent e) {
        int editingCol = this.tableView.getEditingColumn();
        if ((editingCol = this.tableView.convertColumnIndexToModel(editingCol)) == this.tableModelAdapter.getPredefinedColumnIndex(ILMTreeToTableModelAdapter.PREDEFINED_COLUMN_LEFT_GROUP)) {
            this.selectRowsFromSelectedParen(e.getTextSelectStart(), true);
        } else if (editingCol == this.tableModelAdapter.getPredefinedColumnIndex(ILMTreeToTableModelAdapter.PREDEFINED_COLUMN_RIGHT_GROUP)) {
            this.selectRowsFromSelectedParen(e.getTextSelectEnd() - 1, false);
        }
    }

    @Override
    public void textSelectionCleared(TextSelectionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeItemListManagerPanel.this.clearSelectedRows();
            }
        });
    }

    public boolean isGroupColumnSelectionEnabled() {
        return this.groupColumnSelectionEnabled;
    }

    public void refresh() {
        this.tableModelAdapter.refresh();
    }

    protected void groupSelectedRows() {
        Object[] selectedRowGroups = this.getSelectedRowGroups();
        if (selectedRowGroups == null || selectedRowGroups.length == 0) {
            return;
        }
        int startRow = ((Dimension)selectedRowGroups[0]).width;
        int endRow = ((Dimension)selectedRowGroups[0]).height;
        if (selectedRowGroups.length == 2) {
            endRow = ((Dimension)selectedRowGroups[1]).width;
        }
        this.tableModelAdapter.groupRow(startRow, endRow);
    }

    protected void ungroupSelectedRow() {
        int selectedRow = this.tableView.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        this.tableModelAdapter.ungroupRow(selectedRow);
    }

    protected void ungroupAll() {
        this.tableModelAdapter.ungroupAll();
    }

    public static String getLeftGroupText(ILMTreeInterface tree, ILMTreeNode treeNode, String groupSymbol, String negationSymbol) {
        StringBuffer line = new StringBuffer();
        TreeNode[] groupNodes = TreeUtil.getGroupsStartingWith(treeNode);
        if (groupNodes != null) {
            for (int i = 0; i < groupNodes.length; ++i) {
                if (negationSymbol != null && ((ILMTreeNode)groupNodes[i]).isNegated()) {
                    line.append(negationSymbol);
                }
                line.append(groupSymbol);
            }
        }
        if (negationSymbol != null && treeNode.isNegated()) {
            line.append(negationSymbol);
        }
        return line.toString();
    }

    public static String getRightGroupText(ILMTreeInterface tree, ILMTreeNode treeNode, String groupSymbol) {
        StringBuffer line = new StringBuffer();
        TreeNode[] groupNodes = TreeUtil.getGroupsEndingWith(treeNode);
        if (groupNodes != null) {
            for (int i = 0; i < groupNodes.length; ++i) {
                line.append(groupSymbol);
            }
        }
        return line.toString();
    }

    @Override
    protected void setSensitivities() {
        super.setSensitivities();
        int selectedRowCount = this.tableView.getSelectedRowCount();
        boolean multipleRowsInGroup = false;
        Object[] selectedRowGroups = this.getSelectedRowGroups();
        for (int i = 0; i < selectedRowGroups.length; ++i) {
            Dimension rows = (Dimension)selectedRowGroups[i];
            multipleRowsInGroup = rows.width != rows.height;
        }
        if (this.groupButton != null) {
            int startRow;
            if (selectedRowGroups.length == 1 && multipleRowsInGroup) {
                startRow = ((Dimension)selectedRowGroups[0]).width;
                int endRow = ((Dimension)selectedRowGroups[0]).height;
                this.groupButton.setEnabled(this.tableModelAdapter.canGroupRow(startRow, endRow));
            } else if (selectedRowGroups.length == 2 && !multipleRowsInGroup) {
                startRow = ((Dimension)selectedRowGroups[0]).width;
                int endRow = ((Dimension)selectedRowGroups[1]).width;
                this.groupButton.setEnabled(this.tableModelAdapter.canGroupRow(startRow, endRow));
            } else {
                this.groupButton.setEnabled(false);
            }
            this.ungroupButton.setEnabled(selectedRowCount == 1 && this.tableModelAdapter.canUngroupRow(this.tableView.getSelectedRow()));
            this.ungroupAllButton.setEnabled(this.tableModelAdapter.isGrouped());
        }
    }

    protected class UngroupAllAction
    extends AbstractAction {
        public UngroupAllAction() {
            this.putValue("ShortDescription", RB.getStringResource(TreeItemListManagerPanel.RB_KEY, "ungroupAllToolTip.txt"));
            this.putValue("SmallIcon", Resources.getImageIcon((String)RB.getStringResource(TreeItemListManagerPanel.RB_KEY, "ungroupAll.image")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeItemListManagerPanel.this.ungroupAll();
            TreeItemListManagerPanel.this.setSensitivities();
        }
    }

    protected class UngroupAction
    extends AbstractAction {
        public UngroupAction() {
            this.putValue("ShortDescription", RB.getStringResource(TreeItemListManagerPanel.RB_KEY, "ungroupToolTip.txt"));
            this.putValue("SmallIcon", Resources.getImageIcon((String)RB.getStringResource(TreeItemListManagerPanel.RB_KEY, "ungroup.image")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeItemListManagerPanel.this.ungroupSelectedRow();
            TreeItemListManagerPanel.this.setSensitivities();
        }
    }

    protected class GroupAction
    extends AbstractAction {
        public GroupAction() {
            this.putValue("ShortDescription", RB.getStringResource(TreeItemListManagerPanel.RB_KEY, "groupToolTip.txt"));
            this.putValue("SmallIcon", Resources.getImageIcon((String)RB.getStringResource(TreeItemListManagerPanel.RB_KEY, "group.image")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeItemListManagerPanel.this.groupSelectedRows();
            TreeItemListManagerPanel.this.setSensitivities();
        }
    }
}

