/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.itemlistmanager;

import com.sas.models.itemlistmanager.RB;
import com.sas.models.itemlistmanager.tree.ILMTreeInterface;
import com.sas.models.itemlistmanager.tree.ILMTreeNode;
import com.sas.models.itemlistmanager.tree.ILMTreeNodeContext;
import com.sas.swing.visuals.itemlistmanager.TreeItemListManagerPanel;
import com.sas.swing.visuals.tableview.renderers.StringRenderer;
import java.awt.Component;
import javax.swing.JTable;

public class LeftGroupRenderer
extends StringRenderer {
    public static final String ADAPTER_RB_KEY = "ILMTreeToTableModelAdapter.";
    protected String LEFT_GROUP_SYMBOL = RB.getStringResource("ILMTreeToTableModelAdapter.", "leftGroupSymbol.txt");
    protected String NEGATION_SYMBOL = RB.getStringResource("ILMTreeToTableModelAdapter.", "negationSymbol.txt");
    protected boolean showNegation;

    public LeftGroupRenderer() {
        this.init();
    }

    public LeftGroupRenderer(int horizontalAlignment) {
        super(horizontalAlignment);
        this.init();
    }

    protected void init() {
        this.showNegation = false;
    }

    public void setShowNegation(boolean mode) {
        this.showNegation = mode;
    }

    public boolean getShowNegation() {
        return this.showNegation;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof ILMTreeNodeContext) {
            ILMTreeNodeContext treeNodeContext = (ILMTreeNodeContext)value;
            String text = this.getText(treeNodeContext.getTree(), treeNodeContext.getTreeNode());
            this.setValue(text);
            treeNodeContext.setText(text);
        }
        return component;
    }

    protected String getText(ILMTreeInterface tree, ILMTreeNode treeNode) {
        return TreeItemListManagerPanel.getLeftGroupText(tree, treeNode, this.LEFT_GROUP_SYMBOL, this.showNegation ? this.NEGATION_SYMBOL : null);
    }
}

