/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.itemlistmanager;

import com.sas.models.itemlistmanager.DeleteRowInterface;
import com.sas.models.itemlistmanager.DeleteRowsInterface;
import com.sas.models.itemlistmanager.InsertRowInterface;
import com.sas.models.itemlistmanager.ItemListManagerViewerInterface;
import com.sas.models.itemlistmanager.MoveRowInterface;
import com.sas.swing.visuals.itemlistmanager.ItemListManagerTableView;
import com.sas.swing.visuals.itemlistmanager.RB;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.swing.visuals.tableview.TableRowModelListener;
import com.sas.swing.visuals.tableview.editors.NonEditableEditor;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class AbstractItemListManagerPanel
extends JPanel {
    public static final String RB_KEY = "AbstractItemListManagerPanel.";
    public static final NonEditableEditor NON_EDITABLE_CELL_EDITOR = new NonEditableEditor();
    protected Object model;
    protected String accessibleNamePrefix;
    protected ArrayList buttonsRight;
    protected ArrayList buttonsBottom;
    protected JPanel mainPanel;
    protected JPanel buttonsRightPanel;
    protected JPanel buttonsBottomPanel;
    protected JButton addButton;
    protected JButton deleteButton;
    protected JButton moveUpButton;
    protected JButton moveDownButton;
    protected int buttonSpacerAmount;
    protected ItemListManagerTableView tableView;
    protected JScrollPane tableScrollPane;
    protected HashMap cellEditorClassMap;
    protected HashMap cellRendererClassMap;
    private boolean ignoreSelectionEvents;

    public AbstractItemListManagerPanel() {
        this((ItemListManagerTableView)null);
    }

    protected AbstractItemListManagerPanel(ItemListManagerTableView table) {
        this.tableView = table;
        try {
            this.init();
            this.buildUI();
            this.addDefaultButtons();
            this.setAccessibleNamePrefix(RB_KEY);
            this.setSensitivities();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void init() {
        this.ignoreSelectionEvents = false;
        this.buttonSpacerAmount = 10;
        this.buttonsRight = new ArrayList();
        this.buttonsBottom = new ArrayList();
        this.cellEditorClassMap = new HashMap();
        this.cellRendererClassMap = new HashMap();
        this.setCellEditor("String", new DefaultTableCellEditor(new JTextField()));
        this.setCellEditor("Integer", new DefaultTableCellEditor(new JTextField()));
        this.setCellRenderer("String", new DefaultTableCellRenderer());
        this.setCellRenderer("Integer", new DefaultTableCellRenderer());
    }

    public void setAccessibleNamePrefix(String prefix) {
        this.accessibleNamePrefix = prefix;
        this.setAccessibleNames();
    }

    protected void setAccessibleNames() {
        this.addButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "addButton");
        this.deleteButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "deleteButton");
        this.moveUpButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "moveUpButton");
        this.moveDownButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "moveDownButton");
        this.tableView.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "tableView");
    }

    protected void buildUI() throws Exception {
        this.addComponents();
    }

    protected void addComponents() {
        this.setLayout(new GridLayout(1, 1));
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(2, 2, 5, 5, true, true, true);
        mainLayout.setRemainderColumn(1);
        mainLayout.setRemainderRow(1);
        this.mainPanel.setLayout(mainLayout);
        this.add(this.mainPanel);
        this.tableScrollPane = new JScrollPane();
        this.mainPanel.add(this.tableScrollPane);
        if (this.tableView == null) {
            this.tableView = new ItemListManagerTableView();
            this.tableView.setPopupMenuEnabled(false);
            this.tableView.setColumnHeaderVisible(true);
            this.tableView.setRowHeaderVisible(false);
        }
        this.tableView.setCellEditorClassMap(this.cellEditorClassMap);
        this.tableView.setCellRendererClassMap(this.cellRendererClassMap);
        this.tableView.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tableScrollPane.getViewport().add(this.tableView);
        this.tableView.getRowModel().addRowModelListener(new TableRowModelListener(){

            @Override
            public void rowMoved(TableRowModelEvent e) {
            }

            @Override
            public void rowMarginChanged(ChangeEvent e) {
            }

            @Override
            public void rowSelectionChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !AbstractItemListManagerPanel.this.ignoreSelectionEvents) {
                    AbstractItemListManagerPanel.this.setSensitivities();
                }
            }
        });
        this.tableView.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                AbstractItemListManagerPanel.this.setSensitivities();
            }
        });
        this.buttonsRightPanel = new JPanel();
        this.buttonsRightPanel.setName("ButtonsRight");
        this.buttonsRightPanel.setLayout(new AutoSizingGridLayout(0, 1, 0, 0, true, false, true));
        this.mainPanel.add(this.buttonsRightPanel);
        this.buttonsBottomPanel = new JPanel();
        this.buttonsBottomPanel.setName("ButtonsBottom");
        this.buttonsBottomPanel.setLayout(new AutoSizingGridLayout(1, 0, 0, 0, true, true, false));
        this.mainPanel.add(this.buttonsBottomPanel);
        this.addButton = new JButton();
        this.addButton.setAction(new AddAction());
        this.deleteButton = new JButton();
        this.deleteButton.setAction(new DeleteAction());
        this.moveUpButton = new JButton();
        this.moveUpButton.setAction(new MoveUpAction());
        this.moveUpButton.setPreferredSize(new Dimension(30, 25));
        this.moveUpButton.setName("MoveUp");
        this.moveDownButton = new JButton();
        this.moveDownButton.setAction(new MoveDownAction());
        this.moveDownButton.setPreferredSize(new Dimension(30, 25));
        this.moveDownButton.setName("MoveDown");
    }

    public Action getAddAction() {
        return this.addButton.getAction();
    }

    public Action getDeleteAction() {
        return this.deleteButton.getAction();
    }

    public Action getMoveUpAction() {
        return this.moveUpButton.getAction();
    }

    public Action getMoveDownAction() {
        return this.moveDownButton.getAction();
    }

    protected void addDefaultButtons() {
        this.addButton(ItemListManagerViewerInterface.BUTTON_ADD, 0, 0);
        this.addButton(ItemListManagerViewerInterface.BUTTON_DELETE, 0, 1);
        this.addButton(ItemListManagerViewerInterface.BUTTON_MOVE_UP, 1, 0);
        this.addButton(ItemListManagerViewerInterface.BUTTON_MOVE_DOWN, 1, 1);
    }

    public int getSelectedRowCount() {
        return this.tableView.getSelectedRowCount();
    }

    public void setRowSelectionAllowed(boolean rowSelectionAllowed) {
        this.tableView.setRowSelectionAllowed(rowSelectionAllowed);
    }

    public void setRowSelectionMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("The selection mode must be one of the values defined in javax.swing.ListSelectionModel.");
        }
        this.tableView.setSelectionMode(mode);
    }

    public int getRowSelectionMode() {
        return this.tableView.getSelectionModel().getSelectionMode();
    }

    public void setColumnVisible(int column, boolean visible) {
        if (visible) {
            this.tableView.showColumn(column);
        } else {
            this.tableView.hideColumn(column);
        }
    }

    public void setColumnReorderingAllowed(boolean reorderingAllowed) {
        this.tableView.getColumnHeader().setReorderingAllowed(reorderingAllowed);
    }

    public boolean getColumnReorderingAllowed() {
        return this.tableView.getColumnHeader().getReorderingAllowed();
    }

    public void moveColumn(int oldColumnIndex, int newColumnIndex) {
        this.tableView.getColumnModel().moveColumn(oldColumnIndex, newColumnIndex);
    }

    public int getViewColumnIndex(int modelColumnIndex) {
        return this.tableView.convertColumnIndexToView(modelColumnIndex);
    }

    public int getModelColumnIndex(int viewColumnIndex) {
        return this.tableView.convertColumnIndexToModel(viewColumnIndex);
    }

    public void showAllColumns() {
        this.tableView.showAllColumns();
    }

    public int getColumnWidth(int column) {
        int viewColumn = this.getViewColumnIndex(column);
        TableColumnModel tableColumnModel = this.tableView.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(viewColumn);
        return tableColumn.getPreferredWidth();
    }

    public void setColumnWidth(int column, int width) {
        int viewColumn = this.getViewColumnIndex(column);
        TableColumnModel tableColumnModel = this.tableView.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(viewColumn);
        tableColumn.setPreferredWidth(width);
    }

    public void setColumnName(int column, String name) {
        int viewColumn = this.getViewColumnIndex(column);
        TableColumnModel tableColumnModel = this.tableView.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(viewColumn);
        tableColumn.setHeaderValue(name);
    }

    public int[] getCurrentCell() {
        return this.tableView.getCurrentCell();
    }

    public void setCurrentCell(int row, int column) {
        this.tableView.setCurrentColumn(column);
        this.tableView.setCurrentRow(row);
    }

    public Object addButton(Object button, int location, int position) {
        Object actualButton = this.getPredefinedButton(button, location);
        if (actualButton == button && !(button instanceof Component)) {
            throw new IllegalArgumentException("Button object must be an instance of java.awt.Component.");
        }
        switch (location) {
            case 0: {
                if (button == ItemListManagerViewerInterface.BUTTON_EXPANDING_SPACER && this.findExpandingSpacerIndex(this.buttonsRight) != -1) {
                    throw new IllegalArgumentException("Only one expanding spacer may be specified for a given location.");
                }
                if (position == -1) {
                    this.buttonsRight.add(actualButton);
                } else {
                    this.buttonsRight.add(position, actualButton);
                }
                int expandingSpacerIndex = this.findExpandingSpacerIndex(this.buttonsRight);
                if (expandingSpacerIndex != -1) {
                    AutoSizingGridLayout buttonsRightPanelLayout = (AutoSizingGridLayout)this.buttonsRightPanel.getLayout();
                    buttonsRightPanelLayout.setUseRowRemainder(true);
                    buttonsRightPanelLayout.setRemainderRow(expandingSpacerIndex + 1);
                }
                this.rebuildButtonsRight();
                break;
            }
            case 1: {
                if (button == ItemListManagerViewerInterface.BUTTON_EXPANDING_SPACER && this.findExpandingSpacerIndex(this.buttonsBottom) != -1) {
                    throw new IllegalArgumentException("Only one expanding spacer may be specified for a given location.");
                }
                if (position == -1) {
                    this.buttonsBottom.add(actualButton);
                } else {
                    this.buttonsBottom.add(position, actualButton);
                }
                int expandingSpacerIndex = this.findExpandingSpacerIndex(this.buttonsBottom);
                if (expandingSpacerIndex != -1) {
                    AutoSizingGridLayout buttonsRightPanelLayout = (AutoSizingGridLayout)this.buttonsBottomPanel.getLayout();
                    buttonsRightPanelLayout.setUseColumnRemainder(true);
                    buttonsRightPanelLayout.setRemainderColumn(expandingSpacerIndex + 1);
                }
                this.rebuildButtonsBottom();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid location specified.");
            }
        }
        return actualButton;
    }

    public void removeButton(Object button) {
        this.removeButton(button, 0);
        this.removeButton(button, 1);
    }

    public void removeButton(Object button, int location) {
        Object realButton = this.getPredefinedButton(button, 0);
        if (location == 0) {
            if (this.buttonsRight.remove(realButton)) {
                AutoSizingGridLayout buttonsRightPanelLayout = (AutoSizingGridLayout)this.buttonsRightPanel.getLayout();
                int expandingSpacerIndex = this.findExpandingSpacerIndex(this.buttonsRight);
                if (expandingSpacerIndex != -1) {
                    buttonsRightPanelLayout.setRemainderRow(expandingSpacerIndex + 1);
                } else {
                    buttonsRightPanelLayout.setUseRowRemainder(false);
                }
                this.rebuildButtonsRight();
            }
        } else if (location == 1) {
            if (this.buttonsBottom.remove(realButton)) {
                AutoSizingGridLayout buttonsRightPanelLayout = (AutoSizingGridLayout)this.buttonsBottomPanel.getLayout();
                int expandingSpacerIndex = this.findExpandingSpacerIndex(this.buttonsBottom);
                if (expandingSpacerIndex != -1) {
                    buttonsRightPanelLayout.setRemainderColumn(expandingSpacerIndex + 1);
                } else {
                    buttonsRightPanelLayout.setUseColumnRemainder(false);
                }
                this.rebuildButtonsBottom();
            }
        } else {
            throw new IllegalArgumentException("Invalid button location specified. Must be BUTTON_LOCATION_VERTICAL or BUTTON_LOCATION_HORIZONTAL");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeButton(Object button, int location, int position) {
        if (location == 0) {
            if (position >= this.buttonsRight.size()) {
                throw new IllegalArgumentException("No button exists at specified position in this location.");
            }
            if (!this.buttonsRight.get(position).equals(button)) throw new IllegalArgumentException("Button at specified position doesn't exist at this location.");
            this.buttonsRight.remove(position);
            this.rebuildButtonsRight();
            return;
        } else {
            if (location != 1) throw new IllegalArgumentException("Invalid button location specified. Must be BUTTON_LOCATION_VERTICAL or BUTTON_LOCATION_HORIZONTAL");
            if (position >= this.buttonsBottom.size()) {
                throw new IllegalArgumentException("No button exists at specified position in this location.");
            }
            if (!this.buttonsBottom.get(position).equals(button)) throw new IllegalArgumentException("Button at specified position doesn't exist at this location.");
            this.buttonsBottom.remove(position);
            this.rebuildButtonsBottom();
        }
    }

    public void removeAllButtons(int location) {
        if (location == 0) {
            this.buttonsRight.clear();
            this.rebuildButtonsRight();
        } else if (location == 1) {
            this.buttonsBottom.clear();
            this.rebuildButtonsBottom();
        } else {
            throw new IllegalArgumentException("Invalid button location specified. Must be BUTTON_LOCATION_VERTICAL or BUTTON_LOCATION_HORIZONTAL");
        }
    }

    public void setCellRenderer(String classification, TableCellRenderer renderer) {
        this.cellRendererClassMap.put(classification, renderer);
    }

    public void setCellRenderer(TableCellRenderer renderer) {
        this.tableView.setCellRenderer(-1, -1, renderer);
    }

    public void setCellRenderer(int row, int column, TableCellRenderer renderer) {
        this.tableView.setCellRenderer(row, column, renderer);
    }

    public TableCellRenderer getCellRenderer(String classification) {
        return (TableCellRenderer)this.cellRendererClassMap.get(classification);
    }

    public void setCellEditor(String classification, TableCellEditor editor) {
        this.cellEditorClassMap.put(classification, editor);
    }

    public void setCellEditor(TableCellEditor editor) {
        this.tableView.setCellEditor(editor);
    }

    public void setCellEditor(int row, int column, TableCellEditor editor) {
        this.tableView.setCellEditor(row, column, editor);
    }

    public void setNonEditableCellEditor(String classification) {
        this.setCellEditor(classification, NON_EDITABLE_CELL_EDITOR);
    }

    public TableCellEditor getCellEditor(String classification) {
        return (TableCellEditor)this.cellEditorClassMap.get(classification);
    }

    public void addRowModelListener(TableRowModelListener listener) {
        if (this.tableView != null) {
            this.tableView.getRowModel().addRowModelListener(listener);
        }
    }

    public void removeRowModelListener(TableRowModelListener listener) {
        if (this.tableView != null) {
            this.tableView.getRowModel().removeRowModelListener(listener);
        }
    }

    public void addColumnModelListener(TableColumnModelListener listener) {
        if (this.tableView != null) {
            this.tableView.getColumnModel().addColumnModelListener(listener);
        }
    }

    public void removeColumnModelListener(TableColumnModelListener listener) {
        if (this.tableView != null) {
            this.tableView.getColumnModel().removeColumnModelListener(listener);
        }
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        if (this.tableView != null) {
            this.tableView.addFocusListener(listener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        if (this.tableView != null) {
            this.tableView.removeFocusListener(listener);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        if (this.tableView != null) {
            this.tableView.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.tableView != null) {
            this.tableView.removePropertyChangeListener(listener);
        }
    }

    public void addActionListener(Object component, ActionListener listener) {
        if (component.equals(ItemListManagerViewerInterface.BUTTON_ADD)) {
            this.addButton.addActionListener(listener);
        } else if (component.equals(ItemListManagerViewerInterface.BUTTON_DELETE)) {
            this.deleteButton.addActionListener(listener);
        } else if (component.equals(ItemListManagerViewerInterface.BUTTON_MOVE_UP)) {
            this.moveUpButton.addActionListener(listener);
        } else if (component.equals(ItemListManagerViewerInterface.BUTTON_MOVE_DOWN)) {
            this.moveDownButton.addActionListener(listener);
        } else {
            throw new IllegalArgumentException("Invalid component specified for an action listener.");
        }
    }

    public void removeActionListener(Object component, ActionListener listener) {
        if (component.equals(ItemListManagerViewerInterface.BUTTON_ADD)) {
            this.addButton.removeActionListener(listener);
        } else if (component.equals(ItemListManagerViewerInterface.BUTTON_DELETE)) {
            this.deleteButton.removeActionListener(listener);
        } else if (component.equals(ItemListManagerViewerInterface.BUTTON_MOVE_UP)) {
            this.moveUpButton.removeActionListener(listener);
        } else if (component.equals(ItemListManagerViewerInterface.BUTTON_MOVE_DOWN)) {
            this.moveDownButton.removeActionListener(listener);
        } else {
            throw new IllegalArgumentException("Invalid component specified for an action listener.");
        }
    }

    protected void rebuildButtonsRight() {
        this.buttonsRightPanel.removeAll();
        for (int i = 0; i < this.buttonsRight.size(); ++i) {
            Object button = this.getPredefinedButton(this.buttonsRight.get(i), 0);
            this.buttonsRightPanel.add((Component)button);
        }
        this.buttonsRightPanel.doLayout();
        this.repaint();
    }

    protected void rebuildButtonsBottom() {
        this.buttonsBottomPanel.removeAll();
        for (int i = 0; i < this.buttonsBottom.size(); ++i) {
            Object button = this.getPredefinedButton(this.buttonsBottom.get(i), 1);
            this.buttonsBottomPanel.add((Component)button);
        }
        this.buttonsRightPanel.doLayout();
        this.repaint();
    }

    protected Object getPredefinedButton(Object button, int location) {
        if (button == ItemListManagerViewerInterface.BUTTON_ADD) {
            return this.addButton;
        }
        if (button == ItemListManagerViewerInterface.BUTTON_DELETE) {
            return this.deleteButton;
        }
        if (button == ItemListManagerViewerInterface.BUTTON_MOVE_UP) {
            return this.moveUpButton;
        }
        if (button == ItemListManagerViewerInterface.BUTTON_MOVE_DOWN) {
            return this.moveDownButton;
        }
        if (button == ItemListManagerViewerInterface.BUTTON_DIVIDER) {
            boolean locationVertical = location == 0;
            JSeparator divider = new JSeparator(locationVertical ? 0 : 1);
            int spacing = this.buttonSpacerAmount / 2;
            JPanel dividerPanel = new JPanel();
            dividerPanel.setLayout(new AutoSizingGridLayout(1, 1, 0, 0, true, true, true));
            if (locationVertical) {
                dividerPanel.setBorder(new EmptyBorder(spacing, 0, spacing, 0));
            } else {
                dividerPanel.setBorder(new EmptyBorder(0, spacing, 0, spacing));
            }
            dividerPanel.add(divider);
            dividerPanel.setName("BUTTON_DIVIDER");
            return dividerPanel;
        }
        if (button == ItemListManagerViewerInterface.BUTTON_SPACER) {
            JPanel buttonSpacer = new JPanel();
            buttonSpacer.setPreferredSize(new Dimension(this.buttonSpacerAmount, this.buttonSpacerAmount));
            buttonSpacer.setName("BUTTON_SPACER");
            return buttonSpacer;
        }
        if (button == ItemListManagerViewerInterface.BUTTON_EXPANDING_SPACER) {
            JPanel buttonSpacer = new JPanel();
            buttonSpacer.setPreferredSize(new Dimension(this.buttonSpacerAmount, this.buttonSpacerAmount));
            buttonSpacer.setName("BUTTON_EXPANDING_SPACER");
            return buttonSpacer;
        }
        return button;
    }

    public void setButtonSpacerAmount(int amount) {
        this.buttonSpacerAmount = amount;
    }

    public int getButtonSpacerAmount() {
        return this.buttonSpacerAmount;
    }

    protected Component findButtonByName(String name, int location) {
        ArrayList buttonList;
        if (location == 0) {
            buttonList = this.buttonsRight;
        } else if (location == 1) {
            buttonList = this.buttonsBottom;
        } else {
            return null;
        }
        int size = buttonList.size();
        for (int i = 0; i < size; ++i) {
            Component button = (Component)buttonList.get(i);
            if (!button.getName().equals(name)) continue;
            return button;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteSelectedRows() {
        if (this.tableView.getSelectedRowCount() == 0) {
            return false;
        }
        boolean rv = false;
        try {
            this.ignoreSelectionEvents = true;
            int[] selectedRows = this.tableView.getSelectedRows();
            if (this.model instanceof DeleteRowsInterface) {
                DeleteRowsInterface deleteModel = (DeleteRowsInterface)this.model;
                deleteModel.deleteRows(selectedRows);
            } else {
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    if (!this.deleteRow(selectedRows[i])) continue;
                    rv = true;
                }
            }
            this.tableView.clearSelection();
            int firstSelectedRow = selectedRows[0];
            if (firstSelectedRow >= this.tableView.getRowCount()) {
                firstSelectedRow = this.tableView.getRowCount() - 1;
            }
            if (firstSelectedRow >= 0) {
                this.tableView.setRowSelectionInterval(firstSelectedRow, firstSelectedRow);
            }
            this.setSensitivities();
            if (this.deleteButton.isEnabled()) {
                this.deleteButton.requestFocus();
            }
        }
        finally {
            this.ignoreSelectionEvents = false;
        }
        return rv;
    }

    protected boolean deleteRow(int rowIndex) {
        if (this.model instanceof DeleteRowInterface) {
            DeleteRowInterface deleteModel = (DeleteRowInterface)this.model;
            if (deleteModel.canDeleteRow(rowIndex)) {
                deleteModel.deleteRow(rowIndex);
                return true;
            }
        } else if (this.model instanceof DefaultTableModel) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.model;
            defaultTableModel.removeRow(rowIndex);
            return true;
        }
        return false;
    }

    protected boolean addRow() {
        int rowIndex = this.tableView.getRowCount();
        if (this.model instanceof InsertRowInterface) {
            InsertRowInterface insertModel = (InsertRowInterface)this.model;
            if (insertModel.canInsertRow(rowIndex)) {
                this.stopCellEditing();
                insertModel.insertRow(rowIndex);
                this.tableView.setRowSelectionInterval(rowIndex, rowIndex);
                this.tableView.scrollRectToVisible(this.tableView.getCellRect(rowIndex, 1, true));
                this.setSensitivities();
                return true;
            }
        } else if (this.model instanceof DefaultTableModel) {
            this.stopCellEditing();
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.model;
            defaultTableModel.insertRow(rowIndex, (Object[])null);
            this.tableView.setRowSelectionInterval(rowIndex, rowIndex);
            this.tableView.scrollRectToVisible(this.tableView.getCellRect(rowIndex, 1, true));
            this.setSensitivities();
        }
        return true;
    }

    protected boolean moveUpSelectedRows() {
        int i;
        if (this.tableView.getSelectedRowCount() == 0) {
            return false;
        }
        this.stopCellEditing();
        boolean rv = true;
        Object[] selectedRowGroups = this.getSelectedRowGroups();
        ArrayList<Dimension> newRowSelections = new ArrayList<Dimension>();
        for (i = 0; i < selectedRowGroups.length; ++i) {
            Dimension rows = (Dimension)selectedRowGroups[i];
            int targetRow = this.moveUpRows(rows.width, rows.height);
            if (targetRow != -1) {
                newRowSelections.add(new Dimension(targetRow, targetRow + (rows.height - rows.width)));
                continue;
            }
            rv = false;
        }
        this.tableView.clearSelection();
        for (i = 0; i < newRowSelections.size(); ++i) {
            Dimension rowRange = (Dimension)newRowSelections.get(i);
            this.tableView.addRowSelectionInterval(rowRange.width, rowRange.height);
            if (i != 0) continue;
            this.tableView.scrollRectToVisible(this.tableView.getCellRect(rowRange.width, 1, true));
        }
        if (this.moveUpButton.isEnabled()) {
            this.moveUpButton.requestFocus();
        } else if (this.moveDownButton.isEnabled()) {
            this.moveDownButton.requestFocus();
        }
        return rv;
    }

    protected int moveUpRows(int rowStart, int rowEnd) {
        if (this.model instanceof MoveRowInterface) {
            MoveRowInterface moveModel = (MoveRowInterface)this.model;
            if (moveModel.canMoveRow(rowStart, rowEnd, rowStart - 1)) {
                int targetRow = moveModel.moveRowRange(rowStart, rowEnd, rowStart - 1);
                return targetRow;
            }
        } else if (this.model instanceof DefaultTableModel) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.model;
            defaultTableModel.moveRow(rowStart, rowEnd, rowStart - 1);
            return rowStart - 1;
        }
        return -1;
    }

    protected boolean moveDownSelectedRows() {
        int i;
        if (this.tableView.getSelectedRowCount() == 0) {
            return false;
        }
        this.stopCellEditing();
        boolean rv = true;
        Object[] selectedRowGroups = this.getSelectedRowGroups();
        ArrayList<Dimension> newRowSelections = new ArrayList<Dimension>();
        for (i = 0; i < selectedRowGroups.length; ++i) {
            Dimension rows = (Dimension)selectedRowGroups[i];
            int targetRow = this.moveDownRows(rows.width, rows.height);
            if (targetRow != -1) {
                newRowSelections.add(new Dimension(targetRow, targetRow + (rows.height - rows.width)));
                continue;
            }
            rv = false;
        }
        this.tableView.clearSelection();
        for (i = 0; i < newRowSelections.size(); ++i) {
            Dimension rowRange = (Dimension)newRowSelections.get(i);
            this.tableView.addRowSelectionInterval(rowRange.width, rowRange.height);
            if (i != newRowSelections.size() - 1) continue;
            this.tableView.scrollRectToVisible(this.tableView.getCellRect(rowRange.height, 1, true));
        }
        if (this.moveDownButton.isEnabled()) {
            this.moveDownButton.requestFocus();
        } else if (this.moveUpButton.isEnabled()) {
            this.moveUpButton.requestFocus();
        }
        return rv;
    }

    protected int moveDownRows(int rowStart, int rowEnd) {
        if (this.model instanceof MoveRowInterface) {
            MoveRowInterface moveModel = (MoveRowInterface)this.model;
            if (moveModel.canMoveRow(rowStart, rowEnd, rowStart + 1)) {
                int targetRow = moveModel.moveRowRange(rowStart, rowEnd, rowStart + 1);
                return targetRow;
            }
        } else if (this.model instanceof DefaultTableModel) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.model;
            defaultTableModel.moveRow(rowStart, rowEnd, rowStart + 1);
            return rowStart + 1;
        }
        return -1;
    }

    protected Object[] getSelectedRowGroups() {
        ArrayList<Dimension> groups = new ArrayList<Dimension>();
        int[] selectedRows = this.tableView.getSelectedRows();
        if (selectedRows.length > 0) {
            int start = selectedRows[0];
            for (int i = 1; i < selectedRows.length; ++i) {
                if (selectedRows[i] == selectedRows[i - 1] + 1) continue;
                groups.add(new Dimension(start, selectedRows[i - 1]));
                start = selectedRows[i];
            }
            groups.add(new Dimension(start, selectedRows[selectedRows.length - 1]));
        }
        return groups.toArray();
    }

    protected void stopCellEditing() {
        TableCellEditor cellEditor = this.tableView.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    protected int findExpandingSpacerIndex(List buttonList) {
        int size = buttonList.size();
        for (int i = 0; i < size; ++i) {
            Component c = (Component)buttonList.get(i);
            String name = c.getName();
            if (name == null || !name.equals("BUTTON_EXPANDING_SPACER")) continue;
            return i;
        }
        return -1;
    }

    protected void setSensitivities() {
        int rowCount = this.tableView.getRowCount();
        int selectedRowCount = this.tableView.getSelectedRowCount();
        boolean enableAdd = true;
        boolean enableDelete = selectedRowCount > 0;
        boolean enableMoveUp = selectedRowCount > 0;
        boolean enableMoveDown = selectedRowCount > 0;
        int[] selectedRows = this.tableView.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            if (enableAdd && this.model instanceof InsertRowInterface && !((InsertRowInterface)this.model).canInsertRow(i)) {
                enableAdd = false;
            }
            if (!enableDelete || !(this.model instanceof DeleteRowInterface) || ((DeleteRowInterface)this.model).canDeleteRow(i)) continue;
            enableDelete = false;
        }
        Object[] selectedRowGroups = this.getSelectedRowGroups();
        if (selectedRowGroups != null && selectedRowGroups.length > 0) {
            for (int i = 0; i < selectedRowGroups.length; ++i) {
                int startRow = ((Dimension)selectedRowGroups[i]).width;
                int endRow = ((Dimension)selectedRowGroups[i]).height;
                if (enableMoveUp) {
                    if (this.model instanceof MoveRowInterface) {
                        if (!((MoveRowInterface)this.model).canMoveRow(startRow, endRow, startRow - 1)) {
                            enableMoveUp = false;
                        }
                    } else if (startRow == 0) {
                        enableMoveUp = false;
                    }
                }
                if (!enableMoveDown) continue;
                if (this.model instanceof MoveRowInterface) {
                    if (((MoveRowInterface)this.model).canMoveRow(startRow, endRow, startRow + 1)) continue;
                    enableMoveDown = false;
                    continue;
                }
                if (endRow != rowCount - 1) continue;
                enableMoveDown = false;
            }
        }
        this.addButton.setEnabled(enableAdd);
        this.deleteButton.setEnabled(enableDelete);
        this.moveUpButton.setEnabled(enableMoveUp);
        this.moveDownButton.setEnabled(enableMoveDown);
    }

    protected class MoveDownAction
    extends AbstractAction {
        public MoveDownAction() {
            this.putValue("ShortDescription", RB.getStringResource(AbstractItemListManagerPanel.RB_KEY, "moveDownToolTip.txt"));
            this.putValue("SmallIcon", Resources.getImageIcon((String)RB.getStringResource(AbstractItemListManagerPanel.RB_KEY, "downArrow.image")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractItemListManagerPanel.this.moveDownSelectedRows();
        }
    }

    protected class MoveUpAction
    extends AbstractAction {
        public MoveUpAction() {
            this.putValue("ShortDescription", RB.getStringResource(AbstractItemListManagerPanel.RB_KEY, "moveUpToolTip.txt"));
            this.putValue("SmallIcon", Resources.getImageIcon((String)RB.getStringResource(AbstractItemListManagerPanel.RB_KEY, "upArrow.image")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractItemListManagerPanel.this.moveUpSelectedRows();
        }
    }

    protected class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(Util.getLabelWithoutMnemonic(RB.getStringResource(AbstractItemListManagerPanel.RB_KEY, "delete.txt")));
            this.putValue("ShortDescription", RB.getStringResource(AbstractItemListManagerPanel.RB_KEY, "deleteToolTip.txt"));
            this.putValue("MnemonicKey", new Integer(Util.getDisplayedMnemonic(RB.getStringResource(AbstractItemListManagerPanel.RB_KEY, "delete.txt"))));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractItemListManagerPanel.this.deleteSelectedRows();
        }
    }

    protected class AddAction
    extends AbstractAction {
        public AddAction() {
            super(Util.getLabelWithoutMnemonic(RB.getStringResource(AbstractItemListManagerPanel.RB_KEY, "add.txt")));
            this.putValue("ShortDescription", RB.getStringResource(AbstractItemListManagerPanel.RB_KEY, "addToolTip.txt"));
            this.putValue("MnemonicKey", new Integer(Util.getDisplayedMnemonic(RB.getStringResource(AbstractItemListManagerPanel.RB_KEY, "add.txt"))));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractItemListManagerPanel.this.addRow();
        }
    }
}

