/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dualselector;

import com.sas.codepolicy.SASScope;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualSelectorUpDownInterface;
import com.sas.swing.visuals.dualselector.DualSelectorV2Interface;
import com.sas.swing.visuals.util.DNDObject;
import com.sas.util.JavaCollectionPermuter;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

@SASScope(value="ALL")
public class JListDualSelectorAdapter
implements DualSelectorV2Interface,
DualSelectorUpDownInterface,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    private ListModel listModel;
    protected JList component;
    protected JScrollPane containerComponent;
    protected JComponent parentSelector;
    public DropTarget dropTarget = null;
    public DragSource dragSource = null;

    public JListDualSelectorAdapter(JComponent parent) {
        this(new JList(), parent);
    }

    public JListDualSelectorAdapter(JList list, JComponent parent) {
        this.component = list;
        this.parentSelector = parent;
        this.containerComponent = new JScrollPane(list);
        this.listModel = this.component.getModel();
        if (!((BaseDualSelector)this.parentSelector).isDesignTime()) {
            DropTarget dropTarget = new DropTarget(this.component, this);
            this.dragSource = new DragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this.component, 3, this);
        } else {
            ((BaseDualSelector)this.parentSelector).setDragAndDropEnabled(false);
        }
    }

    @Override
    public void clearSelections() {
        this.component.clearSelection();
    }

    @Override
    public int getCount() {
        return this.component.getModel().getSize();
    }

    @Override
    public int getSelectedCount() {
        List list = this.getSelectedItems();
        return list.size();
    }

    @Override
    public int getLastSelectedIndex() {
        return this.component.getMaxSelectionIndex();
    }

    @Override
    public void setSelectedIndex(int index) {
        this.component.setSelectedIndex(index);
        this.component.ensureIndexIsVisible(index);
    }

    @SASScope
    public void setSelectedIndices(int[] indices) {
        if (indices != null && indices.length > 0) {
            this.component.setSelectedIndices(indices);
            this.component.ensureIndexIsVisible(indices[0]);
        }
    }

    @Override
    @SASScope
    public void setSelectedValues(List values) {
        this.listModel = this.component.getModel();
        if (this.listModel == null || values == null) {
            return;
        }
        int listModelSize = this.listModel.getSize();
        int valuesSize = values.size();
        int[] selectedIndices = new int[valuesSize];
        block0: for (int i = 0; i < valuesSize; ++i) {
            Object value = values.get(i);
            if (value == null) continue;
            for (int j = 0; j < listModelSize; ++j) {
                if (value.equals(this.listModel.getElementAt(j))) {
                    selectedIndices[i] = j;
                    continue block0;
                }
                selectedIndices[i] = -1;
            }
        }
        this.setSelectedIndices(selectedIndices);
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public JComponent getContainerComponent() {
        return this.containerComponent;
    }

    @Override
    public List getSelectedItems() {
        this.listModel = this.component.getModel();
        ArrayList selectedItems = new ArrayList();
        if (this.listModel != null && this.listModel.getSize() > 0) {
            int[] selectedIndexes = this.component.getSelectedIndices();
            int cnt = selectedIndexes.length;
            for (int i = 0; i < cnt; ++i) {
                try {
                    selectedItems.add(this.listModel.getElementAt(selectedIndexes[i]));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return selectedItems;
    }

    @Override
    public List getAllItems() {
        this.listModel = this.component.getModel();
        ArrayList allItems = new ArrayList();
        for (int i = 0; i < this.getCount(); ++i) {
            allItems.add(this.listModel.getElementAt(i));
        }
        return allItems;
    }

    @Override
    public List getAllMoveableItems() {
        return this.getAllItems();
    }

    @Override
    public void addItems(List newItems) {
        this.listModel = this.component.getModel();
        if (this.listModel instanceof DefaultListModel) {
            for (int i = 0; i < newItems.size(); ++i) {
                ((DefaultListModel)this.listModel).addElement(newItems.get(i));
            }
        } else {
            ((CollectionToListModelAdapter)this.listModel).getModel().addAll(newItems);
            ((CollectionToListModelAdapter)this.listModel).refresh();
        }
    }

    @Override
    public void removeItems(List removeItems) {
        this.listModel = this.component.getModel();
        int size = removeItems.size();
        if (this.listModel instanceof DefaultListModel) {
            if (size == this.listModel.getSize()) {
                ((DefaultListModel)this.listModel).clear();
            } else {
                for (int i = 0; i < removeItems.size(); ++i) {
                    ((DefaultListModel)this.listModel).removeElementAt(((DefaultListModel)this.listModel).indexOf(removeItems.get(i)));
                }
            }
        } else {
            if (size == this.listModel.getSize()) {
                ((CollectionToListModelAdapter)this.listModel).getModel().clear();
            } else {
                ((CollectionToListModelAdapter)this.listModel).getModel().removeAll(removeItems);
            }
            ((CollectionToListModelAdapter)this.listModel).refresh();
        }
    }

    @Override
    public boolean isInAdapter(Object item) {
        this.listModel = this.component.getModel();
        boolean value = false;
        if (this.listModel instanceof DefaultListModel) {
            value = ((DefaultListModel)this.listModel).contains(item);
        } else if (this.listModel instanceof CollectionToListModelAdapter && ((CollectionToListModelAdapter)this.listModel).getModel() instanceof Collection) {
            value = ((CollectionToListModelAdapter)this.listModel).getModel().contains(item);
        }
        return value;
    }

    @Override
    public int[] getSelectedIndices() {
        return this.component.getSelectedIndices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveItems(int[] selectedIndices, int offset) {
        List dataToMove = new ArrayList<Object>();
        this.listModel = this.component.getModel();
        try {
            if (this.listModel instanceof DefaultListModel) {
                Object[] objects = ((DefaultListModel)this.listModel).toArray();
                for (int i = 0; i < objects.length; ++i) {
                    dataToMove.add(objects[i]);
                }
            } else if (this.listModel instanceof CollectionToListModelAdapter && ((CollectionToListModelAdapter)this.listModel).getModel() instanceof Collection) {
                dataToMove = (List)((CollectionToListModelAdapter)this.listModel).getModel();
            }
            if (dataToMove != null) {
                if (selectedIndices.length == 1) {
                    JavaCollectionPermuter.move(dataToMove, (int)selectedIndices[0], (int)offset);
                } else {
                    JavaCollectionPermuter.move(dataToMove, (int[])selectedIndices, (int)offset);
                }
                int i = 0;
                while (i < selectedIndices.length) {
                    int n = i++;
                    selectedIndices[n] = selectedIndices[n] + offset;
                }
                this.component.setSelectedIndices(selectedIndices);
            }
        }
        catch (IllegalArgumentException i) {
        }
        finally {
            if (this.listModel instanceof DefaultListModel) {
                for (int i = 0; i < dataToMove.size(); ++i) {
                    ((DefaultListModel)this.listModel).setElementAt(dataToMove.get(i), i);
                }
            } else if (this.listModel instanceof CollectionToListModelAdapter && ((CollectionToListModelAdapter)this.listModel).getModel() instanceof Collection) {
                ((CollectionToListModelAdapter)this.listModel).setModel(dataToMove);
            }
        }
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.component.isSelectedIndex(index);
    }

    @Override
    public boolean canMove(int[] indices, int offset) {
        boolean returnValue = false;
        if (offset == -1 && !this.isSelectedIndex(0)) {
            returnValue = true;
        }
        if (offset == 1 && !this.isSelectedIndex(this.getCount() - 1)) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
            event.acceptDrag(2);
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
            if (((BaseDualSelector)this.parentSelector).dragGestureInitiator == event.getDropTargetContext().getComponent()) {
                event.rejectDrop();
            } else {
                Transferable transferable = event.getTransferable();
                if (transferable.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    event.acceptDrop(2);
                    if (((BaseDualSelector)this.parentSelector).sourceAdapter == this) {
                        ((BaseDualSelector)this.parentSelector).transferTargetItems();
                    } else {
                        ((BaseDualSelector)this.parentSelector).transferSourceItems();
                    }
                    event.getDropTargetContext().dropComplete(true);
                } else {
                    event.rejectDrop();
                }
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        List selected;
        ((BaseDualSelector)this.parentSelector).dragGestureInitiator = event.getComponent();
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled() && (selected = this.getSelectedItems()) != null) {
            DNDObject items = new DNDObject();
            for (int i = 0; i < selected.size(); ++i) {
                items.add(selected.get(i));
            }
            this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, items, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        if (event.getDropSuccess()) {
            // empty if block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }
}

