/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.ranking;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.ranking.OLAPRankingSelectorInterface;
import com.sas.dataselectors.ranking.RankingSelectorInterface;
import com.sas.dataselectors.ranking.RelationalRankingSelectorInterface;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.Util;
import com.sas.swing.visuals.dataselectors.ranking.RB;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@SASScope(value="ALL")
public class RankingSelector
extends BaseSwingSelectorPanel
implements ActionListener,
ChangeListener,
ItemListener {
    public static final String RB_KEY = "RankingSelector.";
    private Map rankableColumns;
    private Map rankableLevels;
    private Map rankableMeasures;
    private ComboBoxModel rankableLevelIDs;
    private ComboBoxModel rankableMeasureIDs;
    private ComboBoxModel rankableColumnIDs;
    private JComboBox basedOnComboBox;
    private ComboBoxModel comboBoxModel;
    private JLabel basedOnLabel;
    private JLabel ofLabel;
    private JComboBox ofComboBox;
    private JCheckBox bottomCheckBox;
    private JCheckBox topCheckBox;
    private JRadioButton bottomRadio;
    private JRadioButton topRadio;
    private JLabel showLabel;
    private ButtonGroup buttonGroup;
    private JPanel topBottomPanel;
    private JSpinner topSpinner;
    private JSpinner bottomSpinner;
    private boolean topRanking;
    private boolean percentageRanking;
    private boolean isOLAP;

    public RankingSelector() {
        this(true, true);
    }

    public RankingSelector(boolean topRanking, boolean percentageRanking) {
        this.topRanking = topRanking;
        this.percentageRanking = percentageRanking;
    }

    @Override
    public void setSelectorModel(Object selectorModel) {
        if ((selectorModel instanceof RelationalRankingSelectorInterface || selectorModel instanceof OLAPRankingSelectorInterface) && this.selectorModel != selectorModel) {
            this.removeAll();
            this.selectorModel = selectorModel;
            this.isOLAP = selectorModel instanceof OLAPRankingSelectorInterface;
            this.createComponents();
            this.addListeners();
            if (this.isOLAP) {
                int selectedIndex;
                this.rankableLevels = ((OLAPRankingSelectorInterface)selectorModel).rankableLevelNames();
                this.comboBoxModel = Util.getKeysComboModel(this.rankableLevels);
                this.rankableLevelIDs = Util.getValuesComboModel(this.rankableLevels);
                this.ofComboBox.setModel(this.comboBoxModel);
                if (this.comboBoxModel != null && this.comboBoxModel.getSize() > 0) {
                    selectedIndex = 0;
                    this.ofComboBox.setSelectedIndex(selectedIndex);
                    ((OLAPRankingSelectorInterface)selectorModel).rankingLevelName((String)this.rankableLevelIDs.getElementAt(selectedIndex));
                }
                this.rankableMeasures = ((OLAPRankingSelectorInterface)selectorModel).rankableMeasureNames();
                this.comboBoxModel = Util.getKeysComboModel(this.rankableMeasures);
                this.rankableMeasureIDs = Util.getValuesComboModel(this.rankableMeasures);
                this.basedOnComboBox.setModel(this.comboBoxModel);
                if (this.comboBoxModel != null && this.comboBoxModel.getSize() > 0) {
                    selectedIndex = 0;
                    this.basedOnComboBox.setSelectedIndex(selectedIndex);
                    ((OLAPRankingSelectorInterface)selectorModel).rankingMeasureName((String)this.rankableMeasureIDs.getElementAt(selectedIndex));
                }
            } else {
                this.rankableColumns = ((RelationalRankingSelectorInterface)selectorModel).rankableColumnNames();
                this.comboBoxModel = Util.getKeysComboModel(this.rankableColumns);
                this.rankableColumnIDs = Util.getValuesComboModel(this.rankableColumns);
                this.basedOnComboBox.setModel(this.comboBoxModel);
                if (this.comboBoxModel != null && this.comboBoxModel.getSize() > 0) {
                    int selectedIndex = 0;
                    this.basedOnComboBox.setSelectedIndex(selectedIndex);
                    ((RelationalRankingSelectorInterface)selectorModel).rankingColumnName((String)this.rankableColumnIDs.getElementAt(selectedIndex));
                }
            }
        }
    }

    @Override
    public String getDialogTitle() {
        return RB.getStringResource(RB_KEY, "dialogTitle.txt");
    }

    private void createComponents() {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(3, 2, 5, 5, true, false, true);
        this.setLayout(mainLayout);
        this.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.showLabel = new JLabel();
        this.showLabel.setName("showLabel");
        this.showLabel.setText(RB.getStringResource(RB_KEY, "showLabel.txt"));
        this.topBottomPanel = new JPanel();
        this.createTopBottomComponents(this.topBottomPanel);
        if (this.isOLAP) {
            this.ofLabel = new JLabel();
            this.ofLabel.setName("ofLabel");
            this.ofLabel.setText(RB.getStringResource(RB_KEY, "ofLabel.txt"));
            this.ofComboBox = new JComboBox();
            this.ofComboBox.setName("ofComboBox");
        }
        this.basedOnLabel = new JLabel();
        this.basedOnLabel.setName("basedOnLabel");
        this.basedOnLabel.setText(RB.getStringResource(RB_KEY, "basedOnLabel.txt"));
        this.basedOnComboBox = new JComboBox();
        this.basedOnComboBox.setName("basedOnComboBox");
        this.add(this.showLabel);
        this.add(this.topBottomPanel);
        if (this.isOLAP) {
            this.add(this.ofLabel);
            this.add(this.ofComboBox);
        }
        this.add(this.basedOnLabel);
        this.add(this.basedOnComboBox);
    }

    private void addListeners() {
        this.topRadio.addActionListener(this);
        this.bottomRadio.addActionListener(this);
        this.topCheckBox.addActionListener(this);
        this.bottomCheckBox.addActionListener(this);
        this.topSpinner.addChangeListener(this);
        this.bottomSpinner.addChangeListener(this);
        this.basedOnComboBox.addItemListener(this);
        if (this.isOLAP) {
            this.ofComboBox.addItemListener(this);
        }
    }

    private void createTopBottomComponents(JPanel panel) {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, false, true);
        panel.setLayout(mainLayout);
        panel.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        JPanel radioPanel = new JPanel();
        this.createRadioComponents(radioPanel);
        JPanel percentPanel = new JPanel();
        this.createPercentComponents(percentPanel);
        panel.add(radioPanel);
        panel.add(percentPanel);
    }

    private void createRadioComponents(JPanel panel) {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        panel.setLayout(mainLayout);
        panel.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.bottomRadio = new JRadioButton();
        this.bottomRadio.setName("bottomRadio");
        this.bottomRadio.setText(RB.getStringResource(RB_KEY, "bottomRadio.txt"));
        this.topRadio = new JRadioButton();
        this.topRadio.setName("topRadio");
        this.topRadio.setText(RB.getStringResource(RB_KEY, "topRadio.txt"));
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.topRadio);
        this.buttonGroup.add(this.bottomRadio);
        if (this.topRanking) {
            this.topRadio.setSelected(true);
        } else {
            this.bottomRadio.setSelected(true);
        }
        panel.add(this.topRadio);
        panel.add(this.bottomRadio);
    }

    private void createPercentComponents(JPanel panel) {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(2, 2, 5, 5, true, false, true);
        mainLayout.setRemainderColumn(1);
        panel.setLayout(mainLayout);
        panel.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        int initSpinnerValue = ((RankingSelectorInterface)this.selectorModel).rankingCount();
        int minSpinnerValue = 1;
        int maxSpinnerValue = 100;
        int spinnerValueIncr = 1;
        SpinnerNumberModel spinnerModel = null;
        spinnerModel = new SpinnerNumberModel(initSpinnerValue, minSpinnerValue, maxSpinnerValue, spinnerValueIncr);
        this.topSpinner = new JSpinner(spinnerModel);
        this.topSpinner.setName("topSpinner");
        this.topCheckBox = new JCheckBox();
        this.topCheckBox.setName("topCheckBox");
        this.topCheckBox.setText(RB.getStringResource(RB_KEY, "topCheckBox.txt"));
        spinnerModel = new SpinnerNumberModel(initSpinnerValue, minSpinnerValue, maxSpinnerValue, spinnerValueIncr);
        this.bottomSpinner = new JSpinner(spinnerModel);
        this.bottomSpinner.setName("bottomSpinner");
        this.bottomCheckBox = new JCheckBox();
        this.bottomCheckBox.setName("bottomCheckBox");
        this.bottomCheckBox.setText(RB.getStringResource(RB_KEY, "bottomCheckBox.txt"));
        if (this.percentageRanking) {
            this.topCheckBox.setSelected(true);
            this.bottomCheckBox.setSelected(true);
        } else {
            this.topCheckBox.setSelected(false);
            this.bottomCheckBox.setSelected(false);
        }
        panel.add(this.topSpinner);
        panel.add(this.topCheckBox);
        panel.add(this.bottomSpinner);
        panel.add(this.bottomCheckBox);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.topRadio) {
            ((RankingSelectorInterface)this.selectorModel).topRanking(true);
            ((RankingSelectorInterface)this.selectorModel).percentageRanking(this.topCheckBox.isSelected());
            ((RankingSelectorInterface)this.selectorModel).rankingCount((Integer)this.topSpinner.getValue());
        } else if (source == this.bottomRadio) {
            ((RankingSelectorInterface)this.selectorModel).topRanking(false);
            ((RankingSelectorInterface)this.selectorModel).percentageRanking(this.bottomCheckBox.isSelected());
            ((RankingSelectorInterface)this.selectorModel).rankingCount((Integer)this.bottomSpinner.getValue());
        } else if (source == this.topCheckBox) {
            if (((RankingSelectorInterface)this.selectorModel).topRanking()) {
                ((RankingSelectorInterface)this.selectorModel).percentageRanking(this.topCheckBox.isSelected());
            }
        } else if (source == this.bottomCheckBox && !((RankingSelectorInterface)this.selectorModel).topRanking()) {
            ((RankingSelectorInterface)this.selectorModel).percentageRanking(this.bottomCheckBox.isSelected());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.topSpinner) {
            if (((RankingSelectorInterface)this.selectorModel).topRanking()) {
                ((RankingSelectorInterface)this.selectorModel).rankingCount((Integer)this.topSpinner.getValue());
            }
        } else if (source == this.bottomSpinner && !((RankingSelectorInterface)this.selectorModel).topRanking()) {
            ((RankingSelectorInterface)this.selectorModel).rankingCount((Integer)this.bottomSpinner.getValue());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.basedOnComboBox) {
            if (this.isOLAP) {
                ((OLAPRankingSelectorInterface)this.selectorModel).rankingMeasureName((String)this.rankableMeasureIDs.getElementAt(this.basedOnComboBox.getSelectedIndex()));
            } else {
                ((RelationalRankingSelectorInterface)this.selectorModel).rankingColumnName((String)this.rankableColumnIDs.getElementAt(this.basedOnComboBox.getSelectedIndex()));
            }
        } else if (source == this.ofComboBox) {
            ((OLAPRankingSelectorInterface)this.selectorModel).rankingLevelName((String)this.rankableLevelIDs.getElementAt(this.ofComboBox.getSelectedIndex()));
        }
    }
}

