/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.qualifiers;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.LabeledStringValueInterface;
import com.sas.dataselectors.filters.OLAPMemberTreePathFactoryInterface;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

@SASScope(value="ALL")
public class Util {
    public static TreePath getNodePathByValue(TreeModel model, String nodeValue) {
        if (model instanceof OLAPMemberTreePathFactoryInterface) {
            OLAPMemberTreePathFactoryInterface pfi = (OLAPMemberTreePathFactoryInterface)((Object)model);
            try {
                List path = pfi.getTreePathNodeList(nodeValue);
                return new TreePath(path.toArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Util.getNodePathByValue((DefaultMutableTreeNode)model.getRoot(), nodeValue);
    }

    public static TreePath getNodePathByValue(DefaultMutableTreeNode node, String nodeValue) {
        if (node != null && nodeValue != null) {
            LabeledStringValueInterface nodeInfo = (LabeledStringValueInterface)((Object)node);
            if (nodeInfo.getValue().equals(nodeValue)) {
                return new TreePath(node.getPath());
            }
            if (!node.isLeaf()) {
                return Util.getNodePathByValue((DefaultMutableTreeNode)node.getFirstChild(), nodeValue);
            }
            DefaultMutableTreeNode nextSibling = node.getNextSibling();
            if (nextSibling != null) {
                return Util.getNodePathByValue(nextSibling, nodeValue);
            }
            DefaultMutableTreeNode nextNextAncestorSibling = Util.getNextAncestorSibling(node);
            if (nextNextAncestorSibling != null) {
                return Util.getNodePathByValue(nextNextAncestorSibling, nodeValue);
            }
            return null;
        }
        return null;
    }

    private static DefaultMutableTreeNode getNextAncestorSibling(DefaultMutableTreeNode node) {
        if (node != null) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent != null) {
                DefaultMutableTreeNode sibling = parent.getNextSibling();
                if (sibling != null) {
                    return sibling;
                }
                return Util.getNextAncestorSibling(parent);
            }
            return null;
        }
        return null;
    }
}

