/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.qualifiers;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.LabeledStringValueInterface;
import com.sas.dataselectors.qualifiers.AskSelectable;
import com.sas.dataselectors.qualifiers.QualifiersSelectorInterface;
import com.sas.swing.visuals.OptionsDialog;
import com.sas.swing.visuals.dataselectors.qualifiers.QualifiersTree;
import com.sas.swing.visuals.dataselectors.qualifiers.Util;
import com.sas.swing.visuals.util.CommonButtons;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

@SASScope(value="ALL")
public class QualifiersDialog
extends OptionsDialog
implements ActionListener,
ListSelectionListener,
TreeSelectionListener {
    private AbstractButton clearButton;
    private AbstractButton OkButton;
    private AbstractButton CancelButton;
    private int horizontalSpaceBetweenOkAndCancelButtons;
    private String itemLabel;
    private String itemName;
    private String itemsLabel;
    private String itemsNameColumnLabel;
    private String itemsValueColumnLabel;
    private String clearButtonText;
    private String selectedItemID;
    private String itemColumnName;
    private String valueColumnName;
    private String idColumnName;
    private String skippedItem;
    private DataItemsTable dataItemsTable;
    private JTree valuesTree;
    private JLabel iLabel;
    private JLabel iName;
    private JLabel sLabel;
    private TableModel tableModel;
    private JScrollPane tableScollPane;
    private QualifiersSelectorInterface adapter;
    private boolean isEditOK;
    private Map selectedValues;
    private Map selectedNodes;
    private Map initialValues;
    private int selectedRow;
    private String noFilterText;
    private ResourceBundle bundle;
    private String RB_KEY;
    private JPanel mainPanel;

    public QualifiersDialog(Frame parent, String title, boolean modal, QualifiersSelectorInterface adapter) {
        super(parent, title, modal);
        this.setButtons(4096);
        this.adapter = adapter;
        this.horizontalSpaceBetweenOkAndCancelButtons = 7;
        this.RB_KEY = "QualifiersEditorBQ.";
        Locale locale = Locale.getDefault();
        this.bundle = ResourceBundle.getBundle("com.sas.dataselectors.qualifiers.Resources", locale);
        this.isEditOK = false;
        this.itemLabel = this.bundle.getString(this.RB_KEY + "itemLabel.txt");
        this.itemName = this.bundle.getString(this.RB_KEY + "itemName.txt");
        this.itemsLabel = this.bundle.getString(this.RB_KEY + "itemsLabel.txt");
        this.itemsNameColumnLabel = this.bundle.getString(this.RB_KEY + "itemsNameColumnLabel.txt");
        this.itemsValueColumnLabel = this.bundle.getString(this.RB_KEY + "itemsValueColumnLabel.txt");
        this.noFilterText = this.bundle.getString(this.RB_KEY + "noSelection.txt");
        this.itemColumnName = "ITEM";
        this.valueColumnName = "VALUE";
        this.idColumnName = "ID";
        this.selectedValues = new HashMap();
        this.selectedNodes = new HashMap();
        this.mainPanel = this.getMainPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(4, 2, 5, 5, true, true, true);
        layout.setRemainderRow(3);
        this.mainPanel.setLayout(layout);
        this.mainPanel.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.fillMainPanel();
        this.setSize(525, 400);
    }

    public QualifiersDialog(Frame parent, String title, boolean modal) {
        this(parent, title, modal, (QualifiersSelectorInterface)null);
    }

    public void adapter(QualifiersSelectorInterface adapter) {
        this.adapter = adapter;
        if (adapter != null) {
            // empty if block
        }
    }

    private void fillMainPanel() {
        this.iLabel = new JLabel(this.itemLabel);
        this.mainPanel.add(this.iLabel);
        this.iName = new JLabel(this.itemName);
        this.mainPanel.add(this.iName);
        this.sLabel = new JLabel(this.itemsLabel);
        JPanel panelx = new JPanel(new BorderLayout());
        panelx.add((Component)this.sLabel, "North");
        panelx.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.mainPanel.add(panelx);
        this.dataItemsTable = this.createDataItemsTable();
        this.dataItemsTable.getColumn(this.itemColumnName).setPreferredWidth(1);
        this.dataItemsTable.removeColumn(this.dataItemsTable.getColumn(this.idColumnName));
        this.tableScollPane = new JScrollPane(this.dataItemsTable);
        this.itemsListHeight(100);
        this.mainPanel.add(this.tableScollPane);
        this.mainPanel.add(new JLabel(""));
        this.valuesTree = this.createValuesTree();
        this.mainPanel.add(new JScrollPane(this.valuesTree));
        this.mainPanel.add(new JLabel(""));
        this.mainPanel.add(this.getButtonsPanel());
    }

    private JPanel getButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.clearButton = new JButton();
        this.clearButton.setEnabled(false);
        this.clearButton.addActionListener(this);
        buttonsPanel.add((Component)this.clearButton, "West");
        JPanel OkCancelPanel = new JPanel(new GridLayout(1, 2, this.horizontalSpaceBetweenOkAndCancelButtons, 0));
        OkCancelPanel.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        AbstractButton[] OkCancelButtons = CommonButtons.createButtons(3);
        int nButtons = OkCancelButtons.length;
        if (nButtons == 2) {
            this.OkButton = OkCancelButtons[0];
            this.OkButton.addActionListener(this);
            OkCancelPanel.add(this.OkButton);
            this.CancelButton = OkCancelButtons[1];
            this.CancelButton.addActionListener(this);
            OkCancelPanel.add(this.CancelButton);
        }
        buttonsPanel.add((Component)OkCancelPanel, "East");
        return buttonsPanel;
    }

    private DataItemsTable createDataItemsTable() {
        this.tableModel = this.createTableModel();
        DataItemsTable table = new DataItemsTable(this.tableModel);
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(this);
        return table;
    }

    private TableModel createTableModel() {
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn(this.itemColumnName);
        model.addColumn(this.valueColumnName);
        model.addColumn(this.idColumnName);
        int nRows = this.adapter.getNumberOfItems();
        for (int i = 0; i < nRows; ++i) {
            Object[] data = new String[]{this.adapter.getName(i), this.noFilterText, this.adapter.getValue(i)};
            model.addRow(data);
        }
        return model;
    }

    private JTree createValuesTree() {
        QualifiersTree tree = new QualifiersTree();
        tree.setModel(null);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(this);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        renderer.setLeafIcon(null);
        tree.setCellRenderer(renderer);
        return tree;
    }

    public boolean isEditOK() {
        return this.isEditOK;
    }

    @Override
    public void onOK() {
        this.isEditOK = true;
        super.onOK();
    }

    @Override
    public void onCancel() {
        this.isEditOK = false;
        super.onCancel();
    }

    public void itemLabel(String label) {
        this.itemLabel = label;
        this.iLabel.setText(this.itemLabel);
    }

    public void itemName(String name) {
        this.itemName = name;
        this.iName.setText(this.itemName);
    }

    public void itemsLabel(String label) {
        this.itemsLabel = label;
        this.sLabel.setText(this.itemsLabel);
    }

    public void itemsNameColumnLabel(String label) {
        this.itemsNameColumnLabel = label;
        this.dataItemsTable.getColumn(this.itemColumnName).setHeaderValue(this.itemsNameColumnLabel);
    }

    public void itemsValueColumnLabel(String label) {
        this.itemsValueColumnLabel = label;
        this.dataItemsTable.getColumn(this.valueColumnName).setHeaderValue(this.itemsValueColumnLabel);
    }

    public void clearButtonText(String text) {
        this.clearButtonText = text;
        this.clearButton.setText(this.clearButtonText);
    }

    public void skipItem(String itemID) {
        if (itemID != null && !itemID.equals(this.skippedItem)) {
            this.skippedItem = itemID;
            this.tableModel = this.createTableModel();
            this.dataItemsTable.setModel(this.tableModel);
            this.dataItemsTable.getColumn(this.itemColumnName).setPreferredWidth(1);
            this.dataItemsTable.removeColumn(this.dataItemsTable.getColumn(this.idColumnName));
            this.itemsNameColumnLabel(this.itemsNameColumnLabel);
            this.itemsValueColumnLabel(this.itemsValueColumnLabel);
            this.initialValues(this.initialValues);
            int deletedRow = this.getRowIndex(itemID);
            if (deletedRow >= 0) {
                ((DefaultTableModel)this.tableModel).removeRow(deletedRow);
                ((DefaultTableModel)this.tableModel).fireTableRowsDeleted(deletedRow, deletedRow);
            }
        }
    }

    private int getRowIndex(String itemID) {
        int colIndex = ((DefaultTableModel)this.tableModel).findColumn(this.idColumnName);
        int rowIndex = -1;
        int nRows = ((DefaultTableModel)this.tableModel).getRowCount();
        for (int i = 0; i < nRows; ++i) {
            if (!((String)((DefaultTableModel)this.tableModel).getValueAt(i, colIndex)).equals(itemID)) continue;
            rowIndex = i;
            break;
        }
        return rowIndex;
    }

    public void initialValues(Map values) {
        this.clear();
        if (values != null) {
            this.initialValues = values;
            ArrayList list = new ArrayList(values.values());
            this.adapter.setSelectedValues(list);
            for (int i = 0; i < this.adapter.getNumberOfItems(); ++i) {
                int lbIndex = this.getRowIndex(this.adapter.getValue(i));
                if (lbIndex < 0) continue;
                String value = this.adapter.getValue(i);
                String selectedValue = this.adapter.getSelectedValue(i);
                String desc = this.adapter.getDescription(i);
                if (desc == null) {
                    desc = this.noFilterText;
                }
                this.dataItemsTable.getModel().setValueAt(desc.trim(), lbIndex, 1);
                if (selectedValue == null) continue;
                this.selectedValues.put(value, selectedValue);
            }
        }
    }

    private void clear() {
        this.tableModel = this.dataItemsTable.getModel();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            this.tableModel.setValueAt(this.noFilterText, i, 1);
            ((DefaultTableModel)this.tableModel).fireTableCellUpdated(i, 1);
        }
        this.dataItemsTable.getSelectionModel().clearSelection();
        this.selectedRow = -1;
        this.selectedItemID = null;
        this.selectedValues.clear();
        this.selectedNodes.clear();
        this.valuesTree.clearSelection();
        this.valuesTree.setModel(null);
        this.clearButton.setEnabled(false);
    }

    private int getItemPosition(String itemID) {
        int pos = -1;
        int nItems = this.adapter.getNumberOfItems();
        for (int i = 0; i < nItems; ++i) {
            if (!this.adapter.getValue(i).equalsIgnoreCase(itemID)) continue;
            pos = i;
            break;
        }
        return pos;
    }

    public Map selectedValues() {
        return this.selectedValues;
    }

    public void itemsListHeight(int height) {
        this.tableScollPane.setPreferredSize(new Dimension(this.tableScollPane.getWidth(), height));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.clearButton) {
            this.tableModel = this.dataItemsTable.getModel();
            this.tableModel.setValueAt(this.noFilterText, this.selectedRow, 1);
            ((DefaultTableModel)this.tableModel).fireTableCellUpdated(this.selectedRow, 1);
            this.selectedValues.remove(this.selectedItemID);
            this.selectedNodes.remove(this.selectedItemID);
            this.valuesTree.clearSelection();
            this.clearButton.setEnabled(false);
        } else if (source == this.OkButton) {
            this.onOK();
        } else if (source == this.CancelButton) {
            this.onCancel();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.selectedItemID = null;
            this.valuesTree.setModel(null);
            this.selectedRow = -1;
        } else {
            String nodeValue;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.selectedRow = lsm.getMinSelectionIndex();
            this.selectedItemID = (String)this.tableModel.getValueAt(this.selectedRow, 2);
            int itemIndex = this.getItemPosition(this.selectedItemID);
            this.valuesTree.setModel(this.adapter.getTreeModel(itemIndex));
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (this.selectedValues.containsKey(this.selectedItemID) && (nodeValue = (String)this.selectedValues.get(this.selectedItemID)) != null) {
                TreePath nodePath = (TreePath)this.selectedNodes.get(this.selectedItemID);
                if (nodePath == null) {
                    nodePath = Util.getNodePathByValue(this.valuesTree.getModel(), nodeValue);
                }
                if (nodePath != null) {
                    this.valuesTree.setSelectionPath(nodePath);
                }
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.valuesTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (this.valuesTree.getModel() instanceof AskSelectable && !((AskSelectable)((Object)this.valuesTree.getModel())).isSelectable(node)) {
            this.tableModel.setValueAt(this.noFilterText.trim(), this.selectedRow, 1);
            this.selectedValues.remove(this.selectedItemID);
            this.selectedNodes.remove(this.selectedItemID);
            ((DefaultTableModel)this.tableModel).fireTableCellUpdated(this.selectedRow, 1);
            this.clearButton.setEnabled(false);
            return;
        }
        LabeledStringValueInterface lv = (LabeledStringValueInterface)((Object)node);
        String value = lv.getValue();
        this.selectedValues.put(this.selectedItemID, value);
        this.selectedNodes.put(this.selectedItemID, e.getPath());
        this.tableModel.setValueAt(lv.getLabel().trim(), this.selectedRow, 1);
        ((DefaultTableModel)this.tableModel).fireTableCellUpdated(this.selectedRow, 1);
        this.clearButton.setEnabled(true);
    }

    @SASScope
    public class DataItemsTable
    extends JTable {
        public DataItemsTable(TableModel model) {
            super(model);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

