/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.propertyeditor;

import com.sas.beans.PropertyChangeSource;
import com.sas.codepolicy.SASScope;
import com.sas.entities.RemoteEntityInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.EntityAttributeValueModelInterface;
import com.sas.table.UpdateRowInterface;
import com.sas.util.Util;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.AbstractTableModel;

@SASScope(value="ALL")
public class EntityAttributeValueTableModelAdapter
extends AbstractTableModel
implements PropertyChangeSource,
UpdateRowInterface {
    public static final String RB_KEY = "EntityAttributeValueTableModelAdapter.";
    protected Map properties;
    protected RemoteEntityInterface model;
    protected String[] columnNames;
    protected boolean tableEditable;
    protected SwingPropertyChangeSupport spcs;
    protected Locale locale;
    private String context;
    private ArrayList labelsList;
    private ArrayList namesList;
    protected EntityAttributeValueModelInterface modelInterface;

    public EntityAttributeValueTableModelAdapter(EntityAttributeValueModelInterface modelInterface) {
        this.modelInterface = modelInterface;
        this.initialize();
    }

    protected void initialize() {
        this.tableEditable = false;
        this.columnNames = new String[1];
        this.spcs = new SwingPropertyChangeSupport(this);
        this.properties = new HashMap(this.modelInterface.getProperties(Locale.getDefault()));
        Iterator iter = this.properties.keySet().iterator();
        this.labelsList = new ArrayList();
        this.namesList = new ArrayList();
        while (iter.hasNext()) {
            String value = (String)iter.next();
            String label = (String)this.properties.get(value);
            this.namesList.add(value);
            this.labelsList.add(label);
        }
    }

    @Override
    public int getRowCount() {
        return this.properties.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    public Object getPropertyAt(int position) {
        return this.namesList.get(position);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.labelsList.get(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void setColumnName(String columnName, int columnIndex) {
        String oldColumnName = this.columnNames[columnIndex];
        if (Util.unequal((Object)oldColumnName, (Object)columnName)) {
            this.columnNames[columnIndex] = columnName;
            this.fireTableStructureChanged();
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        return "Prompts";
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isTableEditable() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    public boolean isRowUpdateAllowed() {
        return true;
    }
}

