/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.format;

import com.sas.codepolicy.SASScope;
import com.sas.models.formats.FormatDescription;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.dataselectors.format.FormatAdapterInterface;
import com.sas.swing.visuals.dataselectors.format.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@SASScope(value="ALL")
public class FormatSelectorPanel
extends JPanel
implements PanelInterface,
LayoutConstants {
    private static final String RB_KEY = "FormatSelectorPanel.";
    public static final String DEFAULT_FORMAT = "DefaultFormat";
    public static final String UNKNOWN_FORMAT = "UnknownFormat";
    private FormatAdapterInterface formatAdapterInterface;
    private Map comboElementToListModelMap;
    private Map formatCategoryMap;
    private int sqlType;
    private DefaultListModel emptyFormatChoicesModel;
    private DefaultListModel formatChoicesModel;
    protected JList formatChoicesList;
    protected JComboBox formatCategoryCombo;
    private DefaultComboBoxModel formatCategoryComboModel;
    protected JLabel exampleLabel;
    protected JLabel exampleText;
    protected LabelView formatInstructionText;
    protected JSpinner widthSpinner;
    protected JSpinner decimalSpinner;
    protected JLabel widthInstructionLabel;
    protected JLabel decimalInstructionLabel;
    private SpinnerNumberModel widthBounds;
    private SpinnerNumberModel decimalBounds;
    protected JPanel rightPanel;
    private String resultFormatString;
    private WidthSpinnerListener widthSpinnerListener;
    private String incomingFormat;
    private String defaultFormat;
    private boolean contentsValid;
    private FormatDescription m_currentFormatDescription;

    public FormatSelectorPanel(FormatAdapterInterface formatAdapterInterface, int sqlType, String incomingFormat) {
        this(formatAdapterInterface, sqlType, incomingFormat, null);
    }

    @SASScope
    public FormatSelectorPanel(FormatAdapterInterface formatAdapterInterface, int sqlType, String incomingFormat, String defaultFormat) {
        this.formatAdapterInterface = formatAdapterInterface;
        this.sqlType = sqlType;
        this.defaultFormat = defaultFormat;
        this.contentsValid = true;
        this.createLayout();
        this.setFormatDetails(null);
        this.primeComboElementToListModelMap();
        this.addListeners();
        this.setValuesInFormatCategoryComboBox();
        this.incomingFormat = incomingFormat;
        if (incomingFormat != null && incomingFormat.length() > 0) {
            this.setControlsBasedOnIncomingFormatString(incomingFormat);
        }
    }

    private void createLayout() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        layout.setColumnSpacePartitioner(new ProportionalSpacePartitioner(new double[]{0.65, 0.35}));
        this.setLayout(layout);
        AutoSizingGridLayout leftPanelLayout = new AutoSizingGridLayout(0, 1, 5, 5, false, true, true);
        leftPanelLayout.setRemainderRow(3);
        JPanel leftPanel = new JPanel(leftPanelLayout);
        leftPanel.add(new JLabel(RB.getStringResource(RB_KEY, "formatLabel.txt")));
        this.formatCategoryComboModel = new DefaultComboBoxModel();
        this.formatCategoryCombo = new JComboBox(this.formatCategoryComboModel);
        this.formatCategoryCombo.setPrototypeDisplayValue("12345678901234WWWWWW");
        leftPanel.add(this.formatCategoryCombo);
        this.emptyFormatChoicesModel = new DefaultListModel();
        this.formatChoicesList = new JList();
        this.formatChoicesList.setVisibleRowCount(7);
        this.formatChoicesList.setPrototypeCellValue("12345678901234WWWWWW");
        this.formatChoicesList.getSelectionModel().setSelectionMode(0);
        leftPanel.add(new JScrollPane(this.formatChoicesList));
        JPanel spinnersPanel = new JPanel();
        spinnersPanel.setLayout(new AutoSizingGridLayout(2, 2, 5, 5, true, false, true));
        this.widthInstructionLabel = new JLabel();
        spinnersPanel.add(this.widthInstructionLabel);
        this.widthBounds = new SpinnerNumberModel();
        this.widthSpinner = new JSpinner(this.widthBounds);
        spinnersPanel.add(this.widthSpinner);
        this.decimalInstructionLabel = new JLabel();
        spinnersPanel.add(this.decimalInstructionLabel);
        this.decimalBounds = new SpinnerNumberModel();
        this.decimalSpinner = new JSpinner(this.decimalBounds);
        spinnersPanel.add(this.decimalSpinner);
        leftPanel.add(spinnersPanel);
        this.add(leftPanel);
        AutoSizingGridLayout rightPanelLayout = new AutoSizingGridLayout(0, 1, 5, 5, false, false, true);
        this.rightPanel = new JPanel(rightPanelLayout);
        this.rightPanel.add(new JLabel(" "));
        this.formatInstructionText = new LabelView();
        this.formatInstructionText.setVerticalAlignment(1);
        this.formatInstructionText.setWrapStyleWord(true);
        this.formatInstructionText.setLineWrap(true);
        this.rightPanel.add(this.formatInstructionText);
        this.exampleLabel = new JLabel();
        this.rightPanel.add(this.exampleLabel);
        this.exampleText = new JLabel();
        this.exampleText.setVerticalAlignment(1);
        this.rightPanel.add(this.exampleText);
        this.add(this.rightPanel);
        Dimension size = this.getPreferredSize();
        this.setSize(480, (int)size.getHeight());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FormatSelectorPanel.this.formatInstructionText.setPreferredSpanSize(new Dimension(FormatSelectorPanel.this.rightPanel.getSize().width, -1));
            }
        });
    }

    private void primeComboElementToListModelMap() {
        this.comboElementToListModelMap = new LinkedHashMap();
        if (this.defaultFormat == null || this.defaultFormat.trim().length() == 0) {
            this.comboElementToListModelMap.put(new FormatTypeComboxBoxElement(DEFAULT_FORMAT, RB.getStringResource(RB_KEY, "defaultFormat.txt")), new DefaultListModel());
        } else {
            this.comboElementToListModelMap.put(new FormatTypeComboxBoxElement(DEFAULT_FORMAT, Message.format((String)RB.getStringResource(RB_KEY, "defaultFormat.fmt.txt"), (Object)this.defaultFormat)), new DefaultListModel());
        }
        try {
            this.formatCategoryMap = this.formatAdapterInterface.getFormatTypes(this.sqlType, Locale.getDefault());
            for (Map.Entry entry : this.formatCategoryMap.entrySet()) {
                this.comboElementToListModelMap.put(new FormatTypeComboxBoxElement(entry.getKey(), (String)entry.getValue()), null);
            }
        }
        catch (IllegalStateException ise) {
            this.formatInstructionText.setText(ise.getLocalizedMessage());
        }
    }

    private void setValuesInFormatCategoryComboBox() {
        Iterator it = this.comboElementToListModelMap.keySet().iterator();
        while (it.hasNext()) {
            this.formatCategoryComboModel.addElement(it.next());
        }
    }

    private void setControlsBasedOnIncomingFormatString(String incomingFormat) {
        String[] parseResults = SASFormat.parseFormat((String)incomingFormat);
        if (parseResults[0] != null && parseResults[0].length() != 0) {
            for (FormatTypeComboxBoxElement cbe : this.comboElementToListModelMap.keySet()) {
                DefaultListModel listModel = this.getFormatChoices(cbe);
                int listSize = listModel.getSize();
                for (int i = 0; i < listSize; ++i) {
                    FormatChoicesListElement le = (FormatChoicesListElement)listModel.getElementAt(i);
                    if (!le.toString().equalsIgnoreCase(parseResults[0])) continue;
                    this.formatCategoryComboModel.setSelectedItem(cbe);
                    this.formatChoicesList.setSelectedValue(le, true);
                    if (parseResults[1] != null && parseResults[1].length() > 0) {
                        int width = Integer.parseInt(parseResults[1]);
                        int min = (Integer)this.widthBounds.getMinimum();
                        int max = (Integer)this.widthBounds.getMaximum();
                        if (width >= min && width <= max) {
                            this.widthBounds.setValue(new Integer(width));
                            if (parseResults[2] != null && parseResults[2].length() > 0) {
                                int dec = Integer.parseInt(parseResults[2]);
                                min = (Integer)this.decimalBounds.getMinimum();
                                max = (Integer)this.decimalBounds.getMaximum();
                                if (dec >= min && dec <= max) {
                                    this.decimalBounds.setValue(new Integer(dec));
                                }
                            }
                        }
                    }
                    return;
                }
            }
        }
        if (incomingFormat != null) {
            FormatTypeComboxBoxElement cbe = new FormatTypeComboxBoxElement(UNKNOWN_FORMAT, Message.format((String)RB.getStringResource(RB_KEY, "unknownFormat.fmt.txt"), (Object)incomingFormat));
            DefaultListModel list = new DefaultListModel();
            this.comboElementToListModelMap.put(cbe, list);
            this.formatCategoryComboModel.addElement(cbe);
            this.formatCategoryComboModel.setSelectedItem(cbe);
            this.setFormatDetails(null);
        }
    }

    private void addListeners() {
        this.formatCategoryCombo.addActionListener(new ComboActionListener());
        this.formatChoicesList.addListSelectionListener(new ListListener());
        this.widthSpinnerListener = new WidthSpinnerListener();
        this.widthSpinner.addChangeListener(this.widthSpinnerListener);
    }

    public String getFormatString() {
        return this.resultFormatString;
    }

    private void setFormatDetails(FormatDescription fd) {
        if (fd == null) {
            this.formatInstructionText.setText("");
            this.exampleLabel.setText("");
            this.exampleText.setText("");
        } else {
            this.formatInstructionText.setText(fd.getDescription());
            this.exampleLabel.setText(RB.getStringResource(RB_KEY, "exampleLabel.txt"));
            String example = fd.getExample();
            if (example != null && example.length() > 0) {
                this.exampleText.setText(example);
            } else {
                this.exampleText.setText(RB.getStringResource(RB_KEY, "notAvailable.txt"));
            }
        }
        this.setWidthValues(fd);
        this.setDecimalValues(fd, null);
    }

    private void setWidthValues(FormatDescription fd) {
        if (fd == null) {
            this.disableSpinner(this.widthSpinner, this.widthSpinnerListener);
            this.widthInstructionLabel.setText(RB.getStringResource(RB_KEY, "validWidthRangeLabel1.txt"));
            this.widthInstructionLabel.setEnabled(false);
        } else {
            this.widthSpinner.setEnabled(false);
            this.widthSpinner.removeChangeListener(this.widthSpinnerListener);
            this.widthBounds.setMinimum(new Integer(fd.getMinWidth()));
            this.widthBounds.setMaximum(new Integer(fd.getMaxWidth()));
            this.widthSpinner.addChangeListener(this.widthSpinnerListener);
            this.widthBounds.setValue(new Integer(fd.getDefaultWidth()));
            boolean enabled = !this.widthBounds.getMinimum().equals(this.widthBounds.getMaximum());
            this.widthSpinner.setEnabled(enabled);
            String messageText = Message.format((String)RB.getStringResource(RB_KEY, "validWidthRangeLabel2.txt"), (Object)new Integer(fd.getMinWidth()), (Object)new Integer(fd.getMaxWidth()));
            this.widthInstructionLabel.setText(messageText);
            this.widthInstructionLabel.setEnabled(enabled);
        }
    }

    private void setDecimalValues(FormatDescription fd, Integer currentValue) {
        this.m_currentFormatDescription = fd;
        if (fd != null && fd.isDecimalWidthSupported()) {
            int minDec = fd.getMinDecimalWidth();
            int maxDec = Math.min(fd.getMaxDecimalWidth(), this.getFormatWidth() - 1);
            int newValue = 0;
            newValue = currentValue != null ? currentValue.intValue() : fd.getDefaultDecimalWidth();
            newValue = Math.min(newValue, maxDec);
            this.decimalBounds.setMinimum(new Integer(minDec));
            this.decimalBounds.setMaximum(new Integer(maxDec));
            this.decimalBounds.setValue(new Integer(newValue));
            boolean enabled = !this.decimalBounds.getMinimum().equals(this.decimalBounds.getMaximum());
            this.decimalInstructionLabel.setEnabled(enabled);
            this.decimalSpinner.setEnabled(enabled);
            String messageText = this.getDecimalRangeLabelText(minDec, maxDec);
            this.decimalInstructionLabel.setText(messageText);
        } else {
            this.disableSpinner(this.decimalSpinner, null);
            this.decimalInstructionLabel.setEnabled(false);
            String messageText = this.getDecimalRangeNotValidLabelText();
            this.decimalInstructionLabel.setText(messageText);
        }
    }

    private String getDecimalRangeLabelText(int minDec, int maxDec) {
        return Message.format((String)RB.getStringResource(RB_KEY, "validDecRangeLabel2.txt"), (Object)new Integer(minDec), (Object)new Integer(maxDec));
    }

    private String getDecimalRangeNotValidLabelText() {
        return RB.getStringResource(RB_KEY, "validDecRangeLabel1.txt");
    }

    protected int getFormatWidth() {
        return this.widthBounds.getNumber().intValue();
    }

    private void disableSpinner(JSpinner spinner, ChangeListener changeListener) {
        SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
        if (changeListener != null) {
            spinner.removeChangeListener(changeListener);
        }
        model.setMinimum(new Integer(0));
        model.setMaximum(new Integer(0));
        if (changeListener != null) {
            spinner.addChangeListener(changeListener);
        }
        spinner.setValue(new Integer(0));
        spinner.setEnabled(false);
    }

    private void updateSpinValues() {
        int decimalValue = this.decimalBounds.getNumber().intValue();
        this.setDecimalValues(this.m_currentFormatDescription, new Integer(decimalValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultListModel getFormatChoices(FormatTypeComboxBoxElement cbe) {
        DefaultListModel<FormatChoicesListElement> model = (DefaultListModel<FormatChoicesListElement>)this.comboElementToListModelMap.get(cbe);
        if (model == null) {
            model = new DefaultListModel<FormatChoicesListElement>();
            try {
                List list = this.formatAdapterInterface.getFormatByType(cbe.key, Locale.getDefault());
                for (FormatDescription fd : list) {
                    model.addElement(new FormatChoicesListElement(fd));
                }
            }
            catch (IllegalStateException ise) {
                this.formatInstructionText.setText(ise.getLocalizedMessage());
            }
            finally {
                this.comboElementToListModelMap.put(cbe, model);
            }
        }
        return model;
    }

    @Override
    public void onApply() {
        FormatChoicesListElement le = (FormatChoicesListElement)this.formatChoicesList.getSelectedValue();
        if (le == null) {
            if (this.formatCategoryCombo.getSelectedItem() != null && ((FormatTypeComboxBoxElement)this.formatCategoryCombo.getSelectedItem()).key == UNKNOWN_FORMAT) {
                this.setContentsValid(true);
                this.resultFormatString = this.incomingFormat;
                return;
            }
            if (this.formatCategoryCombo.getSelectedItem() != null && ((FormatTypeComboxBoxElement)this.formatCategoryCombo.getSelectedItem()).key == DEFAULT_FORMAT) {
                this.setContentsValid(true);
                this.resultFormatString = null;
                return;
            }
            this.setContentsValid(false);
            JOptionPane.showMessageDialog(this, RB.getStringResource(RB_KEY, "noFormatSelected.txt"), RB.getStringResource(RB_KEY, "noFormatSelectedTitle.txt"), 0);
            this.resultFormatString = null;
            return;
        }
        this.setContentsValid(true);
        FormatDescription fd = le.formatDescription;
        int width = this.widthBounds.getNumber().intValue();
        int decimalWidth = this.decimalBounds.getNumber().intValue();
        String baseFormat = fd.getBaseFormatName();
        StringBuffer sb = new StringBuffer(baseFormat);
        if (fd.isWidthSupported()) {
            sb.append(width);
        }
        sb.append('.');
        if (fd.isDecimalWidthSupported() && decimalWidth >= 0) {
            sb.append(decimalWidth);
        }
        this.resultFormatString = sb.toString();
    }

    @Override
    @SASScope
    public String getDialogTitle() {
        return RB.getStringResource("FormatSelector.dialogTitle.txt");
    }

    @Override
    @SASScope
    public String getHelpID() {
        return null;
    }

    @Override
    @SASScope
    public JComponent getPanel() {
        return this;
    }

    @Override
    @SASScope
    public String getTabTitle() {
        return null;
    }

    @Override
    @SASScope
    public boolean isContentsValid() {
        return this.contentsValid;
    }

    @Override
    @SASScope
    public boolean isYesNo() {
        return false;
    }

    @Override
    @SASScope
    public void onCancel() {
    }

    @Override
    @SASScope
    public void onClose() {
    }

    @Override
    @SASScope
    public void setContentsValid(boolean newValue) {
        this.contentsValid = newValue;
    }

    @SASScope
    private static class FormatChoicesListElement {
        FormatDescription formatDescription;

        FormatChoicesListElement(FormatDescription formatDescription) {
            this.formatDescription = formatDescription;
        }

        public String toString() {
            return this.formatDescription.getBaseFormatName();
        }
    }

    @SASScope
    private static class FormatTypeComboxBoxElement {
        Object key;
        String displayText;

        FormatTypeComboxBoxElement(Object key, String displayText) {
            this.key = key;
            this.displayText = displayText;
        }

        public String toString() {
            return this.displayText;
        }
    }

    @SASScope
    private class WidthSpinnerListener
    implements ChangeListener {
        private WidthSpinnerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FormatSelectorPanel.this.updateSpinValues();
        }
    }

    @SASScope
    private class ListListener
    implements ListSelectionListener {
        private ListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            FormatChoicesListElement le = (FormatChoicesListElement)FormatSelectorPanel.this.formatChoicesList.getSelectedValue();
            if (le == null) {
                FormatSelectorPanel.this.setFormatDetails(null);
            } else {
                FormatSelectorPanel.this.setFormatDetails(le.formatDescription);
            }
        }
    }

    @SASScope
    private class ComboActionListener
    implements ActionListener {
        private ComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormatTypeComboxBoxElement cbe = (FormatTypeComboxBoxElement)FormatSelectorPanel.this.formatCategoryCombo.getSelectedItem();
            FormatSelectorPanel.this.setFormatDetails(null);
            if (cbe == null) {
                FormatSelectorPanel.this.formatChoicesModel = FormatSelectorPanel.this.emptyFormatChoicesModel;
            } else {
                FormatSelectorPanel.this.formatChoicesModel = FormatSelectorPanel.this.getFormatChoices(cbe);
            }
            FormatSelectorPanel.this.formatChoicesList.setModel(FormatSelectorPanel.this.formatChoicesModel);
            if (FormatSelectorPanel.this.formatChoicesModel != null && FormatSelectorPanel.this.formatChoicesModel.size() > 0) {
                FormatSelectorPanel.this.formatChoicesList.setSelectedIndex(0);
            }
        }
    }
}

