/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters.editors;

import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dataselectors.filters.editors.SimpleDualListSelector;
import com.sas.swing.visuals.dataselectors.filters.editors.ValueEditorInterface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ValueEditorSimpleDualListSelector
extends SimpleDualListSelector
implements ValueEditorInterface {
    transient List valueEditorActionListeners = new ArrayList();

    public ValueEditorSimpleDualListSelector(JComponent parent, String labelFrom, String labelTo, String name, List listOfAvailableValues) {
        this.setBounds(new Rectangle(0, 0, 373, 100));
        this.setName(name);
        if (labelTo != null) {
            this.setSelectedListLabel(labelTo);
        }
        if (labelFrom != null) {
            this.setAvailableListLabel(labelFrom);
        }
        CollectionToListModelAdapter tmpModel = new CollectionToListModelAdapter();
        tmpModel.setModel(listOfAvailableValues);
        this.setModel(tmpModel);
        parent.add((Component)this, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 6, 2, 6), 0, 0));
        InnerListSelectionListener myListSelectionListener = new InnerListSelectionListener();
        this.addListSelectionListener(myListSelectionListener);
        this.clearSelection();
    }

    @Override
    public List setEditorValues(List newValues) {
        ListModel lm = this.getModel();
        this.clearSelection();
        ArrayList vals = new ArrayList(newValues);
        if (vals.size() == 0) {
            return vals;
        }
        int[] setIdx = new int[vals.size()];
        int setSize = 0;
        int j = 0;
        Iterator iter = vals.iterator();
        block0: while (iter.hasNext()) {
            Object val = iter.next();
            for (int i = 0; i < lm.getSize(); ++i) {
                Object val2 = lm.getElementAt(i);
                if (!val2.equals(val)) continue;
                setIdx[j] = i;
                ++j;
                ++setSize;
                iter.remove();
                continue block0;
            }
        }
        int[] setIndices = new int[setSize];
        while (setSize > 0) {
            setIndices[--setSize] = setIdx[setSize];
        }
        this.setSelectedIndices(setIndices);
        return vals;
    }

    @Override
    public List getEditorValues() {
        ArrayList<Object> vals = new ArrayList<Object>();
        Object[] objs = this.getSelectedValues();
        for (int i = 0; i < objs.length; ++i) {
            vals.add(objs[i]);
        }
        return vals;
    }

    @Override
    public List copyEditorValues(ValueEditorInterface fromEditor) {
        List vals = fromEditor.getEditorValues();
        List remainingVals = this.setEditorValues(vals);
        return remainingVals;
    }

    @Override
    public void addValueEditorActionListener(ActionListener l) {
        if (this.valueEditorActionListeners.contains(l)) {
            return;
        }
        this.valueEditorActionListeners.add(l);
    }

    @Override
    public void removeValueEditorActionListener(ActionListener l) {
        if (!this.valueEditorActionListeners.contains(l)) {
            return;
        }
        this.valueEditorActionListeners.remove(l);
    }

    public void notifyValueEditorActionListeners(String command) {
        ActionEvent event = new ActionEvent(this, 1001, command);
        for (ActionListener listener : this.valueEditorActionListeners) {
            listener.actionPerformed(event);
        }
    }

    private class InnerListSelectionListener
    implements ListSelectionListener {
        private InnerListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            Object obj = event.getSource();
            if (!event.getValueIsAdjusting()) {
                ValueEditorSimpleDualListSelector.this.notifyValueEditorActionListeners(obj.toString());
            }
        }
    }
}

