/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters.editors;

import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dataselectors.filters.editors.ValueEditorInterface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ValueEditorJList
extends JList
implements ValueEditorInterface {
    transient List valueEditorActionListeners = new ArrayList();
    transient JLabel valueLabel = null;

    public ValueEditorJList(JComponent parent, String label, String name, List listOfAvailableValues) {
        if (label != null) {
            this.valueLabel = new JLabel();
            this.valueLabel.setBounds(new Rectangle(0, 100, 205, 17));
            this.valueLabel.setName(label);
            this.valueLabel.setText(label);
        }
        this.setBounds(new Rectangle(0, 0, 148, 23));
        CollectionToListModelAdapter tmpModel = new CollectionToListModelAdapter();
        tmpModel.setModel(listOfAvailableValues);
        this.setModel(tmpModel);
        this.clearSelection();
        this.setName(name);
        JScrollPane tmpScrollPane = new JScrollPane(this);
        tmpScrollPane.setBounds(new Rectangle(205, 142, 168, 24));
        tmpScrollPane.setName("Scroll " + name);
        if (this.valueLabel != null) {
            this.valueLabel.setLabelFor(this);
        }
        JComboBox tmpBug = new JComboBox();
        tmpScrollPane.setBorder(tmpBug.getBorder());
        if (parent.getLayout() instanceof GridBagLayout) {
            if (this.valueLabel != null) {
                parent.add((Component)this.valueLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 6, 0, 5), 0, 0));
            }
            parent.add((Component)tmpScrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(2, 4, 2, 6), 0, 0));
        } else {
            if (this.valueLabel != null) {
                parent.add(this.valueLabel);
            }
            parent.add(tmpScrollPane);
        }
        InnerListSelectionListener myListener = new InnerListSelectionListener();
        this.addListSelectionListener(myListener);
        this.clearSelection();
    }

    @Override
    public List setEditorValues(List newValues) {
        ArrayList vals = new ArrayList(newValues);
        if (vals.size() == 0) {
            return vals;
        }
        ValueEditorJList jlist = this;
        ListModel lm = jlist.getModel();
        int[] setIdx = new int[vals.size()];
        int j = 0;
        Iterator iter = vals.iterator();
        block0: while (iter.hasNext()) {
            Object val = iter.next();
            for (int i = 0; i < lm.getSize(); ++i) {
                Object val2 = lm.getElementAt(i);
                if (!val2.equals(val)) continue;
                setIdx[j++] = i;
                iter.remove();
                continue block0;
            }
        }
        jlist.clearSelection();
        jlist.setSelectedIndices(setIdx);
        return vals;
    }

    @Override
    public List getEditorValues() {
        ArrayList<Object> vals = new ArrayList<Object>();
        ValueEditorJList jlist = this;
        Object[] objs = jlist.getSelectedValues();
        for (int i = 0; i < objs.length; ++i) {
            vals.add(objs[i]);
        }
        return vals;
    }

    @Override
    public List copyEditorValues(ValueEditorInterface fromEditor) {
        List vals = fromEditor.getEditorValues();
        List remainingVals = this.setEditorValues(vals);
        return remainingVals;
    }

    @Override
    public void addValueEditorActionListener(ActionListener l) {
        if (this.valueEditorActionListeners.contains(l)) {
            return;
        }
        this.valueEditorActionListeners.add(l);
    }

    @Override
    public void removeValueEditorActionListener(ActionListener l) {
        if (!this.valueEditorActionListeners.contains(l)) {
            return;
        }
        this.valueEditorActionListeners.remove(l);
    }

    public void notifyValueEditorActionListeners(String command) {
        ActionEvent event = new ActionEvent(this, 1001, command);
        for (ActionListener listener : this.valueEditorActionListeners) {
            listener.actionPerformed(event);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.valueLabel.setEnabled(enable);
    }

    class InnerListSelectionListener
    implements ListSelectionListener {
        InnerListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            Object obj = event.getSource();
            if (!event.getValueIsAdjusting()) {
                ValueEditorJList.this.notifyValueEditorActionListeners(obj.toString());
            }
        }
    }
}

