/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters.editors;

import com.sas.swing.models.CollectionToComboBoxModelAdapter;
import com.sas.swing.visuals.dataselectors.filters.editors.ValueEditorInterface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ValueEditorJComboBox
extends JComboBox
implements ValueEditorInterface {
    transient List valueEditorActionListeners = new ArrayList();
    transient JLabel valueLabel = null;

    public ValueEditorJComboBox(JComponent parent, String label, String name, List listOfAvailableValues) {
        if (label != null) {
            this.valueLabel = new JLabel();
            this.valueLabel.setBounds(new Rectangle(0, 100, 205, 17));
            this.valueLabel.setName(label);
            this.valueLabel.setText(label);
        }
        this.setBounds(new Rectangle(205, 100, 168, 21));
        CollectionToComboBoxModelAdapter tmpModel = new CollectionToComboBoxModelAdapter();
        tmpModel.setModel(listOfAvailableValues);
        this.setModel(tmpModel);
        this.setName(name);
        this.setRenderer(new HintCellRenderer("<pick a value from the list>"));
        if (this.valueLabel != null) {
            this.valueLabel.setLabelFor(this);
            parent.add((Component)this.valueLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 6, 0, 5), 0, 0));
        }
        parent.add((Component)this, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 12, 2, new Insets(2, 2, 2, 6), 0, 0));
        InnerActionListener myActionListener = new InnerActionListener();
        this.addActionListener(myActionListener);
        this.setSelectedIndex(-1);
    }

    @Override
    public List setEditorValues(List newValues) {
        ArrayList vals = new ArrayList(newValues);
        if (vals.size() == 0) {
            return vals;
        }
        ValueEditorJComboBox cbox = this;
        ComboBoxModel lm = cbox.getModel();
        Object val = vals.get(0);
        int setIdx = -1;
        for (int i = 0; i < lm.getSize(); ++i) {
            Object val2 = lm.getElementAt(i);
            if (!val2.equals(val)) continue;
            setIdx = i;
            vals.remove(0);
            break;
        }
        cbox.setSelectedIndex(setIdx);
        return vals;
    }

    @Override
    public List getEditorValues() {
        ArrayList<Object> vals = new ArrayList<Object>();
        ValueEditorJComboBox cbox = this;
        Object val = cbox.getSelectedItem();
        if (val != null) {
            vals.add(val);
        }
        return vals;
    }

    @Override
    public List copyEditorValues(ValueEditorInterface fromEditor) {
        List vals = fromEditor.getEditorValues();
        List remainingVals = this.setEditorValues(vals);
        return remainingVals;
    }

    @Override
    public void addValueEditorActionListener(ActionListener l) {
        if (this.valueEditorActionListeners.contains(l)) {
            return;
        }
        this.valueEditorActionListeners.add(l);
    }

    @Override
    public void removeValueEditorActionListener(ActionListener l) {
        if (!this.valueEditorActionListeners.contains(l)) {
            return;
        }
        this.valueEditorActionListeners.remove(l);
    }

    public void notifyValueEditorActionListeners(String command) {
        ActionEvent event = new ActionEvent(this, 1001, command);
        for (ActionListener listener : this.valueEditorActionListeners) {
            listener.actionPerformed(event);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.valueLabel.setEnabled(enable);
    }

    class HintCellRenderer
    extends BasicComboBoxRenderer
    implements ListCellRenderer {
        public String hint = null;

        public HintCellRenderer(String newHint) {
            this.hint = newHint;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component basic = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this.hint != null && value == null && index == -1) {
                this.setText(this.hint);
            }
            return this;
        }
    }

    private class InnerActionListener
    implements ActionListener {
        private InnerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ValueEditorJComboBox.this.notifyValueEditorActionListeners(event.getActionCommand());
        }
    }
}

