/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.swing.visuals.dataselectors.filters.FilterValueProviderPanelInterface;
import com.sas.swing.visuals.dataselectors.filters.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@SASScope
public class UserDefinedValueEditorPanel
extends JPanel
implements ListSelectionListener,
LayoutConstants,
FilterValueProviderPanelInterface {
    public static final String RB_KEY = "UserDefinedValueEditorPanel.";
    private JList valueList;
    private DefaultListModel listModel;
    private static final String addString = "Add";
    private static final String deleteString = "Delete";
    private static final String editString = "Edit";
    private JButton addButton;
    private JButton deleteButton;
    private JButton editButton;
    private JTextField valueTextField;

    public UserDefinedValueEditorPanel() {
        this.createComponents();
        this.addListeners();
    }

    protected void addListeners() {
        this.valueList.addListSelectionListener(this);
        AddListener addListener = new AddListener(this.addButton);
        this.addButton.addActionListener(addListener);
        this.valueTextField.addActionListener(addListener);
        this.valueTextField.getDocument().addDocumentListener(addListener);
        ValueListListener deleteAndEditListener = new ValueListListener();
        this.deleteButton.addActionListener(deleteAndEditListener);
        this.editButton.addActionListener(deleteAndEditListener);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                UserDefinedValueEditorPanel.this.valueTextField.requestFocus();
            }
        });
    }

    protected void createComponents() {
        this.listModel = new DefaultListModel();
        this.valueList = new JList(this.listModel);
        this.valueList.setName("nValueList");
        this.valueList.setSelectionMode(2);
        this.valueList.setSelectedIndex(0);
        this.valueList.setVisibleRowCount(10);
        this.valueList.setCellRenderer(new ListValueRenderer());
        JScrollPane scroller = new JScrollPane(this.valueList);
        Insets buttonInsets = new Insets(1, 1, 1, 1);
        this.addButton = new JButton();
        this.addButton.setName("nListAddButton");
        this.addButton.setMargin(buttonInsets);
        this.addButton.setIcon(Resources.getImageIcon((String)"AddBlack"));
        this.addButton.setToolTipText(RB.getStringResource(RB_KEY, "addButtonToolTip.txt"));
        this.addButton.setActionCommand(addString);
        this.addButton.setEnabled(false);
        this.deleteButton = new JButton();
        this.deleteButton.setName("nListDeleteButton");
        this.deleteButton.setMargin(buttonInsets);
        this.deleteButton.setIcon(Resources.getImageIcon((String)"DeleteBlack"));
        this.deleteButton.setToolTipText(RB.getStringResource(RB_KEY, "deleteButtonToolTip.txt"));
        this.deleteButton.setActionCommand(deleteString);
        this.deleteButton.setEnabled(false);
        this.editButton = new JButton();
        this.editButton.setName("nListEditButton");
        this.editButton.setMargin(buttonInsets);
        this.editButton.setIcon(Resources.getImageIcon((String)"Pencil"));
        this.editButton.setToolTipText(RB.getStringResource(RB_KEY, "editButtonToolTip.txt"));
        this.editButton.setActionCommand(editString);
        this.editButton.setEnabled(false);
        this.editButton.setVisible(false);
        this.valueTextField = new JTextField(){

            @Override
            protected void processKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 10 && e.getID() == 401) {
                    UserDefinedValueEditorPanel.this.doAddAction();
                } else {
                    super.processKeyEvent(e);
                }
            }
        };
        this.valueTextField.setName("nListValueTextField");
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(2, 2, 5, 5, true, true, true);
        mainLayout.setRemainderColumn(1);
        this.setLayout(mainLayout);
        JPanel lowerButtonPanel = new JPanel();
        AutoSizingGridLayout lowerButtonPanelLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, false);
        lowerButtonPanelLayout.setIgnoreSizeOfNonVisibleComponents(true);
        lowerButtonPanelLayout.setGridGravity(4);
        lowerButtonPanel.setLayout(lowerButtonPanelLayout);
        lowerButtonPanel.add(this.editButton);
        lowerButtonPanel.add(this.deleteButton);
        this.add(this.valueTextField);
        this.add(this.addButton);
        this.add(scroller);
        this.add(lowerButtonPanel);
    }

    @Override
    public List getSelectedValues() {
        ArrayList<String> values = new ArrayList<String>();
        int size = this.listModel.getSize();
        String textValue = this.valueTextField.getText();
        if (textValue != null && textValue.length() > 0 && (size == 0 || this.indexInList(textValue) == -1)) {
            values.add(textValue);
        }
        for (int i = 0; i < size; ++i) {
            values.add((String)this.listModel.getElementAt(i));
        }
        return values;
    }

    @Override
    public void setSelectedValues(List values) {
        this.listModel.clear();
        this.valueList.getSelectionModel().clearSelection();
        this.valueTextField.setText("");
        if (values != null) {
            if (values.size() == 1 || values.size() == 2 && values.get(1) == null) {
                String valueText = "";
                Object val = values.get(0);
                if (val instanceof String || val instanceof FilterValueInterface && ((FilterValueInterface)val).getUnformattedValue() instanceof String) {
                    valueText = val.toString().trim();
                }
                this.valueTextField.setText(valueText);
            } else {
                for (Object val : values) {
                    if (val == null) continue;
                    this.listModel.addElement(val);
                }
            }
        }
        this.valueTextField.requestFocusInWindow();
        this.firePropertyChange("selectionChanged", null, this.getSelectedValues());
    }

    @Override
    public boolean isSelectionComplete() {
        String value = this.valueTextField.getText();
        return this.listModel.getSize() > 0 || value != null && value.length() > 0;
    }

    public void setListValueRenderer(ListCellRenderer renderer) {
        ListCellRenderer oldValue = this.valueList.getCellRenderer();
        if (renderer == oldValue) {
            return;
        }
        this.valueList.setCellRenderer(renderer);
        this.firePropertyChange("listValueRenderer", oldValue, renderer);
    }

    protected int indexInList(String value) {
        if (value == null || value.length() == 0) {
            return -1;
        }
        int size = this.listModel.getSize();
        for (int i = 0; i < size; ++i) {
            Object obj = this.listModel.get(i);
            String valueToCompare = null;
            if (obj instanceof FilterValueInterface) {
                FilterValueInterface val = (FilterValueInterface)obj;
                valueToCompare = val.getUnformattedValue().toString();
            } else {
                valueToCompare = obj.toString().trim();
            }
            if (!value.equals(valueToCompare)) continue;
            return i;
        }
        return -1;
    }

    private void doAddAction() {
        String value = this.valueTextField.getText();
        if (value.equals("")) {
            this.valueTextField.requestFocusInWindow();
            this.valueTextField.selectAll();
            return;
        }
        int index = this.indexInList(value);
        if (index != -1) {
            this.listModel.setElementAt(value, index);
        } else {
            index = this.valueList.getSelectedIndex();
            index = this.valueList.getModel().getSize() == 0 || index == -1 ? 0 : ++index;
            this.listModel.insertElementAt(value, index);
        }
        this.valueTextField.requestFocusInWindow();
        this.valueTextField.setText("");
        this.valueList.setSelectedIndex(index);
        this.valueList.ensureIndexIsVisible(index);
        this.firePropertyChange("selectionChanged", null, this.getSelectedValues());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int selectionCount = this.valueList.getSelectedIndices().length;
            if (this.valueList.getSelectedIndex() == -1) {
                this.deleteButton.setEnabled(false);
                this.editButton.setEnabled(false);
            } else if (selectionCount == 1) {
                this.deleteButton.setEnabled(true);
                this.editButton.setEnabled(true);
            } else if (selectionCount > 1) {
                this.deleteButton.setEnabled(true);
                this.editButton.setEnabled(false);
            }
        }
    }

    @SASScope
    class ListValueRenderer
    extends DefaultListCellRenderer {
        ListValueRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Object listValue = value;
            if (value instanceof FilterValueInterface) {
                listValue = ((FilterValueInterface)value).getUnformattedValue();
            }
            String text = listValue != null ? listValue.toString().trim() : "";
            this.setText(text);
            return component;
        }
    }

    @SASScope
    class AddListener
    implements ActionListener,
    DocumentListener {
        private boolean alreadyEnabled = false;
        private JButton button;

        public AddListener(JButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserDefinedValueEditorPanel.this.doAddAction();
        }

        protected boolean alreadyInList(String name) {
            return UserDefinedValueEditorPanel.this.listModel.contains(name);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.enableButton();
            UserDefinedValueEditorPanel.this.firePropertyChange("selectionChanged", null, UserDefinedValueEditorPanel.this.getSelectedValues());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleEmptyTextField(e);
            UserDefinedValueEditorPanel.this.firePropertyChange("selectionChanged", null, UserDefinedValueEditorPanel.this.getSelectedValues());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (!this.handleEmptyTextField(e)) {
                this.enableButton();
            }
            UserDefinedValueEditorPanel.this.firePropertyChange("selectionChanged", null, UserDefinedValueEditorPanel.this.getSelectedValues());
        }

        private void enableButton() {
            if (!this.alreadyEnabled) {
                this.button.setEnabled(true);
            }
        }

        private boolean handleEmptyTextField(DocumentEvent e) {
            if (e.getDocument().getLength() <= 0) {
                this.button.setEnabled(false);
                this.alreadyEnabled = false;
                return true;
            }
            return false;
        }
    }

    @SASScope
    class ValueListListener
    implements ActionListener {
        ValueListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == UserDefinedValueEditorPanel.this.deleteButton) {
                int[] indices = UserDefinedValueEditorPanel.this.valueList.getSelectedIndices();
                int length = indices.length;
                for (int i = length - 1; i >= 0; --i) {
                    int index = indices[i];
                    UserDefinedValueEditorPanel.this.listModel.remove(index);
                }
                int size = UserDefinedValueEditorPanel.this.listModel.getSize();
                if (size == 0) {
                    UserDefinedValueEditorPanel.this.deleteButton.setEnabled(false);
                } else {
                    int lastIndexRemoved = indices[0];
                    if (lastIndexRemoved == UserDefinedValueEditorPanel.this.listModel.getSize()) {
                        --lastIndexRemoved;
                    }
                    UserDefinedValueEditorPanel.this.valueList.setSelectedIndex(lastIndexRemoved);
                    UserDefinedValueEditorPanel.this.valueList.ensureIndexIsVisible(lastIndexRemoved);
                }
                UserDefinedValueEditorPanel.this.firePropertyChange("selectionChanged", null, UserDefinedValueEditorPanel.this.getSelectedValues());
            } else if (source == UserDefinedValueEditorPanel.this.editButton) {
                String value = UserDefinedValueEditorPanel.this.valueList.getSelectedValue().toString();
                UserDefinedValueEditorPanel.this.valueTextField.setText(value);
                UserDefinedValueEditorPanel.this.valueList.getSelectionModel().clearSelection();
            }
        }
    }
}

