/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters;

import com.sas.swing.visuals.dataselectors.filters.RB;
import com.sas.swing.visuals.dataselectors.filters.SimpleSelectionValueEditor;
import com.sas.swing.visuals.dataselectors.filters.editors.ValueEditorInterface;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class SimpleSelectionValuePicker
extends JComponent
implements ActionListener {
    public static final String RB_KEY = "SimpleSelectionValuePicker.";
    private String _labelAvailableValues = RB.getStringResource("SimpleSelectionValuePicker.", "LabelAvailableValues.txt");
    private String _labelSelectedValues = RB.getStringResource("SimpleSelectionValuePicker.", "LabelSelectedValues.txt");
    private String _LabelPromptTypeValues = RB.getStringResource("SimpleSelectionValuePicker.", "LabelPromptTypeValues.txt");
    private transient int numberOfPrompts = 0;
    private transient List promptLabels = new ArrayList();
    private transient boolean allowTypedValues = true;
    private transient List listOfAvailableValues = null;
    private transient List valueEditors = new ArrayList();
    private transient InnerValueEditorsActionListener valueEditorActionListener = new InnerValueEditorsActionListener();
    private transient List valuePickerActionListeners = new ArrayList();
    private transient boolean ignoreRebuildWhileAdjusting = false;

    public SimpleSelectionValuePicker() {
        this.setLayout(new GridBagLayout());
    }

    public int getNumberOfPrompts() {
        return this.numberOfPrompts;
    }

    public void setNumberOfPrompts(int num) {
        if (this.numberOfPrompts != num) {
            this.numberOfPrompts = num;
            this.rebuildPicker(true);
        }
    }

    public void setPromptLabels(String[] labels) {
        this.promptLabels = Arrays.asList(labels);
        this.rebuildPicker(true);
    }

    public void setEditableAndValueList(boolean editable, List valuesList) {
        boolean changed = false;
        if (this.allowTypedValues != editable) {
            changed = true;
            this.allowTypedValues = editable;
        }
        if (this.listOfAvailableValues != valuesList) {
            changed = true;
            this.listOfAvailableValues = valuesList;
        }
        if (changed) {
            this.rebuildPicker(true);
        }
    }

    public boolean areValuesComplete() {
        for (ValueEditorInterface editor : this.valueEditors) {
            List values = editor.getEditorValues();
            if (values != null && values.size() != 0) continue;
            return false;
        }
        return true;
    }

    public List getEditorValues() {
        ArrayList vals = new ArrayList();
        for (int i = 0; i < this.valueEditors.size(); ++i) {
            vals.addAll(((ValueEditorInterface)this.valueEditors.get(i)).getEditorValues());
        }
        return vals;
    }

    public ValueEditorInterface[] getValueEditors() {
        return (ValueEditorInterface[])this.valueEditors.toArray();
    }

    public void setAdjusting(boolean adjusting) {
        this.ignoreRebuildWhileAdjusting = adjusting;
    }

    public boolean isAdjusting() {
        return this.ignoreRebuildWhileAdjusting;
    }

    public void rebuildPicker(boolean retainSelectedValues) {
        ValueEditorInterface valueEditorComponent;
        if (this.isAdjusting()) {
            return;
        }
        List oldValueEditors = this.valueEditors;
        ArrayList<ValueEditorInterface> newValueEditors = new ArrayList<ValueEditorInterface>();
        for (int n = oldValueEditors.size(); n > 0; --n) {
            ((ValueEditorInterface)oldValueEditors.get(n - 1)).removeValueEditorActionListener(this.valueEditorActionListener);
        }
        this.removeAll();
        if (this.numberOfPrompts == 0) {
            ValueEditorInterface dummy = SimpleSelectionValueEditor.makeDualSelector(this, this._labelAvailableValues, this._labelSelectedValues, "Editor of Select Value(s):", new ArrayList());
            JComponent tmp = (JComponent)((Object)dummy);
            tmp.setEnabled(false);
        } else if (this.numberOfPrompts == -1) {
            if (this.allowTypedValues) {
                String tmpStr = this._LabelPromptTypeValues;
                if (this.promptLabels.size() > 0) {
                    tmpStr = (String)this.promptLabels.get(0);
                }
                valueEditorComponent = SimpleSelectionValueEditor.makeTextPane(this, tmpStr, "Editor of " + tmpStr);
                newValueEditors.add(valueEditorComponent);
            } else {
                String tmpFrom = this._labelAvailableValues;
                String tmpTo = this._labelSelectedValues;
                if (this.promptLabels.size() > 1) {
                    tmpTo = (String)this.promptLabels.get(1);
                }
                if (this.promptLabels.size() > 2) {
                    tmpFrom = (String)this.promptLabels.get(2);
                }
                ValueEditorInterface valueEditorComponent2 = SimpleSelectionValueEditor.makeDualSelector(this, tmpFrom, tmpTo, "Editor of Select Value(s):", this.listOfAvailableValues);
                newValueEditors.add(valueEditorComponent2);
            }
        } else {
            for (int i = 0; i < this.numberOfPrompts; ++i) {
                valueEditorComponent = null;
                String tmpLabel = null;
                String tmpStr = Integer.toString(i);
                if (i < this.promptLabels.size()) {
                    tmpStr = tmpLabel = (String)this.promptLabels.get(i);
                }
                valueEditorComponent = this.allowTypedValues ? SimpleSelectionValueEditor.makeTextField(this, tmpLabel, "Editor of " + tmpStr) : SimpleSelectionValueEditor.makeComboBox(this, tmpLabel, "Editor of " + tmpStr, this.listOfAvailableValues);
                newValueEditors.add(valueEditorComponent);
            }
        }
        if (retainSelectedValues && oldValueEditors != null && newValueEditors != null) {
            List copyVals = new ArrayList();
            int i = 0;
            for (ValueEditorInterface editor : oldValueEditors) {
                List newValues = editor.getEditorValues();
                ++i;
                copyVals.addAll(newValues);
            }
            i = 0;
            Iterator iter = newValueEditors.iterator();
            while (iter.hasNext() && copyVals.size() > 0) {
                ValueEditorInterface editor;
                editor = (ValueEditorInterface)iter.next();
                List remainingValues = editor.setEditorValues(copyVals);
                copyVals = remainingValues;
                List newValues = editor.getEditorValues();
                ++i;
            }
        }
        for (int m = newValueEditors.size(); m > 0; --m) {
            ((ValueEditorInterface)newValueEditors.get(m - 1)).addValueEditorActionListener(this.valueEditorActionListener);
        }
        oldValueEditors.clear();
        this.valueEditors = newValueEditors;
        this.setVisible(true);
        this.validate();
        this.repaint();
    }

    public void setEditorValues(List vals) {
        List copyVals = vals;
        Iterator iter = this.valueEditors.iterator();
        while (iter.hasNext() && copyVals.size() > 0) {
            List remainingValues;
            ValueEditorInterface editor = (ValueEditorInterface)iter.next();
            copyVals = remainingValues = editor.setEditorValues(copyVals);
        }
    }

    public void listValues() {
        this.listValues(this.valueEditors);
    }

    void listValues(List controls) {
        for (Object obj : controls) {
            if (obj instanceof ValueEditorInterface) {
                ValueEditorInterface valueEditorInterface = (ValueEditorInterface)obj;
                continue;
            }
            System.err.println("Unknown: " + obj);
        }
    }

    public void addActionListener(ActionListener listener) {
        if (!this.valuePickerActionListeners.contains(listener)) {
            this.valuePickerActionListeners.add(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.valuePickerActionListeners.contains(listener)) {
            this.valuePickerActionListeners.remove(listener);
        }
    }

    protected void notifyActionListeners(String what) {
        ActionEvent event = new ActionEvent(this, 1001, "Action taken in value editor " + what);
        this.actionPerformed(event);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        for (int i = 0; i < this.valuePickerActionListeners.size(); ++i) {
            ActionListener l = (ActionListener)this.valuePickerActionListeners.get(i);
            l.actionPerformed(event);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        for (ValueEditorInterface editor : this.valueEditors) {
            if (!(editor instanceof JComponent)) continue;
            ((JComponent)((Object)editor)).setEnabled(enable);
        }
    }

    class InnerValueEditorsActionListener
    implements ActionListener {
        InnerValueEditorsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleSelectionValuePicker.this.notifyActionListeners(e.getSource().toString());
        }
    }
}

