/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterData;
import com.sas.dataselectors.filters.timebased.TimePeriod;
import com.sas.dataselectors.filters.timebased.TimePeriodType;
import com.sas.swing.visuals.CalendarPanel;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.dataselectors.filters.RB;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

@SASScope(value="ALL")
public class RelationalRelativeDatePanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
KeyListener {
    public static final String RB_KEY = "RelationalRelativeDatePanel.";
    public static final int TYPE_VALUE = 0;
    public static final int TYPE_STARTING = 1;
    public static final int TYPE_ENDING = 2;
    public static final int ITEM_SPECIFIC_DATE_TIME = 0;
    public static final int ITEM_SELECTED_PERIOD = 1;
    protected final int dateTextFieldCols = 7;
    protected final int timeTextFieldCols = 6;
    protected final int unitTextFieldCols = 4;
    protected JLabel mainLabel;
    protected JRadioButton specificRadioButton;
    protected JRadioButton comboRadioButton;
    protected ComboBox comboRadioComboBox;
    protected JPanel nPeriodsPanel;
    protected JPanel nPeriodsMarginPanel;
    protected JTextField nPeriodsTextField;
    protected JComboBox nPeriodsComboBox;
    protected JLabel nPeriodsLabel;
    protected CalendarPanel calendarPanel;
    protected JTextField selectedDateTextField;
    protected static final int hGap = 10;
    protected static final int vGap = 10;
    protected int type;
    protected boolean timeBased;
    protected boolean singleDayResult;
    protected int radioSelection;
    protected TimeZone timeZone;
    protected int daySelectedInTimePeriod;
    protected static String FROM_NOW = RB.getStringResource("RelationalRelativeDatePanel.", "fromNow.txt");
    protected static String AGO = RB.getStringResource("RelationalRelativeDatePanel.", "ago.txt");
    protected static String SPECIFIC_DATE_TIME = RB.getStringResource("RelationalRelativeDatePanel.", "specificDateTime.txt");
    protected static final String SELECTION_CHANGED = "selectionChanged";

    public RelationalRelativeDatePanel() {
        this((TimeZone)null);
    }

    public RelationalRelativeDatePanel(TimeZone timeZone) {
        this.setTimeZone(timeZone);
        this.init();
    }

    protected void init() {
        this.createComponents();
        this.layoutComponents();
        this.adjustComponents();
        this.setType(0);
        this.setTimeBased(false);
        this.setSingleDayResult(false);
        this.setDaySelectedInTimePeriod(1);
        this.setWeekStartingDay(1);
        this.addListeners();
        this.setSensitivities();
    }

    protected void createComponents() {
        this.createRadioPanel();
        this.createNPeriodsPanel();
        this.createCalendarPanel();
    }

    protected void createRadioPanel() {
        this.mainLabel = new JLabel();
        this.specificRadioButton = new JRadioButton(SPECIFIC_DATE_TIME, true);
        this.comboRadioButton = new JRadioButton();
        this.comboRadioComboBox = new ComboBox();
        this.buildTimePeriods();
    }

    protected void buildTimePeriods() {
        Object currentlySelectedItem = this.comboRadioComboBox.getSelectedItem();
        this.comboRadioComboBox.removeAllItems();
        List periodTypes = TimePeriod.getAvailableTypes();
        this.comboRadioComboBox.setMaximumRowCount(periodTypes.size());
        for (TimePeriod t : periodTypes) {
            if (this.singleDayResult && !t.isDescriptionImpliesSingleDay()) continue;
            boolean addIt = false;
            if (this.timeBased) {
                addIt = !this.singleDayResult || t.isTimeBased();
            } else if (!t.isTimeBased()) {
                addIt = true;
            }
            if (!addIt) continue;
            this.comboRadioComboBox.addItem(t.getLabel(), t.getToolTip(this.daySelectedInTimePeriod));
        }
        if (currentlySelectedItem != null) {
            this.comboRadioComboBox.setSelectedItem(currentlySelectedItem);
        }
    }

    protected void createNPeriodsPanel() {
        this.nPeriodsPanel = new JPanel();
        this.nPeriodsMarginPanel = new JPanel();
        this.nPeriodsTextField = new JTextField("", 3);
        this.nPeriodsComboBox = new JComboBox();
        this.buildNPeriods();
        this.nPeriodsLabel = new JLabel(FROM_NOW);
    }

    protected void buildNPeriods() {
        this.nPeriodsComboBox.removeAllItems();
        this.nPeriodsComboBox.addItem(TimePeriodType.YEARS.getLabel());
        this.nPeriodsComboBox.addItem(TimePeriodType.MONTHS.getLabel());
        this.nPeriodsComboBox.addItem(TimePeriodType.WEEKS.getLabel());
        this.nPeriodsComboBox.addItem(TimePeriodType.DAYS.getLabel());
        if (this.timeBased) {
            this.nPeriodsComboBox.addItem(TimePeriodType.HOURS.getLabel());
            this.nPeriodsComboBox.addItem(TimePeriodType.MINUTES.getLabel());
        }
    }

    protected void createCalendarPanel() {
        this.calendarPanel = this.timeZone != null ? new CalendarPanel(this.timeZone) : new CalendarPanel();
        this.calendarPanel.setGoToButtonMode(0);
        this.calendarPanel.setGoToButtonText(0, RB.getStringResource(RB_KEY, "currentDateTime.txt"), null);
        this.calendarPanel.showTimeButton(false);
        this.calendarPanel.setTimePanelText(RB.getStringResource(RB_KEY, "timeGMT.txt"));
        this.selectedDateTextField = new JTextField();
        this.selectedDateTextField.setEditable(false);
        JPanel daysUserContentPanel = this.calendarPanel.getDaysUserContentPanel();
        daysUserContentPanel.setPreferredSize(null);
        daysUserContentPanel.add(new JLabel(RB.getStringResource(RB_KEY, "selected.txt")));
        daysUserContentPanel.add(this.selectedDateTextField);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 2, 0, 0, true, false, true);
        daysUserContentPanel.setLayout(layout);
    }

    protected void setAccessibleNames() {
        String prefix = "";
        if (this.type == 0) {
            prefix = "value_";
        } else if (this.type == 1) {
            prefix = "starting_";
        } else if (this.type == 2) {
            prefix = "ending_";
        }
        this.specificRadioButton.getAccessibleContext().setAccessibleName(prefix + SPECIFIC_DATE_TIME);
        this.comboRadioButton.getAccessibleContext().setAccessibleName(prefix + "comboRadioButton");
        this.comboRadioComboBox.getAccessibleContext().setAccessibleName(prefix + "comboRadioComboBox");
        this.nPeriodsTextField.getAccessibleContext().setAccessibleName(prefix + "nPeriodsTextField");
        this.nPeriodsComboBox.getAccessibleContext().setAccessibleName(prefix + "nPeriodsComboBox");
        this.calendarPanel.setAccessibleNamePrefix(prefix + "Calendar_");
    }

    protected void layoutComponents() {
        int rows = 0;
        int cols = 1;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(rows, cols, 0, 0, true, false, false);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout(layout);
        this.layoutRadioPanel();
        this.layoutNPeriodsPanel();
        this.add(this.calendarPanel);
    }

    protected void layoutRadioPanel() {
        JPanel radioPanel = new JPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 2, 0, 0, true, false, false);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        radioPanel.setLayout(layout);
        radioPanel.add(this.mainLabel);
        radioPanel.add(this.specificRadioButton);
        this.add(new JPanel());
        JPanel radioComboPanel = new JPanel();
        layout = new AutoSizingGridLayout(1, 2, 0, 0, true, false, false);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        radioComboPanel.setLayout(layout);
        radioComboPanel.add(this.comboRadioButton);
        radioComboPanel.add(this.comboRadioComboBox);
        radioPanel.add(new JPanel());
        radioPanel.add(radioComboPanel);
        ButtonGroup group = new ButtonGroup();
        group.add(this.specificRadioButton);
        group.add(this.comboRadioButton);
        this.add(radioPanel);
    }

    protected void layoutNPeriodsPanel() {
        this.nPeriodsPanel.setLayout(new FlowLayout(0));
        this.nPeriodsPanel.add(this.nPeriodsMarginPanel);
        this.nPeriodsPanel.add(this.nPeriodsTextField);
        this.nPeriodsPanel.add(this.nPeriodsComboBox);
        this.nPeriodsPanel.add(this.nPeriodsLabel);
        this.add(this.nPeriodsPanel);
    }

    protected void adjustComponents() {
        Dimension labelDim = this.mainLabel.getPreferredSize();
        Dimension comboRadioDim = this.comboRadioButton.getPreferredSize();
        FlowLayout layout = (FlowLayout)this.nPeriodsPanel.getLayout();
        this.nPeriodsMarginPanel.setPreferredSize(new Dimension(labelDim.width + comboRadioDim.width - layout.getHgap() * 2, 0));
    }

    protected void addListeners() {
        this.specificRadioButton.addActionListener(this);
        this.comboRadioButton.addActionListener(this);
        this.comboRadioComboBox.addActionListener(this);
        this.nPeriodsComboBox.addActionListener(this);
        this.nPeriodsTextField.addKeyListener(this);
        this.calendarPanel.addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.specificRadioButton) {
            this.radioSelection = 0;
            this.setSensitivities();
            this.firePropertyChange(SELECTION_CHANGED, null, null);
        } else if (source == this.comboRadioButton) {
            this.radioSelection = 1;
            this.updateCalendarCurrentDate();
            this.setSensitivities();
            this.firePropertyChange(SELECTION_CHANGED, null, null);
        } else if (source == this.comboRadioComboBox) {
            if (!this.comboRadioComboBox.isEnabled()) {
                return;
            }
            this.updateCalendarCurrentDate();
            this.setSensitivities();
            this.firePropertyChange(SELECTION_CHANGED, null, null);
        } else if (source == this.nPeriodsComboBox) {
            this.updateCalendarCurrentDate();
            this.firePropertyChange(SELECTION_CHANGED, null, null);
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (evt.getSource() == this.nPeriodsTextField) {
            this.updateCalendarCurrentDate();
            this.firePropertyChange(SELECTION_CHANGED, null, null);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property;
        if (evt.getSource() == this.calendarPanel && ((property = evt.getPropertyName()).equals("dateChanged") || property.equals("timeChanged") || property.equals("valueChanged"))) {
            this.firePropertyChange(SELECTION_CHANGED, null, null);
            GregorianCalendar selectedDate = this.calendarPanel.getSelectedDate();
            if (selectedDate != null) {
                if (this.timeBased) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3);
                    this.selectedDateTextField.setText(dateFormat.format(selectedDate.getTime()));
                } else {
                    DateFormat dateFormat = DateFormat.getDateInstance(1);
                    this.selectedDateTextField.setText(dateFormat.format(selectedDate.getTime()));
                }
            }
        }
    }

    public void setType(int type) {
        this.type = type;
        this.updateComponents();
        this.setAccessibleNames();
    }

    public void setTimeBased(boolean mode) {
        if (this.timeBased == mode) {
            return;
        }
        this.timeBased = mode;
        this.buildTimePeriods();
        this.buildNPeriods();
        this.calendarPanel.showTimeButton(this.timeBased);
    }

    public boolean getTimeBased() {
        return this.timeBased;
    }

    @SASScope
    public void setWeekStartingDay(int weekStartingDay) {
        this.calendarPanel.setWeekStartingDay(weekStartingDay);
    }

    @SASScope
    public int getWeekStartingDay() {
        return this.calendarPanel.getWeekStartingDay();
    }

    public void setSingleDayResult(boolean mode) {
        if (this.singleDayResult == mode) {
            return;
        }
        this.singleDayResult = mode;
        this.buildTimePeriods();
    }

    public boolean getSingleDayResult() {
        return this.singleDayResult;
    }

    public void setDaySelectedInTimePeriod(int value) throws IllegalArgumentException {
        if (value != 1 && value != 2 && value != 0) {
            throw new IllegalArgumentException("Invalid parameter to setDaySelectedInTimePeriod. Must be DAY_FIRST, DAY_LAST or DAY_UNDEFINED");
        }
        this.daySelectedInTimePeriod = value;
    }

    public int getDaySelectedInTimePeriod() {
        return this.daySelectedInTimePeriod;
    }

    public void setRadioSelection(int selection) {
        this.radioSelection = selection;
        this.specificRadioButton.setSelected(selection == 0);
        this.comboRadioButton.setSelected(selection == 1);
        this.setSensitivities();
    }

    public int getRadioSelection() {
        return this.radioSelection;
    }

    public void setSelectedPeriod(TimePeriod period) {
        this.comboRadioComboBox.setSelectedItem(period.getLabel());
    }

    public TimePeriod getSelectedPeriod() {
        return TimePeriod.findByLabel((String)this.comboRadioComboBox.getSelectedItem());
    }

    public void setNPeriods(int periodValue, TimePeriodType periodType) {
        this.setNPeriodsValue(periodValue);
        this.setNPeriodsType(periodType);
    }

    public void setNPeriodsValue(int periodValue) {
        this.nPeriodsTextField.setText(periodValue + "");
        this.updateCalendarCurrentDate();
    }

    public void setNPeriodsType(TimePeriodType periodType) {
        if (periodType == null) {
            return;
        }
        this.nPeriodsComboBox.setSelectedItem(periodType.getLabel());
    }

    public int getNPeriodsValue() {
        try {
            return Integer.parseInt(this.nPeriodsTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void showNPeriodsPanel(boolean show) {
        this.nPeriodsPanel.setVisible(show);
    }

    public void setDate(GregorianCalendar date) {
        this.calendarPanel.setCurrentDate(date);
    }

    public GregorianCalendar getDate() {
        return this.calendarPanel.getSelectedDate();
    }

    public void showTimePanel(boolean show) {
        this.calendarPanel.showTimePanel(show);
    }

    public void setTimeButtonEnabled(boolean enabled) {
        this.calendarPanel.enableTimeButton(enabled);
    }

    public TimePeriodType getNPeriodsType() {
        String label = (String)this.nPeriodsComboBox.getSelectedItem();
        return TimePeriodType.findByLabel(label);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Util.setEnabledOnContainer(this, enabled);
        this.setSensitivities();
    }

    public Object getSelection() {
        if (this.getRadioSelection() == 0) {
            GregorianCalendar gc = this.calendarPanel.getSelectedDate();
            if (gc != null) {
                return gc.getTime();
            }
            return null;
        }
        RelativeTimeFilterData data = new RelativeTimeFilterData();
        TimePeriod selectedPeriod = this.getSelectedPeriod();
        data.setPeriod(selectedPeriod);
        data.setDaySelectedInTimePeriod(this.daySelectedInTimePeriod);
        if (selectedPeriod == TimePeriod.PERIOD_N_PERIODS_AGO || selectedPeriod == TimePeriod.PERIOD_N_PERIODS_FROM_NOW) {
            data.setPeriodType(this.getNPeriodsType());
            data.setMultiplier(this.getNPeriodsValue());
        }
        return data;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setSelection(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Date) {
            this.setRadioSelection(0);
            GregorianCalendar gc = this.timeZone != null ? new GregorianCalendar(this.timeZone) : new GregorianCalendar();
            gc.setFirstDayOfWeek(this.getWeekStartingDay());
            gc.setTime((Date)value);
            this.calendarPanel.setCurrentDate(gc);
            this.calendarPanel.setSelectedDate(gc);
        } else if (value instanceof RelativeTimeFilterData) {
            this.setRadioSelection(1);
            RelativeTimeFilterData data = (RelativeTimeFilterData)value;
            TimePeriod selectedPeriod = data.getPeriod();
            this.setSelectedPeriod(selectedPeriod);
            if (selectedPeriod == TimePeriod.PERIOD_N_PERIODS_AGO || selectedPeriod == TimePeriod.PERIOD_N_PERIODS_FROM_NOW) {
                this.showNPeriodsPanel(true);
                this.setNPeriodsType(data.getPeriodType());
                this.setNPeriodsValue(data.getMultiplier());
            }
        }
    }

    protected void updateComponents() {
        switch (this.type) {
            case 0: {
                this.mainLabel.setText(RB.getStringResource(RB_KEY, "value.txt"));
                break;
            }
            case 1: {
                this.mainLabel.setText(RB.getStringResource(RB_KEY, "from.txt"));
                break;
            }
            case 2: {
                this.mainLabel.setText(RB.getStringResource(RB_KEY, "to.txt"));
            }
        }
        this.adjustComponents();
    }

    @SASScope
    public void updateCalendarCurrentDate() {
        boolean alignTime = true;
        TimePeriod selectedPeriod = this.getSelectedPeriod();
        GregorianCalendar date = this.timeZone != null ? new GregorianCalendar(this.timeZone) : new GregorianCalendar();
        date.setFirstDayOfWeek(this.getWeekStartingDay());
        int selectedDayOfWeek = date.getFirstDayOfWeek();
        if (this.daySelectedInTimePeriod == 2) {
            GregorianCalendar d = (GregorianCalendar)date.clone();
            d.set(7, selectedDayOfWeek);
            d.add(7, 6);
            selectedDayOfWeek = d.get(7);
        }
        if (selectedPeriod == TimePeriod.PERIOD_CURRENT_DATETIME) {
            alignTime = false;
        } else if (selectedPeriod == TimePeriod.PERIOD_CURRENT_DATETIME_LAST_YEAR) {
            date.add(1, -1);
            alignTime = false;
        } else if (selectedPeriod != TimePeriod.PERIOD_TODAY) {
            if (selectedPeriod == TimePeriod.PERIOD_YESTERDAY) {
                date.add(5, -1);
            } else if (selectedPeriod == TimePeriod.PERIOD_TOMORROW) {
                date.add(5, 1);
            } else if (selectedPeriod == TimePeriod.PERIOD_CURRENT_DAY_LAST_YEAR) {
                date.add(1, -1);
            } else if (selectedPeriod == TimePeriod.PERIOD_CURRENT_WEEK) {
                date.set(7, selectedDayOfWeek);
            } else if (selectedPeriod == TimePeriod.PERIOD_LAST_WEEK) {
                date.add(4, -1);
                date.set(7, selectedDayOfWeek);
            } else if (selectedPeriod == TimePeriod.PERIOD_CURRENT_WEEK_LAST_YEAR) {
                date.add(1, -1);
                date.set(7, selectedDayOfWeek);
            } else if (selectedPeriod == TimePeriod.PERIOD_CURRENT_MONTH) {
                date.set(5, this.daySelectedInTimePeriod == 1 ? 1 : date.getActualMaximum(5));
            } else if (selectedPeriod == TimePeriod.PERIOD_LAST_MONTH) {
                date.add(2, -1);
                date.set(5, this.daySelectedInTimePeriod == 1 ? 1 : date.getActualMaximum(5));
            } else if (selectedPeriod == TimePeriod.PERIOD_CURRENT_MONTH_LAST_YEAR) {
                date.add(1, -1);
                date.set(5, this.daySelectedInTimePeriod == 1 ? 1 : date.getActualMaximum(5));
            } else if (selectedPeriod == TimePeriod.PERIOD_CURRENT_QUARTER) {
                int quarter = this.getQuarter(date);
                date.set(2, this.daySelectedInTimePeriod == 1 ? quarter * 3 : quarter * 3 + 2);
                date.set(5, this.daySelectedInTimePeriod == 1 ? 1 : date.getActualMaximum(5));
            } else if (selectedPeriod == TimePeriod.PERIOD_LAST_QUARTER) {
                int quarter = this.getQuarter(date) - 1;
                if (quarter < 0) {
                    quarter = 3;
                }
                date.set(2, this.daySelectedInTimePeriod == 1 ? quarter * 3 : quarter * 3 + 2);
                date.set(5, this.daySelectedInTimePeriod == 1 ? 1 : date.getActualMaximum(5));
            } else if (selectedPeriod == TimePeriod.PERIOD_CURRENT_QUARTER_LAST_YEAR) {
                int quarter = this.getQuarter(date);
                date.add(1, -1);
                date.set(2, this.daySelectedInTimePeriod == 1 ? quarter * 3 : quarter * 3 + 2);
                date.set(5, this.daySelectedInTimePeriod == 1 ? 1 : date.getActualMaximum(5));
            } else if (selectedPeriod == TimePeriod.PERIOD_CURRENT_YEAR) {
                date.set(6, this.daySelectedInTimePeriod == 1 ? 1 : date.getActualMaximum(6));
            } else if (selectedPeriod == TimePeriod.PERIOD_LAST_YEAR) {
                date.add(1, -1);
                date.set(6, this.daySelectedInTimePeriod == 1 ? 1 : date.getActualMaximum(6));
            } else if (selectedPeriod == TimePeriod.PERIOD_CURRENT_HOUR) {
                date.set(12, 0);
                alignTime = false;
            } else if (selectedPeriod == TimePeriod.PERIOD_LAST_HOUR) {
                date.add(11, -1);
                date.set(12, 0);
                alignTime = false;
            } else if (selectedPeriod == TimePeriod.PERIOD_CURRENT_MINUTE) {
                alignTime = false;
            } else if (selectedPeriod == TimePeriod.PERIOD_LAST_MINUTE) {
                date.add(12, -1);
                alignTime = false;
            } else if (selectedPeriod == TimePeriod.PERIOD_NEXT_MINUTE) {
                date.add(12, 1);
                alignTime = false;
            } else if (selectedPeriod == TimePeriod.PERIOD_N_PERIODS_AGO) {
                this.adjustDateNPeriods(date, false);
                alignTime = false;
            } else if (selectedPeriod == TimePeriod.PERIOD_N_PERIODS_FROM_NOW) {
                this.adjustDateNPeriods(date, true);
                alignTime = false;
            }
        }
        if (alignTime) {
            if (this.daySelectedInTimePeriod == 1) {
                date.set(11, 0);
                date.set(12, 0);
                date.set(13, 0);
            } else if (this.daySelectedInTimePeriod == 2) {
                date.set(11, date.getActualMaximum(11));
                date.set(12, date.getActualMaximum(12));
                date.set(13, date.getActualMaximum(13));
            }
        }
        this.calendarPanel.setCurrentDate(date);
        this.calendarPanel.setSelectedDate(date);
        this.calendarPanel.showTimePanel(this.timeBased);
    }

    protected boolean adjustDateNPeriods(GregorianCalendar date, boolean forward) {
        boolean adjustedTime = false;
        int nPeriods = this.getNPeriodsValue();
        TimePeriodType nPeriodsType = this.getNPeriodsType();
        if (!forward) {
            nPeriods = -nPeriods;
        }
        if (nPeriodsType == TimePeriodType.YEARS) {
            date.add(1, nPeriods);
        } else if (nPeriodsType == TimePeriodType.QUARTERS) {
            int quarter = this.getQuarter(date);
            date.set(2, quarter * 3);
        } else if (nPeriodsType == TimePeriodType.MONTHS) {
            date.add(2, nPeriods);
        } else if (nPeriodsType == TimePeriodType.WEEKS) {
            date.add(3, nPeriods);
        } else if (nPeriodsType == TimePeriodType.DAYS) {
            date.add(6, nPeriods);
        } else if (nPeriodsType == TimePeriodType.HOURS) {
            date.add(10, nPeriods);
            adjustedTime = true;
        } else if (nPeriodsType == TimePeriodType.MINUTES) {
            date.add(12, nPeriods);
            adjustedTime = true;
        }
        return adjustedTime;
    }

    protected int getQuarter(GregorianCalendar date) {
        int month = date.get(2);
        return month / 3;
    }

    protected void setSensitivities() {
        TimePeriod selectedPeriod;
        if (this.isEnabled()) {
            this.comboRadioComboBox.setEnabled(this.comboRadioButton.isSelected());
            Util.setEnabledOnContainer(this.nPeriodsPanel, this.comboRadioButton.isSelected());
            this.calendarPanel.setEnabled(this.specificRadioButton.isSelected());
        }
        boolean nPeriodsAgo = (selectedPeriod = this.getSelectedPeriod()) == TimePeriod.PERIOD_N_PERIODS_AGO;
        boolean nPeriodsFromNow = selectedPeriod == TimePeriod.PERIOD_N_PERIODS_FROM_NOW;
        this.nPeriodsPanel.setVisible(nPeriodsAgo || nPeriodsFromNow);
        if (nPeriodsAgo) {
            this.nPeriodsLabel.setText(AGO);
        } else if (nPeriodsFromNow) {
            this.nPeriodsLabel.setText(FROM_NOW);
        }
    }

    protected void resizeWindow() {
        Window parentWindow = (Window)this.getTopLevelAncestor();
        if (parentWindow != null) {
            parentWindow.pack();
        }
    }

    @SASScope
    public void redraw() {
        this.updateComponents();
        this.setSelection(this.getSelection());
    }
}

