/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.dataselectors.filters.timebased.TimeBasedFilterAdapterInterface;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterInterface;
import com.sas.swing.visuals.CheckBoxList;
import com.sas.swing.visuals.dataselectors.filters.FilterValueProviderPanelInterface;
import com.sas.swing.visuals.dataselectors.filters.RB;
import com.sas.swing.visuals.dataselectors.filters.StartEndDatePanel;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

@SASScope
public class OLAPRelativeTimeFilterPanel
extends JPanel
implements FilterValueProviderPanelInterface,
ActionListener,
PropertyChangeListener,
KeyListener,
ListSelectionListener {
    public static final String RB_KEY = "OLAPRelativeTimeFilterPanel.";
    protected OLAPTimeBasedFilterAdapterInterface model;
    protected Object dataItem;
    protected final int dateTextFieldCols = 7;
    protected final int timeTextFieldCols = 6;
    protected final int unitTextFieldCols = 4;
    protected JPanel periodPanel;
    protected JLabel periodTypeLabel;
    protected JComboBox periodTypeComboBox;
    protected JPanel showSelectPanel;
    protected JPanel showPanel;
    protected JLabel showLabel;
    protected List showRadioButtons = new ArrayList();
    protected JTextField showNUnitsTextField;
    protected JPanel verticalDividerPanel;
    protected JSeparator verticalDividerSeparator;
    protected JPanel selectPanel;
    protected JLabel selectLabel;
    protected List selectRadioButtons = new ArrayList();
    protected CheckBoxList selectUnitList;
    protected JScrollPane selectUnitScrollPane;
    protected JPanel dateRangePanel;
    protected StartEndDatePanel startDatePanel;
    protected StartEndDatePanel endDatePanel;
    protected List periodTypesList;
    protected String showChoice;
    protected int selectType;
    protected String selectChoice;
    public final int SELECT_TYPE_NONE = 0;
    public final int SELECT_TYPE_RADIOS = 1;
    public final int SELECT_TYPE_LIST = 2;
    protected static final int hGap = 10;
    protected static final int vGap = 5;
    protected static final String SELECTION_CHANGED = "selectionChanged";
    protected boolean isModified = false;
    protected DynamicAttributeCommandInterface command;

    public OLAPRelativeTimeFilterPanel() {
        this.createComponents();
        this.layoutComponents();
        this.adjustComponents();
        this.addListeners();
    }

    public OLAPRelativeTimeFilterPanel(OLAPTimeBasedFilterAdapterInterface model) {
        this();
        this.setModel(model);
    }

    public OLAPTimeBasedFilterAdapterInterface getModel() {
        return this.model;
    }

    public void setModel(Object model) {
        if (this.model == model || !(model instanceof OLAPTimeBasedFilterAdapterInterface) && model != null) {
            return;
        }
        this.model = (OLAPTimeBasedFilterAdapterInterface)model;
    }

    public void setDataItem(Object item) {
        this.dataItem = item;
        if (this.model != null && this.model instanceof TimeBasedFilterAdapterInterface) {
            TimeBasedFilterAdapterInterface tbfa = (TimeBasedFilterAdapterInterface)((Object)this.model);
            tbfa.setDataItem(this.dataItem);
            this.updateVisualsFromModel();
        }
    }

    protected void updateVisualsFromModel() {
        if (this.model == null) {
            return;
        }
        String periodType = this.model.getPeriodType();
        this.periodTypesList = this.model.getPeriodTypes();
        this.periodTypeComboBox.removeAllItems();
        for (String[] element : this.periodTypesList) {
            this.periodTypeComboBox.addItem(element[0]);
        }
        this.periodTypeComboBox.setSelectedItem(this.getPeriodNameFromType(periodType));
        this.periodTypeSelectionChanged();
        this.showNUnitsTextField.setText(this.model.getNumberOfPeriods());
        this.setShowChoice(this.model.getShowOption());
        JRadioButton radioButton = this.getShowRadioButton(this.showChoice);
        if (radioButton != null) {
            radioButton.setSelected(true);
        }
        this.showChoiceSelectionChanged();
    }

    public void setCommand(DynamicAttributeCommandInterface newCommand) {
        if (newCommand != this.command) {
            DynamicAttributeCommandInterface old = this.command;
            this.command = newCommand;
            this.firePropertyChange("command", old, newCommand);
        }
    }

    public DynamicAttributeCommandInterface getCommand() {
        return this.command;
    }

    public boolean isModified() {
        return this.isModified;
    }

    protected void createComponents() {
        this.createPeriodPanel();
        this.showSelectPanel = new JPanel();
        this.createShowPanel();
        this.createVerticalDividerPanel();
        this.createSelectPanel();
        this.createDateRangePanel();
    }

    protected void createPeriodPanel() {
        this.periodPanel = new JPanel();
        this.periodTypeLabel = new JLabel(RB.getStringResource(RB_KEY, "periodType.txt"));
        this.periodTypeComboBox = new JComboBox();
        this.periodTypeComboBox.getAccessibleContext().setAccessibleName("periodTypeComboBox");
    }

    protected void createShowPanel() {
        this.showPanel = new JPanel();
        this.showLabel = new JLabel(RB.getStringResource(RB_KEY, "show.txt"));
        this.showNUnitsTextField = new JTextField("", 4);
        this.showNUnitsTextField.getAccessibleContext().setAccessibleName("showNUnitsTextField");
    }

    protected void createShowChoices() {
        this.showRadioButtons.clear();
        ButtonGroup group = new ButtonGroup();
        List showOptionsList = this.model.getShowOptionsList();
        for (String[] element : showOptionsList) {
            JRadioButton radioButton = new JRadioButton(element[0]);
            radioButton.setName(element[1]);
            radioButton.getAccessibleContext().setAccessibleName(element[1]);
            radioButton.setMargin(new Insets(0, 10, 0, 0));
            radioButton.addActionListener(this);
            this.showRadioButtons.add(radioButton);
            group.add(radioButton);
        }
        this.layoutShowPanelRadioButtons();
        this.setShowChoice(this.model.getShowOption());
        this.showNUnitsTextField.setText(this.model.getDefaultNumberOfPeriods());
    }

    protected void createVerticalDividerPanel() {
        this.verticalDividerPanel = new JPanel();
        this.verticalDividerSeparator = new JSeparator(1);
        this.verticalDividerPanel.add(this.verticalDividerSeparator);
    }

    protected void createSelectPanel() {
        this.selectPanel = new JPanel();
        this.selectLabel = new JLabel(RB.getStringResource(RB_KEY, "select.txt"));
        this.selectUnitList = new CheckBoxList();
        this.selectUnitList.setSelectionMode(0);
        this.selectUnitList.getAccessibleContext().setAccessibleName("selectUnitList");
        this.selectUnitScrollPane = new JScrollPane(this.selectUnitList);
        this.selectUnitScrollPane.setPreferredSize(new Dimension(0, 70));
        this.selectUnitScrollPane.getAccessibleContext().setAccessibleName("selectUnitScrollPane");
    }

    protected void createSelectChoices() {
        this.selectRadioButtons.clear();
        ButtonGroup group = new ButtonGroup();
        List selectOptionsList = this.model.getSelectOptionsList();
        for (String[] element : selectOptionsList) {
            JRadioButton radioButton = new JRadioButton(element[0]);
            radioButton.setName(element[1]);
            radioButton.getAccessibleContext().setAccessibleName(element[1]);
            radioButton.setMargin(new Insets(0, 10, 0, 0));
            radioButton.addActionListener(this);
            this.selectRadioButtons.add(radioButton);
            group.add(radioButton);
        }
        this.layoutSelectPanelRadioButtons();
        if (!this.setSelectChoice(this.model.getSelectOption())) {
            this.setSelectChoice(this.model.getDefaultSelectOption());
        }
    }

    protected void createDateRangePanel() {
        this.dateRangePanel = new JPanel();
        TitledBorder border = new TitledBorder(RB.getStringResource(RB_KEY, "dateRange.txt"));
        this.dateRangePanel.setBorder(border);
        this.startDatePanel = new StartEndDatePanel();
        this.startDatePanel.setType(0);
        this.endDatePanel = new StartEndDatePanel();
        this.endDatePanel.setType(1);
        if (this.model != null) {
            String s = this.model.getDefaultStartingPeriodOption();
            this.startDatePanel.setSelectedItem(s.equals("FIRSTPERIOD") ? 0 : 1);
            s = this.model.getDefaultEndingPeriodOption();
            this.endDatePanel.setSelectedItem(s.equals("LASTPERIOD") ? 0 : 1);
        }
    }

    protected void layoutComponents() {
        int rows = 0;
        int cols = 1;
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(rows, cols, 10, 5, true, false, false);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.setLayout(mainLayout);
        this.layoutPeriodPanel();
        this.layoutShowSelectPanel();
        this.layoutShowPanel();
        this.layoutSelectPanel();
        this.layoutDateRangePanel();
    }

    protected void layoutPeriodPanel() {
        this.add(this.periodPanel);
        int rows = 0;
        int cols = 2;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(rows, cols, 10, 5, true, false, false);
        layout.setDefaultCellGravity(256);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.periodPanel.setLayout(layout);
        this.periodPanel.add(this.periodTypeLabel);
        this.periodPanel.add(this.periodTypeComboBox);
    }

    protected void layoutShowSelectPanel() {
        this.add(this.showSelectPanel);
        int rows = 0;
        int cols = 3;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(rows, cols, 10, 5, true, false, true);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.showSelectPanel.setLayout(layout);
        this.showSelectPanel.add(this.showPanel);
        this.showSelectPanel.add(this.verticalDividerPanel);
        this.showSelectPanel.add(this.selectPanel);
    }

    protected void layoutShowPanel() {
        int rows = 0;
        int cols = 2;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(rows, cols, 0, 5, true, false, false);
        layout.setDefaultCellGravity(256);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.showPanel.setLayout(layout);
        this.layoutShowPanelRadioButtons();
    }

    protected void layoutShowPanelRadioButtons() {
        this.showPanel.removeAll();
        this.showPanel.add(this.showLabel);
        this.showPanel.add(new JPanel());
        for (JRadioButton rb : this.showRadioButtons) {
            this.showPanel.add(rb);
            if (rb.getName().equals("NPERIODS")) {
                this.showPanel.add(this.showNUnitsTextField);
                continue;
            }
            this.showPanel.add(new JPanel());
        }
        this.adjustComponents();
    }

    protected void layoutSelectPanel() {
        int rows = 0;
        int cols = 1;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(rows, cols, 10, 5, true, false, true);
        layout.setDefaultCellGravity(256);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.selectPanel.setLayout(layout);
        this.layoutSelectPanelRadioButtons();
    }

    protected void layoutSelectPanelRadioButtons() {
        this.selectPanel.removeAll();
        this.selectPanel.add(this.selectLabel);
        for (JRadioButton rb : this.selectRadioButtons) {
            this.selectPanel.add(rb);
        }
        this.selectPanel.add(this.selectUnitScrollPane);
        this.adjustComponents();
    }

    protected void layoutDateRangePanel() {
        this.add(this.dateRangePanel);
        int rows = 0;
        int cols = 2;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(rows, cols, 10, 5, true, false, false);
        layout.setDefaultCellGravity(256);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.dateRangePanel.setLayout(layout);
        this.dateRangePanel.add(this.startDatePanel);
        this.dateRangePanel.add(this.endDatePanel);
    }

    protected void adjustComponents() {
        Dimension d = this.showPanel.getPreferredSize();
        this.verticalDividerSeparator.setPreferredSize(new Dimension(1, d.height));
    }

    protected void addListeners() {
        this.periodTypeComboBox.addActionListener(this);
        this.showNUnitsTextField.addKeyListener(this);
        this.selectUnitList.addListSelectionListener(this);
        this.startDatePanel.addPropertyChangeListener(this);
        this.endDatePanel.addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.periodTypeComboBox) {
            this.setPeriodType(this.getPeriodTypeFromName((String)this.periodTypeComboBox.getSelectedItem()));
            this.periodTypeSelectionChanged();
        } else {
            for (JRadioButton rb : this.showRadioButtons) {
                if (source != rb) continue;
                this.setShowChoice(rb.getName());
                this.showChoiceSelectionChanged();
                this.firePropertyChange(SELECTION_CHANGED, null, null);
                return;
            }
            for (JRadioButton rb : this.selectRadioButtons) {
                if (source != rb) continue;
                this.setSelectChoice(rb.getName());
                this.firePropertyChange(SELECTION_CHANGED, null, null);
                return;
            }
        }
        this.firePropertyChange(SELECTION_CHANGED, null, null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.startDatePanel) {
            if (this.model != null) {
                if (this.startDatePanel.getSelectedItem() == 0) {
                    this.model.setStartingPeriodOption("FIRSTPERIOD");
                } else {
                    this.model.setStartingPeriodOption("SELECTEDPERIOD");
                    TreePath selectedTreePath = this.startDatePanel.getSelectedDateTreePath();
                    if (selectedTreePath != null) {
                        this.model.setSelectedStartingPeriod((TreeNode)selectedTreePath.getLastPathComponent());
                    } else {
                        this.model.setSelectedStartingPeriod((String)null);
                    }
                }
            }
        } else if (evt.getSource() == this.endDatePanel && this.model != null) {
            if (this.endDatePanel.getSelectedItem() == 0) {
                this.model.setEndingPeriodOption("LASTPERIOD");
            } else {
                this.model.setEndingPeriodOption("SELECTEDPERIOD");
                TreePath selectedTreePath = this.endDatePanel.getSelectedDateTreePath();
                if (selectedTreePath != null) {
                    this.model.setSelectedEndingPeriod((TreeNode)selectedTreePath.getLastPathComponent());
                } else {
                    this.model.setSelectedEndingPeriod((String)null);
                }
            }
        }
        this.firePropertyChange(SELECTION_CHANGED, null, null);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (evt.getSource() == this.showNUnitsTextField && this.model != null) {
            this.model.setNumberOfPeriods(this.showNUnitsTextField.getText());
        }
        this.firePropertyChange(SELECTION_CHANGED, null, null);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getSource() == this.selectUnitList) {
            Object[] selections = this.selectUnitList.getSelectedValues();
            if (this.model != null) {
                String[] stringSelections = null;
                if (selections != null) {
                    stringSelections = new String[selections.length];
                    for (int i = 0; i < selections.length; ++i) {
                        stringSelections[i] = (String)selections[i];
                    }
                }
                this.model.setSelectedPeriods(stringSelections);
            }
        }
        this.firePropertyChange(SELECTION_CHANGED, null, null);
    }

    public void setShowChoice(String type) {
        JRadioButton radioButton;
        this.showChoice = type;
        if (this.model != null) {
            this.model.setShowOption(this.showChoice);
        }
        if ((radioButton = this.getShowRadioButton(this.showChoice)) != null) {
            radioButton.setSelected(true);
        }
    }

    protected void showChoiceSelectionChanged() {
        this.createSelectChoices();
        this.updateSelectType();
    }

    public boolean setSelectChoice(String choice) {
        JRadioButton radioButton;
        this.selectChoice = choice;
        if (this.model != null) {
            this.model.setSelectOption(this.selectChoice);
        }
        if ((radioButton = this.getSelectRadioButton(this.selectChoice)) != null) {
            radioButton.setSelected(true);
            this.updateStartEndDatePanels();
            return true;
        }
        return false;
    }

    protected void updateSelectType() {
        if (this.showChoice == null) {
            return;
        }
        if (this.showChoice.equals("NPERIODS")) {
            this.setSelectType(1);
        } else if (this.showChoice.equals("ACROSS")) {
            this.setSelectType(2);
        } else if (this.showChoice.equals("RANGE")) {
            this.setSelectType(0);
        }
        this.updateStartEndDatePanels();
    }

    protected JRadioButton getShowRadioButton(String type) {
        for (JRadioButton rb : this.showRadioButtons) {
            if (!rb.getName().equals(type)) continue;
            return rb;
        }
        return null;
    }

    protected JRadioButton getSelectRadioButton(String type) {
        for (JRadioButton rb : this.selectRadioButtons) {
            if (!rb.getName().equals(type)) continue;
            return rb;
        }
        return null;
    }

    protected void setSelectionRadioButtonsVisible(boolean visible) {
        for (JRadioButton rb : this.selectRadioButtons) {
            rb.setVisible(visible);
        }
    }

    public void setPeriodType(String type) {
        if (this.model != null) {
            this.model.setPeriodType(type);
        }
    }

    protected void periodTypeSelectionChanged() {
        this.createShowChoices();
        this.updateStartEndDatePanels();
        this.setSelectType(this.selectType);
    }

    protected String getPeriodTypeFromName(String name) {
        for (String[] element : this.periodTypesList) {
            if (!element[0].equals(name)) continue;
            return element[1];
        }
        return null;
    }

    protected String getPeriodNameFromType(String type) {
        for (String[] element : this.periodTypesList) {
            if (!element[1].equals(type)) continue;
            return element[0];
        }
        return null;
    }

    protected void updateStartEndDatePanels() {
        List startingPeriodList;
        String endingPeriodOption;
        TreeModel startTree = this.model.getStartTreeModel();
        TreeModel endTree = this.model.getEndTreeModel();
        this.startDatePanel.setTree(startTree);
        this.endDatePanel.setTree(endTree);
        String startingPeriodOption = this.model.getStartingPeriodOption();
        if (startingPeriodOption != null) {
            if (startingPeriodOption.equals("FIRSTPERIOD")) {
                this.startDatePanel.setSelectedItem(0);
            } else {
                this.startDatePanel.setSelectedItem(1);
                this.startDatePanel.setSelectedDate(this.model.getSelectedStartingPeriod());
            }
        }
        if ((endingPeriodOption = this.model.getEndingPeriodOption()) != null) {
            if (this.model.getEndingPeriodOption().equals("LASTPERIOD")) {
                this.endDatePanel.setSelectedItem(0);
            } else {
                this.endDatePanel.setSelectedItem(1);
                this.endDatePanel.setSelectedDate(this.model.getSelectedEndingPeriod());
            }
        }
        boolean startDateEnabled = true;
        boolean endDateEnabled = true;
        JRadioButton showNPeriodsRadioButton = this.getShowRadioButton("NPERIODS");
        if (showNPeriodsRadioButton != null && showNPeriodsRadioButton.isSelected()) {
            JRadioButton rb = this.getSelectRadioButton("STARTINGPERIOD");
            if (rb != null) {
                startDateEnabled = rb.isSelected();
            }
            if ((rb = this.getSelectRadioButton("ENDINGPERIOD")) != null) {
                endDateEnabled = rb.isSelected();
            }
        }
        if ((startingPeriodList = this.model.getStartingPeriodOptionsList()).size() == 2) {
            String[] firstPeriodLabels = (String[])startingPeriodList.get(0);
            String[] selectedPeriodLabels = (String[])startingPeriodList.get(1);
            this.startDatePanel.setUnitLabels(this.model.getStartingPeriodLabel(), firstPeriodLabels[0], null, null, selectedPeriodLabels[0]);
        }
        this.startDatePanel.setFirstLastValue(this.model.getCurrentFirstPeriod());
        List endingPeriodList = this.model.getEndingPeriodOptionsList();
        if (endingPeriodList.size() == 2) {
            String[] lastPeriodLabels = (String[])endingPeriodList.get(0);
            String[] selectedPeriodLabels = (String[])endingPeriodList.get(1);
            this.endDatePanel.setUnitLabels(null, null, this.model.getEndingPeriodLabel(), lastPeriodLabels[0], selectedPeriodLabels[0]);
        }
        this.endDatePanel.setFirstLastValue(this.model.getCurrentLastPeriod());
        Util.setEnabledOnContainer(this.startDatePanel, startDateEnabled);
        Util.setEnabledOnContainer(this.endDatePanel, endDateEnabled);
    }

    public void setSelectType(int type) {
        this.selectType = type;
        this.verticalDividerPanel.setVisible(type != 0);
        this.selectPanel.setVisible(type != 0);
        switch (type) {
            case 1: {
                this.selectLabel.setText(RB.getStringResource(RB_KEY, "select.txt"));
                this.setSelectionRadioButtonsVisible(true);
                this.selectUnitScrollPane.setVisible(false);
                break;
            }
            case 2: {
                String selectUnitLabel = this.model.getLocalizedSelectLabelParameter();
                this.selectLabel.setText(MessageFormat.format(RB.getStringResource(RB_KEY, "selectUnit.txt"), selectUnitLabel));
                this.setSelectionRadioButtonsVisible(false);
                List selectablePeriodsList = this.model.getSelectablePeriods();
                this.selectUnitScrollPane.setVisible(selectablePeriodsList != null);
                DefaultListModel<String> selectUnitListModel = new DefaultListModel<String>();
                for (String[] element : selectablePeriodsList) {
                    selectUnitListModel.addElement(element[0]);
                }
                this.selectUnitList.setModel(selectUnitListModel);
            }
        }
    }

    protected void resizeWindow() {
        Window parentWindow = (Window)this.getTopLevelAncestor();
        if (parentWindow != null) {
            parentWindow.pack();
        }
    }

    @Override
    public void setSelectedValues(List values) {
    }

    @Override
    public List getSelectedValues() {
        ArrayList<OLAPTimeBasedFilterAdapterInterface> list = new ArrayList<OLAPTimeBasedFilterAdapterInterface>();
        if (this.model != null) {
            list.add(this.model);
        }
        return list;
    }

    @Override
    public boolean isSelectionComplete() {
        if (this.showChoice == null) {
            return false;
        }
        if (this.showChoice.equals("NPERIODS")) {
            String value = this.showNUnitsTextField.getText();
            try {
                int i = Integer.parseInt(value);
                if (value.length() == 0 || i == 0) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            if (this.selectChoice == null) {
                return false;
            }
            if (this.selectChoice.equals("STARTINGPERIOD") ? !this.startDatePanel.isSelectionComplete() : this.selectChoice.equals("ENDINGPERIOD") && !this.endDatePanel.isSelectionComplete()) {
                return false;
            }
        } else if (this.showChoice.equals("ACROSS")) {
            if (this.model.getSelectedPeriods() == null) {
                return false;
            }
            if (!this.startDatePanel.isSelectionComplete() || !this.endDatePanel.isSelectionComplete()) {
                return false;
            }
        } else if (this.showChoice.equals("RANGE")) {
            if (!this.startDatePanel.isSelectionComplete()) {
                return false;
            }
            if (!this.endDatePanel.isSelectionComplete()) {
                return false;
            }
        }
        return true;
    }
}

