/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters;

import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.dataselectors.filters.AdvancedFilterModelInterface;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterItemListInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterableItemInterface;
import com.sas.dataselectors.filters.FilterableListModelInterface;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.dataselectors.filters.Util;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.dataselectors.SelectorDialog;
import com.sas.swing.visuals.dataselectors.filters.AdvancedFilterSelector;
import com.sas.swing.visuals.dataselectors.filters.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class AdvancedOLAPFilterItemSelectorPanel
extends JComponent
implements LayoutConstants {
    public static final String RB_KEY = "AdvancedOLAPFilterItemSelectorPanel.";
    protected DynamicAttributeCommandInterface command;
    private FilterableListModelInterface model;
    private FilterItemListInterface itemListModel;
    private FilterLogicTestNodeInterface selectionModel;
    private FilterItemInterface selectedItem;
    private JTable filterTable;
    private FilterTableModel filterTableModel;
    private JTextArea expressionTextArea;
    private JButton editButton;
    private JButton clearButton;
    private JButton clearAllButton;
    private String noFilterText;
    private boolean isModified;
    private ListSelectionModel filterTableRowSelectionModel;
    private AdvancedFilterSelector dSelector;

    public AdvancedOLAPFilterItemSelectorPanel() {
        this.createComponents();
        this.addListeners();
        this.noFilterText = RB.getStringResource(RB_KEY, "noFilterText.txt");
    }

    protected void createComponents() {
        JLabel filterLabel = new JLabel();
        filterLabel.setName("filterLabel");
        filterLabel.setText(RB.getStringResource(RB_KEY, "filterLabel.txt"));
        filterLabel.setLabelFor(this.filterTable);
        this.filterTable = new JTable();
        this.filterTableModel = new FilterTableModel();
        this.filterTable.setModel(this.filterTableModel);
        this.filterTable.setSelectionMode(0);
        this.filterTable.setAutoResizeMode(3);
        this.filterTable.getTableHeader().setReorderingAllowed(false);
        this.filterTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.filterTable.getColumnModel().getColumn(1).setPreferredWidth(225);
        this.filterTable.setRowSelectionAllowed(true);
        JScrollPane scrollPane = new JScrollPane(this.filterTable);
        scrollPane.setPreferredSize(new Dimension(400, 100));
        this.expressionTextArea = new JTextArea();
        this.expressionTextArea.setFont(new Font("Dialog", 0, 12));
        this.expressionTextArea.setEnabled(true);
        this.expressionTextArea.setLineWrap(true);
        this.expressionTextArea.setWrapStyleWord(true);
        this.expressionTextArea.setBackground(this.getBackground());
        this.expressionTextArea.setEditable(false);
        JLabel expressionTextAreaLabel = new JLabel(RB.getStringResource(RB_KEY, "expressionPanelLabel.txt"));
        expressionTextAreaLabel.setName("expressionTextAreaLabel");
        expressionTextAreaLabel.setLabelFor(this.expressionTextArea);
        JScrollPane scroller = new JScrollPane(this.expressionTextArea);
        scroller.setVerticalScrollBarPolicy(20);
        scroller.setHorizontalScrollBarPolicy(30);
        scroller.setPreferredSize(new Dimension(100, 50));
        this.editButton = new JButton(RB.getStringResource("AdvancedFilterSelectorPanel.", "edit.txt"));
        this.editButton.setEnabled(false);
        this.clearButton = new JButton(RB.getStringResource(RB_KEY, "clearLabel.txt"));
        this.clearButton.setEnabled(false);
        this.clearAllButton = new JButton(RB.getStringResource(RB_KEY, "clearAllLabel.txt"));
        this.clearAllButton.setEnabled(false);
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(2, 1, 5, 15, true, true, true);
        mainLayout.setRemainderRow(2);
        this.setLayout(mainLayout);
        JPanel labelPanel = new JPanel();
        AutoSizingGridLayout labelPanelLayout = new AutoSizingGridLayout(1, 1, 0, 0, false, false, false);
        labelPanel.setLayout(labelPanelLayout);
        labelPanel.add(filterLabel);
        JPanel table_buttonsPanel = new JPanel();
        AutoSizingGridLayout table_buttonsLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        table_buttonsLayout.setRemainderColumn(1);
        table_buttonsPanel.setLayout(table_buttonsLayout);
        JPanel buttonPanel = new JPanel();
        AutoSizingGridLayout buttonPanelLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, false, false);
        buttonPanel.setLayout(buttonPanelLayout);
        buttonPanel.add(this.editButton);
        buttonPanel.add(this.clearButton);
        buttonPanel.add(this.clearAllButton);
        table_buttonsPanel.add(scrollPane);
        table_buttonsPanel.add(buttonPanel);
        JPanel expLabelPanel = new JPanel();
        expLabelPanel.setOpaque(false);
        AutoSizingGridLayout expLabelPanelLayout = new AutoSizingGridLayout(1, 1, 0, 0, false, false, false);
        expLabelPanel.setLayout(expLabelPanelLayout);
        JPanel expressionPanel = new JPanel();
        expressionPanel.setOpaque(false);
        AutoSizingGridLayout expressionLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        expressionPanel.setLayout(expressionLayout);
        expLabelPanel.add(expressionTextAreaLabel);
        expressionPanel.add(expLabelPanel);
        expressionPanel.add(scroller);
        JPanel upperPanel = new JPanel();
        AutoSizingGridLayout upperPanelLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        upperPanel.setLayout(upperPanelLayout);
        upperPanel.add(labelPanel);
        upperPanel.add(table_buttonsPanel);
        this.add(upperPanel);
        this.add(expressionPanel);
    }

    protected void addListeners() {
        InnerActionListener myActionListener = new InnerActionListener();
        InnerListSelectionListener myListSelectionListener = new InnerListSelectionListener();
        this.editButton.addActionListener(myActionListener);
        this.clearButton.addActionListener(myActionListener);
        this.clearAllButton.addActionListener(myActionListener);
        this.filterTableRowSelectionModel = this.filterTable.getSelectionModel();
        this.filterTableRowSelectionModel.addListSelectionListener(myListSelectionListener);
    }

    public void setModel(Object model) {
        if (this.model != model && (model instanceof FilterableListModelInterface || model == null)) {
            FilterableListModelInterface old = this.model;
            this.model = (FilterableListModelInterface)model;
            this.updateModel();
            this.firePropertyChange("model", old, this.model);
            this.isModified = false;
        }
    }

    public Object getModel() {
        return this.model;
    }

    public void setCommand(DynamicAttributeCommandInterface newCommand) {
        if (newCommand != this.command) {
            DynamicAttributeCommandInterface old = this.command;
            this.command = newCommand;
            this.firePropertyChange("command", old, newCommand);
        }
    }

    public void updateModel() {
        this.filterTableModel.updateRows(this.model);
    }

    public DynamicAttributeCommandInterface getCommand() {
        return this.command;
    }

    private void enableButtons() {
        int selectedRowCount = this.filterTable.getSelectedRowCount();
        this.clearAllButton.setEnabled(this.hasFilters());
        if (selectedRowCount == 0) {
            this.editButton.setEnabled(false);
            this.clearButton.setEnabled(false);
        } else {
            int selectedRow = this.filterTableRowSelectionModel.getMinSelectionIndex();
            this.editButton.setEnabled(true);
            boolean clearEnabled = this.hasFilter(selectedRow);
            this.clearButton.setEnabled(clearEnabled);
        }
    }

    private boolean hasFilters() {
        boolean hasFilters = false;
        if (this.model != null) {
            List filterableItems = this.model.getFilterableItems();
            for (FilterableItemInterface filterableItem : filterableItems) {
                AdvancedFilterModelInterface advancedFilterModel;
                int count;
                if (filterableItem == null || (count = (advancedFilterModel = filterableItem.getFilterModel()).getSelectionCount()) <= 0) continue;
                return true;
            }
        }
        return hasFilters;
    }

    private void updateExpressionText() {
        int selectedRowCount = this.filterTable.getSelectedRowCount();
        if (selectedRowCount == 0) {
            this.expressionTextArea.setText("");
        } else {
            int selectedRow = this.filterTableRowSelectionModel.getMinSelectionIndex();
            String expressionText = (String)this.filterTable.getValueAt(selectedRow, 1);
            this.expressionTextArea.setText(expressionText);
        }
    }

    private boolean hasFilter(int index) {
        AdvancedFilterModelInterface advancedFilterModel;
        int count;
        FilterableItemInterface filterableItem;
        List filterableItems;
        boolean hasFilter = false;
        if (this.model != null && (filterableItems = this.model.getFilterableItems()).size() >= index && (filterableItem = (FilterableItemInterface)filterableItems.get(index)) != null && (count = (advancedFilterModel = filterableItem.getFilterModel()).getSelectionCount()) > 0) {
            return true;
        }
        return hasFilter;
    }

    public boolean isModified() {
        return this.isModified;
    }

    private void setUpAdvancedFilterSelector(int selectedRow) {
        this.dSelector = new AdvancedFilterSelector();
        this.dSelector.setNameDescriptionVisible(false);
        this.dSelector.setItemSelectable(true);
        List filterableItemsList = this.model.getFilterableItems();
        FilterableItemInterface filterableItem = (FilterableItemInterface)filterableItemsList.get(selectedRow);
        this.dSelector.setSelectorModel(filterableItem.getFilterModel());
        FilterItemInterface selectedItem = (FilterItemInterface)this.filterTable.getValueAt(selectedRow, 0);
        this.dSelector.setSelectedItem(selectedItem);
        this.dSelector.setItemSelectable(false);
    }

    class FilterTableModel
    extends DefaultTableModel {
        public FilterTableModel() {
            this.addColumn(RB.getStringResource(AdvancedOLAPFilterItemSelectorPanel.RB_KEY, "itemColumnHeader.txt"));
            this.addColumn(RB.getStringResource(AdvancedOLAPFilterItemSelectorPanel.RB_KEY, "filterColumnHeader.txt"));
        }

        public void updateRows(FilterableListModelInterface filterableListModel) {
            int numRows = this.getRowCount();
            if (numRows > 0) {
                for (int k = numRows - 1; k >= 0; --k) {
                    this.removeRow(k);
                }
            }
            if (filterableListModel == null) {
                return;
            }
            Object[] vals = new Object[2];
            List filterableItems = filterableListModel.getFilterableItems();
            for (FilterableItemInterface filterableItem : filterableItems) {
                if (filterableItem == null) continue;
                AdvancedFilterModelInterface advancedFilterModel = filterableItem.getFilterModel();
                SimpleFilterLogicTreeInterface tree = advancedFilterModel.getSelectionTree();
                List itemList = advancedFilterModel.getDataSource().getFilterItemList();
                FilterItemInterface filterItem = (FilterItemInterface)itemList.get(0);
                int count = advancedFilterModel.getSelectionCount();
                vals[0] = filterItem;
                vals[1] = count == 0 ? AdvancedOLAPFilterItemSelectorPanel.this.noFilterText : Util.getExpressionString(tree, 1);
                this.addRow(vals);
            }
            AdvancedOLAPFilterItemSelectorPanel.this.enableButtons();
            AdvancedOLAPFilterItemSelectorPanel.this.updateExpressionText();
        }

        public Class getColumnClass(int columnIndex) {
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    private class InnerListSelectionListener
    implements ListSelectionListener {
        private InnerListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            AdvancedOLAPFilterItemSelectorPanel.this.enableButtons();
            AdvancedOLAPFilterItemSelectorPanel.this.updateExpressionText();
        }
    }

    private class InnerActionListener
    implements ActionListener {
        private InnerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == AdvancedOLAPFilterItemSelectorPanel.this.editButton) {
                int selectedRow = AdvancedOLAPFilterItemSelectorPanel.this.filterTable.getSelectedRow();
                if (selectedRow != -1) {
                    Container container = AdvancedOLAPFilterItemSelectorPanel.this.getTopLevelAncestor();
                    if (container != null) {
                        container.setCursor(Cursor.getPredefinedCursor(3));
                    }
                    AdvancedOLAPFilterItemSelectorPanel.this.setUpAdvancedFilterSelector(selectedRow);
                    SelectorDialog dialog = new SelectorDialog((Frame)com.sas.swing.visuals.util.Util.getParentFrame(AdvancedOLAPFilterItemSelectorPanel.this), (PanelInterface)AdvancedOLAPFilterItemSelectorPanel.this.dSelector, true);
                    dialog.pack();
                    if (container != null) {
                        container.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    dialog.setVisible(true);
                    boolean cancelled = dialog.wasCancelled();
                    if (!cancelled) {
                        Object selectorModel = AdvancedOLAPFilterItemSelectorPanel.this.dSelector.getSelectorModel();
                        if (selectorModel instanceof AdvancedFilterModelInterface) {
                            ((AdvancedFilterModelInterface)selectorModel).commitChanges();
                            AdvancedOLAPFilterItemSelectorPanel.this.isModified = true;
                            AdvancedOLAPFilterItemSelectorPanel.this.updateModel();
                        }
                    } else {
                        Object selectorModel = AdvancedOLAPFilterItemSelectorPanel.this.dSelector.getSelectorModel();
                        if (selectorModel instanceof AdvancedFilterModelInterface) {
                            ((AdvancedFilterModelInterface)selectorModel).cancel();
                            AdvancedOLAPFilterItemSelectorPanel.this.updateModel();
                        }
                    }
                    AdvancedOLAPFilterItemSelectorPanel.this.filterTable.setRowSelectionInterval(selectedRow, selectedRow);
                }
            } else if (source == AdvancedOLAPFilterItemSelectorPanel.this.clearButton) {
                int selectedRow = AdvancedOLAPFilterItemSelectorPanel.this.filterTable.getSelectedRow();
                if (selectedRow != -1) {
                    AdvancedOLAPFilterItemSelectorPanel.this.model.clearFilter(selectedRow);
                    AdvancedOLAPFilterItemSelectorPanel.this.updateModel();
                    AdvancedOLAPFilterItemSelectorPanel.this.isModified = true;
                }
                AdvancedOLAPFilterItemSelectorPanel.this.filterTable.setRowSelectionInterval(selectedRow, selectedRow);
            } else if (source == AdvancedOLAPFilterItemSelectorPanel.this.clearAllButton) {
                AdvancedOLAPFilterItemSelectorPanel.this.model.clearAll();
                AdvancedOLAPFilterItemSelectorPanel.this.updateModel();
                AdvancedOLAPFilterItemSelectorPanel.this.isModified = true;
            }
        }
    }
}

