/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.calculateditems;

import com.sas.codepolicy.SASScope;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

@SASScope
public class MinimumResizeListener
implements ComponentListener {
    Window _window = null;
    Dimension _minimumSize = null;

    public MinimumResizeListener(Window window) {
        this(window, window.getSize());
    }

    public MinimumResizeListener(Window window, Dimension minimumSize) {
        this._window = window;
        this._minimumSize = minimumSize;
        this._window.setSize(this._minimumSize);
        this._window.addComponentListener(this);
    }

    public void dispose() {
        this._window.removeComponentListener(this);
        this._window = null;
        this._minimumSize = null;
    }

    public Dimension getMinimumSize() {
        return this._minimumSize;
    }

    public void setMinimumSize(Dimension min) {
        this._minimumSize = min;
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentHidden(ComponentEvent event) {
    }

    @Override
    public void componentShown(ComponentEvent event) {
        if (event.getSource() != this._window) {
            return;
        }
        this.checkSize();
    }

    @Override
    public void componentResized(ComponentEvent event) {
        if (event.getSource() != this._window) {
            return;
        }
        this.checkSize();
    }

    void checkSize() {
        try {
            if (!this._window.isVisible()) {
                return;
            }
            Dimension newSize = this._window.getSize();
            boolean update = false;
            if (newSize.width < this._minimumSize.width) {
                update = true;
                newSize.width = this._minimumSize.width;
            }
            if (newSize.height < this._minimumSize.height) {
                update = true;
                newSize.height = this._minimumSize.height;
            }
            if (update) {
                this._window.setSize(newSize);
                this._window.validate();
                this._window.repaint();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

