/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.ComponentComboBox;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

@SASScope(value="ALL")
public class WideComboBox
extends ComponentComboBox {
    public static final int STEPPED_POPUP_STYLE = 5;
    public static final int SCROLLING_POPUP_STYLE = 6;
    private int _popupStyle;

    public WideComboBox() {
        this.initialize();
    }

    public WideComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.initialize();
    }

    public WideComboBox(Object[] items) {
        super(items);
        this.initialize();
    }

    public WideComboBox(Vector items) {
        super(items);
        this.initialize();
    }

    protected void initialize() {
        this._popupStyle = 6;
        this.updateUI();
    }

    @Override
    protected ComboPopup createPopup() {
        BasicComboPopup popup = new BasicComboPopup(this){

            @Override
            public void show() {
                int style = 6;
                if (this.comboBox instanceof WideComboBox) {
                    style = ((WideComboBox)this.comboBox).getPopupStyle();
                }
                Dimension popupSize = new Dimension(this.getPreferredSize());
                boolean horizontalScrollBarPresent = false;
                if (popupSize.width > this.comboBox.getSize().width && style == 6) {
                    horizontalScrollBarPresent = true;
                }
                if (horizontalScrollBarPresent) {
                    if (this.scroller.getHorizontalScrollBar().getHeight() != 0) {
                        popupSize.setSize(this.comboBox.getSize().width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()) + this.scroller.getHorizontalScrollBar().getHeight());
                    } else {
                        popupSize.setSize(this.comboBox.getSize().width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                    }
                } else {
                    popupSize.setSize(Math.max(popupSize.width, this.comboBox.getSize().width), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                }
                final Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
                this.scroller.setMaximumSize(popupBounds.getSize());
                this.scroller.setPreferredSize(popupBounds.getSize());
                this.scroller.setMinimumSize(popupBounds.getSize());
                this.list.revalidate();
                int selectedIndex = this.comboBox.getSelectedIndex();
                if (selectedIndex == -1) {
                    this.list.clearSelection();
                } else {
                    this.list.setSelectedIndex(selectedIndex);
                    this.list.ensureIndexIsVisible(selectedIndex);
                }
                if (horizontalScrollBarPresent && this.scroller.getHorizontalScrollBar().getHeight() == 0) {
                    this.setVisible(true);
                    Dimension dims = new Dimension(popupBounds.getSize());
                    dims.height += this.scroller.getHorizontalScrollBar().getHeight();
                    this.scroller.setMaximumSize(dims.getSize());
                    this.scroller.setPreferredSize(dims.getSize());
                    this.scroller.setMinimumSize(dims.getSize());
                    this.list.revalidate();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (comboBox.isShowing()) {
                            this.show(comboBox, popupBounds.x, popupBounds.y);
                        }
                    }
                });
            }

            @Override
            protected JScrollPane createScroller() {
                int style = 6;
                if (this.comboBox instanceof WideComboBox) {
                    style = ((WideComboBox)this.comboBox).getPopupStyle();
                }
                if (style == 6) {
                    JScrollPane scrollPane = new JScrollPane(this.list, 20, 30);
                    return scrollPane;
                }
                return super.createScroller();
            }

            @Override
            protected void configureScroller() {
                int style = 6;
                if (this.comboBox instanceof WideComboBox) {
                    style = ((WideComboBox)this.comboBox).getPopupStyle();
                }
                if (style == 6) {
                    this.scroller.setFocusable(false);
                    this.scroller.getHorizontalScrollBar().setFocusable(false);
                    this.scroller.getVerticalScrollBar().setFocusable(false);
                    this.scroller.setBorder(null);
                } else {
                    super.configureScroller();
                }
            }
        };
        return popup;
    }

    @SASScope
    public int getPopupStyle() {
        return this._popupStyle;
    }

    @SASScope
    public void setPopupStyle(int popupStyle) {
        if (popupStyle != 5 && popupStyle != 6) {
            return;
        }
        if (this._popupStyle != popupStyle) {
            int oldValue = this._popupStyle;
            this._popupStyle = popupStyle;
            this.firePropertyChange("popupStyle", oldValue, popupStyle);
            this.updateUI();
        }
    }
}

