/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.swing.visuals.CheckBoxListCellRenderer;
import com.sas.swing.visuals.TriStateCheckBox;
import com.sas.swing.visuals.TriStateCheckBoxList;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JList;

public class TriStateCheckBoxListCellRenderer
extends CheckBoxListCellRenderer {
    @Override
    protected void createCheckBox() {
        this.setLayout(new GridLayout(1, 1));
        this.checkBox = new TriStateCheckBox();
        this.checkBox.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        this.add(this.checkBox);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color foreground;
        Color background;
        this.setOpaque(true);
        if (cellHasFocus) {
            background = list.getSelectionBackground();
            foreground = list.getSelectionForeground();
        } else {
            background = list.getBackground();
            foreground = list.getForeground();
        }
        this.setBackground(background);
        this.setForeground(foreground);
        this.checkBox.setBackground(background);
        this.checkBox.setForeground(foreground);
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.checkBox.setEnabled(list.isEnabled());
        this.checkBox.setFont(list.getFont());
        String s = value.toString();
        this.checkBox.setText(s);
        if (list instanceof TriStateCheckBoxList) {
            ((TriStateCheckBox)this.checkBox).setSelectedValue(((TriStateCheckBoxList)list).getSelectedIndexValue(index));
        } else {
            this.checkBox.setSelected(isSelected);
        }
        this.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, background));
        return this;
    }
}

