/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.swing.visuals.BasicTriStateCheckBoxIcon;
import com.sas.swing.visuals.RB;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;

public class TriStateCheckBox
extends JCheckBox {
    public static final String RB_KEY = "TriStateCheckBox.";
    public static final int OFF = 0;
    public static final int MIXED = 1;
    public static final int ON = 2;

    public TriStateCheckBox() {
        this(null, null, false);
    }

    public TriStateCheckBox(Icon icon) {
        this(null, icon, false);
    }

    public TriStateCheckBox(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public TriStateCheckBox(Icon icon, int value) {
        this(null, icon, value);
    }

    public TriStateCheckBox(String text) {
        this(text, null, false);
    }

    public TriStateCheckBox(String text, boolean selected) {
        this(text, null, selected);
    }

    public TriStateCheckBox(String text, int value) {
        this(text, null, value);
    }

    public TriStateCheckBox(String text, Icon icon) {
        this(text, icon, false);
    }

    public TriStateCheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        if (icon == null) {
            this.setIcon(new BasicTriStateCheckBoxIcon());
        }
        this.setModel(new TriStateCheckBoxModel());
        if (selected) {
            this.setSelectedValue(2);
        } else {
            this.setSelectedValue(0);
        }
    }

    public TriStateCheckBox(String text, Icon icon, int value) {
        this(text, icon);
        this.setSelectedValue(value);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    public void setCycleEnabled(boolean b) {
        ButtonModel triModel = this.getModel();
        if (triModel instanceof TriStateCheckBoxModel) {
            ((TriStateCheckBoxModel)triModel).setCycleEnabled(b);
        }
    }

    public boolean isCycleEnabled() {
        ButtonModel triModel = this.getModel();
        if (triModel instanceof TriStateCheckBoxModel) {
            return ((TriStateCheckBoxModel)triModel).isCycleEnabled();
        }
        return false;
    }

    public void setSelectedValue(int value) {
        ButtonModel triModel = this.getModel();
        if (triModel instanceof TriStateCheckBoxModel) {
            ((TriStateCheckBoxModel)triModel).setSelectedValue(value);
        }
    }

    public int getSelectedValue() {
        ButtonModel triModel = this.getModel();
        if (triModel instanceof TriStateCheckBoxModel) {
            return ((TriStateCheckBoxModel)triModel).getSelectedValue();
        }
        return -1;
    }

    public static class TriStateCheckBoxModel
    extends JToggleButton.ToggleButtonModel {
        protected int selectedValue;
        protected boolean cycleEnabled = true;

        @Override
        public void setSelected(boolean b) {
            if (this.isCycleEnabled() || this.getSelectedValue() == 1) {
                if (this.getSelectedValue() + 1 <= 2) {
                    this.setSelectedValue(this.getSelectedValue() + 1);
                } else {
                    this.setSelectedValue(0);
                }
            } else {
                this.setSelectedValue(2 - this.getSelectedValue());
            }
        }

        public void setSelectedValue(int value) {
            if (this.getSelectedValue() != value) {
                if (value <= 2) {
                    this.selectedValue = value;
                }
                if (this.selectedValue == 0) {
                    super.setSelected(false);
                } else {
                    super.setSelected(true);
                }
            }
        }

        public int getSelectedValue() {
            return this.selectedValue;
        }

        public void setCycleEnabled(boolean cycle) {
            if (this.isCycleEnabled() != cycle) {
                this.cycleEnabled = cycle;
                this.fireStateChanged();
            }
        }

        public boolean isCycleEnabled() {
            return this.cycleEnabled;
        }
    }
}

