/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.util.Strings;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

@SASScope
public class LimitedPlainDocument
extends PlainDocument {
    private int maxCharacters = Integer.MAX_VALUE;
    private int maxLines = Integer.MAX_VALUE;
    private boolean beepEnabled;

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        int strLength = str.length();
        int lines = Strings.count((String)str, (int)0, (int)-1, (char)'\n');
        int currentLineCount = this.getNumberOfLines();
        if (this.getLength() + strLength > this.maxCharacters) {
            if (this.beepEnabled) {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (Math.max(1, currentLineCount) + lines > this.maxLines) {
            if (this.beepEnabled) {
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            super.insertString(offs, str, a);
        }
    }

    public int getNumberOfLines() {
        String noNewLines = "";
        try {
            noNewLines = this.getText(0, this.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (noNewLines == null || noNewLines.length() == 0) {
            return 0;
        }
        int lines = Strings.count((String)noNewLines, (int)0, (int)-1, (char)'\n') + 1;
        return lines;
    }

    public boolean isBeepEnabled() {
        return this.beepEnabled;
    }

    public void setBeepEnabled(boolean beepEnabled) {
        this.beepEnabled = beepEnabled;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }
}

