/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDateType;
import com.sas.datatypes.BaseRangeDataType;
import com.sas.datatypes.ColorType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DataTypeUtil;
import com.sas.datatypes.DateRangeType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.StringType;
import com.sas.swing.visuals.ColorPicker;
import com.sas.swing.visuals.DatePicker;
import com.sas.swing.visuals.DateRangeEditor;
import com.sas.swing.visuals.DoubleEditor;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.IntegerEditor;
import com.sas.swing.visuals.RangeEditor;
import com.sas.swing.visuals.TextEditor;
import com.sas.swing.visuals.ValueListEditor;
import java.util.Locale;

@SASScope
public class EditorFactory {
    public static EditorFactory defaultInstance = new EditorFactory();

    public EditorInterface getEditor(DataTypeInterface dataType, Locale locale) {
        if ((dataType = DataTypeUtil.getContainedDataType((DataTypeInterface)dataType)) instanceof BaseDateType) {
            return new DatePicker(((BaseDateType)dataType).getDateType(), ((BaseDateType)dataType).getTimeZone(), locale);
        }
        if (dataType instanceof ColorType) {
            return new ColorPicker();
        }
        if (dataType instanceof StringType) {
            return new TextEditor();
        }
        if (dataType instanceof DoubleType) {
            return new DoubleEditor();
        }
        if (dataType instanceof IntegerType) {
            return new IntegerEditor();
        }
        if (dataType instanceof DateRangeType) {
            return new DateRangeEditor(((BaseDateType)((DateRangeType)dataType).getDataType()).getDateType(), locale);
        }
        if (dataType instanceof BaseRangeDataType) {
            return new RangeEditor(((BaseRangeDataType)dataType).getRangeMinMaxDataType(), locale);
        }
        return null;
    }

    public void cleanupEditor(EditorInterface editor) {
        if (editor instanceof ValueListEditor) {
            ((ValueListEditor)editor).removeListeners();
        } else if (editor instanceof TextEditor) {
            ((TextEditor)editor).removeListeners();
        } else if (editor instanceof DatePicker) {
            ((DatePicker)editor).removeListeners();
        } else if (editor instanceof ColorPicker) {
            ((ColorPicker)editor).removeListeners();
        } else if (editor instanceof RangeEditor) {
            ((RangeEditor)editor).removeListeners();
        }
    }
}

