/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDateType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DataTypeUtil;
import com.sas.datatypes.DateType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.WeekdayType;
import com.sas.datatypes.YearType;
import com.sas.prompts.PromptUtil;
import com.sas.swing.models.ValueProviderModelAdapter;
import com.sas.swing.visuals.CalendarPanel;
import com.sas.swing.visuals.CalendarPopupDialog;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.DateFormatter;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.FormattedComboBoxEditor;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.ValuePicker;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.util.transforms.MissingValuesToStringTransform;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;

@SASScope
public class DatePicker
extends JComponent
implements EditorInterface,
ActionListener,
PropertyChangeListener,
DocumentListener,
MutableSupportedSpecialValuesInterface,
SupportsGenericErrorHandlerInterface,
GenericErrorHandlerInterface {
    private static final long serialVersionUID = 7472036809533567437L;
    public static final String RB_KEY = "DatePicker.";
    public static final String CURRENT = "CURRENT";
    public static final String PREVIOUS = "PREVIOUS";
    public static final String NEXT = "NEXT";
    public static final String N_AGO = "N_AGO";
    public static final String N_FROM_NOW = "N_FROM_NOW";
    public static final String RELATIVE_TYPE = "RELATIVE_TYPE";
    public static final String PERIOD_TYPE = "PERIOD_TYPE";
    public static final int TODAY = 1;
    public static final int YESTERDAY = 2;
    public static final int TOMORROW = 3;
    public static final int CURRENT_DAY_LAST_YEAR = 4;
    public static final int CURRENT_DAY_LAST_MONTH = 5;
    public static final int CURRENT_DAY_NEXT_YEAR = 6;
    public static final int CURRENT_DAY_NEXT_MONTH = 7;
    public static final int N_DAYS_AGO = 9;
    public static final int N_DAYS_FROM_NOW = 10;
    public static final int CURRENT_WEEK = 101;
    public static final int PREVIOUS_WEEK = 102;
    public static final int NEXT_WEEK = 103;
    public static final int CURRENT_WEEK_PREVIOUS_YEAR = 104;
    public static final int CURRENT_WEEK_NEXT_YEAR = 105;
    public static final int N_WEEKS_AGO = 106;
    public static final int N_WEEKS_FROM_NOW = 107;
    public static final int CURRENT_MONTH = 201;
    public static final int PREVIOUS_MONTH = 202;
    public static final int NEXT_MONTH = 203;
    public static final int CURRENT_MONTH_PREVIOUS_YEAR = 204;
    public static final int CURRENT_MONTH_NEXT_YEAR = 205;
    public static final int N_MONTHS_AGO = 206;
    public static final int N_MONTHS_FROM_NOW = 207;
    public static final int CURRENT_QUARTER = 301;
    public static final int PREVIOUS_QUARTER = 302;
    public static final int NEXT_QUARTER = 303;
    public static final int CURRENT_QUARTER_PREVIOUS_YEAR = 304;
    public static final int CURRENT_QUARTER_NEXT_YEAR = 305;
    public static final int N_QUARTERS_AGO = 306;
    public static final int N_QUARTERS_FROM_NOW = 307;
    public static final int CURRENT_DATE_AND_TIME = 401;
    public static final int CURRENT_DATE_AND_TIME_PREVIOUS_YEAR = 402;
    public static final int CURRENT_DATE_AND_TIME_NEXT_YEAR = 403;
    public static final int CURRENT_HOUR = 404;
    public static final int PREVIOUS_HOUR = 405;
    public static final int NEXT_HOUR = 406;
    public static final int CURRENT_MINUTE = 407;
    public static final int PREVIOUS_MINUTE = 408;
    public static final int NEXT_MINUTE = 409;
    public static final int CURRENT_DATE_AND_TIME_N_HOURS_AGO = 410;
    public static final int CURRENT_DATE_AND_TIME_N_HOURS_FROM_NOW = 411;
    public static final int CURRENT_DATE_AND_TIME_N_MINUTES_AGO = 412;
    public static final int CURRENT_DATE_AND_TIME_N_MINUTES_FROM_NOW = 413;
    public static final int CURRENT_TIME = 501;
    public static final int N_HOURS_AGO = 507;
    public static final int N_HOURS_FROM_NOW = 508;
    public static final int N_MINUTES_AGO = 509;
    public static final int N_MINUTES_FROM_NOW = 510;
    public static final int CURRENT_YEAR = 601;
    public static final int PREVIOUS_YEAR = 602;
    public static final int NEXT_YEAR = 603;
    public static final int N_YEARS_AGO = 604;
    public static final int N_YEARS_FROM_NOW = 605;
    public static final int BEGINNING_OF_CURRENT_YEAR = 701;
    public static final int BEGINNING_OF_CURRENT_QUARTER = 702;
    public static final int BEGINNING_OF_CURRENT_MONTH = 703;
    public static final int BEGINNING_OF_CURRENT_WEEK = 704;
    public static final int BEGINNING_OF_CURRENT_HOUR = 705;
    public static final int BEGINNING_OF_CURRENT_MINUTE = 706;
    public static final int BEGINNING_OF_PREVIOUS_HOUR = 707;
    public static final int BEGINNING_OF_NEXT_HOUR = 708;
    public static final int BEGINNING_OF_PREVIOUS_MINUTE = 709;
    public static final int BEGINNING_OF_NEXT_MINUTE = 710;
    public static final int BEGINNING_OF_N_HOURS_AGO = 711;
    public static final int BEGINNING_OF_N_HOURS_FROM_NOW = 712;
    public static final int BEGINNING_OF_N_MINUTES_AGO = 713;
    public static final int BEGINNING_OF_N_MINUTES_FROM_NOW = 714;
    public static final int BEGINNING_OF_CURRENT_DATE_AND_TIME_HOUR = 715;
    public static final int BEGINNING_OF_CURRENT_DATE_AND_TIME_MINUTE = 716;
    public static final int BEGINNING_OF_PREVIOUS_DATE_AND_TIME_HOUR = 717;
    public static final int BEGINNING_OF_NEXT_DATE_AND_TIME_HOUR = 718;
    public static final int BEGINNING_OF_PREVIOUS_DATE_AND_TIME_MINUTE = 719;
    public static final int BEGINNING_OF_NEXT_DATE_AND_TIME_MINUTE = 720;
    public static final int END_OF_CURRENT_YEAR = 801;
    public static final int END_OF_CURRENT_QUARTER = 802;
    public static final int END_OF_CURRENT_MONTH = 803;
    public static final int END_OF_CURRENT_WEEK = 804;
    public static final int END_OF_CURRENT_HOUR = 805;
    public static final int END_OF_CURRENT_MINUTE = 806;
    public static final int END_OF_PREVIOUS_HOUR = 807;
    public static final int END_OF_NEXT_HOUR = 808;
    public static final int END_OF_PREVIOUS_MINUTE = 809;
    public static final int END_OF_NEXT_MINUTE = 810;
    public static final int END_OF_N_HOURS_AGO = 811;
    public static final int END_OF_N_HOURS_FROM_NOW = 812;
    public static final int END_OF_N_MINUTES_AGO = 813;
    public static final int END_OF_N_MINUTES_FROM_NOW = 814;
    public static final int END_OF_CURRENT_DATE_AND_TIME_HOUR = 815;
    public static final int END_OF_CURRENT_DATE_AND_TIME_MINUTE = 816;
    public static final int END_OF_PREVIOUS_DATE_AND_TIME_HOUR = 817;
    public static final int END_OF_NEXT_DATE_AND_TIME_HOUR = 818;
    public static final int END_OF_PREVIOUS_DATE_AND_TIME_MINUTE = 819;
    public static final int END_OF_NEXT_DATE_AND_TIME_MINUTE = 820;
    private JButton calendarButton;
    private ComboBox comboField;
    private JFormattedTextField textField;
    private DefaultComboBoxModel comboModel;
    private JFormattedTextField nField;
    private Object lastNValue;
    private JLabel relativeValue;
    private JLabel exampleLabel;
    private List overiddenOptions;
    private List availableValues;
    private CalendarPanel calendarPanel;
    private DateTypes type;
    private DataTypeInterface dataType;
    private Object dateSet;
    private DateFormatter formatter;
    private boolean showRelativeDates;
    private boolean showExampleLabel;
    private boolean ignoreActionEventOnCombo;
    private Date minimum;
    private Date maximum;
    private boolean handlingError;
    private boolean ignoreNField;
    private boolean ignoreRemoveEvent;
    private JComponent editorComponent;
    private CalendarPopupDialog dialog;
    private boolean isDialogShowing;
    private boolean launchingCalendarPopup;
    private boolean selectionChanged;
    private SupportedSpecialValues specialValues;
    private GenericErrorHandlerInterface errorHandler;
    private FocusAdapter focusListener;
    private MouseAdapter mouseAdapter;
    private PopupMenuListener popupMenuListener;
    private boolean isEditing;
    private boolean valueModified;
    private boolean listenersRemoved;
    private EventListenerList listenerList = new EventListenerList();
    private transient ChangeEvent changeEvent = null;
    private TimeZone timezone;

    public DatePicker(DateTypes type, Locale locale) {
        this(type, false, locale);
    }

    public DatePicker(DateTypes type, boolean relativeDatesShown, Locale locale) {
        this(type, relativeDatesShown, null, locale);
    }

    public DatePicker(DateTypes type, TimeZone timeZone, Locale locale) {
        this(type, false, timeZone, locale);
    }

    public DatePicker(DateTypes type, boolean relativeDatesShown, TimeZone timeZone, Locale locale) {
        this.timezone = timeZone;
        if (this.timezone == null) {
            this.timezone = TimeZone.getDefault();
        }
        this.isEditing = false;
        this.valueModified = false;
        this.showExampleLabel = false;
        this.lastNValue = null;
        this.showRelativeDates = relativeDatesShown;
        this.errorHandler = new JOptionPaneErrorHandler(this);
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                if (event.isTemporary() || !DatePicker.this.isEditing || DatePicker.this.handlingError) {
                    return;
                }
                if (!DatePicker.this.valueModified) {
                    try {
                        DatePicker.this.ignoreRemoveEvent = true;
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DatePicker.this.ignoreRemoveEvent = false;
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                Component comp1 = event.getComponent();
                Component comp2 = event.getOppositeComponent();
                if (comp1 == null || comp2 == null) {
                    DatePicker.this.isEditing = false;
                    DatePicker.this.valueModified = false;
                    DatePicker.this.fireEditingStopped();
                    return;
                }
                Component editorFocus = DatePicker.this.editorComponent;
                if (editorFocus instanceof JComboBox) {
                    editorFocus = ((JComboBox)editorFocus).getEditor().getEditorComponent();
                }
                if ((comp1 != DatePicker.this.calendarButton && comp1 != editorFocus && comp1 != DatePicker.this.nField || comp2 != DatePicker.this.calendarButton && comp2 != editorFocus && comp2 != DatePicker.this.nField) && !SwingUtilities.isDescendingFrom(comp2, DatePicker.this.dialog)) {
                    DatePicker.this.isEditing = false;
                    DatePicker.this.valueModified = false;
                    DatePicker.this.fireEditingStopped();
                }
            }

            @Override
            public void focusGained(FocusEvent event) {
                DatePicker.this.isEditing = true;
                DatePicker.this.fireEditingStarted();
                try {
                    DatePicker.this.ignoreRemoveEvent = true;
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DatePicker.this.ignoreRemoveEvent = false;
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        this.type = type;
        this.setLocale(locale);
        this.launchingCalendarPopup = false;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, -1, 5, 5, false, false, true);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        layout.setDefaultCellGravity(1);
        layout.setRemainderColumn(1);
        this.setLayout(layout);
        this.setOpaque(false);
        if (type == DateTypes.DATE) {
            this.dataType = new DateType(this.timezone);
        } else if (type == DateTypes.WEEKDAY) {
            this.dataType = new WeekdayType(this.timezone);
        } else if (type == DateTypes.WEEK) {
            this.dataType = new WeekType(this.timezone);
        } else if (type == DateTypes.MONTH) {
            this.dataType = new MonthType(this.timezone);
        } else if (type == DateTypes.QUARTER) {
            this.dataType = new QuarterType(this.timezone);
        } else if (type == DateTypes.TIMESTAMP) {
            this.dataType = new TimeStampType(this.timezone);
        } else if (type == DateTypes.TIME) {
            this.dataType = new TimeType(this.timezone);
        } else if (type == DateTypes.YEAR) {
            this.dataType = new YearType(this.timezone);
        }
        DateFormat format = ((BaseDateType)this.dataType).getDateFormatter(null, locale);
        format.setTimeZone(this.timezone);
        Calendar cal = format.getCalendar();
        this.setWeekDefaults(cal);
        format.setCalendar(cal);
        this.formatter = new DateFormatter(format, this.dataType, this.getSupportedSpecialValues(), locale);
        this.formatter.setCommitsOnValidEdit(false);
        this.formatter.setAllowsInvalid(true);
        this.relativeValue = new JLabel();
        this.relativeValue.setForeground(Color.gray);
        this.relativeValue.setVisible(false);
        this.configureUI();
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getSource() == DatePicker.this.calendarButton) {
                    if (DatePicker.this.dialog != null) {
                        DatePicker.this.isDialogShowing = DatePicker.this.dialog.isShowing();
                    } else {
                        DatePicker.this.isDialogShowing = false;
                    }
                }
            }
        };
        this.addListeners();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.calendarButton != null) {
            this.calendarButton.setEnabled(enabled);
        }
        if (this.comboField != null) {
            this.comboField.setEnabled(enabled);
        }
        if (this.textField != null) {
            this.textField.setEnabled(enabled);
        }
        if (this.nField != null) {
            this.nField.setEnabled(enabled);
        }
        if (this.relativeValue != null) {
            this.relativeValue.setEnabled(enabled);
        }
        if (this.exampleLabel != null) {
            this.exampleLabel.setEnabled(enabled);
        }
        if (this.calendarPanel != null) {
            this.calendarPanel.setEnabled(enabled);
        }
        if (this.editorComponent != null) {
            this.editorComponent.setEnabled(enabled);
        }
        if (this.dialog != null) {
            this.dialog.setEnabled(enabled);
        }
    }

    private void setWeekDefaults(Calendar cal) {
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
    }

    public void stopEditing() {
        this.getValue();
        this.isEditing = false;
        this.valueModified = false;
        this.fireEditingStopped();
    }

    public void cancelEditing() {
        this.setValue(this.dateSet);
        this.isEditing = false;
        this.valueModified = false;
        this.fireEditingStopped();
    }

    public void addListeners() {
        if (this.comboField != null) {
            if (this.comboField.getEditor() instanceof JFormattedTextField) {
                ((JFormattedTextField)((FormattedComboBoxEditor)this.comboField.getEditor()).getEditorComponent()).setFocusLostBehavior(1);
            }
            this.comboField.getEditor().getEditorComponent().addFocusListener(this.focusListener);
            this.comboField.addActionListener(this);
            if (this.comboField.getEditor().getEditorComponent() instanceof JTextComponent) {
                ((JTextComponent)this.comboField.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
            }
            if (this.popupMenuListener == null) {
                this.popupMenuListener = new PopupMenuListener(){

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (DatePicker.this.selectionChanged) {
                                    DatePicker.this.updateForSelectedItem();
                                }
                            }
                        });
                    }

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    }
                };
            }
            this.comboField.addPopupMenuListener(this.popupMenuListener);
        }
        if (this.textField != null) {
            this.textField.getDocument().addDocumentListener(this);
        }
        if (this.editorComponent != null) {
            this.editorComponent.addFocusListener(this.focusListener);
        }
        if (this.calendarButton != null) {
            this.calendarButton.addFocusListener(this.focusListener);
        }
        if (this.nField != null) {
            this.nField.addActionListener(this);
            this.nField.addFocusListener(this.focusListener);
            this.nField.getDocument().addDocumentListener(this);
        }
        if (this.calendarButton != null) {
            this.calendarButton.addActionListener(this);
            this.calendarButton.addMouseListener(this.mouseAdapter);
        }
        this.listenersRemoved = false;
    }

    public void removeListeners() {
        if (this.comboField != null) {
            if (this.comboField.getEditor() instanceof FormattedComboBoxEditor) {
                ((JFormattedTextField)((FormattedComboBoxEditor)this.comboField.getEditor()).getEditorComponent()).setFocusLostBehavior(3);
            }
            this.comboField.getEditor().getEditorComponent().removeFocusListener(this.focusListener);
            this.comboField.removeActionListener(this);
            if (this.comboField.getEditor().getEditorComponent() instanceof JTextComponent) {
                ((JTextComponent)this.comboField.getEditor().getEditorComponent()).getDocument().removeDocumentListener(this);
            }
            this.comboField.removePopupMenuListener(this.popupMenuListener);
        }
        if (this.textField != null) {
            this.textField.getDocument().removeDocumentListener(this);
        }
        if (this.editorComponent != null) {
            this.editorComponent.removeFocusListener(this.focusListener);
        }
        if (this.calendarButton != null) {
            this.calendarButton.removeFocusListener(this.focusListener);
        }
        if (this.nField != null) {
            this.nField.removeActionListener(this);
            this.nField.removeFocusListener(this.focusListener);
            this.nField.getDocument().removeDocumentListener(this);
        }
        if (this.calendarButton != null) {
            this.calendarButton.removeActionListener(this);
            this.calendarButton.removeMouseListener(this.mouseAdapter);
        }
        this.listenersRemoved = true;
    }

    private void addCalendarButton() {
        if (this.calendarButton == null && (this.type == DateTypes.DATE || this.type == DateTypes.TIMESTAMP || this.type == DateTypes.WEEKDAY || this.type == DateTypes.WEEK || this.type == DateTypes.MONTH || this.type == DateTypes.QUARTER || this.type == DateTypes.TIME)) {
            this.calendarButton = new JButton();
            this.calendarButton.setName("Date Button");
            this.calendarButton.setHorizontalAlignment(0);
            if (this.type == DateTypes.DATE || this.type == DateTypes.WEEK || this.type == DateTypes.WEEKDAY) {
                this.calendarButton.setIcon(Resources.getImageIcon((String)"TypeDate.gif", (int)16));
            } else if (this.type == DateTypes.TIMESTAMP) {
                this.calendarButton.setIcon(Resources.getImageIcon((String)"TypeTimeStamp.gif", (int)16));
            } else if (this.type == DateTypes.TIME) {
                this.calendarButton.setIcon(Resources.getImageIcon((String)"TypeTime.gif", (int)16));
            } else if (this.type == DateTypes.MONTH || this.type == DateTypes.QUARTER) {
                this.calendarButton.setText("...");
            }
            if (this.calendarButton.getIcon() != null) {
                this.calendarButton.setMargin(LayoutConstants.EMPTY_INSETS);
            } else {
                this.calendarButton.setMargin(LayoutConstants.DOTS_BUTTON_INSETS);
            }
        }
        if (this.calendarButton != null) {
            this.add(this.calendarButton);
        }
    }

    private Object getRelativeDateFor(DateTypes type, String relativeType) {
        if (this.comboModel != null) {
            int size = this.comboModel.getSize();
            for (int i = 0; i < size; ++i) {
                ValueItem vi;
                Object obj = this.comboModel.getElementAt(i);
                if (!(obj instanceof ValueItem) || !((vi = (ValueItem)obj).getValue() instanceof DatePeriod) || ((DatePeriod)vi.getValue()).getPeriodType() != type || vi.getAttribute(RELATIVE_TYPE) != relativeType) continue;
                return obj;
            }
        }
        return null;
    }

    public Object getRelativeCurrentDate(DateTypes type) {
        return this.getRelativeDateFor(type, CURRENT);
    }

    public Object getRelativeNextDate(DateTypes type) {
        return this.getRelativeDateFor(type, NEXT);
    }

    public Object getRelativePreviousDate(DateTypes type) {
        return this.getRelativeDateFor(type, PREVIOUS);
    }

    public Object getRelativeNAgoDate(DateTypes type) {
        return this.getRelativeDateFor(type, N_AGO);
    }

    public Object getRelativeNFromNowDate(DateTypes type) {
        return this.getRelativeDateFor(type, N_FROM_NOW);
    }

    public static ValueItem createRelativeItem(Object value, Object label, String relativeType, DateTypes type) {
        ValueItem valueItem = new ValueItem(label, value);
        if (relativeType != null) {
            valueItem.setAttribute(RELATIVE_TYPE, (Object)relativeType);
        }
        if (type != null) {
            valueItem.setAttribute(PERIOD_TYPE, (Object)type);
        }
        return valueItem;
    }

    public static Object getRelativeValue(int key) {
        return DatePicker.getRelativeValue(key, TimeZone.getDefault(), Locale.getDefault());
    }

    public static Object getRelativeValue(int key, TimeZone tz, Locale locale) {
        switch (key) {
            case 1: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, tz, locale), null, CURRENT, DateTypes.DATE);
            }
            case 2: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, 0, 0, 0, 0, -1, 0, 0, tz, locale), null, PREVIOUS, DateTypes.DATE);
            }
            case 3: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, 0, 0, 0, 0, 1, 0, 0, tz, locale), null, NEXT, DateTypes.DATE);
            }
            case 4: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, -1, 0, 0, 0, 0, 0, 0, tz, locale), null, null, DateTypes.DATE);
            }
            case 5: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, 0, 0, -1, 0, 0, 0, 0, tz, locale), null, null, DateTypes.DATE);
            }
            case 6: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, 1, 0, 0, 0, 0, 0, 0, tz, locale), null, null, DateTypes.DATE);
            }
            case 7: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, 0, 0, 1, 0, 0, 0, 0, tz, locale), null, null, DateTypes.DATE);
            }
            case 9: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nDaysAgo.txt", locale), N_AGO, DateTypes.DATE);
            }
            case 10: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nDaysFromNow.txt", locale), N_FROM_NOW, DateTypes.DATE);
            }
            case 101: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.WEEK, tz, locale), null, CURRENT, DateTypes.WEEK);
            }
            case 102: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.WEEK, 0, 0, 0, -1, 0, 0, 0, tz, locale), null, PREVIOUS, DateTypes.WEEK);
            }
            case 103: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.WEEK, 0, 0, 0, 1, 0, 0, 0, tz, locale), null, NEXT, DateTypes.WEEK);
            }
            case 104: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.WEEK, -1, 0, 0, 0, 0, 0, 0, tz, locale), null, null, DateTypes.WEEK);
            }
            case 105: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.WEEK, 1, 0, 0, 0, 0, 0, 0, tz, locale), null, null, DateTypes.WEEK);
            }
            case 106: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.WEEK, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nWeeksAgo.txt", locale), N_AGO, DateTypes.WEEK);
            }
            case 107: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.WEEK, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nWeeksFromNow.txt", locale), N_FROM_NOW, DateTypes.WEEK);
            }
            case 201: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.MONTH, tz, locale), null, CURRENT, DateTypes.MONTH);
            }
            case 202: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.MONTH, 0, 0, -1, 0, 0, 0, 0, tz, locale), null, PREVIOUS, DateTypes.MONTH);
            }
            case 203: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.MONTH, 0, 0, 1, 0, 0, 0, 0, tz, locale), null, NEXT, DateTypes.MONTH);
            }
            case 204: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.MONTH, -1, 0, 0, 0, 0, 0, 0, tz, locale), null, null, DateTypes.MONTH);
            }
            case 205: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.MONTH, 1, 0, 0, 0, 0, 0, 0, tz, locale), null, null, DateTypes.MONTH);
            }
            case 206: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.MONTH, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nMonthsAgo.txt", locale), N_AGO, DateTypes.MONTH);
            }
            case 207: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.MONTH, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nMonthsFromNow.txt", locale), N_FROM_NOW, DateTypes.MONTH);
            }
            case 301: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.QUARTER, tz, locale), null, CURRENT, DateTypes.QUARTER);
            }
            case 302: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.QUARTER, 0, -1, 0, 0, 0, 0, 0, tz, locale), null, PREVIOUS, DateTypes.QUARTER);
            }
            case 303: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.QUARTER, 0, 1, 0, 0, 0, 0, 0, tz, locale), null, NEXT, DateTypes.QUARTER);
            }
            case 304: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.QUARTER, -1, 0, 0, 0, 0, 0, 0, tz, locale), null, null, DateTypes.QUARTER);
            }
            case 305: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.QUARTER, 1, 0, 0, 0, 0, 0, 0, tz, locale), null, null, DateTypes.QUARTER);
            }
            case 306: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.QUARTER, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nQuartersAgo.txt", locale), N_AGO, DateTypes.QUARTER);
            }
            case 307: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.QUARTER, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nQuartersFromNow.txt", locale), N_FROM_NOW, DateTypes.QUARTER);
            }
            case 401: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, tz, locale), null, CURRENT, DateTypes.TIMESTAMP);
            }
            case 402: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, -1, 0, 0, 0, 0, 0, 0, tz, locale), null, null, DateTypes.TIMESTAMP);
            }
            case 403: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 1, 0, 0, 0, 0, 0, 0, tz, locale), null, null, DateTypes.TIMESTAMP);
            }
            case 404: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.HOUR, tz, locale), null, CURRENT, DateTypes.HOUR);
            }
            case 405: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.HOUR, 0, 0, 0, 0, 0, -1, 0, tz, locale), null, PREVIOUS, DateTypes.HOUR);
            }
            case 406: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.HOUR, 0, 0, 0, 0, 0, 1, 0, tz, locale), null, NEXT, DateTypes.HOUR);
            }
            case 407: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.MINUTE, tz, locale), null, CURRENT, DateTypes.MINUTE);
            }
            case 408: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.MINUTE, 0, 0, 0, 0, 0, 0, -1, tz, locale), null, PREVIOUS, DateTypes.MINUTE);
            }
            case 409: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.MINUTE, 0, 0, 0, 0, 0, 0, 1, tz, locale), null, NEXT, DateTypes.MINUTE);
            }
            case 410: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nHoursAgo.txt", locale), N_AGO, DateTypes.HOUR);
            }
            case 411: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nHoursFromNow.txt", locale), N_FROM_NOW, DateTypes.HOUR);
            }
            case 412: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nMinutesAgo.txt", locale), N_AGO, DateTypes.MINUTE);
            }
            case 413: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nMinutesFromNow.txt", locale), N_FROM_NOW, DateTypes.MINUTE);
            }
            case 501: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, tz, locale), null, null, DateTypes.TIME);
            }
            case 507: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nHoursAgo.txt", locale), N_AGO, DateTypes.HOUR);
            }
            case 508: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nHoursFromNow.txt", locale), N_FROM_NOW, DateTypes.HOUR);
            }
            case 509: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nMinutesAgo.txt", locale), N_AGO, DateTypes.MINUTE);
            }
            case 510: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nMinutesFromNow.txt", locale), N_FROM_NOW, DateTypes.MINUTE);
            }
            case 601: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.YEAR, tz, locale), null, CURRENT, DateTypes.YEAR);
            }
            case 602: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.YEAR, -1, 0, 0, 0, 0, 0, 0, tz, locale), null, PREVIOUS, DateTypes.YEAR);
            }
            case 603: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.YEAR, 1, 0, 0, 0, 0, 0, 0, tz, locale), null, NEXT, DateTypes.YEAR);
            }
            case 604: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.YEAR, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nYearsAgo.txt", locale), N_AGO, DateTypes.YEAR);
            }
            case 605: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.YEAR, 0, 0, 0, 0, 0, 0, 0, tz, locale), RB.getStringResource(RB_KEY, "nYearsFromNow.txt", locale), N_FROM_NOW, DateTypes.YEAR);
            }
            case 701: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, DateTypes.YEAR, 1, tz, locale), null, CURRENT, DateTypes.DATE);
            }
            case 702: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, DateTypes.MONTH, 1, tz, locale), null, CURRENT, DateTypes.DATE);
            }
            case 703: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, DateTypes.MONTH, 1, tz, locale), null, CURRENT, DateTypes.DATE);
            }
            case 704: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, DateTypes.MONTH, 1, tz, locale), null, CURRENT, DateTypes.DATE);
            }
            case 705: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, DateTypes.HOUR, 1, tz, locale), null, CURRENT, DateTypes.HOUR);
            }
            case 706: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, DateTypes.MINUTE, 1, tz, locale), null, CURRENT, DateTypes.MINUTE);
            }
            case 707: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, -1, 0, DateTypes.HOUR, 1, tz, locale), null, PREVIOUS, DateTypes.HOUR);
            }
            case 708: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 1, 0, DateTypes.HOUR, 1, tz, locale), null, NEXT, DateTypes.HOUR);
            }
            case 709: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 0, -1, DateTypes.MINUTE, 1, tz, locale), null, PREVIOUS, DateTypes.MINUTE);
            }
            case 710: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 0, 1, DateTypes.MINUTE, 1, tz, locale), null, NEXT, DateTypes.MINUTE);
            }
            case 711: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, DateTypes.HOUR, 1, tz, locale), RB.getStringResource(RB_KEY, "beginningNHoursAgo.txt", locale), N_AGO, DateTypes.HOUR);
            }
            case 712: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, DateTypes.HOUR, 1, tz, locale), RB.getStringResource(RB_KEY, "beginningNHoursFromNow.txt", locale), N_FROM_NOW, DateTypes.HOUR);
            }
            case 713: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, DateTypes.MINUTE, 1, tz, locale), RB.getStringResource(RB_KEY, "beginningNMinutesAgo.txt", locale), N_AGO, DateTypes.MINUTE);
            }
            case 714: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, DateTypes.MINUTE, 1, tz, locale), RB.getStringResource(RB_KEY, "beginningNMinutesFromNow.txt", locale), N_FROM_NOW, DateTypes.MINUTE);
            }
            case 715: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, DateTypes.HOUR, 1, tz, locale), null, CURRENT, DateTypes.HOUR);
            }
            case 716: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, DateTypes.MINUTE, 1, tz, locale), null, CURRENT, DateTypes.MINUTE);
            }
            case 717: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, -1, 0, DateTypes.HOUR, 1, tz, locale), null, PREVIOUS, DateTypes.HOUR);
            }
            case 718: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 1, 0, DateTypes.HOUR, 1, tz, locale), null, NEXT, DateTypes.HOUR);
            }
            case 719: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 0, -1, DateTypes.MINUTE, 1, tz, locale), null, PREVIOUS, DateTypes.MINUTE);
            }
            case 720: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 0, 1, DateTypes.MINUTE, 1, tz, locale), null, NEXT, DateTypes.MINUTE);
            }
            case 801: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, DateTypes.YEAR, 2, tz, locale), null, CURRENT, DateTypes.DATE);
            }
            case 802: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, DateTypes.MONTH, 2, tz, locale), null, CURRENT, DateTypes.DATE);
            }
            case 803: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, DateTypes.MONTH, 2, tz, locale), null, CURRENT, DateTypes.DATE);
            }
            case 804: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.DATE, DateTypes.MONTH, 2, tz, locale), null, CURRENT, DateTypes.DATE);
            }
            case 805: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, DateTypes.HOUR, 2, tz, locale), null, CURRENT, DateTypes.HOUR);
            }
            case 806: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, DateTypes.MINUTE, 2, tz, locale), null, CURRENT, DateTypes.MINUTE);
            }
            case 807: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, -1, 0, DateTypes.HOUR, 2, tz, locale), null, PREVIOUS, DateTypes.HOUR);
            }
            case 808: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 1, 0, DateTypes.HOUR, 2, tz, locale), null, NEXT, DateTypes.HOUR);
            }
            case 809: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 0, -1, DateTypes.MINUTE, 2, tz, locale), null, PREVIOUS, DateTypes.MINUTE);
            }
            case 810: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 0, 1, DateTypes.MINUTE, 2, tz, locale), null, NEXT, DateTypes.MINUTE);
            }
            case 811: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, DateTypes.HOUR, 2, tz, locale), RB.getStringResource(RB_KEY, "endNHoursAgo.txt", locale), N_AGO, DateTypes.HOUR);
            }
            case 812: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, DateTypes.HOUR, 2, tz, locale), RB.getStringResource(RB_KEY, "endNHoursFromNow.txt", locale), N_FROM_NOW, DateTypes.HOUR);
            }
            case 813: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, DateTypes.MINUTE, 2, tz, locale), RB.getStringResource(RB_KEY, "endNMinutesAgo.txt", locale), N_AGO, DateTypes.MINUTE);
            }
            case 814: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIME, DateTypes.MINUTE, 2, tz, locale), RB.getStringResource(RB_KEY, "endNMinutesFromNow.txt", locale), N_FROM_NOW, DateTypes.MINUTE);
            }
            case 815: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, DateTypes.HOUR, 2, tz, locale), null, CURRENT, DateTypes.HOUR);
            }
            case 816: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, DateTypes.MINUTE, 2, tz, locale), null, CURRENT, DateTypes.MINUTE);
            }
            case 817: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, -1, 0, DateTypes.HOUR, 2, tz, locale), null, PREVIOUS, DateTypes.HOUR);
            }
            case 818: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 1, 0, DateTypes.HOUR, 2, tz, locale), null, NEXT, DateTypes.HOUR);
            }
            case 819: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 0, -1, DateTypes.MINUTE, 2, tz, locale), null, PREVIOUS, DateTypes.MINUTE);
            }
            case 820: {
                return DatePicker.createRelativeItem(new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 0, 1, DateTypes.MINUTE, 2, tz, locale), null, NEXT, DateTypes.MINUTE);
            }
        }
        return null;
    }

    private void loadRelativeDates() {
        if (this.showRelativeDates) {
            this.comboModel = new DefaultComboBoxModel();
            if (this.overiddenOptions != null) {
                Iterator iterator = this.overiddenOptions.iterator();
                while (iterator.hasNext()) {
                    this.comboModel.addElement(iterator.next());
                }
            } else if (this.type == DateTypes.DATE) {
                this.comboModel.addElement(DatePicker.getRelativeValue(1, this.timezone, this.getLocale()));
                this.comboModel.addElement(DatePicker.getRelativeValue(2, this.timezone, this.getLocale()));
                this.comboModel.addElement(DatePicker.getRelativeValue(3, this.timezone, this.getLocale()));
                this.comboModel.addElement(DatePicker.getRelativeValue(4, this.timezone, this.getLocale()));
                this.comboModel.addElement(DatePicker.getRelativeValue(5, this.timezone, this.getLocale()));
                this.comboModel.addElement(DatePicker.getRelativeValue(6, this.timezone, this.getLocale()));
                this.comboModel.addElement(DatePicker.getRelativeValue(7, this.timezone, this.getLocale()));
                this.comboModel.addElement(DatePicker.getRelativeValue(9, this.timezone, this.getLocale()));
                this.comboModel.addElement(DatePicker.getRelativeValue(10, this.timezone, this.getLocale()));
            } else if (this.type != DateTypes.WEEKDAY) {
                if (this.type == DateTypes.WEEK) {
                    this.comboModel.addElement(DatePicker.getRelativeValue(101, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(102, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(103, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(104, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(105, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(106, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(107, this.timezone, this.getLocale()));
                } else if (this.type == DateTypes.MONTH) {
                    this.comboModel.addElement(DatePicker.getRelativeValue(201, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(202, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(203, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(204, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(205, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(206, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(207, this.timezone, this.getLocale()));
                } else if (this.type == DateTypes.QUARTER) {
                    this.comboModel.addElement(DatePicker.getRelativeValue(301, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(302, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(303, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(304, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(305, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(306, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(307, this.timezone, this.getLocale()));
                } else if (this.type == DateTypes.TIMESTAMP) {
                    this.comboModel.addElement(DatePicker.getRelativeValue(401, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(402, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(403, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(404, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(405, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(406, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(407, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(408, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(409, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(410, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(411, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(412, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(413, this.timezone, this.getLocale()));
                } else if (this.type == DateTypes.TIME) {
                    this.comboModel.addElement(DatePicker.getRelativeValue(501, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(404, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(405, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(406, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(407, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(408, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(409, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(507, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(508, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(509, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(510, this.timezone, this.getLocale()));
                } else if (this.type == DateTypes.YEAR) {
                    this.comboModel.addElement(DatePicker.getRelativeValue(601, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(602, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(603, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(604, this.timezone, this.getLocale()));
                    this.comboModel.addElement(DatePicker.getRelativeValue(605, this.timezone, this.getLocale()));
                }
            }
        }
    }

    public void setRelativeOptions(List options) {
        if (!Util.equal((Object)options, (Object)this.overiddenOptions)) {
            this.overiddenOptions = options;
            Object value = this.getValue();
            this.removeAll();
            this.removeListeners();
            this.comboField = null;
            this.comboModel = null;
            this.textField = null;
            this.configureUI();
            this.addListeners();
            if (this.showRelativeDates || !(value instanceof DatePeriod) || !((DatePeriod)value).isRelativeDate()) {
                this.setValue(value);
            }
            this.revalidate();
        }
    }

    public List getRelativeOptions() {
        if (this.showRelativeDates && this.comboModel != null) {
            int size = this.comboModel.getSize();
            ArrayList values = new ArrayList();
            for (int i = 0; i < size; ++i) {
                values.add(this.comboModel.getElementAt(i));
            }
            return values;
        }
        return Collections.EMPTY_LIST;
    }

    private void loadSpecialValues() {
        if (this.specialValues != null && (this.specialValues.isAllSupported() || this.specialValues.isOtherSupported() || this.specialValues.isMissingValuesSupported() && !this.specialValues.isMissingValuesHiddenIfSupported())) {
            if (this.comboModel == null) {
                this.comboModel = new DefaultComboBoxModel();
            } else if (this.comboModel.getSize() > 0) {
                this.comboModel.addElement(ComboBox.SEPARATOR);
            }
            if (this.specialValues.isAllSupported()) {
                this.comboModel.addElement(new ValueItem((Object)SpecialValues.toDisplayString((SpecialValues)SpecialValues.ALL, (Locale)this.getLocale()), (Object)SpecialValues.ALL));
            }
            if (this.specialValues.isOtherSupported()) {
                this.comboModel.addElement(new ValueItem((Object)SpecialValues.toDisplayString((SpecialValues)SpecialValues.OTHER, (Locale)this.getLocale()), (Object)SpecialValues.OTHER));
            }
            if (this.specialValues.isMissingValuesSupported() && !this.specialValues.isMissingValuesHiddenIfSupported()) {
                this.comboModel.addElement(new ValueItem((Object)MissingValues.toDisplayString((MissingValues)MissingValues.Dot, (Locale)this.getLocale()), (Object)MissingValues.Dot));
            }
        }
    }

    private void loadAvailableValues() {
        if (this.availableValues != null && !this.availableValues.isEmpty()) {
            if (this.comboModel == null) {
                this.comboModel = new DefaultComboBoxModel<Object>(this.availableValues.toArray());
            } else {
                if (this.comboModel.getSize() > 0) {
                    this.comboModel.addElement(ComboBox.SEPARATOR);
                }
                Iterator iter = this.availableValues.iterator();
                while (iter.hasNext()) {
                    this.comboModel.addElement(iter.next());
                }
            }
        }
    }

    public DateTypes getType() {
        return this.type;
    }

    public void setType(DateTypes type) {
        if (type != DateTypes.DATE && type != DateTypes.TIME && type != DateTypes.TIMESTAMP && type != DateTypes.WEEKDAY && type != DateTypes.WEEK && type != DateTypes.MONTH && type != DateTypes.QUARTER && type != DateTypes.YEAR) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidType.ex.txt", this.getLocale()));
        }
        this.type = type;
    }

    public JButton getCalendarButton() {
        return this.calendarButton;
    }

    public JComponent getEditor() {
        if (this.showRelativeDates) {
            return this.comboField;
        }
        return this.textField;
    }

    public Object getDate() {
        return this.dateSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(Object date, String stringValue) {
        if (this.isValueAllowed(date)) {
            Object oldDate = this.dateSet;
            this.dateSet = date;
            if (this.comboField != null) {
                Object selectedItem = this.comboField.getSelectedItem();
                if (selectedItem instanceof ValueItem) {
                    selectedItem = ((ValueItem)selectedItem).getValue();
                }
                if (!Util.equal((Object)selectedItem, (Object)date)) {
                    int i;
                    boolean found = false;
                    if (date instanceof DatePeriod && ((DatePeriod)date).isRelativeDate()) {
                        ComboBoxModel model = this.comboField.getModel();
                        int size = model.getSize();
                        for (i = 0; i < size; ++i) {
                            Object item = model.getElementAt(i);
                            if (item instanceof ValueItem) {
                                Object relativeType = ((ValueItem)item).getAttribute(RELATIVE_TYPE);
                                if (relativeType == N_AGO || relativeType == N_FROM_NOW || !Util.equal((Object)((ValueItem)item).getValue(), (Object)date)) continue;
                                this.comboField.setSelectedItem(item);
                                found = true;
                                break;
                            }
                            if (!Util.equal(item, (Object)date)) continue;
                            this.comboField.setSelectedItem(item);
                            found = true;
                            break;
                        }
                        if (!found) {
                            DatePeriod dp = (DatePeriod)date;
                            int nFields = 0;
                            nFields += dp.getNYears() != 0 ? 1 : 0;
                            nFields += dp.getNQuarters() != 0 ? 1 : 0;
                            nFields += dp.getNMonths() != 0 ? 1 : 0;
                            nFields += dp.getNWeeks() != 0 ? 1 : 0;
                            nFields += dp.getNDays() != 0 ? 1 : 0;
                            nFields += dp.getNHours() != 0 ? 1 : 0;
                            if ((nFields += dp.getNMinutes() != 0 ? 1 : 0) == 1) {
                                for (int i2 = 0; i2 < size; ++i2) {
                                    Object item = model.getElementAt(i2);
                                    if (!(item instanceof ValueItem) || !this.updateNFieldIfPossible(dp, item)) continue;
                                    found = true;
                                    break;
                                }
                            }
                        }
                    }
                    if (!found) {
                        int index;
                        ComboBoxModel dataModel = this.comboField.getModel();
                        if (dataModel instanceof DefaultComboBoxModel && (index = ((DefaultComboBoxModel)dataModel).getIndexOf(date)) >= 0) {
                            this.comboField.setSelectedIndex(index);
                            found = true;
                        }
                        if (!found) {
                            Locale locale = this.getLocale();
                            int size = dataModel.getSize();
                            for (i = 0; i < size; ++i) {
                                Object element = dataModel.getElementAt(i);
                                if (!ValuePicker.areValuesEqual(date, element, this.dataType, locale)) continue;
                                try {
                                    this.ignoreActionEventOnCombo = true;
                                    this.comboField.setSelectedIndex(i);
                                }
                                finally {
                                    this.ignoreActionEventOnCombo = false;
                                }
                                found = true;
                                break;
                            }
                        }
                        if (!found) {
                            this.comboField.setSelectedItem(date);
                        }
                    }
                } else if (this.comboField.isEditable()) {
                    Object selItem = this.comboField.getSelectedItem();
                    if (selItem == null || !(selItem instanceof ValueItem) || ((ValueItem)selItem).getAttribute(RELATIVE_TYPE) != N_AGO && ((ValueItem)selItem).getAttribute(RELATIVE_TYPE) != N_FROM_NOW) {
                        if (selItem != ValueProviderModelAdapter.MORE_VALUES) {
                            this.comboField.getEditor().setItem(this.dateSet);
                        }
                    } else if (this.dateSet instanceof DatePeriod) {
                        this.updateNFieldIfPossible((DatePeriod)this.dateSet, selItem);
                    }
                }
            } else if (this.editorComponent != null) {
                if (stringValue == null) {
                    if (date instanceof Date) {
                        try {
                            stringValue = this.formatter.valueToString(date);
                        }
                        catch (ParseException parseException) {}
                    } else if (date instanceof MissingValues) {
                        stringValue = (String)MissingValuesToStringTransform.defaultInstance.transform(date);
                    }
                }
                if (this.editorComponent instanceof JTextComponent) {
                    ((JTextComponent)this.editorComponent).setText(stringValue);
                } else if (this.editorComponent instanceof JComboBox) {
                    ((JComboBox)this.editorComponent).setSelectedItem(stringValue);
                }
            }
            this.updateRelativeFieldValue();
            if (!Util.equal((Object)oldDate, (Object)this.dateSet)) {
                this.fireValueChanged();
                this.firePropertyChange("date", oldDate, this.dateSet);
            }
        } else {
            this.handleError(new IllegalArgumentException(Message.format((String)RB.getStringResource("notPermittedValue.fmt.txt", this.getLocale()), (Object)date)));
        }
    }

    private boolean updateNFieldIfPossible(DatePeriod dp, Object item) {
        int value;
        DateTypes periodType;
        Object relativeType = ((ValueItem)item).getAttribute(RELATIVE_TYPE);
        if (relativeType == N_AGO) {
            int value2;
            DateTypes periodType2 = (DateTypes)((ValueItem)item).getAttribute(PERIOD_TYPE);
            if (periodType2 != null && (value2 = DatePicker.getNValue(dp, periodType2)) < 0) {
                if (this.comboField.getSelectedItem() != item) {
                    this.comboField.setSelectedItem(item);
                }
                this.nField.setText(String.valueOf(-value2));
                this.nField.setVisible(true);
                return true;
            }
        } else if (relativeType == N_FROM_NOW && (periodType = (DateTypes)((ValueItem)item).getAttribute(PERIOD_TYPE)) != null && (value = DatePicker.getNValue(dp, periodType)) > 0) {
            if (this.comboField.getSelectedItem() != item) {
                this.comboField.setSelectedItem(item);
            }
            this.nField.setText(String.valueOf(value));
            this.nField.setVisible(true);
            return true;
        }
        return false;
    }

    protected boolean isValueAllowed(Object value) {
        return true;
    }

    private void updateRelativeFieldValue() {
        if (this.dateSet instanceof DatePeriod && ((DatePeriod)this.dateSet).isRelativeDate()) {
            String text = "";
            Locale locale = this.getLocale();
            Date val = ((DatePeriod)this.dateSet).getStartOfPeriod();
            text = this.dataType.getDisplayString((Object)val, locale);
            this.relativeValue.setText("(" + text + ")");
            this.relativeValue.setVisible(true);
        } else {
            this.relativeValue.setVisible(false);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
    }

    public void showCalendarDialog(Object owner) {
        Date convert;
        if (this.calendarPanel == null) {
            this.calendarPanel = new CalendarPanel(this.timezone);
            this.calendarPanel.setShowWeekdayHeaders(true);
            this.calendarPanel.setShowSeconds(true);
            this.calendarPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.calendarPanel.showOKButton(true);
        }
        this.calendarPanel.setWeekStartingDay(2);
        this.calendarPanel.setMinimalDaysInFirstWeek(4);
        GregorianCalendar maxCal = null;
        if (this.maximum != null) {
            maxCal = new GregorianCalendar(this.getLocale());
            maxCal.setTimeZone(this.timezone);
            maxCal.setTime(this.maximum);
            this.setWeekDefaults(maxCal);
        }
        this.calendarPanel.setMaxDate(maxCal);
        GregorianCalendar minCal = null;
        if (this.minimum != null) {
            minCal = new GregorianCalendar(this.getLocale());
            minCal.setTimeZone(this.timezone);
            minCal.setTime(this.minimum);
            this.setWeekDefaults(minCal);
        }
        this.calendarPanel.setMinDate(minCal);
        if (this.type == DateTypes.TIMESTAMP) {
            this.calendarPanel.showTimePanel(true);
        } else if (this.type == DateTypes.TIME) {
            this.calendarPanel.setSelectionMode(50);
        } else if (this.type == DateTypes.WEEK) {
            this.calendarPanel.setSelectionMode(20);
        } else if (this.type == DateTypes.MONTH) {
            this.calendarPanel.setSelectionMode(30);
        } else if (this.type == DateTypes.QUARTER) {
            this.calendarPanel.setSelectionMode(40);
        } else if (this.type == DateTypes.WEEKDAY) {
            this.calendarPanel.setSelectionMode(60);
        }
        int day = -1;
        int week = -1;
        GregorianCalendar gregCal = null;
        if (this.dateSet instanceof Date) {
            gregCal = new GregorianCalendar(this.getLocale());
            gregCal.setTimeZone(this.timezone);
            convert = (Date)this.dateSet;
            gregCal.setTime(convert);
            this.setWeekDefaults(gregCal);
        }
        if (gregCal != null) {
            this.calendarPanel.setCurrentDate(gregCal);
            if (this.calendarPanel.getSelectionMode() == 20) {
                this.calendarPanel.setSelectedWeek(gregCal);
            } else {
                this.calendarPanel.setSelectedDate(gregCal);
            }
        } else {
            gregCal = new GregorianCalendar(this.getLocale());
            convert = DataTypeUtil.convertDateToTimeZone((Date)gregCal.getTime(), null, (TimeZone)this.timezone, (Locale)this.getLocale());
            gregCal.setTimeZone(this.timezone);
            gregCal.setTime(convert);
            this.setWeekDefaults(gregCal);
            this.calendarPanel.setCurrentDate(gregCal);
            if (this.calendarPanel.getSelectionMode() == 20) {
                this.calendarPanel.setSelectedWeek(null);
            } else {
                this.calendarPanel.setSelectedDate(null);
            }
        }
        day = gregCal.get(5);
        week = gregCal.get(3);
        int wid = this.getWidth();
        Dimension prefSize = this.calendarPanel.getPreferredSize();
        this.calendarPanel.setMinimumSize(prefSize);
        this.calendarPanel.setPreferredSize(new Dimension(Math.max(wid, prefSize.width), prefSize.height));
        int x = 0;
        int y = 0;
        if (this.isShowing()) {
            Double dX = new Double(this.getLocationOnScreen().getX());
            Integer h = new Integer(this.getHeight());
            Double dY = new Double(this.getLocationOnScreen().getY() + h.doubleValue());
            x = dX.intValue();
            y = dY.intValue();
        }
        this.dialog = owner instanceof Frame ? new CalendarPopupDialog((Frame)owner, "Calendar", this.calendarPanel) : (owner instanceof Dialog ? new CalendarPopupDialog((Dialog)owner, "Calendar", this.calendarPanel) : new CalendarPopupDialog((Frame)null, "Calendar", this.calendarPanel));
        Point p = this.computePopupMenuLocation(x, y, this.dialog.getSize().width, this.dialog.getSize().height, this);
        this.dialog.setLocation(p.x, p.y);
        this.calendarPanel.addPropertyChangeListener(this);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (DatePicker.this.calendarPanel != null) {
                    DatePicker.this.calendarPanel.removePropertyChangeListener(DatePicker.this);
                }
                DatePicker.this.dialog = null;
            }
        });
        this.dialog.setVisible(true);
        JComponent button = null;
        if (this.calendarPanel.getSelectionMode() == 10) {
            if (day != -1) {
                button = this.calendarPanel.getButtonForDay(day);
            }
        } else if (this.calendarPanel.getSelectionMode() == 20 && week != -1) {
            button = this.calendarPanel.getButtonForWeek(week);
        }
        if (button != null) {
            button.requestFocus();
        }
    }

    private Point computePopupMenuLocation(int x, int y, int width, int height, Component comp) {
        Point p = new Point(0, 0);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(comp.getGraphicsConfiguration());
        Rectangle scrBounds = new Rectangle();
        scrBounds.x = p.x + screenInsets.left;
        scrBounds.y = p.y + screenInsets.top;
        scrBounds.width = scrSize.width - screenInsets.left - screenInsets.right;
        scrBounds.height = scrSize.height - screenInsets.top - screenInsets.bottom;
        int scrMaxX = (int)scrBounds.getMaxX();
        int scrMaxY = (int)scrBounds.getMaxY();
        Rectangle popRect = new Rectangle(x, y, width, height);
        int popMaxX = (int)popRect.getMaxX();
        int popMaxY = (int)popRect.getMaxY();
        int xDiff = popMaxX - scrMaxX;
        int yDiff = popMaxY - scrMaxY;
        if (xDiff > 0 && yDiff <= 0) {
            return new Point(x - width + this.getSize().width, y);
        }
        if (yDiff > 0 && xDiff <= 0) {
            return new Point(x, y - height - this.getSize().height);
        }
        if (xDiff > 0 && yDiff > 0) {
            return new Point(x - width + this.getSize().width, y - height - this.getSize().height);
        }
        return new Point(x, y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.calendarButton) {
            String text;
            if (this.isDialogShowing) {
                if (this.dialog != null) {
                    this.dialog.dispose();
                }
                this.dialog = null;
                this.isDialogShowing = false;
                return;
            }
            this.launchingCalendarPopup = true;
            if (this.comboField != null) {
                text = ((JTextComponent)this.comboField.getEditor().getEditorComponent()).getText();
                this.setDate(this.getValue(), text);
            } else if (this.editorComponent != null && this.editorComponent instanceof JTextField) {
                text = ((JTextField)this.editorComponent).getText();
                try {
                    this.setDate(this.formatter.stringToValue(text), text);
                }
                catch (ParseException ex) {
                    this.handleError(ex);
                }
            }
            Container owner = SwingUtilities.getAncestorOfClass(Dialog.class, this);
            if (owner == null) {
                owner = SwingUtilities.getAncestorOfClass(Frame.class, this);
            }
            this.showCalendarDialog(owner);
            this.launchingCalendarPopup = false;
            this.isDialogShowing = true;
        } else if (source == this.comboField) {
            if (this.comboField.isPopupVisible()) {
                this.selectionChanged = true;
                return;
            }
            if (!this.ignoreActionEventOnCombo) {
                this.updateForSelectedItem();
            }
        } else if (source != this.textField && source == this.nField && !this.ignoreNField) {
            this.validateNField();
        }
    }

    private void updateForSelectedItem() {
        this.selectionChanged = false;
        Object selectedItem = this.comboField.getSelectedItem();
        if (selectedItem instanceof ValueItem) {
            Object type = ((ValueItem)selectedItem).getAttribute(RELATIVE_TYPE);
            if (type == N_AGO || type == N_FROM_NOW) {
                this.lastNValue = null;
                this.relativeValue.setVisible(false);
                this.nField.setValue(new Integer(1));
                this.nField.setText(RB.getStringResource(RB_KEY, "nValue.txt", this.getLocale()));
                this.nField.setVisible(true);
                this.nField.requestFocus();
                this.revalidate();
                this.nField.selectAll();
            } else {
                this.nField.setVisible(false);
                this.setDate(((ValueItem)selectedItem).getValue(), ((ValueItem)selectedItem).getLabel());
            }
        } else {
            this.nField.setVisible(false);
            this.setDate(selectedItem, null);
        }
        this.revalidate();
    }

    private boolean setNValue(DatePeriod dp, DateTypes periodType, int nValue) {
        if (periodType == DateTypes.YEAR) {
            if (dp.getNYears() != nValue) {
                dp.setNYears(nValue);
                return true;
            }
        } else if (periodType == DateTypes.QUARTER) {
            if (dp.getNQuarters() != nValue) {
                dp.setNQuarters(nValue);
                return true;
            }
        } else if (periodType == DateTypes.MONTH) {
            if (dp.getNMonths() != nValue) {
                dp.setNMonths(nValue);
                return true;
            }
        } else if (periodType == DateTypes.WEEK) {
            if (dp.getNWeeks() != nValue) {
                dp.setNWeeks(nValue);
                return true;
            }
        } else if (periodType == DateTypes.DATE) {
            if (dp.getNDays() != nValue) {
                dp.setNDays(nValue);
                return true;
            }
        } else if (periodType == DateTypes.HOUR) {
            if (dp.getNHours() != nValue) {
                dp.setNHours(nValue);
                return true;
            }
        } else if (periodType == DateTypes.MINUTE && dp.getNMinutes() != nValue) {
            dp.setNMinutes(nValue);
            return true;
        }
        return false;
    }

    public static int getNValue(DatePeriod dp, DateTypes periodType) {
        if (periodType == DateTypes.YEAR) {
            return dp.getNYears();
        }
        if (periodType == DateTypes.QUARTER) {
            return dp.getNQuarters();
        }
        if (periodType == DateTypes.MONTH) {
            return dp.getNMonths();
        }
        if (periodType == DateTypes.WEEK) {
            return dp.getNWeeks();
        }
        if (periodType == DateTypes.DATE) {
            return dp.getNDays();
        }
        if (periodType == DateTypes.HOUR) {
            return dp.getNHours();
        }
        if (periodType == DateTypes.MINUTE) {
            return dp.getNMinutes();
        }
        return 0;
    }

    private void validateNField() {
        int nValue = 0;
        try {
            Object text = this.nField.getValue();
            if (text instanceof Number && !Util.equal((Object)text, (Object)this.lastNValue)) {
                this.lastNValue = text;
                nValue = ((Number)text).intValue();
                Object selectedItem = this.comboField.getSelectedItem();
                if (selectedItem instanceof ValueItem && ((ValueItem)selectedItem).getValue() instanceof DatePeriod) {
                    ValueItem item = (ValueItem)selectedItem;
                    DatePeriod dp = (DatePeriod)item.getValue();
                    boolean changed = false;
                    DateTypes periodType = (DateTypes)item.getAttribute(PERIOD_TYPE);
                    DatePeriod d = (DatePeriod)dp.clone();
                    if (periodType != null) {
                        Object type = item.getAttribute(RELATIVE_TYPE);
                        if (type == N_AGO) {
                            changed = this.setNValue(d, periodType, -nValue);
                        } else if (type == N_FROM_NOW) {
                            changed = this.setNValue(d, periodType, nValue);
                        }
                    }
                    if (changed || nValue == 0 || !d.equals(this.dateSet)) {
                        item.setValue((Object)d);
                        this.setDate((Date)item.getValue(), item.getLabel());
                    } else {
                        this.updateRelativeFieldValue();
                    }
                }
            }
        }
        catch (IllegalArgumentException ex) {
            this.handleError(ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() instanceof CalendarPanel && "valueChanged".equalsIgnoreCase(e.getPropertyName())) {
            CalendarPanel calPanel = (CalendarPanel)e.getSource();
            GregorianCalendar cal = null;
            cal = calPanel.getSelectionMode() == 20 ? calPanel.getSelectedWeek() : calPanel.getSelectedDate();
            if (this.dialog != null) {
                this.isDialogShowing = this.dialog.isShowing();
            }
            if (cal != null) {
                Date newDate = cal.getTime();
                if (!(newDate instanceof DatePeriod)) {
                    if (this.type == DateTypes.YEAR) {
                        newDate = new DatePeriod(newDate, DateTypes.YEAR, this.timezone, this.getLocale());
                    } else if (this.type == DateTypes.QUARTER) {
                        newDate = new DatePeriod(newDate, DateTypes.QUARTER, this.timezone, this.getLocale());
                    } else if (this.type == DateTypes.MONTH) {
                        newDate = new DatePeriod(newDate, DateTypes.MONTH, this.timezone, this.getLocale());
                    } else if (this.type == DateTypes.WEEK) {
                        newDate = new DatePeriod(newDate, DateTypes.WEEK, this.timezone, this.getLocale());
                    } else if (this.type == DateTypes.DATE) {
                        newDate = new DatePeriod(newDate, DateTypes.DATE, this.timezone, this.getLocale());
                    } else if (this.type == DateTypes.WEEKDAY) {
                        newDate = new DatePeriod(newDate, DateTypes.WEEKDAY, this.timezone, this.getLocale());
                    } else if (this.type == DateTypes.HOUR) {
                        newDate = new DatePeriod(newDate, DateTypes.HOUR, this.timezone, this.getLocale());
                    } else if (this.type == DateTypes.MINUTE) {
                        newDate = new DatePeriod(newDate, DateTypes.MINUTE, this.timezone, this.getLocale());
                    } else if (this.type == DateTypes.TIMESTAMP) {
                        newDate = new DatePeriod(newDate, DateTypes.TIMESTAMP, this.timezone, this.getLocale());
                    } else if (this.type == DateTypes.TIME) {
                        newDate = new DatePeriod(newDate, DateTypes.TIME, this.timezone, this.getLocale());
                    }
                }
                this.setDate(newDate, null);
            }
        }
    }

    public Date getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Date maximum) {
        this.maximum = maximum;
    }

    public Date getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Date minimum) {
        this.minimum = minimum;
    }

    public boolean isLaunchingCalendarPopup() {
        return this.launchingCalendarPopup;
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue() {
        if (this.handlingError) {
            return this.dateSet;
        }
        String text = null;
        if (this.comboField != null) {
            Object selectedItem = this.comboField.getSelectedItem();
            if (selectedItem instanceof Date && !this.valueModified) {
                return selectedItem;
            }
            text = ((JTextComponent)this.comboField.getEditor().getEditorComponent()).getText();
            ComboBoxModel model = this.comboField.getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                Object item = model.getElementAt(i);
                if (item instanceof ValueItem) {
                    if (!Util.equal((Object)((ValueItem)item).getLabel(), (Object)text)) continue;
                    if (this.nField.isVisible()) {
                        try {
                            this.ignoreNField = true;
                            this.nField.commitEdit();
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            this.ignoreNField = false;
                        }
                        this.validateNField();
                    }
                    Object value = ((ValueItem)item).getValue();
                    return value;
                }
                if (!Util.equal(item, (Object)text)) continue;
                return item;
            }
        } else {
            text = this.textField.getText();
        }
        Object value = this.dateSet;
        try {
            if (this.valueModified) {
                value = this.formatter.stringToValue(text);
            }
        }
        catch (ParseException ex) {
            this.handleError(ex);
            if (this.comboField != null) {
                if (this.comboField.isEditable()) {
                    ((JTextComponent)this.comboField.getEditor().getEditorComponent()).setText(this.dataType.getDisplayString(this.dateSet, this.getLocale()));
                }
            }
            this.textField.setText(this.dataType.getDisplayString(this.dateSet, this.getLocale()));
        }
        return value;
    }

    private void handleError(Exception ex) {
        String msg = null;
        if (ex != null) {
            msg = ex.getMessage();
        }
        this.handleError(msg);
    }

    private void handleError(String msg) {
        this.handleError(this, new Message(Strings.padSingleQuotesForMessage((String)msg)), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(Object object, Message message, String messageCode) {
        if (this.getGenericErrorHandler() != null) {
            try {
                this.handlingError = true;
                this.getGenericErrorHandler().handleError(object, message, messageCode);
            }
            finally {
                this.handlingError = false;
            }
        }
    }

    protected boolean isHandlingError() {
        return this.handlingError;
    }

    @Override
    public void setValue(Object anObject) {
        this.setDate(anObject, null);
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        this.listenerList.add(EditorListener.class, listener);
    }

    @Override
    public void removeEditorListener(EditorListener listener) {
        this.listenerList.remove(EditorListener.class, listener);
    }

    public EditorListener[] getEditorListeners() {
        return (EditorListener[])this.listenerList.getListeners(EditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStarted(this.changeEvent);
        }
    }

    protected void fireValueModified() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueModified(this.changeEvent);
        }
    }

    protected void fireValueChanged() {
        this.valueModified = false;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueChanged(this.changeEvent);
        }
    }

    @Override
    public boolean isEditing() {
        return this.isEditing;
    }

    @Override
    public void requestFocus() {
        if (this.editorComponent instanceof JComboBox && ((JComboBox)this.editorComponent).isEditable()) {
            Component editor = ((JComboBox)this.editorComponent).getEditor().getEditorComponent();
            if (editor != null) {
                editor.requestFocus();
            }
        } else {
            this.editorComponent.requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        Component editor;
        if (this.editorComponent instanceof JComboBox && ((JComboBox)this.editorComponent).isEditable() && (editor = ((JComboBox)this.editorComponent).getEditor().getEditorComponent()) != null && editor instanceof JComponent) {
            return ((JComponent)editor).requestFocus(temporary);
        }
        return this.editorComponent.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        Component editor;
        if (this.editorComponent instanceof JComboBox && ((JComboBox)this.editorComponent).isEditable() && (editor = ((JComboBox)this.editorComponent).getEditor().getEditorComponent()) != null) {
            return editor.requestFocusInWindow();
        }
        return this.editorComponent.requestFocusInWindow();
    }

    public boolean isShowRelativeDates() {
        return this.showRelativeDates;
    }

    public void setShowRelativeDates(boolean showRelativeDates) {
        if (this.showRelativeDates != showRelativeDates) {
            boolean oldValue = this.showRelativeDates;
            this.showRelativeDates = showRelativeDates;
            Object value = this.getValue();
            this.removeAll();
            this.removeListeners();
            this.comboField = null;
            this.comboModel = null;
            this.textField = null;
            this.configureUI();
            this.addListeners();
            if (showRelativeDates || !(value instanceof DatePeriod) || !((DatePeriod)value).isRelativeDate()) {
                this.setValue(value);
            }
            this.revalidate();
            this.firePropertyChange("showRelativeDates", oldValue, this.showRelativeDates);
        }
    }

    private void configureUI() {
        this.loadRelativeDates();
        if (this.showRelativeDates && this.comboModel != null && this.comboModel.getSize() > 0 || this.availableValues != null && !this.availableValues.isEmpty() || this.specialValues != null && (this.specialValues.isAllSupported() || this.specialValues.isOtherSupported() || this.specialValues.isMissingValuesSupported() && !this.specialValues.isMissingValuesHiddenIfSupported())) {
            this.loadSpecialValues();
            this.loadAvailableValues();
            NumberFormat nf = NumberFormat.getIntegerInstance(this.getLocale());
            NumberFormatter numberFormatter = new NumberFormatter(nf);
            numberFormatter.setMinimum(new Integer(0));
            numberFormatter.setValueClass(Integer.class);
            this.nField = new JFormattedTextField(numberFormatter){
                private String nValue;
                {
                    this.nValue = RB.getStringResource(DatePicker.RB_KEY, "nValue.txt", this.getLocale());
                }

                @Override
                protected void invalidEdit() {
                }

                @Override
                public void commitEdit() throws ParseException {
                    if (DatePicker.this.listenersRemoved) {
                        return;
                    }
                    Object oldValue = this.getValue();
                    if (this.nValue.equals(this.getText())) {
                        this.setValue(new Integer(1));
                        this.fireActionPerformed();
                        return;
                    }
                    try {
                        super.commitEdit();
                        int length = DatePicker.this.nField.getText().length();
                        for (int j = 0; j < length; ++j) {
                            Format.Field[] fields = ((NumberFormatter)DatePicker.this.nField.getFormatter()).getFields(j);
                            if (fields != null && fields.length != 0) continue;
                            String message = new Message(Strings.padSingleQuotesForMessage((String)RB.getStringResource(DatePicker.RB_KEY, "invalidNValue.ex.txt", this.getLocale()))).toString();
                            throw new ParseException(message, j);
                        }
                        this.fireActionPerformed();
                    }
                    catch (ParseException ex) {
                        DatePicker.this.handleError(RB.getStringResource(DatePicker.RB_KEY, "invalidNValue.ex.txt", this.getLocale()));
                        this.setValue(oldValue);
                        throw ex;
                    }
                }
            };
            this.nField.setFocusLostBehavior(1);
            this.nField.setColumns(3);
            this.nField.setVisible(false);
            this.comboField = new WideComboBox();
            ((WideComboBox)this.comboField).setPopupStyle(5);
            this.comboField.setName("Date Field");
            this.comboField.setEditable(true);
            FormattedComboBoxEditor editor = new FormattedComboBoxEditor(this.formatter);
            editor.setGenericErrorHandler(this);
            ((JTextField)editor.getEditorComponent()).setColumns(10);
            this.comboField.setEditor(editor);
            this.comboField.setModel(this.comboModel);
            this.comboField.setSelectedIndex(-1);
            this.editorComponent = this.comboField;
        } else {
            this.textField = new JFormattedTextField(this.formatter){

                @Override
                protected void invalidEdit() {
                }

                @Override
                public void commitEdit() throws ParseException {
                    if (DatePicker.this.listenersRemoved) {
                        return;
                    }
                    try {
                        super.commitEdit();
                        Object val = this.getValue();
                        if (!PromptUtil.isValueAllowedIfSpecial((SupportedSpecialValues)DatePicker.this.getSupportedSpecialValues(), (Object)val)) {
                            throw new ParseException(Message.format((String)RB.getStringResource("notPermittedValue.fmt.txt", DatePicker.this.getLocale()), (Object)val), 0);
                        }
                        DatePicker.this.setDate(val, null);
                    }
                    catch (ParseException ex) {
                        DatePicker.this.handleError(ex);
                        this.setValue(this.getValue());
                        throw ex;
                    }
                }
            };
            this.textField.setColumns(10);
            this.textField.setFocusLostBehavior(1);
            this.editorComponent = this.textField;
        }
        this.add(this.editorComponent);
        if (this.showRelativeDates && this.type != DateTypes.WEEKDAY) {
            this.add(this.nField);
        }
        this.addCalendarButton();
        this.add(this.relativeValue);
    }

    @Override
    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            GenericErrorHandlerInterface oldValue = this.errorHandler;
            this.errorHandler = errorHandler;
            this.firePropertyChange("genericErrorHandler", oldValue, this.errorHandler);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.ignoreRemoveEvent && !this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.ignoreRemoveEvent && !this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValues;
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValues) {
        if (this.specialValues != specialValues) {
            SupportedSpecialValues oldValue = this.specialValues;
            this.specialValues = specialValues;
            this.formatter.setSupportedSpecialValues(specialValues);
            Object value = this.getValue();
            this.removeAll();
            this.removeListeners();
            this.comboField = null;
            this.comboModel = null;
            this.textField = null;
            this.configureUI();
            this.addListeners();
            if (PromptUtil.isValueAllowedIfSpecial((SupportedSpecialValues)specialValues, (Object)value)) {
                this.setValue(value);
            }
            this.revalidate();
            this.firePropertyChange("specialValues", oldValue, this.specialValues);
        }
    }

    public List getAvailableValues() {
        return this.availableValues;
    }

    public void setAvailableValues(List availableValues) {
        if (this.availableValues != availableValues) {
            List oldValue = this.availableValues;
            this.availableValues = availableValues;
            Object value = this.getValue();
            this.removeAll();
            this.removeListeners();
            this.comboField = null;
            this.comboModel = null;
            this.textField = null;
            this.configureUI();
            this.addListeners();
            this.setValue(value);
            this.revalidate();
            this.firePropertyChange("availableValues", oldValue, this.availableValues);
        }
    }

    public boolean isShowExampleLabel() {
        return this.showExampleLabel;
    }

    public void setShowExampleLabel(boolean showExampleLabel) {
        if (this.showExampleLabel != showExampleLabel) {
            boolean oldValue = this.showExampleLabel;
            this.showExampleLabel = showExampleLabel;
            this.firePropertyChange("showExampleLabel", oldValue, this.showExampleLabel);
        }
    }
}

