/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.WeekdayType;
import com.sas.datatypes.YearType;
import com.sas.prompts.PromptUtil;
import com.sas.swing.visuals.RB;
import com.sas.text.Message;
import com.sas.util.DateTypes;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValueItem;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.TimeZone;

@SASScope
public class DateFormatter
extends javax.swing.text.DateFormatter
implements MutableSupportedSpecialValuesInterface {
    private DataTypeInterface dataType;
    private Locale locale;
    private SupportedSpecialValues specialValues;

    public DateFormatter(DateFormat format, DateTypes dateType, SupportedSpecialValues specialValues, Locale locale) {
        this(format, dateType, specialValues, null, locale);
    }

    public DateFormatter(DateFormat format, DataTypeInterface dataType, SupportedSpecialValues specialValues, Locale locale) {
        super(format);
        this.locale = locale;
        this.specialValues = specialValues;
        this.dataType = dataType;
    }

    public DateFormatter(DateFormat format, DateTypes dateType, SupportedSpecialValues specialValues, TimeZone timeZone, Locale locale) {
        super(format);
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if (dateType == DateTypes.DATE) {
            this.dataType = new DateType(timeZone);
        } else if (dateType == DateTypes.WEEK) {
            this.dataType = new WeekType(timeZone);
        } else if (dateType == DateTypes.MONTH) {
            this.dataType = new MonthType(timeZone);
        } else if (dateType == DateTypes.QUARTER) {
            this.dataType = new QuarterType(timeZone);
        } else if (dateType == DateTypes.TIMESTAMP) {
            this.dataType = new TimeStampType(timeZone);
        } else if (dateType == DateTypes.TIME) {
            this.dataType = new TimeType(timeZone);
        } else if (dateType == DateTypes.YEAR) {
            this.dataType = new YearType(timeZone);
        } else if (dateType == DateTypes.WEEKDAY) {
            this.dataType = new WeekdayType(timeZone);
        } else if (dateType == DateTypes.HOUR) {
            this.dataType = new TimeType(timeZone);
        } else if (dateType == DateTypes.MINUTE) {
            this.dataType = new TimeType(timeZone);
        }
        this.locale = locale;
        this.specialValues = specialValues;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        try {
            Object v = this.dataType.coerceValue((Object)string, this.locale);
            if (!PromptUtil.isValueAllowedIfSpecial((SupportedSpecialValues)this.getSupportedSpecialValues(), (Object)v)) {
                throw new ParseException(Message.format((String)RB.getStringResource("notPermittedValue.fmt.txt", this.locale), (Object)v), 0);
            }
            return v;
        }
        catch (Exception e) {
            ParseException ex = new ParseException(e.getMessage(), 0);
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value instanceof ValueItem) {
            if (((ValueItem)value).getLabel() != null) {
                return ((ValueItem)value).getLabel().toString();
            }
            return "";
        }
        Object v = this.dataType.coerceValue(value, this.locale);
        String s = this.dataType.getDisplayString(v, this.locale);
        return s;
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValuesSupported) {
        this.specialValues = specialValuesSupported;
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValues;
    }
}

