/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.ConfigPanelInterface;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.JTextComponent;

@SASScope
public class Config {
    public static final int _DISABLEABLE = 1;
    public static final int _INITIALIZABLE = 2;
    public static final int _FILTERABLE = 4;
    public static final int _VISIBILITY = 8;
    public static final int _CALLBACKABLE = 16;
    public static final int _HELPASSIGNABLE = 18;
    private HashMap _callbackMap;
    private HashSet _disabledElements;
    private HashMap _filterMap;
    private HashSet _hiddenElements;
    private HashMap _initMap;
    private HashMap _helpProdMap;
    private HashMap _helpIDMap;

    public void setCallback(Element element, Callback callback) {
        if ((element._properties & 0x10) == 0) {
            throw new IllegalStateException("Callback is not supported for " + element);
        }
        this.getCallbackMap().put(element, callback);
    }

    public void setFilter(Element element, Set filters) {
        if ((element._properties & 4) == 0) {
            throw new IllegalStateException("Filtering is not supported for " + element);
        }
        this.getFilterMap().put(element, filters);
    }

    public void setInitValue(Element element, Object value) {
        if ((element._properties & 2) == 0) {
            throw new IllegalStateException("Initialization is not supported for " + element);
        }
        element._configPanelInterface.validateInitValue(element, value);
        this.getInitMap().put(element, value);
    }

    public void setEnabled(Element element, boolean enabled) {
        if ((element._properties & 1) == 0) {
            throw new IllegalStateException("Controlling the enabled nature is not supported for " + element);
        }
        if (enabled) {
            this.getDisabledElements().remove(element);
        } else {
            this.getDisabledElements().add(element);
        }
    }

    public void setVisible(Element element, boolean visible) {
        if ((element._properties & 8) == 0) {
            throw new IllegalStateException("Controlling the visibility is not supported for " + element);
        }
        if (visible) {
            this.getHiddenElements().remove(element);
        } else {
            this.getHiddenElements().add(element);
        }
    }

    public void setHelpProduct(Element element, String helpProduct) {
        if ((element._properties & 0x12) == 0) {
            throw new IllegalStateException("Controlling the help DocProduct is not supported for " + element);
        }
        this.getHelpProdMap().put(element, helpProduct);
    }

    public void setHelpID(Element element, String helpID) {
        if ((element._properties & 0x12) == 0) {
            throw new IllegalStateException("Controlling the helpID is not supported for " + element);
        }
        this.getHelpIDMap().put(element, helpID);
    }

    public Callback getCallback(Element element) {
        return (Callback)this.getCallbackMap().get(element);
    }

    public Set getFilter(Element element) {
        return (Set)this.getFilterMap().get(element);
    }

    public Object getInitValue(Element element, Object defaultValue) {
        Object retVal = this.getInitMap().get(element);
        return retVal == null ? defaultValue : retVal;
    }

    public boolean isEnabled(Element element) {
        return !this.getDisabledElements().contains(element);
    }

    public boolean isVisible(Element element) {
        return !this.getHiddenElements().contains(element);
    }

    public String getHelpProduct(Element element, String defaultHelpProduct) {
        String helpProduct = (String)this.getHelpProdMap().get(element);
        return helpProduct == null ? defaultHelpProduct : helpProduct;
    }

    public String getHelpID(Element element, String defaultHelpID) {
        String helpID = (String)this.getHelpIDMap().get(element);
        return helpID == null ? defaultHelpID : helpID;
    }

    public void initializeTextComponent(JTextComponent tc, Element element, Object defaultValue) {
        Object initVal = this.getInitValue(element, defaultValue);
        if (initVal == null) {
            return;
        }
        tc.setText(initVal.toString());
    }

    private HashMap getCallbackMap() {
        if (this._callbackMap == null) {
            this._callbackMap = new HashMap();
        }
        return this._callbackMap;
    }

    private HashSet getDisabledElements() {
        if (this._disabledElements == null) {
            this._disabledElements = new HashSet();
        }
        return this._disabledElements;
    }

    private HashMap getFilterMap() {
        if (this._filterMap == null) {
            this._filterMap = new HashMap();
        }
        return this._filterMap;
    }

    private HashSet getHiddenElements() {
        if (this._hiddenElements == null) {
            this._hiddenElements = new HashSet();
        }
        return this._hiddenElements;
    }

    private HashMap getInitMap() {
        if (this._initMap == null) {
            this._initMap = new HashMap();
        }
        return this._initMap;
    }

    private HashMap getHelpProdMap() {
        if (this._helpProdMap == null) {
            this._helpProdMap = new HashMap();
        }
        return this._helpProdMap;
    }

    private HashMap getHelpIDMap() {
        if (this._helpIDMap == null) {
            this._helpIDMap = new HashMap();
        }
        return this._helpIDMap;
    }

    @SASScope
    public static class Selection
    extends Base {
        public Selection(ConfigPanelInterface configPanelInterface, String name) {
            super(configPanelInterface, name);
        }
    }

    @SASScope
    public static class Filter
    extends Base {
        public Filter(ConfigPanelInterface configPanelInterface, String name) {
            super(configPanelInterface, name);
        }
    }

    @SASScope
    public static class Element
    extends Base {
        int _properties;

        public Element(ConfigPanelInterface configPanelInterface, String name, int properties) {
            super(configPanelInterface, name);
            this._properties = properties;
        }

        public String toString() {
            return this._name;
        }
    }

    @SASScope
    public static abstract class Callback {
        public abstract void callback(Object var1);
    }

    @SASScope
    private static class Base {
        protected String _name;
        protected ConfigPanelInterface _configPanelInterface;

        private Base(ConfigPanelInterface configPanelInterface, String name) {
            this._name = name;
            this._configPanelInterface = configPanelInterface;
        }
    }
}

