/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

@SASScope
public class CompoundIcon
implements Icon {
    protected List m_alIcons = new ArrayList();
    private List m_disabledIcons;
    private List m_disabledSelIcons;
    protected int m_cpIconGap = 3;
    protected int m_eOrientation = 0;
    protected boolean m_bReverseOrder = false;

    public CompoundIcon() {
    }

    public CompoundIcon(Icon icon) {
        this();
        this.m_alIcons.add(icon);
    }

    public CompoundIcon(Icon[] aIcons) {
        this();
        int nIcons = aIcons.length;
        for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
            this.m_alIcons.add(aIcons[iIcon]);
        }
    }

    public CompoundIcon(List alIcons) {
        this();
        int nIcons = alIcons.size();
        for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
            this.m_alIcons.add(alIcons.get(iIcon));
        }
    }

    public int getIconCount() {
        return this.m_alIcons.size();
    }

    public void addIcon(Icon icon) {
        this.m_alIcons.add(icon);
        this.m_disabledIcons = null;
        this.m_disabledSelIcons = null;
    }

    public void addIcon(Icon icon, int iIcon) {
        this.m_alIcons.add(iIcon, icon);
        this.m_disabledIcons = null;
        this.m_disabledSelIcons = null;
    }

    public Icon removeIcon(int iIcon) {
        this.m_disabledIcons = null;
        this.m_disabledSelIcons = null;
        return (Icon)this.m_alIcons.remove(iIcon);
    }

    public void setOrientation(int eOrientation) {
        this.m_eOrientation = eOrientation;
    }

    public int getOrientation() {
        return this.m_eOrientation;
    }

    public void setIconGap(int cpIconGap) {
        this.m_cpIconGap = cpIconGap;
    }

    public int getIconGap() {
        return this.m_cpIconGap;
    }

    public void setReverseOrder(boolean bReverseOrder) {
        this.m_bReverseOrder = bReverseOrder;
    }

    public boolean isReverseOrder() {
        return this.m_bReverseOrder;
    }

    @Override
    public int getIconHeight() {
        int cyIcon = 0;
        int nIcons = this.m_alIcons.size();
        if (this.m_eOrientation == 0) {
            for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
                cyIcon = Math.max(cyIcon, ((Icon)this.m_alIcons.get(iIcon)).getIconHeight());
            }
        } else {
            for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
                cyIcon += ((Icon)this.m_alIcons.get(iIcon)).getIconHeight() + this.m_cpIconGap;
            }
            cyIcon -= this.m_cpIconGap;
        }
        return cyIcon;
    }

    @Override
    public int getIconWidth() {
        int cxIcon = 0;
        int nIcons = this.m_alIcons.size();
        if (this.m_eOrientation == 1) {
            for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
                cxIcon = Math.max(cxIcon, ((Icon)this.m_alIcons.get(iIcon)).getIconWidth());
            }
        } else {
            for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
                cxIcon += ((Icon)this.m_alIcons.get(iIcon)).getIconWidth() + this.m_cpIconGap;
            }
            cxIcon -= this.m_cpIconGap;
        }
        return cxIcon;
    }

    @Override
    public synchronized void paintIcon(Component cmp, Graphics g, int x, int y) {
        List icons = this.m_alIcons;
        if (cmp instanceof JComponent && !cmp.isEnabled()) {
            Icon compareIcon = null;
            if (cmp instanceof AbstractButton) {
                compareIcon = ((AbstractButton)cmp).isSelected() ? ((AbstractButton)cmp).getDisabledSelectedIcon() : ((AbstractButton)cmp).getDisabledIcon();
            } else if (cmp instanceof JLabel) {
                compareIcon = ((JLabel)cmp).getDisabledIcon();
            }
            if (compareIcon == null) {
                if (cmp instanceof AbstractButton && ((AbstractButton)cmp).isSelected()) {
                    if (this.m_disabledSelIcons == null) {
                        this.m_disabledSelIcons = new ArrayList();
                        for (Icon ic : this.m_alIcons) {
                            ic = UIManager.getLookAndFeel().getDisabledSelectedIcon((JComponent)cmp, ic);
                            this.m_disabledSelIcons.add(ic);
                        }
                    }
                    icons = this.m_disabledSelIcons;
                } else {
                    if (this.m_disabledIcons == null) {
                        this.m_disabledIcons = new ArrayList();
                        for (Icon ic : this.m_alIcons) {
                            ic = UIManager.getLookAndFeel().getDisabledIcon((JComponent)cmp, ic);
                            this.m_disabledIcons.add(ic);
                        }
                    }
                    icons = this.m_disabledIcons;
                }
            }
        }
        if (this.m_bReverseOrder) {
            if (this.m_eOrientation == 0) {
                x += this.getIconWidth();
            } else {
                y += this.getIconHeight();
            }
            for (int iIcon = icons.size() - 1; iIcon >= 0; --iIcon) {
                Icon icon = (Icon)icons.get(iIcon);
                if (this.m_eOrientation == 0) {
                    x -= icon.getIconWidth();
                } else {
                    y -= icon.getIconHeight();
                }
                icon.paintIcon(cmp, g, x, y);
                if (this.m_eOrientation == 0) {
                    x -= this.m_cpIconGap;
                    continue;
                }
                y -= this.m_cpIconGap;
            }
        } else {
            int nIcons = icons.size();
            for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
                Icon icon = (Icon)icons.get(iIcon);
                icon.paintIcon(cmp, g, x, y);
                if (this.m_eOrientation == 0) {
                    x += icon.getIconWidth() + this.m_cpIconGap;
                    continue;
                }
                y += icon.getIconHeight() + this.m_cpIconGap;
            }
        }
    }
}

