/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.ComboBox;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

@SASScope
public abstract class ComponentComboBox
extends ComboBox {
    public static final String RB_KEY = "ComponentComboBox.";

    public ComponentComboBox() {
    }

    public ComponentComboBox(ComboBoxModel aModel) {
        super(aModel);
    }

    public ComponentComboBox(Object[] items) {
        super(items);
    }

    public ComponentComboBox(Vector items) {
        super(items);
    }

    @Override
    public void updateUI() {
        LookAndFeel lnf = UIManager.getLookAndFeel();
        String lnfName = lnf.getName();
        BasicComboBoxUI uiCombo = lnfName.equals("Metal") ? new MetalComponentComboBoxUI(this) : (lnfName.equals("Windows") ? new WindowsComponentComboBoxUI(this) : (lnfName.equals("CDE/Motif") ? new MotifComponentComboBoxUI(this) : new BasicComboBoxUI()));
        this.setUI(uiCombo);
    }

    protected abstract ComboPopup createPopup();

    @SASScope
    class MotifComponentComboBoxUI
    extends BasicComboBoxUI {
        private ComponentComboBox combo;

        public MotifComponentComboBoxUI(ComponentComboBox combo) {
            this.combo = combo;
        }

        @Override
        protected ComboPopup createPopup() {
            return this.combo.createPopup();
        }
    }

    @SASScope
    class WindowsComponentComboBoxUI
    extends BasicComboBoxUI {
        private ComponentComboBox combo;

        public WindowsComponentComboBoxUI(ComponentComboBox combo) {
            this.combo = combo;
        }

        @Override
        protected ComboPopup createPopup() {
            return this.combo.createPopup();
        }
    }

    @SASScope
    class BasicComponentComboBoxUI
    extends BasicComboBoxUI {
        private ComponentComboBox combo;

        public BasicComponentComboBoxUI(ComponentComboBox combo) {
            this.combo = combo;
        }

        @Override
        protected ComboPopup createPopup() {
            return this.combo.createPopup();
        }
    }

    @SASScope
    class MetalComponentComboBoxUI
    extends MetalComboBoxUI {
        private ComponentComboBox combo;

        public MetalComponentComboBoxUI(ComponentComboBox combo) {
            this.combo = combo;
        }

        @Override
        protected ComboPopup createPopup() {
            return this.combo.createPopup();
        }
    }
}

