/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.swing.visuals.BasicButton;
import com.sas.swing.visuals.CheckBoxTree;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

@SASScope(value="ALL")
@SubjectToChange
public class CheckBoxTreeCellRendererWrapper
extends JComponent
implements TreeCellRenderer,
LayoutConstants {
    private JCheckBox checkBox;
    protected TreeCellRenderer renderer;
    private CheckBoxTree checkTree;
    private int pressedRow;
    private int armedRow;
    private boolean checkBoxHasFocus;
    private AbstractButton image;
    private JPanel checkImagePanel;
    private AutoSizingGridLayout layout;
    private boolean leftRight;
    private boolean createdRenderer = false;

    public CheckBoxTreeCellRendererWrapper(JTree tree) {
        this(tree.getCellRenderer());
        this.createdRenderer = true;
    }

    public CheckBoxTreeCellRendererWrapper(TreeCellRenderer renderer) {
        this.setOpaque(false);
        this.leftRight = true;
        this.renderer = renderer;
        this.pressedRow = -1;
        this.armedRow = -1;
        this.checkBoxHasFocus = false;
        this.checkBox = this.createDefaultCheckBox();
        this.layout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        this.layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout(this.layout);
        this.checkImagePanel = new JPanel();
        this.checkImagePanel.setOpaque(false);
        AutoSizingGridLayout checkLayout = new AutoSizingGridLayout(1, 2, 0, 0, true, true, true);
        checkLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.checkImagePanel.setLayout(checkLayout);
        this.checkImagePanel.add(this.checkBox);
        this.image = new BasicButton();
        this.image.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.image.setBorderPainted(false);
        this.image.setOpaque(false);
        this.image.setMargin(EMPTY_INSETS);
        this.checkImagePanel.add(this.image);
        this.add(this.checkImagePanel);
    }

    public boolean isDefaultRenderer() {
        return this.createdRenderer;
    }

    public JCheckBox createDefaultCheckBox() {
        return new JCheckBox();
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public void setCheckBox(JCheckBox newCheckBox) {
        if (this.checkBox != newCheckBox) {
            JCheckBox old = this.checkBox;
            this.checkBox = newCheckBox;
            this.firePropertyChange("checkBox", old, newCheckBox);
        }
    }

    public TreeCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public void setCellRenderer(TreeCellRenderer newRenderer) {
        if (this.renderer != newRenderer) {
            TreeCellRenderer old = this.renderer;
            this.renderer = newRenderer;
            this.createdRenderer = old == null || newRenderer == null;
            this.firePropertyChange("cellRenderer", old, newRenderer);
        }
    }

    public void setPressedRow(int row) {
        if (this.pressedRow != row) {
            int old = this.pressedRow;
            this.pressedRow = row;
            this.firePropertyChange("pressedRow", old, row);
        }
    }

    public int getPressedRow() {
        return this.pressedRow;
    }

    public void setArmedRow(int row) {
        if (this.armedRow != row) {
            int old = this.armedRow;
            this.armedRow = row;
            this.firePropertyChange("armedRow", old, row);
        }
    }

    public int getArmedRow() {
        return this.armedRow;
    }

    public void setCheckBoxHasFocus(boolean checkBoxFocus) {
        if (this.checkBoxHasFocus != checkBoxFocus) {
            this.checkBoxHasFocus = checkBoxFocus;
            this.firePropertyChange("checkBoxHasFocus", this.checkBoxHasFocus ? Boolean.FALSE : Boolean.TRUE, this.checkBoxHasFocus ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getCheckBoxHasFocus() {
        return this.checkBoxHasFocus;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean ltr;
        Component component = this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        if (component instanceof JComponent) {
            this.setToolTipText(((JComponent)component).getToolTipText());
        }
        boolean bl = ltr = tree.getComponentOrientation().isLeftToRight();
        if (this.getComponentCount() > 1) {
            if (ltr == this.leftRight) {
                if (ltr) {
                    this.remove(1);
                } else {
                    this.remove(0);
                }
            } else {
                this.checkImagePanel.removeAll();
                this.removeAll();
            }
        }
        this.image.setIcon(null);
        if (leaf) {
            this.image.setVisible(false);
        } else {
            this.image.setVisible(true);
        }
        if (tree instanceof CheckBoxTree) {
            this.checkTree = (CheckBoxTree)tree;
            if (this.checkTree.getCheckedModel() != null && this.checkTree.getCheckedModel().getSelectionMode() == 1) {
                this.image.setVisible(false);
            }
            if (!this.checkTree.isShowSelectionIcon()) {
                this.image.setVisible(false);
            }
            boolean armed = row == this.armedRow;
            boolean pressed = row == this.pressedRow;
            TreePath path = this.checkTree.getPathForRow(row);
            boolean checkBoxVisible = this.checkTree.isCheckBoxVisibleForPath(path);
            this.checkBox.setVisible(checkBoxVisible);
            boolean enabled = this.checkTree.isCheckBoxEnabledForPath(path);
            this.checkBox.setEnabled(enabled);
            if (checkBoxVisible && this.checkTree.getCheckedModel() != null) {
                boolean sel = this.checkTree.getCheckedModel().isPathSelected(path);
                if (enabled && this.checkBoxHasFocus) {
                    this.checkBox.getModel().setArmed(armed);
                    this.checkBox.getModel().setPressed(pressed);
                } else {
                    this.checkBox.getModel().setArmed(false);
                    this.checkBox.getModel().setPressed(false);
                }
                this.checkBox.setSelected(sel);
            }
            if (!this.checkTree.isIconVisibleForPath(path)) {
                this.image.setIcon(null);
            } else {
                if (!this.checkBoxHasFocus) {
                    this.image.getModel().setArmed(armed);
                    this.image.getModel().setPressed(pressed);
                } else {
                    this.image.getModel().setArmed(false);
                    this.image.getModel().setPressed(false);
                }
                this.image.setIcon(this.checkTree.getIconForCheckedState(this.checkTree.getCheckedState(path)));
            }
        }
        this.checkBox.setBackground(tree.getBackground());
        this.image.setBackground(tree.getBackground());
        if (ltr == this.leftRight) {
            if (ltr) {
                this.add(component);
            } else {
                this.add(component, 0);
            }
        } else if (ltr) {
            this.checkImagePanel.add(this.checkBox);
            this.checkImagePanel.add(this.image);
            this.add(this.checkImagePanel);
            this.add(component);
        } else {
            this.checkImagePanel.add(this.image);
            this.checkImagePanel.add(this.checkBox);
            this.add(component);
            this.add(this.checkImagePanel);
        }
        this.leftRight = ltr;
        return this;
    }
}

