/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.swing.visuals.BasicCheckBoxListUI;
import com.sas.swing.visuals.CheckBoxListCellRenderer;
import com.sas.swing.visuals.CheckBoxListSelectionModel;
import com.sas.swing.visuals.RB;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;

public class CheckBoxList
extends JList {
    public static final String RB_KEY = "CheckBoxList.";

    public CheckBoxList(ListModel dataModel) {
        super(dataModel);
        this.setCellRenderer(new CheckBoxListCellRenderer());
        this.setSelectionModel(new CheckBoxListSelectionModel());
        this.setUI(new BasicCheckBoxListUI());
    }

    public CheckBoxList(final Object[] listData) {
        this((ListModel)new AbstractListModel(){

            @Override
            public int getSize() {
                return listData.length;
            }

            @Override
            public Object getElementAt(int i) {
                return listData[i];
            }
        });
    }

    public CheckBoxList(final Vector listData) {
        this((ListModel)new AbstractListModel(){

            @Override
            public int getSize() {
                return listData.size();
            }

            @Override
            public Object getElementAt(int i) {
                return listData.elementAt(i);
            }
        });
    }

    public CheckBoxList() {
        this((ListModel)new AbstractListModel(){

            @Override
            public int getSize() {
                return 0;
            }

            @Override
            public Object getElementAt(int i) {
                return "No Data Model";
            }
        });
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    @Override
    public void setSelectedIndices(int[] indices) {
        ListSelectionModel sm = this.getSelectionModel();
        sm.clearSelection();
        for (int i = 0; i < indices.length; ++i) {
            sm.setSelectionInterval(indices[i], indices[i]);
        }
    }

    public void setBorderPaintedFlat(boolean b) {
        ListCellRenderer cellRend = this.getCellRenderer();
        if (cellRend instanceof CheckBoxListCellRenderer) {
            ((CheckBoxListCellRenderer)cellRend).setBorderPaintedFlat(b);
        }
    }

    public boolean isBorderPaintedFlat() {
        ListCellRenderer cellRend = this.getCellRenderer();
        if (cellRend instanceof CheckBoxListCellRenderer) {
            return ((CheckBoxListCellRenderer)cellRend).isBorderPaintedFlat();
        }
        return false;
    }
}

