/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;

@SASScope
public class ButtonBorderRollOverHandler
extends MouseAdapter
implements FocusListener {
    private List buttonList;

    public ButtonBorderRollOverHandler() {
    }

    public ButtonBorderRollOverHandler(AbstractButton button) {
        this.addButton(button);
    }

    public boolean addButton(AbstractButton button) {
        if (this.buttonList == null) {
            this.buttonList = new ArrayList();
        }
        if (!this.buttonList.contains(button)) {
            button.setContentAreaFilled(false);
            button.setBorderPainted(false);
            button.addMouseListener(this);
            button.addFocusListener(this);
            this.buttonList.add(button);
            return true;
        }
        return false;
    }

    public boolean removeButton(AbstractButton button) {
        if (this.buttonList == null) {
            return false;
        }
        if (this.buttonList.contains(button)) {
            button.removeMouseListener(this);
            button.removeFocusListener(this);
            this.buttonList.remove(button);
            return true;
        }
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            this.updateButtonBorder((AbstractButton)e.getSource(), true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            this.updateButtonBorder((AbstractButton)e.getSource(), false);
        }
    }

    private void updateButtonBorder(AbstractButton button, boolean mouseOver) {
        if (button.hasFocus() || mouseOver) {
            button.setBorderPainted(true);
            button.setContentAreaFilled(true);
        } else {
            button.setBorderPainted(false);
            button.setContentAreaFilled(false);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            this.updateButtonBorder((AbstractButton)e.getSource(), false);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            this.updateButtonBorder((AbstractButton)e.getSource(), false);
        }
    }
}

