/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.util;

import com.sas.codepolicy.SASScope;
import com.sas.swing.util.RB;
import com.sas.swing.util.protocol.sas.doc.jh.Handler;
import com.sas.text.Message;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.FlatMap;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.WindowPresentation;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

@SASScope(value="ALL")
public class SASJavaHelp {
    public static final String RB_KEY = "SASJavaHelp.";
    private String docProduct;
    private HelpSet helpSet;
    private Map.ID homeID;
    private String helpSetPath;
    private URL helpSetURL;
    private Locale locale;
    private DefaultHelpBroker curDefaultHelpBroker;
    private Window actWindow;
    private Point location;
    private Dimension size;
    private ClassLoader defaultClassLoader;
    private static ClassLoader s_applicationDefaultClassLoader = null;
    private LoggerFactoryInterface logFactory;
    private CommonLoggerInterface logger;
    private boolean viewDisplayed = true;
    private static final MessageFormat PATH_FORMAT = new MessageFormat("doc/{0}/{1}/config/{1}.hs");
    private static final String SLASH = "/";
    private static final String TOPICSDIR = "html";
    private static final String FILESDIR = "config";
    private static final String HTMLEXT = ".html";
    private static final String HTMEXT = ".htm";
    private static final String DEFAULT_PRESENTATION = "mainwindow";

    public SASJavaHelp() {
        this(null);
    }

    public SASJavaHelp(String docProduct) {
        this(docProduct, Locale.getDefault());
    }

    public SASJavaHelp(String docProduct, Locale appLocale) {
        this(docProduct, appLocale, null);
    }

    @SASScope
    public SASJavaHelp(String docProduct, Locale appLocale, LoggerFactoryInterface logFactory) {
        this(docProduct, appLocale, logFactory, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    SASJavaHelp(String docProduct, Locale appLocale, LoggerFactoryInterface logFactory, boolean registerHandler) {
        if (registerHandler) {
            Handler.register();
        } else {
            Class<System> clazz = System.class;
            // MONITORENTER : java.lang.System.class
            String handlerPackages = System.getProperty("java.protocol.handler.pkgs");
            if (handlerPackages == null) {
                handlerPackages = "com.sas.swing.util.protocol";
            } else {
                Object[] packages = handlerPackages.split("\\|");
                Arrays.sort(packages);
                if (Arrays.binarySearch(packages, "com.sas.swing.util.protocol") < 0) {
                    handlerPackages = handlerPackages + "|com.sas.swing.util.protocol";
                }
            }
            System.setProperty("java.protocol.handler.pkgs", handlerPackages);
            // MONITOREXIT : clazz
        }
        this.docProduct = docProduct;
        this.logFactory = logFactory;
        this.initVariables();
        this.setLocale(appLocale);
    }

    private void initVariables() {
        this.helpSet = null;
        this.helpSetPath = null;
        this.helpSetURL = null;
        this.actWindow = null;
        this.location = null;
        this.size = null;
        this.defaultClassLoader = null;
        this.curDefaultHelpBroker = new DefaultHelpBroker();
        this.logger = LoggerRepository2.getLogger((String)SASJavaHelp.class.getName(), (LoggerFactoryInterface)this.logFactory);
    }

    private List buildDocLookupPaths(Locale locale, String docProdName) {
        ArrayList<String> paths = new ArrayList<String>(4);
        String localeString = locale.toString();
        Object[] formatArgs = new Object[2];
        formatArgs[1] = docProdName.toLowerCase();
        if (locale.getVariant() != "") {
            formatArgs[0] = localeString;
            paths.add(PATH_FORMAT.format(formatArgs));
        }
        if (locale.getCountry() != "") {
            formatArgs[0] = localeString.substring(0, 5);
            paths.add(PATH_FORMAT.format(formatArgs));
        }
        formatArgs[0] = locale.getLanguage();
        paths.add(PATH_FORMAT.format(formatArgs));
        if (!locale.getLanguage().equals("en")) {
            formatArgs[0] = "en";
            paths.add(PATH_FORMAT.format(formatArgs));
        }
        return paths;
    }

    public void showHelp(String docProd, String file) {
        HelpSet curHS = this.curDefaultHelpBroker.getHelpSet();
        HelpSet hs = this.getHelpSet(docProd);
        if (hs != null) {
            block10: {
                if (curHS == null || !curHS.getHelpSetURL().getPath().equalsIgnoreCase(hs.getHelpSetURL().getPath())) {
                    this.curDefaultHelpBroker.setHelpSet(hs);
                    this.curDefaultHelpBroker.setHelpSetPresentation(hs.getPresentation(DEFAULT_PRESENTATION));
                }
                if (file != null) {
                    URL fileURL = this.getFileURL(file);
                    if (fileURL != null) {
                        try {
                            URL mapURL = this.getFileURL(null);
                            FlatMap flat = new FlatMap(mapURL, hs);
                            Map.ID id = flat.getIDFromURL(fileURL);
                            if (id.id != null && !id.id.equals(this.getHomeID().id)) {
                                this.curDefaultHelpBroker.setCurrentURL(fileURL);
                                break block10;
                            }
                            this.findID(curHS, hs);
                        }
                        catch (Exception e) {
                            this.logger.info(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"fileNotFound.fmt.txt"), (Object)file));
                            this.findID(curHS, hs);
                        }
                    } else {
                        this.findID(curHS, hs);
                    }
                } else {
                    this.findID(curHS, hs);
                }
            }
            this.displayHelpBrowser(true);
        } else {
            this.logger.warn(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"helpFailed.fmt.txt"), (Object)"showHelp"));
        }
    }

    public void showHelp(String file) {
        String product = this.getDocProduct();
        if (product != null) {
            this.showHelp(product, file);
        } else {
            this.logger.warn(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"doesNotExist.fmt.txt"), (Object)"docProduct"));
        }
    }

    public void showContext(String docProd, String mapID) {
        HelpSet curHS = this.curDefaultHelpBroker.getHelpSet();
        HelpSet hs = this.getHelpSet(docProd);
        if (hs != null) {
            if (curHS == null || !curHS.getHelpSetURL().getPath().equalsIgnoreCase(hs.getHelpSetURL().getPath())) {
                this.curDefaultHelpBroker.setHelpSet(hs);
                this.curDefaultHelpBroker.setHelpSetPresentation(hs.getPresentation(DEFAULT_PRESENTATION));
            }
            if (mapID != null && !mapID.equals(this.getHomeID().id)) {
                try {
                    this.curDefaultHelpBroker.setCurrentID(mapID);
                }
                catch (BadIDException e) {
                    this.logger.info(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"mapDoesNotExist.fmt.txt"), (Object)mapID));
                    this.findID(curHS, hs);
                }
            } else {
                this.findID(curHS, hs);
            }
            this.displayHelpBrowser(true);
        } else {
            this.logger.warn(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"helpFailed.fmt.txt"), (Object)"showContext"));
        }
    }

    public void showContext(String mapID) {
        String product = this.getDocProduct();
        if (product != null) {
            this.showContext(product, mapID);
        } else {
            this.logger.warn(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"doesNotExist.fmt.txt"), (Object)"docProduct"));
        }
    }

    private void findID(HelpSet currentHelpSet, HelpSet newHelpSet) {
        if (currentHelpSet == null || currentHelpSet.getHelpSetURL().getPath().equalsIgnoreCase(newHelpSet.getHelpSetURL().getPath())) {
            this.curDefaultHelpBroker.setCurrentID(this.getHomeID().id);
        } else {
            this.findSuitableTOCItem(newHelpSet);
        }
    }

    private void findSuitableTOCItem(HelpSet hs) {
        NavigatorView[] views = new NavigatorView[5];
        views = hs.getNavigatorViews();
        block2: for (int i = 0; i < views.length; ++i) {
            if (views[i] instanceof TOCView) {
                DefaultMutableTreeNode one = ((TOCView)views[i]).getDataAsTree();
                if (one != null) {
                    Enumeration<TreeNode> nodes = one.preorderEnumeration();
                    while (nodes.hasMoreElements()) {
                        Map.ID id;
                        DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)nodes.nextElement();
                        TOCItem tocItem = (TOCItem)nextNode.getUserObject();
                        if (tocItem == null || (id = tocItem.getID()) == null || id.id.equals(this.getHomeID().id)) continue;
                        this.curDefaultHelpBroker.setCurrentID(id.id);
                        break block2;
                    }
                    break;
                }
                this.logger.debug(RB.getStringResource((String)RB_KEY, (String)"noItemsinTOC.txt"));
                break;
            }
            if (i != views.length - 1) continue;
            this.logger.debug(RB.getStringResource((String)RB_KEY, (String)"tocDoesNotExist.txt"));
            URL mapURL = this.getFileURL(null);
            if (mapURL != null) {
                try {
                    FlatMap flat = new FlatMap(mapURL, hs);
                    Enumeration ids = flat.getAllIDs();
                    while (ids.hasMoreElements()) {
                        Map.ID id = (Map.ID)ids.nextElement();
                        if (id == null || id.id.equals(this.getHomeID().id)) continue;
                        this.curDefaultHelpBroker.setCurrentID(id.id);
                    }
                }
                catch (Exception e) {
                    this.logger.info(RB.getStringResource((String)RB_KEY, (String)"flatMapError.txt"));
                }
                continue;
            }
            this.logger.info(RB.getStringResource((String)RB_KEY, (String)"mapFileDoesNotExist.txt"));
        }
    }

    private URL getFileURL(String file) {
        URL url = null;
        String HSPath = this.getHelpSetPath();
        if (HSPath != null) {
            URLConnection checkURL = null;
            StringBuffer newPath = new StringBuffer();
            int index = HSPath.lastIndexOf(FILESDIR);
            if (index != -1) {
                if (file != null && file.length() > 0) {
                    newPath.append(HSPath.substring(0, index) + TOPICSDIR + SLASH + file + HTMLEXT);
                } else {
                    newPath.append(HSPath.substring(0, index + 7) + "map.jhm");
                }
                try {
                    url = new URL(newPath.toString());
                    checkURL = url.openConnection();
                    checkURL.connect();
                }
                catch (Exception e) {
                    if (file != null && file.length() > 0) {
                        newPath.delete(newPath.indexOf(TOPICSDIR) + 5, newPath.length());
                        newPath.append(file + HTMEXT);
                    }
                    return null;
                }
                try {
                    url = new URL(newPath.toString());
                    checkURL = url.openConnection();
                    checkURL.connect();
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
        return url;
    }

    private void displayHelpBrowser(boolean display) {
        if (display) {
            if (this.getActivationWindow() != null) {
                WindowPresentation presentation = this.curDefaultHelpBroker.getWindowPresentation();
                Window helpWindow = presentation.getHelpWindow();
                Window activationWindow = this.getActivationWindow();
                if (helpWindow != null && helpWindow instanceof Frame && helpWindow.isVisible() && presentation.getActivationWindow() != activationWindow && activationWindow instanceof Dialog && ((Dialog)activationWindow).isModal()) {
                    helpWindow.setVisible(false);
                }
                this.curDefaultHelpBroker.setActivationWindow(activationWindow);
            }
            if (this.getSize() != null) {
                this.curDefaultHelpBroker.setSize(this.getSize());
            }
            if (this.getLocation() != null) {
                this.curDefaultHelpBroker.setLocation(this.getLocation());
            }
            this.curDefaultHelpBroker.setViewDisplayed(this.isViewDisplayed());
        }
        this.curDefaultHelpBroker.setDisplayed(display);
    }

    public void getHelpInfo() {
        this.printHelpInfo(null);
    }

    @SASScope
    public void printHelpInfo(PrintStream stream) {
        if (stream == null) {
            stream = new PrintStream(System.out, true);
        }
        stream.println("");
        stream.println(RB.getStringResource((String)RB_KEY, (String)"helpInformation.txt"));
        stream.println("docProduct: " + this.docProduct);
        stream.println("helpSet: " + this.helpSet);
        stream.println("helpSetPath: " + this.helpSetPath);
        stream.println("helpSetURL: " + this.helpSetURL);
        stream.println("locale: " + this.locale);
        stream.println("curDefaultHelpBroker: " + this.curDefaultHelpBroker);
        stream.println("activation window: " + this.actWindow);
        stream.println("size: " + this.size);
        stream.println("defaultClassLoader: " + this.defaultClassLoader);
        stream.println("location: " + this.location);
        stream.println("");
    }

    public void enableHelpKey(Component comp, String docProd, final String id) throws IllegalArgumentException {
        if (comp == null) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"componentNull.fmt.txt"), (Object)"enableHelpKey"));
        }
        HelpSet hs = this.getHelpSet(docProd);
        if (hs != null) {
            final String currDocProd = this.getDocProduct();
            final ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SASJavaHelp.this.showContext(currDocProd, id);
                }
            };
            KeyListener key = new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    int code = e.getKeyCode();
                    if (code == 112 || code == 156) {
                        ActionListener al = action;
                        al.actionPerformed(new ActionEvent(e.getComponent(), 1001, null));
                    }
                }
            };
            CSH.setHelpIDString((Component)comp, (String)id);
            if (hs != null) {
                CSH.setHelpSet((Component)comp, (HelpSet)hs);
            }
            if (comp instanceof JComponent) {
                JComponent root = (JComponent)comp;
                root.registerKeyboardAction(action, KeyStroke.getKeyStroke(156, 0), 1);
                root.registerKeyboardAction(action, KeyStroke.getKeyStroke(112, 0), 1);
            } else {
                comp.addKeyListener(key);
            }
        } else {
            this.logger.warn(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"helpSetFailed.fmt.txt"), (Object)"enableHelpKey"));
        }
    }

    public void enableContextOnClick(Component comp, final String docProd, final String id) throws IllegalArgumentException {
        if (comp == null) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"componentNull.fmt.txt"), (Object)"enableContextOnClick"));
        }
        if (!(comp instanceof JButton) && !(comp instanceof JMenuItem)) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"wrongComponentType.fmt.txt"), (Object)"JButton", (Object)"JMenuItem"));
        }
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SASJavaHelp.this.showContext(docProd, id);
            }
        };
        if (comp instanceof JButton) {
            ((JButton)comp).addActionListener(l);
        } else if (comp instanceof JMenuItem) {
            ((JMenuItem)comp).addActionListener(l);
        }
    }

    public void enableHelpOnClick(Component comp, final String docProd, final String file) throws IllegalArgumentException {
        if (comp == null) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"componentNull.fmt.txt"), (Object)"enableHelpOnClick"));
        }
        if (!(comp instanceof JButton) && !(comp instanceof JMenuItem)) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"wrongComponentType.fmt.txt"), (Object)"JButton", (Object)"JMenuItem"));
        }
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SASJavaHelp.this.showHelp(docProd, file);
            }
        };
        if (comp instanceof JButton) {
            ((JButton)comp).addActionListener(l);
        } else if (comp instanceof JMenuItem) {
            ((JMenuItem)comp).addActionListener(l);
        }
    }

    public void setHelpSet(HelpSet hs) {
        if (hs != null) {
            this.helpSet = hs;
        }
    }

    public HelpSet getHelpSet() {
        return this.helpSet;
    }

    public HelpSet getHelpSet(String docProd) {
        HelpSet currHelpSet = this.getHelpSet();
        String currDocProd = this.getDocProduct();
        String newDocProd = null;
        HelpSet newHelpSet = null;
        if ((docProd == null || docProd.equals(currDocProd)) && currHelpSet != null) {
            if (currDocProd == null) {
                this.logger.info(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"notSet.fmt.txt"), (Object)"docProduct", (Object)"HelpSet"));
                return null;
            }
            newHelpSet = this.getHelpSet();
        } else {
            newDocProd = docProd == null ? currDocProd : docProd;
            if (newDocProd.indexOf(".hs") != -1) {
                newDocProd = new String(newDocProd.substring(0, newDocProd.lastIndexOf(".hs")));
            }
            if (this.getLocale().getLanguage() == null || this.getLocale().getLanguage().length() == 0) {
                this.setLocale(new Locale("en"));
            }
            URL url = null;
            String path2 = null;
            for (String path2 : this.buildDocLookupPaths(this.getLocale(), newDocProd)) {
                url = HelpSet.findHelpSet((ClassLoader)this.getDefaultClassLoader(), (String)path2);
                if (url != null) {
                    this.logger.info(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"pathValid.fmt.txt"), (Object)path2, (Object)newDocProd));
                    break;
                }
                this.logger.info(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"pathInvalid.fmt.txt"), (Object)path2));
            }
            if (url != null) {
                try {
                    newHelpSet = new HelpSet(this.getDefaultClassLoader(), url);
                    this.homeID = newHelpSet.getHomeID();
                    if (this.homeID == null || this.homeID.equals((Object)"")) {
                        this.logger.warn(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"homeIDMissing.fmt.txt"), (Object)newDocProd));
                        return null;
                    }
                    this.setDocProduct(newDocProd);
                    this.setHelpSet(newHelpSet);
                    this.setHelpSetURL(url);
                    this.setHelpSetPath(url.toExternalForm());
                    this.logger.info(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"successfulHelpSet.fmt.txt"), (Object)newDocProd));
                }
                catch (HelpSetException hse) {
                    this.logger.warn(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"parseProblems.fmt.txt"), (Object)newDocProd));
                    this.logger.error(hse.getMessage(), (Throwable)hse);
                    return null;
                }
                catch (Exception e) {
                    this.logger.warn(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"helpForError.fmt.txt"), (Object)newDocProd, (Object)path2));
                    this.logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            } else {
                this.logger.warn(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"pathNotEstablished.fmt.txt"), (Object)newDocProd));
                return null;
            }
        }
        return newHelpSet;
    }

    private Map.ID getHomeID() {
        return this.homeID;
    }

    private void setHelpSetPath(String path) {
        if (path != null) {
            this.helpSetPath = path;
        }
    }

    private String getHelpSetPath() {
        return this.helpSetPath;
    }

    public void setLocale(Locale loc) {
        if (loc != null) {
            this.locale = (Locale)loc.clone();
            this.curDefaultHelpBroker.setLocale((Locale)loc.clone());
        }
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return (Locale)this.locale.clone();
        }
        return null;
    }

    private void setHelpSetURL(URL url) {
        if (url != null) {
            this.helpSetURL = url;
        }
    }

    private URL getHelpSetURL() {
        return this.helpSetURL;
    }

    public void setDefaultHelpBroker(DefaultHelpBroker broker) {
        if (broker != null) {
            this.curDefaultHelpBroker = broker;
        }
    }

    public DefaultHelpBroker getDefaultHelpBroker() {
        return this.curDefaultHelpBroker;
    }

    public void setDocProduct(String docProductName) {
        if (docProductName != null) {
            this.docProduct = docProductName;
        }
    }

    public String getDocProduct() {
        return this.docProduct;
    }

    public void setActivationWindow(Window window) {
        if (window != null) {
            this.actWindow = window;
        }
    }

    public Window getActivationWindow() {
        return this.actWindow;
    }

    public void setLocation(Point point) {
        if (point != null) {
            this.location = (Point)point.clone();
        }
    }

    public Point getLocation() {
        if (this.location != null) {
            return (Point)this.location.clone();
        }
        return null;
    }

    public void setSize(Dimension dim) {
        if (dim != null) {
            this.size = (Dimension)dim.clone();
        }
    }

    public Dimension getSize() {
        if (this.size != null) {
            return (Dimension)this.size.clone();
        }
        return null;
    }

    @SASScope
    public static void setApplicationDefaultClassLoader(ClassLoader loader) {
        s_applicationDefaultClassLoader = loader;
        Handler.setDefaultClassLoader(s_applicationDefaultClassLoader);
    }

    @SASScope
    public void setDefaultClassLoader(ClassLoader loader) {
        this.defaultClassLoader = loader;
        Handler.setDefaultClassLoader(this.defaultClassLoader);
    }

    @SASScope
    public ClassLoader getDefaultClassLoader() {
        if (this.defaultClassLoader == null && s_applicationDefaultClassLoader != null) {
            return s_applicationDefaultClassLoader;
        }
        return this.defaultClassLoader;
    }

    @SASScope
    public void setLoggerFactory(LoggerFactoryInterface logFactory) {
        this.logFactory = logFactory;
        this.logger = LoggerRepository2.getLogger((String)SASJavaHelp.class.getName(), (LoggerFactoryInterface)logFactory);
    }

    @SASScope
    public void setViewDisplayed(boolean display) {
        this.viewDisplayed = display;
    }

    @SASScope
    public boolean isViewDisplayed() {
        return this.viewDisplayed;
    }
}

