/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.beans.PropertyChangeSource;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class TransformingListModel
extends AbstractListModel
implements ListDataListener,
PropertyChangeSource {
    protected PropertyChangeSupport propertyChangeSupport;
    protected ListModel model;
    protected TransformInterface transform;

    public TransformingListModel() {
        this.setModel(this.newDefaultModel());
    }

    public TransformingListModel(ListModel model) {
        this.setModel(model);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(evt);
        }
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propName, oldValue, newValue);
        }
    }

    protected ListModel newDefaultModel() {
        return new DefaultListModel();
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setModel(ListModel newModel) {
        if (newModel == null) {
            newModel = this.newDefaultModel();
        }
        if (this.model != newModel) {
            ListModel oldModel = this.model;
            if (this.model != null) {
                this.model.removeListDataListener(this);
            }
            this.model = newModel;
            this.model.addListDataListener(this);
            this.contentsChanged(new ListDataEvent(this, 0, -1, -1));
            this.firePropertyChange("model", oldModel, this.model);
        }
    }

    public TransformInterface getTransform() {
        return this.transform;
    }

    public void setTransform(TransformInterface newTransform) {
        if (this.transform != newTransform) {
            TransformInterface oldTransform = this.transform;
            this.transform = newTransform;
            this.contentsChanged(new ListDataEvent(this, 0, -1, -1));
            this.firePropertyChange("transform", oldTransform, this.transform);
        }
    }

    @Override
    public Object getElementAt(int index) {
        Object element = this.getModel().getElementAt(index);
        try {
            if (this.transform != null) {
                element = this.transform.transform(element);
            }
        }
        catch (TransformException e) {
            e.printStackTrace();
        }
        return element;
    }

    @Override
    public int getSize() {
        return this.getModel().getSize();
    }

    @Override
    public void intervalAdded(ListDataEvent event) {
        this.fireIntervalAdded(this, event.getIndex0(), event.getIndex1());
    }

    @Override
    public void intervalRemoved(ListDataEvent event) {
        this.fireIntervalRemoved(this, event.getIndex0(), event.getIndex1());
    }

    @Override
    public void contentsChanged(ListDataEvent event) {
        this.fireContentsChanged(this, event.getIndex0(), event.getIndex1());
    }
}

