/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.dataselectors.LabeledStringValueInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.swing.models.RB;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

@SASScope(value="ALL")
@SubjectToChange
public class OLAPMemberTreeNode
extends DefaultMutableTreeNode
implements LabeledStringValueInterface {
    public static final String RB_KEY = "OLAPMemberTreeNode.";
    private Object value;
    private String label;

    OLAPMemberTreeNode() {
    }

    public OLAPMemberTreeNode(Object userObject) {
        super(userObject);
    }

    public OLAPMemberTreeNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public OLAPMemberTreeNode(OLAPDataSetInterface model) throws OLAPException {
        super(model);
        if (model != null) {
            this.setLabel(model.getCubeName());
            this.setValue(model);
        }
    }

    public OLAPMemberTreeNode(TupleElementInterface element) throws OLAPException {
        super(element);
        if (element != null) {
            this.setLabel(element.getLabel());
            this.setValue(element);
        }
    }

    public OLAPMemberTreeNode(AxisInterface axis) throws OLAPException {
        super(axis);
        if (axis != null) {
            if (axis.getAxisNumber() == 1) {
                this.setLabel(RB.getStringResource(RB_KEY, "rows.txt"));
            } else if (axis.getAxisNumber() == 0) {
                this.setLabel(RB.getStringResource(RB_KEY, "columns.txt"));
            } else if (axis.getAxisNumber() == -1) {
                this.setLabel(RB.getStringResource(RB_KEY, "slicers.txt"));
            } else if (axis.getAxisNumber() == 2) {
                this.setLabel(RB.getStringResource(RB_KEY, "pages.txt"));
            } else if (axis.getAxisNumber() == 4) {
                this.setLabel(RB.getStringResource(RB_KEY, "chapters.txt"));
            } else if (axis.getAxisNumber() == 3) {
                this.setLabel(RB.getStringResource(RB_KEY, "sections.txt"));
            }
            this.setValue(axis);
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getValue() {
        return this.value == null ? null : this.value.toString();
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public static int getChildCount(TupleElementInterface element) {
        int childCount = 0;
        try {
            if (element != null) {
                int min = element.getMinimumCoordinate();
                int max = element.getMaximumCoordinate();
                TupleInterface[] tuples = element.getTuple().getAxis().getTuples(min, max - min + 1);
                TupleElementInterface[] elements = element.getTuple().getElements(0, element.getTupleElementIndex() + 1);
                int level = 0;
                for (int i = 0; i < elements.length; ++i) {
                    level += elements[i].getSpan();
                }
                elements = OLAPMemberTreeNode.getTupleElementsForLevel(level, tuples, false, -1);
                childCount = elements.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return childCount;
    }

    static TupleElementInterface[] getTupleElementsForLevel(int level, TupleInterface[] tuples, boolean includeDuplicates, int count) throws OLAPException {
        int nTuples = tuples.length;
        ArrayList<TupleElementInterface> elements = new ArrayList<TupleElementInterface>(nTuples);
        TupleElementInterface[] tupleElements = new TupleElementInterface[nTuples];
        ArrayList<String> elemNames = new ArrayList<String>(nTuples);
        if (level == 0) {
            if (count != -1 && count < nTuples) {
                nTuples = count;
            }
            for (int i = 0; i < nTuples; ++i) {
                TupleElementInterface tElement = tuples[i].getElements(0, 1)[0];
                if (!includeDuplicates && (includeDuplicates || elemNames.contains(tElement.getName()))) continue;
                elements.add(tElement);
                elemNames.add(tElement.getName());
            }
            tupleElements = new TupleElementInterface[elements.size()];
            System.arraycopy(elements.toArray(), 0, tupleElements, 0, elements.size());
            return tupleElements;
        }
        int currentCount = count == -1 ? nTuples * -1 : 0;
        block1: for (int i = 0; i < nTuples; ++i) {
            tupleElements = tuples[i].getElements(0, -1);
            int nElements = tupleElements.length;
            int relativeIndex = 0;
            for (int index = 0; index < nElements - 1 && currentCount <= count; ++index) {
                if ((relativeIndex += tupleElements[index].getSpan()) == level) {
                    Object tupleElement = null;
                    if (includeDuplicates || !includeDuplicates && !elemNames.contains(tupleElements[index + 1].getName())) {
                        elements.add(tupleElements[index + 1]);
                        elemNames.add(tupleElements[index + 1].getName());
                    }
                    ++currentCount;
                    continue block1;
                }
                if (relativeIndex > level) continue block1;
            }
        }
        tupleElements = new TupleElementInterface[elements.size()];
        System.arraycopy(elements.toArray(new TupleElementInterface[0]), 0, tupleElements, 0, elements.size());
        return tupleElements;
    }
}

