/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import com.sas.util.Util;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.AbstractTableModel;

public class MapToTableModelAdapter
extends AbstractTableModel
implements PropertyChangeSource {
    protected List keys;
    protected List values;
    protected Map model;
    protected String[] columnNames;
    protected boolean tableEditable;
    protected SwingPropertyChangeSupport spcs;

    public MapToTableModelAdapter() {
        this.keys = new ArrayList();
        this.values = new ArrayList();
        this.spcs = new SwingPropertyChangeSupport(this);
        this.columnNames = new String[2];
    }

    public MapToTableModelAdapter(int size) {
        this.keys = new ArrayList(size);
        this.values = new ArrayList(size);
        this.spcs = new SwingPropertyChangeSupport(this);
        this.columnNames = new String[2];
    }

    public MapToTableModelAdapter(Map m) {
        this.model = m;
        this.createDelegate();
        this.spcs = new SwingPropertyChangeSupport(this);
        this.columnNames = new String[2];
    }

    @Override
    public int getRowCount() {
        return this.keys.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.keys.get(rowIndex);
        }
        if (columnIndex == 1) {
            return this.values.get(rowIndex);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object key = this.keys.get(rowIndex);
        Object oldValue = this.values.get(rowIndex);
        if (Util.unequal(oldValue, (Object)aValue)) {
            this.model.put(key, aValue);
            this.values.set(rowIndex, aValue);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isTableEditable() && columnIndex == 1;
    }

    public void setModel(Map model) {
        Map oldModel = this.model;
        if (oldModel != model) {
            this.model = model;
            this.refresh();
            this.spcs.firePropertyChange("model", oldModel, model);
        }
    }

    public Map getModel() {
        return this.model;
    }

    public void setColumnName(String columnName, int columnIndex) {
        String oldColumnName = this.columnNames[columnIndex];
        if (Util.unequal((Object)oldColumnName, (Object)columnName)) {
            this.columnNames[columnIndex] = columnName;
            this.fireTableStructureChanged();
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        String columnName = this.columnNames[columnIndex];
        if (columnName == null) {
            return super.getColumnName(columnIndex);
        }
        return columnName;
    }

    public boolean isTableEditable() {
        return this.tableEditable;
    }

    public void setTableEditable(boolean editable) {
        if (this.tableEditable != editable) {
            this.tableEditable = editable;
            this.spcs.firePropertyChange("tableEditable", !editable, editable);
        }
    }

    protected void createDelegate() {
        this.keys = new ArrayList(this.model.keySet());
        this.values = new ArrayList(this.model.values());
    }

    public void refresh() {
        this.createDelegate();
        this.fireTableDataChanged();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }
}

