/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import com.sas.beans.Util;
import com.sas.util.Enumerable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class ListModelPropertyChangeAdapter
extends AbstractListModel
implements PropertyChangeListener,
ComboBoxModel,
PropertyChangeSource {
    protected Object selectedObject;
    protected Object source;
    protected String property;
    protected List sourceList;
    protected PropertyChangeSupport propertyChangeSupport;
    protected static List emptyList = new ArrayList();

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        String[][][] propertyMetadata = new String[][][]{{{"Name", "source"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}, {{"Name", "elementAt"}, {"Hidden", "true"}}};
        ebi.defaultInputPropertyName = "source";
        ebi.defaultOutputPropertyName = "source";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public ListModelPropertyChangeAdapter() {
        this.sourceList = emptyList;
    }

    public ListModelPropertyChangeAdapter(Object sourceObject, String propertyName) {
        this.setPropertySource(sourceObject, propertyName);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(evt);
        }
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propName, oldValue, newValue);
        }
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object sourceObject) {
        this.setPropertySource(sourceObject, this.getPropertyName());
    }

    public String getPropertyName() {
        return this.property;
    }

    public void setPropertyName(String propertyName) {
        this.setPropertySource(this.getSource(), propertyName);
    }

    public void setPropertySource(Object sourceObject, String propertyName) {
        if (this.source != null) {
            Util.removePropertyChangeListener((Object)this.source, (PropertyChangeListener)this);
        }
        Object oldSource = this.source;
        String oldProperty = this.property;
        this.source = sourceObject;
        this.property = propertyName;
        if (oldSource != this.source) {
            this.firePropertyChange("source", oldSource, this.source);
        }
        if (oldProperty != this.property) {
            this.firePropertyChange("property", oldProperty, this.property);
        }
        if (this.source != null) {
            Util.addPropertyChangeListener((Object)this.source, (PropertyChangeListener)this);
        }
        this.updateSourceList();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object eSource = evt.getSource();
        String propName = evt.getPropertyName();
        if (eSource == this.source && propName != null && propName.equals(this.property)) {
            this.updateSourceList();
        }
    }

    protected void updateSourceList() {
        if (this.source == null || this.property == null) {
            this.sourceList = emptyList;
        } else {
            Object propertyValue = Util.getPropertyValue((Object)this.source, (String)this.property);
            if (propertyValue == null) {
                this.sourceList = emptyList;
            } else if (propertyValue.getClass().isArray()) {
                this.sourceList = Arrays.asList((Object[])propertyValue);
            } else if (propertyValue instanceof List) {
                this.sourceList = (List)propertyValue;
            } else if (propertyValue instanceof Enumerable) {
                this.sourceList = new ArrayList();
                Enumeration valueEnum = ((Enumerable)propertyValue).getItems();
                while (valueEnum.hasMoreElements()) {
                    this.sourceList.add(valueEnum.nextElement());
                }
            } else {
                this.sourceList = emptyList;
            }
        }
        if (!this.sourceList.contains(this.selectedObject)) {
            this.selectedObject = this.getSize() > 0 ? this.getElementAt(0) : null;
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    @Override
    public int getSize() {
        return this.sourceList.size();
    }

    @Override
    public Object getElementAt(int i) {
        return this.sourceList.get(i);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item != this.selectedObject) {
            Object oldItem = this.selectedObject;
            this.selectedObject = item;
            this.firePropertyChange("selectedItem", oldItem, this.selectedObject);
        }
    }
}

