/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.codepolicy.SASScope;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.util.Util;
import java.util.Collection;
import javax.swing.MutableComboBoxModel;

@SASScope(value="ALL")
public class CollectionToComboBoxModelAdapter
extends CollectionToListModelAdapter
implements MutableComboBoxModel {
    protected Object selectedItem;

    public CollectionToComboBoxModelAdapter() {
    }

    public CollectionToComboBoxModelAdapter(int size) {
        super(size);
    }

    public CollectionToComboBoxModelAdapter(Collection c) {
        super(c);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object item) {
        Object oldSelectedItem = this.selectedItem;
        if (Util.unequal((Object)oldSelectedItem, (Object)item)) {
            this.selectedItem = item;
            this.fireContentsChanged(this, -1, -1);
            this.spcs.firePropertyChange("selectedItem", oldSelectedItem, item);
        }
    }

    @SASScope
    public void addElement(Object obj) {
        this.delegate.add(obj);
        int size = this.getSize();
        this.fireIntervalAdded(this, size - 1, size - 1);
    }

    @SASScope
    public void insertElementAt(Object obj, int index) {
        this.delegate.add(index, obj);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    @SASScope
    public void removeElement(Object obj) {
        this.delegate.remove(obj);
        int size = this.getSize();
        this.fireIntervalRemoved(this, size, size);
    }

    @Override
    @SASScope
    public void removeElementAt(int index) {
        this.delegate.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }
}

