/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.adapters;

import com.sas.codepolicy.SASScope;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

@SASScope
public class ViewAction
extends AbstractAction {
    protected JTable table;
    protected TableColumn viewColumn;
    protected int prevPos;

    public ViewAction(JTable table, TableColumn column, String name) {
        this.table = table;
        this.viewColumn = column;
        this.prevPos = -1;
        this.putValue("ActionCommandKey", this.viewColumn.getIdentifier());
        this.putValue("Name", name);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object eSource = evt.getSource();
        if (eSource instanceof AbstractButton) {
            String actionCmd = (String)this.getValue("ActionCommandKey");
            boolean selected = ((AbstractButton)eSource).isSelected();
            this.showColumn(selected);
        }
    }

    public static int getColumnIndex(TableColumnModel columnModel, TableColumn column) {
        Enumeration<TableColumn> columnEnum = columnModel.getColumns();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn modelColumn = columnModel.getColumn(i);
            if (modelColumn != column) continue;
            return i;
        }
        return -1;
    }

    public void showColumn(boolean show) {
        TableColumnModel columnModel = this.table.getColumnModel();
        int colCount = columnModel.getColumnCount();
        int colIndex = ViewAction.getColumnIndex(columnModel, this.viewColumn);
        if (!show) {
            if (colIndex != -1) {
                this.prevPos = colIndex;
            }
            columnModel.removeColumn(this.viewColumn);
        } else if (colIndex == -1) {
            columnModel.addColumn(this.viewColumn);
            if (this.prevPos != -1 && this.prevPos < colCount) {
                columnModel.moveColumn(colCount, this.prevPos);
            }
        }
    }
}

