/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.security.PermissionCombiner;
import com.sas.security.SecuritySupport;
import com.sas.visuals.image.ImageException;
import com.sas.visuals.image.ImageProvider;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;

@SASScope(value="ALL")
@SubjectToChange
class JDK_1_2_SecuritySupport
extends SecuritySupport {
    JDK_1_2_SecuritySupport() {
    }

    @Override
    public Image getImage(final Object src) throws IOException, ImageException {
        try {
            return (Image)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, ImageException {
                    ImageProvider imgProvider = null;
                    if (src instanceof URL) {
                        imgProvider = new ImageProvider((URL)src);
                    } else if (src instanceof InputStream) {
                        imgProvider = new ImageProvider((InputStream)src);
                    } else if (src instanceof String) {
                        imgProvider = new ImageProvider((String)src);
                    }
                    if (imgProvider != null) {
                        return imgProvider.getImage();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof IOException) {
                throw (IOException)pae.getException();
            }
            if (pae.getException() instanceof ImageException) {
                throw (ImageException)pae.getException();
            }
            return null;
        }
    }

    public InputStream getResourceAsStream(final Class aClass, final String resourceName) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return aClass.getResourceAsStream(resourceName);
            }
        });
    }

    public URL getResource(final Class aClass, final String resourceName) {
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return aClass.getResource(resourceName);
            }
        });
    }

    public Thread createThread(final Runnable p) {
        return (Thread)this.doThreadPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Thread(p);
            }
        });
    }

    public Object doThreadPrivileged(PrivilegedAction p) {
        CodeSource codeSource = new CodeSource((URL)null, (Certificate[])null);
        Permissions newPermissions = new Permissions();
        newPermissions.add(new RuntimePermission("modifyThreadGroup"));
        newPermissions.add(new RuntimePermission("modifyThread"));
        ProtectionDomain protectionDomain = new ProtectionDomain(codeSource, newPermissions);
        final ProtectionDomain[] domains = new ProtectionDomain[]{protectionDomain};
        final AccessControlContext acc = AccessController.getContext();
        try {
            acc.checkPermission(new RuntimePermission("modifyThreadGroup"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        AccessControlContext combined = acc;
        try {
            Class<?> domainCombinerClass = Class.forName("java.security.DomainCombiner");
            combined = (AccessControlContext)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new AccessControlContext(acc, (DomainCombiner)new PermissionCombiner(domains));
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return AccessController.doPrivileged(p, combined);
    }

    public Object invokeMethod(final Method method, final Object object, final Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    return method.invoke(object, args);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof IllegalAccessException) {
                throw (IllegalAccessException)pae.getException();
            }
            if (pae.getException() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)pae.getException();
            }
            throw (InvocationTargetException)pae.getException();
        }
    }

    public Method getMethod(final Class cls, final String name, final Class[] paramTypes) throws NoSuchMethodException, SecurityException {
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException, SecurityException {
                    return cls.getMethod(name, paramTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)pae.getException();
            }
            throw (SecurityException)pae.getException();
        }
    }

    public Method[] getDeclaredMethods(final Class cls) throws SecurityException {
        try {
            return (Method[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException {
                    return cls.getDeclaredMethods();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SecurityException)pae.getException();
        }
    }

    public Constructor getConstructor(final Class c, final Class[] args) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    return c.getConstructor(args);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (NoSuchMethodException)pae.getException();
        }
    }

    public int getMethodModifiers(final Member method) {
        Integer modifiers = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Integer(method.getModifiers());
            }
        });
        return modifiers;
    }

    public String getMethodName(final Method method) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return method.getName();
            }
        });
    }

    public Class[] getMethodParameterTypes(final Method method) {
        return (Class[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return method.getParameterTypes();
            }
        });
    }

    public Class getMethodReturnType(final Method method) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return method.getReturnType();
            }
        });
    }

    public Class[] getMethodExceptionTypes(final Method method) {
        return (Class[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return method.getExceptionTypes();
            }
        });
    }

    public BeanInfo getBeanInfo(final Class startClass, final Class stopClass) throws IntrospectionException {
        try {
            return (BeanInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IntrospectionException {
                    return Introspector.getBeanInfo(startClass, stopClass);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IntrospectionException)pae.getException();
        }
    }

    public String getPrivilegedLocalHostName() throws UnknownHostException {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getHostName();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (UnknownHostException)pae.getException();
        }
    }

    public Socket socketAccept(final ServerSocket serverSocket) throws IOException {
        try {
            return (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return serverSocket.accept();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }
}

