/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models.itemlistmanager.tree;

import com.sas.models.itemlistmanager.ILMTableModel;
import com.sas.models.itemlistmanager.tree.GroupInfo;
import com.sas.models.itemlistmanager.tree.ILMColumn;
import com.sas.models.itemlistmanager.tree.ILMModelEvent;
import com.sas.models.itemlistmanager.tree.ILMModelListener;
import com.sas.models.itemlistmanager.tree.ILMTabularGroupingModelInterface;
import com.sas.models.itemlistmanager.tree.ILMTreeInterface;
import com.sas.models.itemlistmanager.tree.ILMTreeNode;
import com.sas.models.itemlistmanager.tree.ItemExaminerInterface;
import com.sas.models.itemlistmanager.tree.TreeUtil;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ILMTree
extends ILMTableModel
implements ILMTreeInterface,
ILMTabularGroupingModelInterface {
    private static final long serialVersionUID = 7903490942231217078L;
    TreeModel groupData;
    GroupInfo defaultGroup;
    protected ItemExaminerInterface itemExaminer;
    protected List columns;
    protected List logicalConditionList = null;
    private Object defaultLogicalCondition;
    private transient CommonLoggerInterface log = LoggerRepository2.getLogger((String)ILMTree.class.getPackage().getName(), null);
    public static List default_lcList = Arrays.asList("AND", "OR");

    public ILMTree() {
        this((ILMTreeNode)null);
    }

    public ILMTree(ILMTreeNode root) {
        this.columns = new ArrayList();
        this.setRoot(root);
    }

    public ILMTree(List lcList) {
        this((ILMTreeNode)null);
        this.setLogicalConditionList(lcList);
    }

    public void setColumnList(String[] names) {
        ILMColumn[] newColumns = null;
        if (names != null) {
            newColumns = new ILMColumn[names.length];
            for (int i = 0; i < names.length; ++i) {
                newColumns[i] = new ILMColumn(names[i]);
            }
        }
        this.setColumnList(newColumns);
    }

    public void setColumnList(ILMColumn[] newColumns) {
        this.columns.clear();
        if (newColumns != null) {
            this.columns.addAll(Arrays.asList(newColumns));
        }
    }

    public List getColumnList() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int index) {
        return ((ILMColumn)this.columns.get((int)index)).name;
    }

    @Override
    public Class getColumnClass(int index) {
        return ((ILMColumn)this.columns.get((int)index)).clazz;
    }

    public ItemExaminerInterface setItemExaminer(ItemExaminerInterface examiner) {
        if (this.itemExaminer != examiner) {
            ItemExaminerInterface oldExaminer = this.itemExaminer;
            this.itemExaminer = examiner;
            return oldExaminer;
        }
        return null;
    }

    public ItemExaminerInterface getItemExaminer() {
        return this.itemExaminer;
    }

    public void setDefaultLogicalCondition(Object value) {
        this.defaultLogicalCondition = value;
    }

    @Override
    public ILMTreeNode addItem() {
        return this.addItem(false);
    }

    @Override
    public ILMTreeNode addItem(boolean negated) {
        Object item = this.newDefaultItem();
        ItemData newItem = new ItemData(item, negated);
        newItem.LC = this.getDefaultLogicalCondition();
        this.addRow(new Object[]{newItem});
        Object[] newChildren = new TreeNode[]{newItem};
        this.fireItemInserted(this, newChildren);
        return newItem;
    }

    public boolean setNegation(ItemData row, boolean value) {
        if (row != null && row.isNegated() != value) {
            row.setNegation(value);
            this.fireItemChanged(row);
            return true;
        }
        return false;
    }

    @Override
    public boolean canSetNegation(int row, boolean value) {
        boolean canNegate = false;
        if (row > -1 && row < this.getRowCount() && (!this.isGrouped(row) || this.isFirstInHighestGroup(row))) {
            canNegate = true;
        }
        return canNegate;
    }

    public boolean canSetNegation(ItemData row, boolean value) {
        return row != null;
    }

    @Override
    public void negateRow(int row) {
        ItemData item = this.getItem(row);
        this.negate(item);
    }

    boolean canSetLogicalCondition(ItemData row, Object newLC) {
        return row != null;
    }

    @Override
    public boolean canSetLogicalCondition(int row) {
        return row > 0 && row < this.getRowCount();
    }

    boolean hasLogicalCondition(ItemData row) {
        return row != null && row.LC != null;
    }

    @Override
    public boolean hasLogicalCondition(int row) {
        if (row > 0 && row < this.getRowCount()) {
            ItemData item = this.getItem(row);
            return item.LC != null;
        }
        return false;
    }

    Object getLogicalCondition(ItemData row) {
        if (row != null) {
            if (this.getRowIndex(row) == 0) {
                return null;
            }
            return row.LC;
        }
        return null;
    }

    @Override
    public Object getLogicalCondition(int row) {
        if (row > 0 && row < this.getRowCount()) {
            ItemData item = this.getItem(row);
            return item.LC;
        }
        return null;
    }

    boolean setLogicalCondition(ItemData row, Object newLC) {
        if (row != null && row.LC != newLC) {
            row.LC = newLC;
            this.fireItemChanged(row);
            return true;
        }
        return false;
    }

    @Override
    public List getLogicalConditionList() {
        return this.logicalConditionList;
    }

    @Override
    public void setLogicalConditionList(List newList) {
        if (this.logicalConditionList != newList) {
            if (newList == null) {
                newList = default_lcList;
            }
            this.logicalConditionList = newList;
        }
    }

    @Override
    public Object getDefaultLogicalCondition() {
        if (this.defaultLogicalCondition != null) {
            return this.defaultLogicalCondition;
        }
        if (!this.logicalConditionList.isEmpty()) {
            return this.logicalConditionList.get(0);
        }
        return null;
    }

    @Override
    public void addILMModelListener(ILMModelListener l) {
        this.listenerList.add(ILMModelListener.class, l);
    }

    @Override
    public void removeILMModelListener(ILMModelListener l) {
        this.listenerList.remove(ILMModelListener.class, l);
    }

    @Override
    public void fireItemChanged(ILMTreeNode node) {
        this.fireItemChanged(Collections.singletonList(node));
    }

    @Override
    public void fireItemChanged(List nodeList) {
        if (nodeList != null) {
            try {
                ILMTreeNode[] children = new ILMTreeNode[nodeList.size()];
                this.fireItemChanged(this, nodeList.toArray(children));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void fireItemMoved(List nodeList) {
        if (nodeList != null) {
            try {
                ILMTreeNode[] children = new ILMTreeNode[nodeList.size()];
                this.fireItemMoved(this, nodeList.toArray(children));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void fireItemMoved(Object source, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        ILMModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ILMModelListener.class) continue;
            if (e == null) {
                e = new ILMModelEvent(source, children);
            }
            ((ILMModelListener)listeners[i + 1]).itemMoved(e);
        }
    }

    protected void fireItemChanged(Object source, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        ILMModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ILMModelListener.class) continue;
            if (e == null) {
                e = new ILMModelEvent(source, children);
            }
            ((ILMModelListener)listeners[i + 1]).itemChanged(e);
        }
    }

    protected void fireItemInserted(Object source, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        ILMModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ILMModelListener.class) continue;
            if (e == null) {
                e = new ILMModelEvent(source, children);
            }
            ((ILMModelListener)listeners[i + 1]).itemInserted(e);
        }
    }

    protected void fireItemRemoved(Object source, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        ILMModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ILMModelListener.class) continue;
            if (e == null) {
                e = new ILMModelEvent(source, children);
            }
            ((ILMModelListener)listeners[i + 1]).itemRemoved(e);
        }
    }

    @Override
    public boolean canDelete(ILMTreeNode leaf) {
        if (leaf instanceof ItemData) {
            return this.canDelete((ItemData)leaf);
        }
        return false;
    }

    protected boolean canDelete(ItemData item) {
        return item != null;
    }

    @Override
    public ILMTreeNode delete(ILMTreeNode leaf) {
        if (leaf instanceof ItemData) {
            return this.delete((ItemData)leaf);
        }
        return null;
    }

    @Override
    public boolean isGrouped(int row) {
        if (row > -1 && row < this.getRowCount()) {
            return this.getGroup(this.getItem(row)) != this.defaultGroup;
        }
        return false;
    }

    public boolean isGrouped(ItemData row) {
        return this.getGroup(row) != this.defaultGroup;
    }

    @Override
    public boolean isGrouped(ILMTreeNode leaf) {
        if (leaf instanceof ItemData) {
            return this.isGrouped((ItemData)leaf);
        }
        return false;
    }

    @Override
    public boolean groupRow(int first, int last) {
        if (first != last) {
            int rowCount = this.getRowCount();
            if (first > -1 && first < rowCount && last > -1 && last < rowCount) {
                ItemData fItem = this.getItem(first);
                ItemData lItem = this.getItem(last);
                return this.groupRow(fItem, lItem);
            }
        }
        return false;
    }

    @Override
    public boolean groupRow(ILMTreeNode firstLeaf, ILMTreeNode lastLeaf) {
        if (firstLeaf instanceof ItemData && lastLeaf instanceof ItemData) {
            return this.groupRow((ItemData)firstLeaf, (ItemData)lastLeaf);
        }
        return false;
    }

    @Override
    public boolean canSplitRow(int row) {
        if (row > -1 && row < this.getRowCount()) {
            ItemData item = this.getItem(row);
            return this.canSplitRow(item);
        }
        return false;
    }

    public boolean canSplitRow(ItemData row) {
        return this.isGrouped(row);
    }

    @Override
    public boolean canSplitRow(ILMTreeNode leaf) {
        return this.isGrouped(leaf);
    }

    @Override
    public boolean splitRow(int row) {
        if (row > -1 && row < this.getRowCount()) {
            ItemData item = this.getItem(row);
            return this.splitRow(item);
        }
        return false;
    }

    @Override
    public boolean splitRow(ILMTreeNode leaf) {
        if (leaf instanceof ItemData) {
            return this.splitRow((ItemData)leaf);
        }
        return false;
    }

    @Override
    public boolean canSetLogicalCondition(ILMTreeNode leaf, Object newLC) {
        if (leaf instanceof ItemData) {
            return this.canSetLogicalCondition((ItemData)leaf, newLC);
        }
        return false;
    }

    @Override
    public boolean hasLogicalCondition(ILMTreeNode leaf) {
        if (leaf instanceof ItemData) {
            return this.hasLogicalCondition((ItemData)leaf);
        }
        return false;
    }

    @Override
    public Object getLogicalCondition(ILMTreeNode leaf) {
        if (leaf instanceof ItemData) {
            return this.getLogicalCondition((ItemData)leaf);
        }
        return null;
    }

    @Override
    public boolean setLogicalCondition(ILMTreeNode leaf, Object newLC) {
        if (leaf instanceof ItemData) {
            return this.setLogicalCondition((ItemData)leaf, newLC);
        }
        return false;
    }

    @Override
    public Object setLogicalCondition(int row, Object newLC) {
        if (row > -1 && row < this.getRowCount()) {
            ItemData item = this.getItem(row);
            return new Boolean(this.setLogicalCondition(item, newLC));
        }
        return null;
    }

    @Override
    public boolean canMoveNodes(ILMTreeNode start, ILMTreeNode end, ILMTreeNode to) {
        if (start instanceof ItemData && end instanceof ItemData && (to == null || to instanceof ItemData)) {
            return this.canMoveNodes((ItemData)start, (ItemData)end, (ItemData)to);
        }
        return false;
    }

    @Override
    public ILMTreeNode moveNodes(ILMTreeNode start, ILMTreeNode end, ILMTreeNode to) {
        if (start instanceof ItemData && end instanceof ItemData && (to == null || to instanceof ItemData)) {
            int t;
            int s = this.getRowIndex((ItemData)start);
            int e = this.getRowIndex((ItemData)end);
            int n = t = to == null ? this.getRowCount() : this.getRowIndex((ItemData)to);
            if (t - s > 0) {
                --t;
            }
            int res = this.moveRowRange(s, e, t);
            return this.getItem(res);
        }
        return null;
    }

    @Override
    public boolean isNegated(int row) {
        if (row > -1 && row < this.getRowCount()) {
            ItemData item = this.getItem(row);
            return this.isNegated(row, item);
        }
        return false;
    }

    @Override
    public boolean isNegated(ILMTreeNode row) {
        if (row != null) {
            return this.isNegated(this.getRowIndex(row), row);
        }
        return false;
    }

    private boolean isNegated(int index, ILMTreeNode row) {
        boolean negated = false;
        if (row != null) {
            negated = row.isNegated;
            ItemData prevItem = index == 0 ? null : this.getItem(index - 1);
            GroupInfo group = this.getGroupInfo(row);
            if (group == this.defaultGroup) {
                return negated;
            }
            while (!(group == null || prevItem != null && this.isInGroup(prevItem, group) || prevItem == null && group == this.defaultGroup)) {
                negated = group.isNegated;
                group = group.getParentGroup();
            }
        }
        return negated;
    }

    @Override
    public boolean setNegation(int row, boolean value) {
        if (row > -1 && row < this.getRowCount()) {
            ItemData item = this.getItem(row);
            return this.setNegation(item, value);
        }
        return false;
    }

    @Override
    public boolean setNegation(ILMTreeNode leaf, boolean value) {
        if (leaf != null) {
            GroupInfo groupRoot = this.getGroupInfo(leaf);
            int index = this.getRowIndex(leaf);
            ItemData prevItem = index == 0 ? null : this.getItem(index - 1);
            for (GroupInfo group = groupRoot; !(group == null || prevItem != null && this.isInGroup(prevItem, group) || prevItem == null && group == this.defaultGroup); group = group.getParentGroup()) {
                groupRoot = group;
            }
            ILMTreeNode node = groupRoot == this.defaultGroup ? leaf : groupRoot;
            boolean isNegated = node.isNegated();
            if (value != isNegated) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Setting negation flag on node: obj=" + node + ", negation=" + value);
                }
                node.setNegation(value);
                this.fireItemChanged(leaf);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canSetNegation(ILMTreeNode leaf, boolean value) {
        return leaf != null;
    }

    @Override
    public void negate(ILMTreeNode leaf) {
        if (leaf != null) {
            this.setNegation(leaf, !this.isNegated(this.getRowIndex(leaf), leaf));
        }
    }

    @Override
    public Object getValueAt(ILMTreeNode leaf, int columnIndex) {
        if (this.itemExaminer != null) {
            return this.itemExaminer.getValueAt(leaf, columnIndex);
        }
        return null;
    }

    @Override
    public Object setValueAt(ILMTreeNode leaf, int columnIndex, Object newValue) {
        if (this.itemExaminer != null) {
            Object retval = this.itemExaminer.setValueAt(leaf, columnIndex, newValue);
            if (!Util.equal((Object)newValue, (Object)retval)) {
                this.fireItemChanged(leaf);
            }
            return retval;
        }
        return null;
    }

    @Override
    public String getClassification(ILMTreeNode leaf, int columnIndex) {
        if (this.itemExaminer == null) {
            String classification = null;
            if (leaf != null && leaf.getItem() != null) {
                classification = leaf.getItem().getClass().getName();
            }
            return classification;
        }
        return this.itemExaminer.getClassification(leaf, columnIndex);
    }

    @Override
    public Object newDefaultItem() {
        Object item = null;
        if (this.itemExaminer != null) {
            item = this.itemExaminer.newDefaultItem();
        }
        return item;
    }

    private GroupInfo getOuterMostGroup(ILMTreeNode leaf) {
        if (leaf instanceof ItemData) {
            GroupInfo group;
            GroupInfo lastExplicit = group = this.getGroup((ItemData)leaf);
            while (group != null) {
                if (group.isExplicit) {
                    lastExplicit = group;
                }
                group = group.getParentGroup();
            }
            return lastExplicit;
        }
        return null;
    }

    private int getRowIndex(Object row) {
        Vector<Vector> data = this.getDataVector();
        int s = data.size();
        for (int i = 0; i < s; ++i) {
            Object o = ((List)data.get(i)).get(0);
            if (o != row) continue;
            return i;
        }
        return -1;
    }

    private ItemData getItem(int row) {
        return (ItemData)((List)this.getDataVector().get(row)).get(0);
    }

    private List removeGroup(GroupInfo gd) {
        List members = this.getMembers(gd);
        for (ItemData item : members) {
            int idx = this.getRowIndex(item);
            this.removeRow(idx);
        }
        GroupInfo parent = gd.getParentGroup();
        if (parent != null) {
            parent.remove(gd);
        }
        return members;
    }

    @Override
    public ILMTreeNode insertNode(ILMTreeNode insertionNode) {
        throw new UnsupportedOperationException("This feature has not yet been implemented!");
    }

    @Override
    public ILMTreeNode insertNode(ILMTreeNode insertionNode, Object[] values) {
        throw new UnsupportedOperationException("This feature has not yet been implemented!");
    }

    @Override
    public boolean canGroupRow(int first, int last) {
        boolean canGroup = false;
        if (first != last) {
            int rowCount = this.getRowCount();
            if (first > -1 && first < rowCount && last > -1 && last < rowCount) {
                ItemData fItem = this.getItem(first);
                ItemData lItem = this.getItem(last);
                canGroup = this.canGroupRow(fItem, lItem);
            }
        }
        return canGroup;
    }

    @Override
    public boolean canGroupRow(ILMTreeNode first, ILMTreeNode last) {
        boolean canGroup = false;
        if (first != null && last != null && first != last) {
            canGroup = true;
            if (first instanceof ItemData && first instanceof ItemData) {
                GroupInfo firstGroup = this.getGroup((ItemData)first);
                GroupInfo lastGroup = this.getGroup((ItemData)last);
                GroupInfo g = this.defaultGroup;
                if (firstGroup != null && lastGroup != null) {
                    g = (GroupInfo)firstGroup.getSharedAncestor(lastGroup);
                }
                if (g.isExplicit) {
                    canGroup = false;
                }
            }
        }
        return canGroup;
    }

    boolean canMoveNodes(ItemData start, ItemData end, ItemData to) {
        return true;
    }

    @Override
    public int moveRowRange(int start, int end, int to) {
        int high;
        int low;
        int delta;
        int idx;
        List members;
        GroupInfo lowest;
        GroupInfo last;
        GroupInfo shared;
        int r;
        GroupInfo gData;
        ItemData iData;
        ArrayList<GroupInfo> groups;
        if (start == to) {
            return to;
        }
        int shift = to - start;
        if (shift < 0) {
            groups = new ArrayList<GroupInfo>();
            iData = null;
            gData = null;
            for (r = start; r <= end; ++r) {
                iData = this.getItem(r);
                gData = this.getGroup(iData);
                for (GroupInfo iGroup : groups) {
                    if (this.isInGroup(iData, iGroup)) continue;
                    shared = (GroupInfo)iGroup.getSharedAncestor(this.getGroup(iData));
                    last = iGroup;
                    for (lowest = iGroup; lowest != shared; lowest = lowest.getParentGroup()) {
                        last = lowest;
                    }
                    members = this.getMembers(last);
                    if (members == null || members.isEmpty()) continue;
                    idx = this.getRowIndex((ItemData)members.get(0));
                    if (idx < start) {
                        delta = start - idx;
                        start = idx;
                        to -= delta;
                    }
                    if ((idx = this.getRowIndex((ItemData)members.get(members.size() - 1))) <= end) continue;
                    end = idx;
                }
                if (gData == this.defaultGroup || groups.contains(gData)) continue;
                groups.add(gData);
            }
        } else {
            groups = new ArrayList();
            iData = null;
            gData = null;
            for (r = end; r >= start; --r) {
                iData = this.getItem(r);
                gData = this.getGroup(iData);
                for (GroupInfo iGroup : groups) {
                    if (this.isInGroup(iData, iGroup)) continue;
                    shared = (GroupInfo)iGroup.getSharedAncestor(this.getGroup(iData));
                    last = iGroup;
                    for (lowest = iGroup; lowest != shared; lowest = lowest.getParentGroup()) {
                        last = lowest;
                    }
                    members = this.getMembers(last);
                    if (members == null || members.isEmpty()) continue;
                    idx = this.getRowIndex((ItemData)members.get(0));
                    if (idx < start) {
                        delta = start - idx;
                        start = idx;
                        to -= delta;
                    }
                    if ((idx = this.getRowIndex((ItemData)members.get(members.size() - 1))) <= end) continue;
                    end = idx;
                }
                if (gData == this.defaultGroup || groups.contains(gData)) continue;
                groups.add(gData);
            }
        }
        ItemData src = this.getItem(start);
        int dstIdx = shift < 0 ? start + shift : end + shift;
        ItemData dst = this.getItem(dstIdx);
        GroupInfo srcGroup = this.getGroup(src);
        GroupInfo dstGroup = this.getGroup(dst);
        ItemData srcSwapObject = null;
        ItemData dstSwapObject = null;
        boolean swapLC = this.isFirstInGroup(start) || this.isFirstInGroup(dstIdx);
        GroupInfo g = this.defaultGroup;
        if (srcGroup != null && dstGroup != null) {
            g = (GroupInfo)srcGroup.getSharedAncestor(dstGroup);
        }
        while (srcGroup != g && srcGroup.getParentGroup() != g) {
            srcGroup = srcGroup.getParentGroup();
        }
        if (srcGroup != g) {
            members = this.getMembers(srcGroup);
            idx = this.getRowIndex((ItemData)members.get(0));
            if (idx < start) {
                delta = start - idx;
                start = idx;
                to -= delta;
            }
            if ((idx = this.getRowIndex((ItemData)members.get(members.size() - 1))) > end) {
                end = idx;
            }
            if (this.isFirstInParentGroup(start) || this.isFirstInGroup(to)) {
                swapLC = true;
                srcSwapObject = this.getItem(start);
            } else {
                swapLC = false;
            }
        }
        int range = 0;
        int dstSize = 1;
        while (dstGroup != g && dstGroup.getParentGroup() != g) {
            dstGroup = dstGroup.getParentGroup();
        }
        if (dstGroup != g) {
            List members2 = this.getMembers(dstGroup);
            to = this.getRowIndex((ItemData)members2.get(0));
            dstSize = members2.size();
            if (this.isFirstInParentGroup(to) || this.isFirstInGroup(start)) {
                swapLC = true;
                dstSwapObject = (ItemData)members2.get(0);
            } else {
                swapLC = false;
            }
        }
        range = end - start;
        if (shift > 0 && dstSize > shift) {
            boolean bl = swapLC = this.isFirstInGroup(to += dstSize - (1 + range)) || this.isFirstInGroup(start);
        }
        if (swapLC) {
            ItemData srcToSwap = src;
            ItemData dstToSwap = dst;
            if (srcSwapObject != null) {
                srcToSwap = srcSwapObject;
            }
            if (dstSwapObject != null) {
                dstToSwap = dstSwapObject;
            }
            Object lc = srcToSwap.LC;
            srcToSwap.LC = dstToSwap.LC;
            dstToSwap.LC = lc;
        }
        int result = super.moveRowRange(start, end, to);
        ArrayList<ItemData> modified = new ArrayList<ItemData>();
        if (shift < 0) {
            low = to;
            high = end;
        } else {
            low = start;
            high = to + range;
        }
        for (int i = low; i <= high; ++i) {
            modified.add(this.getItem(i));
        }
        this.getRootNode();
        this.fireItemMoved(modified);
        this.fireItemChanged(modified);
        return result;
    }

    private boolean isFirstInParentGroup(int index) {
        GroupInfo gd;
        GroupInfo pg;
        List members;
        if (index == 0) {
            return true;
        }
        ItemData item = this.getItem(index);
        return item.equals((members = this.getMembers(pg = (gd = this.getGroup(item)).getParentGroup())).get(0));
    }

    @Override
    public boolean isFirstInGroup(int index) {
        if (index == 0) {
            return true;
        }
        GroupInfo gd = this.getGroup(this.getItem(index));
        return !this.isInGroup(this.getItem(index - 1), gd);
    }

    private boolean isFirstInHighestGroup(int index) {
        GroupInfo gd = this.getGroup(this.getItem(index));
        GroupInfo highestGroup = this.findHighestExplicitGroup(gd);
        return index == 0 && this.isGrouped(index) || !this.isInGroup(this.getItem(index - 1), highestGroup);
    }

    @Override
    public boolean isFirstInGroup(int index, GroupInfo group) {
        ItemData item = this.getItem(index);
        if (group == null) {
            group = this.defaultGroup;
        }
        if (this.isInGroup(item, group)) {
            if (index == 0) {
                return true;
            }
            if (!this.isInGroup(this.getItem(index - 1), group)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public GroupInfo getGroupInfo(int row) {
        if (row > -1 && row < this.getRowCount()) {
            ItemData item = this.getItem(row);
            return this.getGroupInfo(item);
        }
        return null;
    }

    public GroupInfo getGroupInfo(ILMTreeNode leaf) {
        if (leaf != null && !leaf.isLeaf()) {
            throw new IllegalArgumentException();
        }
        if (leaf instanceof ItemData) {
            return this.getGroup((ItemData)leaf);
        }
        return this.defaultGroup;
    }

    private GroupInfo getGroup(ItemData item) {
        if (item.group != null) {
            return item.group;
        }
        return this.defaultGroup;
    }

    private GroupInfo getGroup(TransItem item) {
        if (item.group != null) {
            return item.group;
        }
        return this.defaultGroup;
    }

    public List getMembers(GroupInfo group) {
        ArrayList<ItemData> members = new ArrayList<ItemData>();
        if (group == null) {
            group = this.defaultGroup;
        }
        Vector<Vector> data = this.getDataVector();
        ItemData item = null;
        int s = data.size();
        for (int i = 0; i < s; ++i) {
            item = (ItemData)((List)data.get(i)).get(0);
            if (!this.isInGroup(item, group)) continue;
            members.add(item);
        }
        return members;
    }

    @Override
    public boolean isInGroup(int row, GroupInfo group) {
        if (group != null && row > -1 && row < this.getRowCount()) {
            ItemData item = this.getItem(row);
            return this.isInGroup(item, group);
        }
        return false;
    }

    private boolean isInGroup(ItemData item, GroupInfo group) {
        for (GroupInfo itemGroup = this.getGroup(item); itemGroup != null; itemGroup = itemGroup.getParentGroup()) {
            if (itemGroup != group) continue;
            return true;
        }
        return false;
    }

    @Override
    public ILMTreeNode getRootNode() {
        ILMTreeNode root = null;
        Vector<Vector> rowData = this.getDataVector();
        ArrayList<TransItem> tiList = new ArrayList<TransItem>(rowData.size());
        int count = rowData.size();
        for (int i = 0; i < count; ++i) {
            List row = (List)rowData.get(i);
            ItemData node = (ItemData)row.get(0);
            TransItem item = new TransItem(node, node.LC, node.group);
            tiList.add(item);
        }
        TransItem newItem = null;
        Enumeration<TreeNode> e = this.defaultGroup.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            int i2;
            TransItem item;
            int i1;
            GroupInfo gd = (GroupInfo)e.nextElement();
            int s = tiList.size();
            for (i1 = 0; i1 < s && this.getGroup(item = (TransItem)tiList.get(i1)) != gd; ++i1) {
            }
            for (i2 = i1; i2 < s && this.getGroup(item = (TransItem)tiList.get(i2)) == gd; ++i2) {
            }
            List tmpList = tiList.subList(i1, i2);
            newItem = this.condense(tmpList);
            if (!gd.isExplicit) continue;
            newItem.item.isExplicit = gd.isExplicit;
            newItem.item.isNegated = gd.isNegated;
        }
        root = newItem == null ? null : newItem.item;
        return root;
    }

    private TransItem condense(List items) {
        TransItem retval = null;
        Object highLC = null;
        int count = items.size();
        while (count > 1) {
            highLC = this.findHighestPrecedence(items);
            items = this.condense(items, highLC);
            count = items.size();
        }
        if (items.size() > 0) {
            retval = (TransItem)items.get(0);
            if (retval.group != null) {
                retval.group = retval.group.getParentGroup();
            }
        }
        return retval;
    }

    private Object findHighestPrecedence(List items) {
        int hIdx = -1;
        int count = items.size();
        for (int i = 1; i < count; ++i) {
            TransItem item = (TransItem)items.get(i);
            if (item.LC == null) continue;
            int idx = this.logicalConditionList.indexOf(item.LC);
            if (hIdx >= 0 && idx >= hIdx) continue;
            hIdx = idx;
        }
        if (hIdx > -1) {
            return this.logicalConditionList.get(hIdx);
        }
        return null;
    }

    private List condense(List items, Object lc) {
        TransItem gg = null;
        DefaultMutableTreeNode g = null;
        TransItem last = null;
        TransItem item = (TransItem)items.get(0);
        int count = items.size();
        int i = 1;
        while (i < count) {
            last = item;
            item = (TransItem)items.get(i);
            if (item.LC == lc) {
                if (g == null) {
                    g = new ILMTreeNode(item.LC, false);
                    if (last == null) {
                        gg = new TransItem((ILMTreeNode)g, item.LC, item.group);
                        items.add(0, gg);
                        ++count;
                        ++i;
                    } else {
                        gg = new TransItem((ILMTreeNode)g, last.LC, item.group);
                        items.set(i - 1, gg);
                        g.add(last.item);
                    }
                    last = gg;
                }
                g.add(item.item);
                items.remove(item);
                --count;
                continue;
            }
            g = null;
            gg = null;
            ++i;
        }
        return items;
    }

    public ItemData delete(ItemData row) {
        ItemData removed;
        if (row != null) {
            int rowIdx = this.getRowIndex(row);
            this.removeRow(rowIdx);
            removed = row;
            GroupInfo gd = this.getGroup(row);
            GroupInfo highestExplicitGroup = this.findHighestExplicitGroup(gd);
            if (highestExplicitGroup != null) {
                List groupMembers = this.removeGroup(highestExplicitGroup);
                this.fireItemRemoved(this, groupMembers.toArray());
            }
        } else {
            removed = null;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List deleteRows(int[] rowIndices) {
        int len;
        ArrayList<ItemData> removed = null;
        if (rowIndices != null && (len = rowIndices.length) > 0) {
            Arrays.sort(rowIndices);
            removed = new ArrayList<ItemData>(len);
            ILMTree iLMTree = this;
            synchronized (iLMTree) {
                int rowCount;
                int delIdx = rowCount = this.getRowCount();
                for (int r = len - 1; r >= 0; --r) {
                    GroupInfo parent;
                    GroupInfo group;
                    GroupInfo highestExplicitGroup;
                    int idx = rowIndices[r];
                    if (idx > delIdx) continue;
                    ItemData item = this.getItem(idx);
                    this.removeRow(idx);
                    removed.add(item);
                    --rowCount;
                    if (!this.isGrouped(item) || (highestExplicitGroup = this.findHighestExplicitGroup(group = this.getGroup(item))) == null) continue;
                    delIdx = idx;
                    if (delIdx < rowCount) {
                        item = this.getItem(delIdx);
                        while (this.isInGroup(item, highestExplicitGroup)) {
                            this.removeRow(delIdx);
                            removed.add(item);
                            if (delIdx >= --rowCount) break;
                            item = this.getItem(delIdx);
                        }
                    }
                    if (--delIdx >= 0) {
                        item = this.getItem(delIdx);
                        while (this.isInGroup(item, highestExplicitGroup)) {
                            this.removeRow(delIdx);
                            removed.add(item);
                            --rowCount;
                            if (--delIdx < 0) break;
                            item = this.getItem(delIdx);
                        }
                    }
                    if ((parent = highestExplicitGroup.getParentGroup()) == null) continue;
                    parent.remove(highestExplicitGroup);
                }
            }
            this.fireItemRemoved(this, removed.toArray());
        }
        return removed;
    }

    private GroupInfo findHighestExplicitGroup(GroupInfo gd) {
        GroupInfo highestExplicitGroup = null;
        for (GroupInfo walk = gd; walk != null; walk = walk.getParentGroup()) {
            if (!walk.isExplicit) continue;
            highestExplicitGroup = walk;
        }
        return highestExplicitGroup;
    }

    public boolean groupRow(ItemData firstRow, ItemData lastRow) {
        boolean success = false;
        if (firstRow != null && lastRow != null && firstRow != lastRow) {
            GroupInfo firstGroup = this.getGroup(firstRow);
            GroupInfo lastGroup = this.getGroup(lastRow);
            GroupInfo g = this.defaultGroup;
            if (firstGroup != null && lastGroup != null) {
                g = (GroupInfo)firstGroup.getSharedAncestor(lastGroup);
            }
            if (g.isExplicit) {
                return false;
            }
            GroupInfo n = new GroupInfo(true, false);
            g.add(n);
            success = true;
            List items = this.getItemRange(firstRow, lastRow);
            for (ItemData item : items) {
                GroupInfo itemGroup = this.getGroup(item);
                if (itemGroup != this.defaultGroup && itemGroup.getParentGroup() != n) {
                    n.add(itemGroup);
                }
                if (itemGroup != null && itemGroup != g) continue;
                item.group = n;
            }
            if (success) {
                this.getRootNode();
                this.fireItemChanged(this.getMembers(n));
            }
        }
        return success;
    }

    private List getItemRange(ItemData firstRow, ItemData lastRow) {
        int i1 = this.getRowIndex(firstRow);
        int i2 = this.getRowIndex(lastRow);
        if (i2 < i1) {
            int tmp = i1;
            i1 = i2;
            i2 = tmp;
        }
        ArrayList<ItemData> items = new ArrayList<ItemData>(i2 - i1);
        for (int x = i1; x <= i2; ++x) {
            items.add(this.getItem(x));
        }
        return items;
    }

    public boolean splitRow(ItemData row) {
        boolean success = false;
        if (row != null) {
            GroupInfo gd = this.getGroup(row);
            GroupInfo highestGroup = this.findHighestExplicitGroup(gd);
            if (highestGroup == this.defaultGroup) {
                return this.splitAll();
            }
            if (highestGroup != null) {
                GroupInfo pGroup = highestGroup.getParentGroup();
                Vector<Vector> data = this.getDataVector();
                ArrayList<ItemData> rowsChanged = null;
                int s = data.size();
                for (int i = 0; i < s; ++i) {
                    ItemData item = (ItemData)((List)data.get(i)).get(0);
                    if (this.isInGroup(item, highestGroup)) {
                        if (rowsChanged == null) {
                            rowsChanged = new ArrayList<ItemData>();
                        }
                        rowsChanged.add(item);
                        success = true;
                    }
                    if (item.group != highestGroup) continue;
                    item.group = pGroup;
                    success = true;
                }
                Enumeration<TreeNode> e = highestGroup.children();
                Vector<GroupInfo> groupsToAdd = new Vector<GroupInfo>();
                while (e.hasMoreElements()) {
                    GroupInfo o = (GroupInfo)e.nextElement();
                    groupsToAdd.add(o);
                }
                for (int i = 0; i < groupsToAdd.size(); ++i) {
                    pGroup.add((GroupInfo)groupsToAdd.get(i));
                }
                pGroup.remove(highestGroup);
                if (success) {
                    this.getRootNode();
                    this.fireItemChanged(rowsChanged);
                }
            }
        }
        return success;
    }

    @Override
    public boolean splitAll() {
        boolean success = false;
        if (this.defaultGroup.getChildCount() > 0) {
            this.defaultGroup.removeAllChildren();
            success = true;
        }
        if (this.defaultGroup.isExplicit) {
            this.defaultGroup.isExplicit = false;
            success = true;
        }
        Vector<Vector> data = this.getDataVector();
        ArrayList<ItemData> rowsChanged = null;
        int s = data.size();
        for (int i = 0; i < s; ++i) {
            ItemData item = (ItemData)((List)data.get(i)).get(0);
            if (item.group == this.defaultGroup) continue;
            item.group = this.defaultGroup;
            if (rowsChanged == null) {
                rowsChanged = new ArrayList<ItemData>();
            }
            rowsChanged.add(item);
            success = true;
        }
        if (success) {
            this.getRootNode();
            this.fireItemChanged(rowsChanged);
        }
        return success;
    }

    public void setRoot(ILMTreeNode newRoot) {
        this.defaultGroup = new GroupInfo();
        this.groupData = new DefaultTreeModel(this.defaultGroup);
        this.dataVector.clear();
        if (newRoot != null) {
            if (newRoot.isLeaf()) {
                ItemData newItem = new ItemData(newRoot);
                newItem.group = this.defaultGroup;
                newItem.LC = null;
                this.addRow(new Object[]{newItem});
            } else if (newRoot.isExplicit || newRoot.isNegated) {
                GroupInfo newGroup = new GroupInfo(newRoot.isExplicit, newRoot.isNegated);
                newGroup.setItem(newRoot.getItem());
                this.defaultGroup.add(newGroup);
                this.setRoot(newRoot, newGroup);
            } else {
                this.setRoot(newRoot, null);
            }
        }
        this.fireTableDataChanged();
    }

    private void setRoot(ILMTreeNode node, GroupInfo group) {
        if (node != null) {
            if (group == null) {
                group = this.defaultGroup;
            }
            int c = node.getChildCount();
            for (int i = 0; i < c; ++i) {
                ILMTreeNode child = (ILMTreeNode)node.getChildAt(i);
                if (child.isLeaf()) {
                    ItemData newItem = new ItemData(child);
                    newItem.group = group;
                    newItem.LC = TreeUtil.getLogicalCondition(child);
                    this.addRow(new Object[]{newItem});
                    continue;
                }
                if (child.isExplicit || child.isNegated) {
                    GroupInfo subGroup = new GroupInfo(child);
                    group.add(subGroup);
                    this.setRoot(child, subGroup);
                    continue;
                }
                this.setRoot(child, group);
            }
        }
    }

    private static class TransItem {
        Object LC;
        ILMTreeNode item;
        GroupInfo group;

        public TransItem() {
            this(null, null, null);
        }

        public TransItem(ILMTreeNode item, Object LC, GroupInfo group) {
            this.item = item;
            this.LC = LC;
            this.group = group;
        }

        public String toString() {
            return "TI[item=" + this.item + ", LC=" + this.LC + ", group=" + this.group + "]";
        }
    }

    static class ItemData
    extends ILMTreeNode {
        Object LC;
        GroupInfo group;

        public ItemData(Object data) {
            this(data, false);
        }

        public ItemData(Object item, boolean negated) {
            this(null, item, negated, null);
        }

        public ItemData(Object lc, Object item, boolean negated, GroupInfo group) {
            super(item, negated);
            this.LC = lc;
            this.group = group;
        }

        public ItemData(ILMTreeNode other) {
            super(other);
            if (other instanceof ItemData) {
                this.group = ((ItemData)other).group;
                this.LC = ((ItemData)other).LC;
            } else {
                this.group = null;
                this.LC = null;
            }
        }
    }
}

