/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models.itemlistmanager;

import com.sas.models.itemlistmanager.DataClassificationInterface;
import com.sas.models.itemlistmanager.DeleteRowsInterface;
import com.sas.models.itemlistmanager.InsertRowInterface;
import com.sas.models.itemlistmanager.MoveRowInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class ILMTableModel
extends DefaultTableModel
implements InsertRowInterface,
DeleteRowsInterface,
MoveRowInterface,
DataClassificationInterface {
    public ILMTableModel() {
    }

    public ILMTableModel(List values, String columnName) {
        this.setValueList(values, columnName);
    }

    public void setValueList(List values, String columnName) {
        this.setColumnCount(0);
        this.addColumn(columnName);
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Object[] objArray = new Object[]{i.next()};
            this.addRow(objArray);
        }
    }

    public List getValueList() {
        int rowCount = this.getRowCount();
        ArrayList<Object> list = new ArrayList<Object>(rowCount);
        for (int row = 0; row < rowCount; ++row) {
            list.add(this.getValueAt(row, 0));
        }
        return list;
    }

    @Override
    public int insertRow(int row) {
        return this.insertRow(null, row);
    }

    @Override
    public int insertRow(Object[] rowData, int row) {
        this.insertRow(row, rowData);
        return row;
    }

    @Override
    public boolean canInsertRow(int row) {
        return true;
    }

    @Override
    public void deleteRow(int index) {
        this.removeRow(index);
    }

    @Override
    public boolean canDeleteRow(int index) {
        return true;
    }

    @Override
    public List deleteRows(int[] rowIndices) {
        ArrayList rows = null;
        if (rowIndices != null) {
            rows = new ArrayList(rowIndices.length);
            Arrays.sort(rowIndices);
            Vector<Vector> dv = this.getDataVector();
            for (int r = rowIndices.length - 1; r >= 0; --r) {
                int idx = rowIndices[r];
                Object o = dv.get(idx);
                rows.add(o);
                this.removeRow(idx);
            }
        }
        return rows;
    }

    @Override
    public boolean isRowMovementAllowed() {
        return true;
    }

    @Override
    public boolean canMoveRow(int start, int end, int to) {
        return to >= 0 && to + (end - start) < this.getRowCount();
    }

    @Override
    public int moveRowRange(int start, int end, int to) {
        this.moveRow(start, end, to);
        return to;
    }

    @Override
    public String getClassification(int row, int column) {
        return null;
    }
}

