/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.timebased;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.timebased.RB;
import com.sas.dataselectors.filters.timebased.TimePeriodType;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

@SASScope
public class TimePeriod
implements Serializable {
    private final String name;
    private final String key;
    private final String keyRoot;
    private final boolean timeBased;
    private final boolean descriptionImpliesSingleDay;
    private final String nPeriodsDescriptionKey;
    private static final String descriptionKeySuffix = ".description.txt";
    private static final String toolTipKeySuffix = ".tooltip.txt";
    private static List types = new ArrayList(2);
    public static final TimePeriod PERIOD_CURRENT_DATETIME;
    public static final TimePeriod PERIOD_NOW;
    public static final TimePeriod PERIOD_CURRENT_DATETIME_LAST_YEAR;
    public static final TimePeriod PERIOD_TODAY;
    public static final TimePeriod PERIOD_YESTERDAY;
    public static final TimePeriod PERIOD_TOMORROW;
    public static final TimePeriod PERIOD_CURRENT_DAY_LAST_YEAR;
    public static final TimePeriod PERIOD_CURRENT_WEEK;
    public static final TimePeriod PERIOD_LAST_WEEK;
    public static final TimePeriod PERIOD_CURRENT_WEEK_LAST_YEAR;
    public static final TimePeriod PERIOD_CURRENT_MONTH;
    public static final TimePeriod PERIOD_LAST_MONTH;
    public static final TimePeriod PERIOD_CURRENT_MONTH_LAST_YEAR;
    public static final TimePeriod PERIOD_CURRENT_QUARTER;
    public static final TimePeriod PERIOD_LAST_QUARTER;
    public static final TimePeriod PERIOD_CURRENT_QUARTER_LAST_YEAR;
    public static final TimePeriod PERIOD_CURRENT_YEAR;
    public static final TimePeriod PERIOD_LAST_YEAR;
    public static final TimePeriod PERIOD_CURRENT_HOUR;
    public static final TimePeriod PERIOD_LAST_HOUR;
    public static final TimePeriod PERIOD_CURRENT_MINUTE;
    public static final TimePeriod PERIOD_LAST_MINUTE;
    public static final TimePeriod PERIOD_NEXT_MINUTE;
    public static final TimePeriod PERIOD_N_PERIODS_AGO;
    public static final TimePeriod PERIOD_N_PERIODS_FROM_NOW;

    private TimePeriod(String name, String key) {
        this(name, key, false, false, null);
    }

    private TimePeriod(String name, String key, String nPeriodsDescriptionKey) {
        this(name, key, false, false, nPeriodsDescriptionKey);
    }

    private TimePeriod(String name, String key, boolean timeBased, boolean descriptionImpliesSingleDay) {
        this(name, key, timeBased, descriptionImpliesSingleDay, null);
    }

    private TimePeriod(String name, String key, boolean timeBased, boolean descriptionImpliesSingleDay, String nPeriodsDescriptionKey) {
        this.name = name;
        this.key = key;
        this.timeBased = timeBased;
        this.descriptionImpliesSingleDay = descriptionImpliesSingleDay;
        this.nPeriodsDescriptionKey = nPeriodsDescriptionKey;
        this.keyRoot = key.substring(0, key.indexOf(".txt"));
        types.add(this);
    }

    public String toString() {
        return this.name;
    }

    public String getLabel() {
        return RB.getStringResource(this.key);
    }

    public String getLabel(Locale locale) {
        return RB.getStringResource(this.key, locale);
    }

    public String getDescription(int numberPeriods, TimePeriodType periodType) {
        return this.getDescription(numberPeriods, periodType, null);
    }

    public String getDescription(int numberPeriods, TimePeriodType periodType, Locale locale) {
        if (this.nPeriodsDescriptionKey == null) {
            return this.getDescription(locale);
        }
        String rbFormat = this.nPeriodsDescriptionKey;
        String periodText = "";
        if (periodType == TimePeriodType.YEARS) {
            periodText = numberPeriods == 1 ? "1Year" : "NYears";
        } else if (periodType == TimePeriodType.QUARTERS) {
            periodText = numberPeriods == 1 ? "1Quarter" : "NQuarters";
        } else if (periodType == TimePeriodType.MONTHS) {
            periodText = numberPeriods == 1 ? "1Month" : "NMonths";
        } else if (periodType == TimePeriodType.WEEKS) {
            periodText = numberPeriods == 1 ? "1Week" : "NWeeks";
        } else if (periodType == TimePeriodType.DAYS) {
            periodText = numberPeriods == 1 ? "1Day" : "NDays";
        } else if (periodType == TimePeriodType.HOURS) {
            periodText = numberPeriods == 1 ? "1Hour" : "NHours";
        } else if (periodType == TimePeriodType.MINUTES) {
            periodText = numberPeriods == 1 ? "1Minute" : "NMinutes";
        }
        rbFormat = Message.format((String)rbFormat, (Object)periodText);
        if (locale != null) {
            return Message.format((String)RB.getStringResource(rbFormat, locale), (Object)("" + numberPeriods));
        }
        return Message.format((String)RB.getStringResource(rbFormat), (Object)("" + numberPeriods));
    }

    public String getDescription() {
        return RB.getStringResource(this.keyRoot + descriptionKeySuffix);
    }

    public String getDescription(Locale locale) {
        return RB.getStringResource(this.keyRoot + descriptionKeySuffix, locale);
    }

    public String getToolTip(int daySelectedInTimePeriod) {
        String key = "";
        if (daySelectedInTimePeriod == 1) {
            key = this.keyRoot + ".FirstDay" + toolTipKeySuffix;
        } else if (daySelectedInTimePeriod == 2) {
            key = this.keyRoot + ".LastDay" + toolTipKeySuffix;
        }
        try {
            return RB.getStringResource(key);
        }
        catch (Exception e) {
            try {
                return RB.getStringResource(this.keyRoot + toolTipKeySuffix);
            }
            catch (Exception e2) {
                return "";
            }
        }
    }

    public boolean isTimeBased() {
        return this.timeBased;
    }

    public boolean isDescriptionImpliesSingleDay() {
        return this.descriptionImpliesSingleDay;
    }

    public static TimePeriod findType(String name) {
        TimePeriod type = null;
        if (name != null) {
            for (TimePeriod t : types) {
                if (!name.equals(t.toString())) continue;
                type = t;
                break;
            }
        }
        return type;
    }

    public static TimePeriod findByLabel(String label) {
        if (label != null) {
            for (TimePeriod t : types) {
                if (!label.equals(t.getLabel())) continue;
                return t;
            }
        }
        return null;
    }

    public static List getAvailableTypes() {
        return Collections.unmodifiableList(types);
    }

    static {
        PERIOD_NOW = PERIOD_CURRENT_DATETIME = new TimePeriod("current datetime", "Period.DateTime.Current.Now.txt", true, true);
        PERIOD_CURRENT_DATETIME_LAST_YEAR = new TimePeriod("current datetime last year", "Period.DateTime.Current.LastYear.txt", true, true);
        PERIOD_TODAY = new TimePeriod("today", "Period.Today.txt", false, true);
        PERIOD_YESTERDAY = new TimePeriod("yesterday", "Period.Yesterday.txt", false, true);
        PERIOD_TOMORROW = new TimePeriod("tomorrow", "Period.Tomorrow.txt", false, true);
        PERIOD_CURRENT_DAY_LAST_YEAR = new TimePeriod("current day last year", "Period.Day.CurrentOfLastYear.txt", false, true);
        PERIOD_CURRENT_WEEK = new TimePeriod("current week", "Period.Week.Current.txt");
        PERIOD_LAST_WEEK = new TimePeriod("last week", "Period.Week.Last.txt");
        PERIOD_CURRENT_WEEK_LAST_YEAR = new TimePeriod("current week last year", "Period.Week.CurrentOfLastYear.txt");
        PERIOD_CURRENT_MONTH = new TimePeriod("current month", "Period.Month.Current.txt");
        PERIOD_LAST_MONTH = new TimePeriod("last month", "Period.Month.Last.txt");
        PERIOD_CURRENT_MONTH_LAST_YEAR = new TimePeriod("current month last year", "Period.Month.CurrentOfLastYear.txt");
        PERIOD_CURRENT_QUARTER = new TimePeriod("current quarter", "Period.Quarter.Current.txt");
        PERIOD_LAST_QUARTER = new TimePeriod("last quarter", "Period.Quarter.Last.txt");
        PERIOD_CURRENT_QUARTER_LAST_YEAR = new TimePeriod("current quarter last year", "Period.Quarter.CurrentOfLastYear.txt");
        PERIOD_CURRENT_YEAR = new TimePeriod("current year", "Period.Year.Current.txt");
        PERIOD_LAST_YEAR = new TimePeriod("last year", "Period.Year.Last.txt");
        PERIOD_CURRENT_HOUR = new TimePeriod("current hour", "Period.Hour.Current.txt", true, false);
        PERIOD_LAST_HOUR = new TimePeriod("last hour", "Period.Hour.Last.txt", true, false);
        PERIOD_CURRENT_MINUTE = new TimePeriod("current minute", "Period.Minute.Current.txt", true, false);
        PERIOD_LAST_MINUTE = new TimePeriod("last minute", "Period.Minute.Last.txt", true, false);
        PERIOD_NEXT_MINUTE = new TimePeriod("next minute", "Period.Minute.Next.txt", true, false);
        PERIOD_N_PERIODS_AGO = new TimePeriod("n periods ago", "Period.NPeriods.Ago.txt", "Period.{0}.Previous.description.txt");
        PERIOD_N_PERIODS_FROM_NOW = new TimePeriod("n periods from now", "Period.NPeriods.FromNow.txt", "Period.{0}.Next.description.txt");
    }
}

