/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.timebased;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.timebased.TimePeriod;
import com.sas.dataselectors.filters.timebased.TimePeriodType;
import com.sas.util.Util;
import java.io.Serializable;

@SASScope
public class RelativeTimeFilterData
implements Serializable {
    protected TimePeriod period;
    protected TimePeriodType periodType;
    protected int multiplier;
    protected int daySelectedInTimePeriod;
    public static final int DAY_UNDEFINED = 0;
    public static final int DAY_FIRST = 1;
    public static final int DAY_LAST = 2;

    public RelativeTimeFilterData() {
        this(TimePeriod.PERIOD_TODAY);
    }

    public RelativeTimeFilterData(TimePeriod period) {
        this(period, 0);
    }

    public RelativeTimeFilterData(TimePeriod period, int daySelectedInTimePeriod) {
        this(period, daySelectedInTimePeriod, null, 1);
    }

    public RelativeTimeFilterData(TimePeriod period, TimePeriodType type, int multiplier) {
        this(period, 0, type, multiplier);
    }

    public RelativeTimeFilterData(TimePeriod period, int daySelectedInTimePeriod, TimePeriodType type, int multiplier) {
        this.setPeriod(period);
        this.setDaySelectedInTimePeriod(daySelectedInTimePeriod);
        this.setPeriodType(type);
        this.setMultiplier(multiplier);
    }

    public RelativeTimeFilterData(RelativeTimeFilterData other) {
        if (other != null) {
            this.setPeriod(other.period);
            this.setDaySelectedInTimePeriod(other.daySelectedInTimePeriod);
            this.setPeriodType(other.periodType);
            this.setMultiplier(other.multiplier);
        }
    }

    public TimePeriod getPeriod() {
        return this.period;
    }

    public boolean setPeriod(TimePeriod period) {
        if (this.period != period) {
            this.period = period;
            return true;
        }
        return false;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public boolean setMultiplier(int value) {
        if (this.multiplier != value) {
            this.multiplier = value;
            return true;
        }
        return false;
    }

    public TimePeriodType getPeriodType() {
        return this.periodType;
    }

    public boolean setPeriodType(TimePeriodType type) {
        if (this.periodType != type) {
            this.periodType = type;
            return true;
        }
        return false;
    }

    public void setDaySelectedInTimePeriod(int value) throws IllegalArgumentException {
        if (value != 0 && value != 1 && value != 2) {
            throw new IllegalArgumentException("Invalid parameter to setDaySelectedInTimePeriod. Must be DAY_FIRST or DAY_LAST");
        }
        this.daySelectedInTimePeriod = value;
    }

    public int getDaySelectedInTimePeriod() {
        return this.daySelectedInTimePeriod;
    }

    public String toString() {
        StringBuffer value = new StringBuffer();
        if (this.period != null) {
            value.append(this.period.getLabel());
        }
        value.append(" selectedDay=" + (this.daySelectedInTimePeriod == 1 ? "FIRST" : (this.daySelectedInTimePeriod == 2 ? "LAST" : "UNDEFINED")));
        value.append(" multiplier=" + this.multiplier);
        if (this.periodType != null) {
            value.append(" periodType=" + this.periodType.getLabel());
        }
        return value.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelativeTimeFilterData) {
            RelativeTimeFilterData other = (RelativeTimeFilterData)obj;
            if (!Util.equal((Object)this.getPeriod(), (Object)other.getPeriod())) {
                return false;
            }
            if (this.getDaySelectedInTimePeriod() != other.getDaySelectedInTimePeriod()) {
                return false;
            }
            if (this.period == TimePeriod.PERIOD_N_PERIODS_AGO || this.period == TimePeriod.PERIOD_N_PERIODS_FROM_NOW) {
                if (!Util.equal((Object)this.getPeriodType(), (Object)other.getPeriodType())) {
                    return false;
                }
                if (this.getMultiplier() != other.getMultiplier()) {
                    return false;
                }
            }
            return true;
        }
        return super.equals(obj);
    }
}

