/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.FilterConditionInterface;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterValueFormatProvider;
import com.sas.dataselectors.filters.RB;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterData;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterValueFormatter;
import com.sas.dataselectors.filters.timebased.TimeCondition;
import com.sas.util.Util;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;

@SASScope(value="ALL")
public class DefaultFilterCondition
implements FilterConditionInterface {
    public static final String RB_KEY = "DefaultFilterCondition.";
    protected transient Object _conditionObject = null;
    protected transient String _conditionLabel = "";
    protected transient int _argumentCount = 0;
    protected transient List _argumentLabels = new ArrayList();
    protected transient String _conditionMessageFormat = "{0}";
    protected transient boolean _isConditionObjectNegated = false;
    protected transient boolean _allowTyped = true;
    protected transient boolean _allowSelected = true;
    transient String _resourceKey;
    public static final FilterConditionInterface IS_EQUALS = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_EQUALS");
    public static final FilterConditionInterface IS_NOT_EQUALS = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_NOT_EQUALS");
    public static final FilterConditionInterface IS_IN_LIST = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_IN_LIST");
    public static final FilterConditionInterface IS_NOT_IN_LIST = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_NOT_IN_LIST");
    public static final FilterConditionInterface IS_LESS_THAN = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_LESS_THAN");
    public static final FilterConditionInterface IS_LESS_THAN_OR_EQUAL = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_LESS_THAN_OR_EQUAL");
    public static final FilterConditionInterface IS_GREATER_THAN = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_GREATER_THAN");
    public static final FilterConditionInterface IS_GREATER_THAN_OR_EQUAL = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_GREATER_THAN_OR_EQUAL");
    public static final FilterConditionInterface IS_BETWEEN = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_BETWEEN");
    public static final FilterConditionInterface IS_NOT_BETWEEN = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_NOT_BETWEEN");
    public static final FilterConditionInterface IS_NULL = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_NULL");
    public static final FilterConditionInterface IS_NOT_NULL = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_NOT_NULL");
    public static final FilterConditionInterface IS_MISSING_VALUE = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_MISSING_VALUE");
    public static final FilterConditionInterface IS_NOT_MISSING_VALUE = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_NOT_MISSING_VALUE");
    public static final FilterConditionInterface IS_BEFORE = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_BEFORE");
    public static final FilterConditionInterface IS_BEFORE_OR_EQUAL = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_BEFORE_OR_EQUAL");
    public static final FilterConditionInterface IS_AFTER = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_AFTER");
    public static final FilterConditionInterface IS_AFTER_OR_EQUAL = DefaultFilterCondition.getConditionFromRB("DefaultFilterCondition.IS_AFTER_OR_EQUAL");

    public DefaultFilterCondition() {
    }

    public DefaultFilterCondition(FilterConditionInterface conditionToCopy) {
        this();
        if (conditionToCopy != null) {
            this.setCondition(conditionToCopy.getCondition());
            this.setConditionArgumentCount(conditionToCopy.getConditionArgumentCount());
            this.setConditionArgumentLabels(conditionToCopy.getConditionArgumentLabels());
            this.setConditionLabel(conditionToCopy.getConditionLabel());
            this.setConditionMessageFormat(conditionToCopy.getConditionMessageFormat());
            this.setConditionObjectNegated(conditionToCopy.isConditionObjectNegated());
            this.setUserValueAllowed(conditionToCopy.isUserValueAllowed());
            this.setValueListAllowed(conditionToCopy.isValueListAllowed());
        }
    }

    public DefaultFilterCondition(FilterConditionInterface conditionToCopy, Object newConditionObject, boolean isNegated) {
        this(conditionToCopy);
        this.setCondition(newConditionObject);
        this.setConditionObjectNegated(isNegated);
    }

    public DefaultFilterCondition(String label, String format, int parmCount, String[] parmLabels) {
        this(label, format, parmCount, parmLabels, null);
    }

    public DefaultFilterCondition(String label, String format, int parmCount, String[] parmLabels, Object conditionObject) {
        this(label, format, parmCount, parmLabels, conditionObject, false);
    }

    public DefaultFilterCondition(String label, String format, int parmCount, String[] parmLabels, Object conditionObject, boolean isConditionObjectNegated) {
        this();
        this.setConditionLabel(label);
        this.setConditionMessageFormat(format);
        this.setConditionArgumentCount(parmCount);
        this.setConditionArgumentLabels(parmLabels);
        this.setCondition(conditionObject);
        this.setConditionObjectNegated(isConditionObjectNegated);
    }

    DefaultFilterCondition(String keyPrefix, Object userObject, boolean isNegated) {
        this(keyPrefix, userObject, isNegated, null);
    }

    DefaultFilterCondition(String keyPrefix, Object userObject, boolean isNegated, Locale locale) {
        this();
        this._resourceKey = keyPrefix;
        this.setLocaleSpecificProperties(locale);
        this.setCondition(userObject);
        this.setConditionObjectNegated(isNegated);
    }

    @Override
    public boolean isConditionObjectNegated() {
        return this._isConditionObjectNegated;
    }

    public void setConditionObjectNegated(boolean isConditionObjectNegated) {
        this._isConditionObjectNegated = isConditionObjectNegated;
    }

    public String toString() {
        return this._conditionLabel;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterConditionInterface) {
            FilterConditionInterface other = (FilterConditionInterface)obj;
            Object condition1 = this.getCondition();
            Object condition2 = other.getCondition();
            boolean one = condition1 != this || condition2 != other ? Util.equal((Object)condition1, (Object)condition2) : true;
            boolean two = this.isConditionObjectNegated() == other.isConditionObjectNegated();
            boolean three = Util.equal((Object)this.getConditionLabel(), (Object)other.getConditionLabel());
            return one && two && three;
        }
        return super.equals(obj);
    }

    @Override
    public Object getCondition() {
        return this._conditionObject;
    }

    public void setCondition(Object conditionObject) {
        this._conditionObject = conditionObject == null ? this : conditionObject;
    }

    @Override
    public String getConditionLabel() {
        return this._conditionLabel;
    }

    @Override
    public String getConditionLabel(Locale locale) {
        return this._conditionLabel;
    }

    public void setConditionLabel(String conditionLabel) {
        this._conditionLabel = conditionLabel;
    }

    @Override
    public int getConditionArgumentCount() {
        return this._argumentCount;
    }

    public void setConditionArgumentCount(int argumentCount) {
        if (argumentCount < -1) {
            throw new IllegalArgumentException();
        }
        this._argumentCount = argumentCount;
    }

    @Override
    public String[] getConditionArgumentLabels() {
        String[] tmp = new String[0];
        String[] labels = this._argumentLabels.toArray(tmp);
        if (labels == null) {
            return null;
        }
        return labels;
    }

    @Override
    public String getConditionArgumentLabel(int index) {
        String label = index < 1 ? RB.getStringResource(RB_KEY, "UndefinedSingleValueLabel.txt") : (index > this._argumentLabels.size() ? MessageFormat.format(RB.getStringResource(RB_KEY, "UndefinedMultipleValueLabel.format.txt"), Integer.toString(index)) : (String)this._argumentLabels.get(index - 1));
        return label;
    }

    public void setConditionArgumentLabels(String[] argumentLabels) {
        ArrayList<String> argumentList = new ArrayList<String>();
        for (int i = 0; i < argumentLabels.length; ++i) {
            argumentList.add(argumentLabels[i]);
        }
        this._argumentLabels.clear();
        this._argumentLabels.addAll(argumentList);
    }

    @Override
    public String getConditionMessageFormat() {
        return this._conditionMessageFormat;
    }

    @Override
    public void setConditionMessageFormat(String messageFormat) {
        this._conditionMessageFormat = messageFormat;
    }

    @Override
    public String format(String item, List values) {
        return DefaultFilterCondition.format(item, (FilterConditionInterface)this, values);
    }

    public static String format(FilterItemInterface item, FilterConditionInterface condition, List values) {
        if (item == null) {
            return DefaultFilterCondition.format((String)null, condition, values);
        }
        return DefaultFilterCondition.format(item.toString(), condition, values, item.getUserValueFormatter());
    }

    public static String format(String item, FilterConditionInterface condition, List values) {
        return DefaultFilterCondition.format(item, condition, values, null);
    }

    public static String format(String item, FilterConditionInterface condition, List values, Format formatter) {
        String result = "";
        String formatToUse = "";
        boolean combineListValues = false;
        if (condition == null) {
            combineListValues = values != null && values.size() > 0;
        } else {
            combineListValues = condition.getConditionArgumentCount() == -1;
            formatToUse = condition.getConditionMessageFormat();
        }
        if (formatToUse == null || formatToUse.length() == 0) {
            formatToUse = combineListValues ? "{0} - {1}" : "{0}";
        }
        ArrayList<String> loader = new ArrayList<String>();
        if (item == null) {
            loader.add("");
        } else {
            loader.add(item);
        }
        String tmp = "";
        if (values == null) {
            loader.add(tmp);
        } else {
            Object conditionObject;
            Iterator iter = values.iterator();
            Object object = conditionObject = condition != null ? condition.getCondition() : null;
            while (iter.hasNext()) {
                Format format;
                Object value = iter.next();
                if (value == null) {
                    value = "";
                }
                String text = null;
                if (value instanceof RelativeTimeFilterData && formatter instanceof FilterValueFormatProvider && (format = ((FilterValueFormatProvider)((Object)formatter)).getFormatter(RelativeTimeFilterData.class)) instanceof RelativeTimeFilterValueFormatter && conditionObject instanceof TimeCondition) {
                    ((RelativeTimeFilterValueFormatter)format).setFilterCondition((TimeCondition)conditionObject);
                }
                if (formatter == null) {
                    text = value.toString();
                } else {
                    try {
                        if (TimeCondition.CONDITION_NEXT_N_PERIODS.equals(conditionObject) && iter.hasNext() || TimeCondition.CONDITION_LAST_N_PERIODS.equals(conditionObject) && !iter.hasNext()) continue;
                        text = formatter.format(value);
                    }
                    catch (IllegalArgumentException e) {
                        text = value.toString();
                    }
                }
                if (combineListValues) {
                    tmp = tmp.concat(text);
                    if (!iter.hasNext()) continue;
                    tmp = tmp.concat(", ");
                    continue;
                }
                loader.add(text);
            }
            if (combineListValues) {
                loader.add(tmp);
            }
        }
        if (condition != null) {
            while (loader.size() < condition.getConditionArgumentCount() + 1) {
                loader.add("");
            }
        }
        result = MessageFormat.format(formatToUse, loader.toArray());
        return result;
    }

    public static FilterConditionInterface getConditionFromRB(String key) {
        return DefaultFilterCondition.getConditionFromRB(key, null, false);
    }

    public static FilterConditionInterface getConditionFromRB(String key, Object conditionObject, boolean isNegated) {
        return DefaultFilterCondition.getConditionFromRB(key, conditionObject, isNegated, null);
    }

    public static FilterConditionInterface getConditionFromRB(String key, Object conditionObject, boolean isNegated, Locale locale) {
        return new DefaultFilterCondition(key, conditionObject, isNegated, locale);
    }

    public void setValueListAllowed(boolean value) {
        this._allowSelected = value;
    }

    public void setUserValueAllowed(boolean value) {
        this._allowTyped = value;
    }

    @Override
    public boolean isUserValueAllowed() {
        return this._allowTyped;
    }

    @Override
    public boolean isValueListAllowed() {
        return this._allowSelected;
    }

    @Override
    public boolean isExpressionValueAllowed() {
        return this._argumentCount > 0;
    }

    @Override
    public boolean isPromptValueAllowed() {
        return this._argumentCount != 0;
    }

    boolean setLocaleSpecificProperties(Locale locale) {
        if (this._resourceKey == null) {
            return false;
        }
        try {
            this.setConditionLabel(RB.getStringResource(this._resourceKey + ".Label.txt", locale));
            String keySuffix = ".Format.notrans.txt";
            if (this._resourceKey != null && (this._resourceKey.equals("DefaultFilterCondition.IS_NULL") || this._resourceKey.equals("DefaultFilterCondition.IS_NOT_NULL") || this._resourceKey.equals("DefaultFilterCondition.IS_MISSING_VALUE") || this._resourceKey.equals("DefaultFilterCondition.IS_NOT_MISSING_VALUE") || this._resourceKey.equals("DefaultFilterCondition.IS_BEFORE") || this._resourceKey.equals("DefaultFilterCondition.IS_BEFORE_OR_EQUAL") || this._resourceKey.equals("DefaultFilterCondition.IS_AFTER") || this._resourceKey.equals("DefaultFilterCondition.IS_AFTER_OR_EQUAL") || this._resourceKey.equals("DefaultAdvancedFilterCondition.IS_BETWEEN_TIME") || this._resourceKey.equals("DefaultAdvancedFilterCondition.YEAR_TO_DATE") || this._resourceKey.equals("DefaultAdvancedFilterCondition.MONTH_TO_DATE"))) {
                keySuffix = ".fmt.txt";
            }
            this.setConditionMessageFormat(RB.getStringResource(this._resourceKey + keySuffix, locale));
        }
        catch (MissingResourceException mre) {
            return false;
        }
        String parmCountString = null;
        try {
            parmCountString = RB.getStringResource(this._resourceKey + ".Parm.Count.notrans");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        int parmCount = 0;
        String[] parmsArray = new String[]{};
        if (parmCountString != null) {
            parmCount = Integer.parseInt(parmCountString.trim());
            switch (parmCount) {
                case 0: {
                    break;
                }
                case -1: 
                case 1: {
                    String parm1;
                    try {
                        parm1 = RB.getStringResource(this._resourceKey + ".Parm.1.Label.txt", locale);
                    }
                    catch (MissingResourceException e) {
                        parm1 = RB.getStringResource("DefaultFilterCondition.Default.Parm.1.Label.txt", locale);
                    }
                    parmsArray = new String[]{parm1};
                    break;
                }
                case 2: {
                    String parm1 = RB.getStringResource(this._resourceKey + ".Parm.1.Label.txt", locale);
                    String parm2 = RB.getStringResource(this._resourceKey + ".Parm.2.Label.txt", locale);
                    parmsArray = new String[]{parm1, parm2};
                    break;
                }
                case 3: {
                    String parm1 = RB.getStringResource(this._resourceKey + ".Parm.1.Label.txt", locale);
                    String parm2 = RB.getStringResource(this._resourceKey + ".Parm.2.Label.txt", locale);
                    String parm3 = RB.getStringResource(this._resourceKey + ".Parm.3.Label.txt", locale);
                    parmsArray = new String[]{parm1, parm2, parm3};
                    break;
                }
            }
        }
        this.setConditionArgumentCount(parmCount);
        this.setConditionArgumentLabels(parmsArray);
        return true;
    }

    @Override
    public void setLocale(Locale locale) {
        this.setLocaleSpecificProperties(locale);
    }
}

