/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.export;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.export.ExportHeadersFootersInterface;
import com.sas.dataselectors.export.ExportSelectorInterface;
import com.sas.dataselectors.export.HTMLExportCSSInfo;
import com.sas.dataselectors.export.HTMLExportCSSInfoInterface;
import com.sas.dataselectors.export.HTMLExportSelectorInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.table.FormattedDataReturnedInterface;
import com.sas.table.FormattedInterface;

@SASScope(value="ALL")
public abstract class BaseExportSelectorAdapter
implements ExportSelectorInterface,
HTMLExportSelectorInterface,
ExportHeadersFootersInterface {
    protected Object dataModel;
    protected String outputType;
    protected String includeRows;
    protected int fromRow;
    protected int toRow;
    protected boolean isFormattedData;
    protected String[] cssURL;
    protected String[] cssMIMEType;
    protected String[] cssMediaList;
    protected String[] cssTitle;
    protected HTMLExportCSSInfoInterface[] cssDefinitions;
    protected String[] headers;
    protected String[] footers;

    public BaseExportSelectorAdapter() {
        if (this.dataModel instanceof FormattedInterface && !((FormattedInterface)this.dataModel).isFormattedDataUsed()) {
            this.setIsFormattedData(false);
        } else {
            this.setIsFormattedData(true);
        }
    }

    public void setDataModel(Object model) {
        if (this.dataModel != model && model != null) {
            this.dataModel = model;
            if (model instanceof FormattedInterface && !((FormattedInterface)model).isFormattedDataUsed()) {
                this.setIsFormattedData(false);
            }
        }
    }

    public Object getDataModel() {
        return this.dataModel;
    }

    @Override
    public String getOutputType() {
        return this.outputType;
    }

    @Override
    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    @Override
    public String getIncludeRows() {
        return this.includeRows;
    }

    @Override
    public void setIncludeRows(String includeRows) {
        this.includeRows = includeRows;
    }

    @Override
    public int getFromRowCount() {
        return this.fromRow;
    }

    @Override
    public void setFromRowCount(int fromRow) {
        this.fromRow = fromRow;
    }

    @Override
    public int getToRowCount() {
        return this.toRow;
    }

    @Override
    public void setToRowCount(int toRow) {
        this.toRow = toRow;
    }

    @Override
    public boolean isFormattedData() {
        return this.isFormattedData;
    }

    @Override
    public void setIsFormattedData(boolean isFormattedData) {
        this.isFormattedData = isFormattedData;
    }

    @Override
    public int getStartRow() {
        int startRow = 0;
        if ("R".equalsIgnoreCase(this.getIncludeRows()) && this.getFromRowCount() > 0) {
            startRow = this.getFromRowCount() - 1;
        }
        return startRow;
    }

    @Override
    public int getNRows() {
        int nRows = -1;
        if ("R".equalsIgnoreCase(this.getIncludeRows()) && this.getStartRow() >= 0 && this.getToRowCount() > 0) {
            nRows = this.getToRowCount() - this.getStartRow();
        }
        return nRows;
    }

    @Override
    public boolean isRawDataAvailable() {
        if (this.getDataModel() instanceof OLAPDataSetInterface) {
            return true;
        }
        if (this.getDataModel() instanceof FormattedDataReturnedInterface) {
            return !((FormattedDataReturnedInterface)this.getDataModel()).isFormattedDataReturned();
        }
        return false;
    }

    @Override
    public String[] getCssURL() {
        return this.cssURL;
    }

    @Override
    public void setCssURL(String[] value) {
        this.cssURL = value;
        this.cssDefinitions = null;
    }

    @Override
    public String[] getCssMIMEType() {
        return this.cssMIMEType;
    }

    @Override
    public void setCssMIMEType(String[] value) {
        this.cssMIMEType = value;
        this.cssDefinitions = null;
    }

    @Override
    public String[] getCssMediaList() {
        return this.cssMediaList;
    }

    @Override
    public void setCssMediaList(String[] value) {
        this.cssMediaList = value;
        this.cssDefinitions = null;
    }

    @Override
    public String[] getCssTitle() {
        return this.cssTitle;
    }

    @Override
    public void setCssTitle(String[] value) {
        this.cssTitle = value;
        this.cssDefinitions = null;
    }

    @Override
    public HTMLExportCSSInfoInterface[] getCSSInfo() {
        String[] cssURL;
        if (this.cssDefinitions == null && (cssURL = this.getCssURL()) != null) {
            HTMLExportCSSInfo cssInfo = null;
            int nUrls = cssURL.length;
            if (nUrls > 0) {
                this.cssDefinitions = new HTMLExportCSSInfoInterface[nUrls];
                for (int i = 0; i < nUrls; ++i) {
                    cssInfo = new HTMLExportCSSInfo();
                    cssInfo.setCSSMediaList(this.getCssMediaList()[i]);
                    cssInfo.setCSSMIMEType(this.getCssMIMEType()[i]);
                    cssInfo.setCSSTitle(this.getCssTitle()[i]);
                    cssInfo.setCSSURL(this.getCssURL()[i]);
                    this.cssDefinitions[i] = cssInfo;
                }
            }
        }
        return this.cssDefinitions;
    }

    @Override
    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    @Override
    public String[] getHeaders() {
        return this.headers;
    }

    @Override
    public String[] getFooters() {
        return this.footers;
    }

    @Override
    public void setFooters(String[] footers) {
        this.footers = footers;
    }

    @Override
    @SASScope
    public int getMinNrows() {
        return 1;
    }

    @Override
    @SASScope
    public abstract int getMaxNrows();
}

