/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.relational;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.BaseCommand;
import com.sas.commands.export.Util;
import com.sas.storage.jdbc.export.RelationalDelimitedValuesExporter;
import com.sas.storage.jdbc.export.RelationalExportInterface;
import com.sas.storage.jdbc.export.RelationalTableModelExporter;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.tableview.actions.RB;
import com.sas.table.TrueRowCountCalculatedInterface;
import com.sas.text.Message;
import com.sas.util.ContentServer2;
import com.sas.util.UncheckedException;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.swing.table.TableModel;

public class ExportToExcelCommand
extends BaseCommand
implements CommandSupportedInterface,
CommandStatusInterface {
    public static final String RB_KEY = "ExportToExcelCommand.";
    protected TableView table;
    private String actionClass;
    private int startRow;
    private int rowCount;
    private boolean isRawData;
    private String excelPath;

    public ExportToExcelCommand() {
    }

    public ExportToExcelCommand(String name) {
        super(name);
    }

    public ExportToExcelCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.startRow = 0;
        this.rowCount = -1;
        this.isRawData = true;
    }

    public int getExportStartRow() {
        return this.startRow;
    }

    public void setExportStartRow(int startRow) {
        this.startRow = startRow;
    }

    public int getExportRowCount() {
        return this.rowCount;
    }

    public void setExportRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public boolean isExportRawData() {
        return this.isRawData;
    }

    public void setExportRawData(boolean isRawData) {
        this.isRawData = isRawData;
    }

    public String getExcelPath() {
        return this.excelPath;
    }

    public void setExcelPath(String excelPath) {
        this.excelPath = excelPath;
    }

    @Override
    public void execute(Object o) {
        if (this.actionClass == "com.sas.actionprovider.SwingAction") {
            this.getTable();
            if (this.table != null) {
                String app = this.getExcelPath();
                if (app == null || app.length() == 0) {
                    try {
                        app = System.getProperty("Excel", "Excel.exe");
                    }
                    catch (Exception ex) {
                        app = "";
                    }
                }
                ContentServer2 server = new ContentServer2();
                server.setFileExtension(".xls");
                server.setMIMEType("text/tab-separated-values");
                OutputStream out = server.getExportOutputStream(app, " /r ", null);
                if (out == null) {
                    out = new ByteArrayOutputStream(4096);
                    server = null;
                }
                OutputStreamWriter writer = new OutputStreamWriter(out, Charset.forName(Util.CHARSET_FOR_NON_HTML_EXPORT_TO_EXCEL).newEncoder());
                try {
                    ((Writer)writer).write(65279);
                }
                catch (Exception ex) {
                    System.err.println("Failed to write 0xFEFF on OutputStreamWriter");
                }
                this.writeToStream(this.table, writer);
                try {
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (Exception e) {
                    throw new UncheckedException((Throwable)e, null);
                }
                int ret = server != null ? server.exportContentsOfOutputStream(out, app, " /r ", null) : ContentServer2.export(((ByteArrayOutputStream)out).toByteArray(), "text/tab-separated-values", app, " /r ", ".xls");
                if (ret != 0) {
                    String error = ContentServer2.errorMsgs[ret];
                    if (this.table instanceof SupportsGenericErrorHandlerInterface && this.table.getGenericErrorHandler() != null) {
                        GenericErrorHandlerInterface errorHandler = this.table.getGenericErrorHandler();
                        if (errorHandler instanceof Frame) {
                            ((Frame)((Object)errorHandler)).setTitle(Message.format((String)RB.getStringResource("TableViewAction.", "errorHandlerTitle.txt"), (Object)this.getName()));
                        } else if (errorHandler instanceof JOptionPaneErrorHandler) {
                            ((JOptionPaneErrorHandler)errorHandler).setTitle(Message.format((String)RB.getStringResource("TableViewAction.", "errorHandlerTitle.txt"), (Object)this.getName()));
                        }
                        errorHandler.handleError(this.table, new Message(error), null);
                    }
                }
            }
        }
    }

    protected void writeToStream(TableView table, Writer writer) {
        int[] columns = new int[table.getColumnCount()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = table.getColumnModel().getColumn(i).getModelIndex();
        }
        boolean trueRowCalculated = true;
        if (table.getModel() instanceof TrueRowCountCalculatedInterface && this.rowCount == -1 && !(trueRowCalculated = ((TrueRowCountCalculatedInterface)table.getModel()).isTrueRowCountCalculated())) {
            ((TrueRowCountCalculatedInterface)table.getModel()).setTrueRowCountCalculated(true);
        }
        RelationalTableModelExporter.writeToStream((TableModel)table.getModel(), (Writer)writer, (RelationalExportInterface)new RelationalDelimitedValuesExporter("\t"), (int[])columns, (int)this.startRow, (int)this.rowCount, (boolean)this.isRawData);
        if (!trueRowCalculated) {
            ((TrueRowCountCalculatedInterface)table.getModel()).setTrueRowCountCalculated(trueRowCalculated);
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        TableView tv = (TableView)filter.getAttribute("table");
        if (tv != null && ContentServer2.isExportAllowed()) {
            return 0;
        }
        return 16;
    }

    public void setTable(TableView table) {
        this.table = table;
    }

    public TableView getTable() {
        return this.table;
    }
}

