/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.export;

import com.sas.codepolicy.SASScope;
import java.util.Random;

@SASScope
public class Util {
    private static final char[] charArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static String DEFAULT_CSV_CHARSET = System.getProperty("file.encoding");
    public static String DEFAULT_CSV_CONTENT_TYPE = "text/csv";
    public static String DEFAULT_TSV_CONTENT_TYPE;
    public static String DEFAULT_EXCEL_XML_CONTENT_TYPE;
    public static String DEFAULT_EXCEL_HTML_CONTENT_TYPE;
    public static String DEFAULT_WORD_HTML_CONTENT_TYPE;
    public static String DEFAULT_XLSX_CONTENT_TYPE;
    public static String CHARSET_FOR_NON_HTML_EXPORT_TO_EXCEL;
    public static String DEFAULT_CHARSET_FOR_HTML_EXPORT_TO_EXCEL;

    public static String getExportFileName(String fileExtension) {
        Random random = new Random();
        StringBuffer sb = new StringBuffer("sasExport");
        for (int i = 0; i < 4; ++i) {
            sb.append(charArray[random.nextInt(36)]);
        }
        sb.append(fileExtension);
        return sb.toString();
    }

    public static String getDefaultContentDisposition(String outputType) {
        String contentDisposition = null;
        if (outputType != null) {
            if ("CSV".equals(outputType)) {
                contentDisposition = "attachment;filename=" + Util.getExportFileName(".csv");
            } else if ("TSV".equals(outputType)) {
                contentDisposition = "attachment;filename=" + Util.getExportFileName(".tsv");
            } else if ("XML".equals(outputType)) {
                contentDisposition = "attachment;filename=" + Util.getExportFileName(".xls");
            } else if ("HTML".equals(outputType)) {
                contentDisposition = "inline;filename=" + Util.getExportFileName(".xls");
            } else if ("WHTML".equals(outputType)) {
                contentDisposition = "inline;filename=" + Util.getExportFileName(".doc");
            } else if ("XLSX".equals(outputType)) {
                contentDisposition = "inline;filename=" + Util.getExportFileName(".xlsx");
            }
        }
        return contentDisposition;
    }

    static {
        DEFAULT_EXCEL_XML_CONTENT_TYPE = DEFAULT_TSV_CONTENT_TYPE = "text/tab-separated-values";
        DEFAULT_EXCEL_HTML_CONTENT_TYPE = "application/vnd.ms-excel";
        DEFAULT_WORD_HTML_CONTENT_TYPE = "application/vnd.msword";
        DEFAULT_XLSX_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        CHARSET_FOR_NON_HTML_EXPORT_TO_EXCEL = "UTF-16LE";
        DEFAULT_CHARSET_FOR_HTML_EXPORT_TO_EXCEL = "UTF-8";
    }
}

