/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionOrderList;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.BaseActionProvider;
import com.sas.actionprovider.support.BaseActionProviderSupport;
import com.sas.actionprovider.support.RB;
import com.sas.codepolicy.SASScope;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope(value="ALL")
public abstract class BaseActionProviderCompositeSupport
extends BaseActionProviderSupport {
    private List supportInstances = new ArrayList(3);
    private Map areaTypeToSupportInstanceMap = Collections.synchronizedMap(new HashMap(8));
    @SASScope
    protected boolean debug = false;
    static final String RB_KEY = "BaseActionProviderCompositeSupport.";

    public BaseActionProviderCompositeSupport() {
        this(null);
    }

    public BaseActionProviderCompositeSupport(Class actionClass) {
        super(actionClass);
        this.addSupportClassInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        List list = this.supportInstances;
        synchronized (list) {
            int size = this.supportInstances.size();
            for (int i = 0; i < size; ++i) {
                BaseActionProviderSupport support = (BaseActionProviderSupport)this.supportInstances.get(i);
                support.initialize();
                this.validateSupport(support);
            }
        }
    }

    protected void addSupport(String className) {
        BaseActionProviderSupport support = this.getSupportInstance(className);
        this.supportInstances.add(support);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateSupport(BaseActionProviderSupport support) {
        Collection areaTypes;
        Collection collection = areaTypes = support.listAreaTypes();
        synchronized (collection) {
            for (String areaType : areaTypes) {
                if (this.areaTypeToSupportInstanceMap.containsKey(areaType)) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "areaTypeAlreadyRegistered.txt"));
                }
                this.areaTypeToSupportInstanceMap.put(areaType, support);
            }
        }
    }

    @Override
    protected boolean validArea(Area area, ActionSupportFilter actionFilter) {
        BaseActionProviderSupport support;
        String type = null;
        if (area == null && (type = area.getType()) == null) {
            return true;
        }
        String areaType = actionFilter.getAreaType();
        return areaType != null && (support = (BaseActionProviderSupport)this.areaTypeToSupportInstanceMap.get(areaType)).validArea(area, actionFilter);
    }

    protected BaseActionProviderSupport getSupportInstance(String supportClassName) {
        Class supportClass = this.getSupportClass(supportClassName);
        BaseActionProviderSupport support = null;
        try {
            Class[] parameterTypes = new Class[]{Class.class};
            Constructor constructor = supportClass.getConstructor(parameterTypes);
            Object[] initArgs = new Object[]{this.getActionClass()};
            support = (BaseActionProviderSupport)constructor.newInstance(initArgs);
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "supportNotInstantiable.txt"));
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "supportNotAccessible.txt"));
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "supportClassInstantiationError.txt"));
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "supportClassConstructorInvalid.txt"));
        }
        return support;
    }

    @Override
    public void setAction(BaseAction action, Collection viewers, Area area) {
        if (area == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullArea.txt"));
        }
        String areaType = area.getType();
        BaseActionProviderSupport support = this.getSupportForArea(areaType);
        if (support != null) {
            support.setAction(action, viewers, area);
        }
    }

    @Override
    public void setActionOrderList(ActionOrderList orderList, ActionProviderViewInterface viewer, String areaType) {
        if (orderList == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionOrderList.txt"));
        }
        BaseActionProviderSupport support = this.getSupportForArea(areaType);
        support.setActionOrderList(orderList, viewer, areaType);
    }

    @Override
    public ActionOrderList getActionOrderList(ActionProviderViewInterface viewer, String areaType) {
        BaseActionProviderSupport support = this.getSupportForArea(areaType);
        return support.getActionOrderList(viewer, areaType);
    }

    @Override
    public ActionList getActions(ActionSupportFilter actionFilter) {
        BaseActionProviderSupport support = this.getSupportForArea(actionFilter.getAreaType());
        return support.getActions(actionFilter);
    }

    @Override
    public BaseAction getAction(String actionType, ActionSupportFilter actionFilter) {
        BaseActionProviderSupport support = this.getSupportForArea(actionFilter.getAreaType());
        return support.getAction(actionType, actionFilter);
    }

    @Override
    public BaseAction getDefaultAction(String areaType, String actionType) {
        BaseActionProviderSupport support = this.getSupportForArea(areaType);
        return support.getDefaultAction(areaType, actionType);
    }

    @Override
    public Collection listAreaTypes() {
        return this.areaTypeToSupportInstanceMap.keySet();
    }

    @Override
    public Collection listActionTypes(String areaType) {
        BaseActionProviderSupport support = this.getSupportForArea(areaType);
        return support.listActionTypes(areaType);
    }

    @Override
    @SASScope
    public ActionList getDefaultActions(String areaType) {
        BaseActionProviderSupport support = this.getSupportForArea(areaType);
        return support.getDefaultActions(areaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        List list = this.supportInstances;
        synchronized (list) {
            int size = this.supportInstances.size();
            for (int i = 0; i < size; ++i) {
                BaseActionProviderSupport support = (BaseActionProviderSupport)this.supportInstances.get(i);
                support.setLocale(loc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActionProvider(BaseActionProvider actionProvider) {
        super.setActionProvider(actionProvider);
        List list = this.supportInstances;
        synchronized (list) {
            int size = this.supportInstances.size();
            for (int i = 0; i < size; ++i) {
                BaseActionProviderSupport support = (BaseActionProviderSupport)this.supportInstances.get(i);
                support.setActionProvider(actionProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SASScope
    public void flushViewerReferencesFromSupportClass(ActionProviderViewInterface viewer) {
        List list = this.supportInstances;
        synchronized (list) {
            int size = this.supportInstances.size();
            for (int i = 0; i < size; ++i) {
                BaseActionProviderSupport support = (BaseActionProviderSupport)this.supportInstances.get(i);
                support.flushViewerReferencesFromSupportClass(viewer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        List list = this.supportInstances;
        synchronized (list) {
            int size = this.supportInstances.size();
            for (int i = 0; i < size; ++i) {
                BaseActionProviderSupport support = (BaseActionProviderSupport)this.supportInstances.get(i);
                support.reset();
            }
        }
    }

    @Override
    public BaseAction newActionInstance(String areaType, String actionType) {
        BaseActionProviderSupport support = this.getSupportForArea(areaType);
        return support.newActionInstance(areaType, actionType);
    }

    private BaseActionProviderSupport getSupportForArea(String areaType) {
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        if (!this.areaTypeToSupportInstanceMap.containsKey(areaType)) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "invalidAreaType.txt"));
        }
        return (BaseActionProviderSupport)this.areaTypeToSupportInstanceMap.get(areaType);
    }

    @Override
    protected Map getAreaScopeAttributeMap(ActionSupportFilter filter) {
        return null;
    }

    protected abstract void addSupportClassInstances();

    protected abstract Class getSupportClass(String var1);
}

