/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support;

import com.sas.actionprovider.Area;
import com.sas.actionprovider.BaseAction;
import com.sas.codepolicy.SASScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@SASScope
public class ActionEntry {
    static final int NO_REGISTRATIONS = 0;
    static final int REGISTRATIONS_EXIST = 1;
    static final String RB_KEY = "ActionEntry.";
    private Collection overrides;
    private Collection viewers;
    private Area area;
    private BaseAction action;
    private List registrations;

    public BaseAction getAction() {
        return this.action;
    }

    public void setAction(BaseAction action) {
        this.action = action;
    }

    public Area getArea() {
        return this.area;
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public Collection getViewers() {
        return this.viewers;
    }

    public void setViewers(Collection viewers) {
        this.viewers = viewers;
    }

    public Collection getOverrides() {
        return this.overrides;
    }

    public void setOverrides(Collection overrides) {
        this.overrides = overrides;
    }

    @SASScope
    public void addRegistration(BaseAction action, Collection viewers, Area area) {
        if (this.registrations == null) {
            this.registrations = new ArrayList();
        }
        this.registrations.add(new Registration(action, viewers, area));
    }

    @SASScope
    public BaseAction getAction(Object uniqueViewerId) {
        if (this.action != null) {
            return this.action;
        }
        Registration registration = this.getRegistration(uniqueViewerId);
        if (registration == null) {
            return null;
        }
        return registration.getAction();
    }

    @SASScope
    public Area getArea(Object uniqueViewerId) {
        if (this.area != null) {
            return this.area;
        }
        Registration registration = this.getRegistration(uniqueViewerId);
        if (registration == null) {
            return null;
        }
        return registration.getArea();
    }

    private Registration getRegistration(Object uniqueViewerId) {
        if (this.registrations == null) {
            return null;
        }
        int numRegistrations = this.registrations.size();
        for (int i = numRegistrations - 1; i >= 0; --i) {
            Registration registration = (Registration)this.registrations.get(i);
            if (!registration.getViewers().contains(uniqueViewerId)) continue;
            return registration;
        }
        return null;
    }

    @SASScope
    public int removeViewer(Object uniqueId) {
        if (this.registrations == null) {
            return 0;
        }
        Iterator iterator = this.registrations.iterator();
        while (iterator.hasNext()) {
            Registration registration = (Registration)iterator.next();
            Collection viewers = registration.getViewers();
            if (viewers.contains(uniqueId)) {
                viewers.remove(uniqueId);
            }
            if (!viewers.isEmpty()) {
                return 1;
            }
            iterator.remove();
        }
        if (!this.registrations.isEmpty()) {
            return 1;
        }
        return 0;
    }

    @SASScope
    public class Registration {
        private Collection viewers = null;
        private Area area;
        private BaseAction action;

        public Registration(BaseAction action, Collection viewers, Area area) {
            this.setAction(action);
            this.setViewers(viewers);
            this.setArea(area);
        }

        public BaseAction getAction() {
            return this.action;
        }

        public void setAction(BaseAction action) {
            this.action = action;
        }

        public Area getArea() {
            return this.area;
        }

        public void setArea(Area area) {
            this.area = area;
        }

        public Collection getViewers() {
            return this.viewers;
        }

        public void setViewers(Collection viewers) {
            this.viewers = viewers;
        }
    }
}

