/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.strategies.relational;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.strategies.relational.BaseSelectorStrategy;
import com.sas.actionprovider.strategies.relational.RB;
import com.sas.actionprovider.util.relational.RelationalActionUtil;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.SelectorDialog;
import com.sas.swing.visuals.dataselectors.filters.AdvancedFilterSelector;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Frame;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FilterSelectorStrategy
extends BaseSelectorStrategy {
    static final String RB_KEY = "RelationalStrategy.";
    private static Map viewerToSelectorsMap = new HashMap(7, 1.0f);

    public FilterSelectorStrategy() {
    }

    public FilterSelectorStrategy(boolean swing, RelationalActionUtil util) {
        super(swing, util);
    }

    @Override
    protected void initializeActionAttributes(BaseAction action, String areaType, Locale locale) {
        super.initializeActionAttributes(action, areaType, locale);
        try {
            Class<?> commandClass = Class.forName("com.sas.commands.dataselectors.AdvancedFilterSelectorCommand");
            action.setCommand((BaseSelectorCommand)commandClass.newInstance());
            action.getCommand().setName(RB.getStringResource(RB_KEY, "filtersSelectorLabel.txt"));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public void setLocaleDependentDefaultAttributes(BaseAction action, String areaType, Locale locale) {
        super.setLocaleDependentDefaultAttributes(action, areaType, locale);
        action.putValue("Name", RB.getStringResource(RB_KEY, "filtersSelectorLabel.txt"));
        action.getAttributeDescriptor("Name").setSupplementalProperty("DYNAMIC", (Object)Boolean.FALSE);
    }

    @Override
    public void setActionAttributes(BaseAction action, ActionSupportFilter filter) {
        super.setActionAttributes(action, filter);
        ActionProviderViewInterface viewer = filter.getViewer();
        if (viewer == null) {
            return;
        }
        SelectorDialog selectorDialog = (SelectorDialog)viewerToSelectorsMap.get(viewer);
        if (selectorDialog == null) {
            AdvancedFilterSelector selectorPanel = new AdvancedFilterSelector();
            selectorDialog = new SelectorDialog((Frame)Util.getParentFrame((Component)((Object)viewer)), (PanelInterface)selectorPanel, true);
            selectorDialog.pack();
            viewerToSelectorsMap.put(viewer, selectorDialog);
        }
        ((BaseSwingSelectorPanel)selectorDialog.getPanel()).setCommand(action.getCommand());
        action.putValue("selector", selectorDialog);
    }

    @Override
    public int getActionStatus(BaseAction action, ActionSupportFilter filter) {
        int currentStatus = super.getActionStatus(action, filter);
        if (!action.isCustom() && action.getCommand() == null) {
            currentStatus |= 0x80;
        }
        return currentStatus;
    }
}

